/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.lang.Assert;
import cn.hutool.json.JSONUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.yundt.module.context.api.IContext;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.EnterpriceCrossSupplierRelationConverter;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossSupplierRelationDomain;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationEnterpriseListReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossSupplierRelationSupplierListReqDto;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossSupplierRelationEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossSupplierRelationService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EnterpriceCrossSupplierRelationServiceImpl
extends BaseServiceImpl<EnterpriceCrossSupplierRelationDto, EnterpriceCrossSupplierRelationEo, IEnterpriceCrossSupplierRelationDomain>
implements IEnterpriceCrossSupplierRelationService {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceCrossSupplierRelationServiceImpl.class);
    @Resource
    private IContext context;

    public EnterpriceCrossSupplierRelationServiceImpl(IEnterpriceCrossSupplierRelationDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<EnterpriceCrossSupplierRelationDto, EnterpriceCrossSupplierRelationEo> converter() {
        return EnterpriceCrossSupplierRelationConverter.INSTANCE;
    }

    @Override
    public PageInfo<EnterpriceCrossSupplierRelationDto> queryPage(EnterpriceCrossSupplierRelationPageReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        return new PageInfo(((IEnterpriceCrossSupplierRelationDomain)this.domain).queryList(dto));
    }

    @Override
    public RestResponse<Long> insertRelation(EnterpriceCrossSupplierRelationDto dto) {
        EnterpriceCrossSupplierRelationEo countEo = new EnterpriceCrossSupplierRelationEo();
        countEo.setSupplierId(dto.getSupplierId());
        countEo.setEnterpriseId(dto.getEnterpriseId());
        countEo.setDr(0);
        int count = ((IEnterpriceCrossSupplierRelationDomain)this.domain).count((BaseEo)countEo);
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u4f9b\u5e94\u5546\u6240\u5c5e\u4e1a\u52a1\u5b9e\u4f53\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossSupplierRelationEo eo = (EnterpriceCrossSupplierRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setTenantId(this.context.tenantId());
        eo.setInstanceId(this.context.instanceId());
        eo.setCreatePerson(this.context.userName());
        eo.setCreateTime(new Date());
        eo.setUpdatePerson(this.context.userName());
        eo.setUpdateTime(new Date());
        ((IEnterpriceCrossSupplierRelationDomain)this.domain).insert((BaseEo)eo);
        return new RestResponse((Object)eo.getId());
    }

    @Override
    public RestResponse updateRelation(EnterpriceCrossSupplierRelationDto dto) {
        Assert.notNull((Object)dto.getId(), (String)"\u7f3a\u5c11id", (Object[])new Object[0]);
        Integer count = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IEnterpriceCrossSupplierRelationDomain)this.domain).filter().ne((Object)"id", (Object)dto.getId())).eq((Object)"supplier_id", (Object)dto.getSupplierId())).eq((Object)"enterprise_id", (Object)dto.getEnterpriseId())).eq((Object)"dr", (Object)0)).count();
        AssertUtils.isTrue((count == 0 ? 1 : 0) != 0, (String)"\u4f9b\u5e94\u5546\u6240\u5c5e\u4e1a\u52a1\u5b9e\u4f53\u5173\u7cfb\u5df2\u5b58\u5728");
        EnterpriceCrossSupplierRelationEo eo = (EnterpriceCrossSupplierRelationEo)this.converter().toEo((BaseDto)dto);
        eo.setTenantId(this.context.tenantId());
        eo.setInstanceId(this.context.instanceId());
        eo.setUpdatePerson(this.context.userName());
        eo.setUpdateTime(new Date());
        ((IEnterpriceCrossSupplierRelationDomain)this.domain).updateSelective((BaseEo)eo);
        return RestResponse.VOID;
    }

    @Override
    public List<EnterpriceCrossSupplierRelationDto> list(EnterpriceCrossSupplierRelationPageReqDto dto) {
        return ((IEnterpriceCrossSupplierRelationDomain)this.domain).queryList(dto);
    }

    @Override
    public List<EnterpriceCrossSupplierRelationDto> supplierList(EnterpriceCrossSupplierRelationSupplierListReqDto dto) {
        return ((IEnterpriceCrossSupplierRelationDomain)this.domain).supplierList(dto);
    }

    @Override
    public List<EnterpriceCrossSupplierRelationDto> enterpriseList(EnterpriceCrossSupplierRelationEnterpriseListReqDto dto) {
        return ((IEnterpriceCrossSupplierRelationDomain)this.domain).enterpriseList(dto);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RestResponse<Void> saveBatch(List<EnterpriceCrossSupplierRelationDto> dto) {
        log.info("-- {}", (Object)JSONUtil.toJsonStr(dto));
        HashSet<Long> checkSet = new HashSet<Long>();
        for (EnterpriceCrossSupplierRelationDto d : dto) {
            AssertUtils.isTrue((!checkSet.contains(d.getSupplierId()) ? 1 : 0) != 0, (String)"\u5b58\u5728\u91cd\u590d\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9");
            checkSet.add(d.getSupplierId());
        }
        List updateIds = dto.stream().filter(e -> e.getId() != null).map(BaseDto::getId).collect(Collectors.toList());
        List all = ((ExtQueryChainWrapper)((IEnterpriceCrossSupplierRelationDomain)this.domain).filter().eq((Object)"dr", (Object)"0")).list();
        List delIds = all.stream().map(BaseEo::getId).filter(e -> !updateIds.contains(e)).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(delIds)) {
            log.info("\u3010del \u3011: {}", delIds);
            ((IEnterpriceCrossSupplierRelationDomain)this.domain).logicDeleteByIds(delIds);
        }
        List updateList = this.converter().toEoList(dto.stream().filter(e -> e.getId() != null).peek(e -> {
            e.setUpdateTime(new Date());
            e.setUpdatePerson(this.context.userName());
            e.setDr(Integer.valueOf(0));
        }).collect(Collectors.toList()));
        List insertList = this.converter().toEoList(dto.stream().filter(e -> e.getId() == null).peek(e -> {
            e.setCreateTime(new Date());
            e.setUpdateTime(new Date());
            e.setCreatePerson(this.context.userName());
            e.setUpdatePerson(this.context.userName());
            e.setInstanceId(this.context.instanceId());
            e.setTenantId(this.context.tenantId());
            e.setDr(Integer.valueOf(0));
        }).collect(Collectors.toList()));
        if (CollUtil.isNotEmpty((Collection)insertList)) {
            log.info("\u3010insertBatch \u3011: {}", (Object)insertList);
            ((IEnterpriceCrossSupplierRelationDomain)this.domain).insertBatch(insertList);
        }
        if (CollUtil.isNotEmpty((Collection)updateList)) {
            log.info("\u3010updateList \u3011: {}", (Object)updateList);
            updateList.stream().forEach(eo -> ((IEnterpriceCrossSupplierRelationDomain)this.domain).updateSelective((BaseEo)eo));
        }
        return new RestResponse();
    }
}

