/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.enterprice.impl;

import cn.hutool.core.util.StrUtil;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderDomain;
import com.yunxi.dg.base.center.report.domain.entity.IEnterpriceCrossOrderLineDomain;
import com.yunxi.dg.base.center.report.dto.companytrade.EnterpriseDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossReceiveDeliveryResultReqDto;
import com.yunxi.dg.base.center.report.dto.entity.EnterpriceCrossTradeRelationRespDto;
import com.yunxi.dg.base.center.report.enums.BusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.CompanyTradeTypeEnum;
import com.yunxi.dg.base.center.report.enums.DisplayBusinessTypeEnum;
import com.yunxi.dg.base.center.report.enums.EnterpriceCrossOrderSyncErpStatusEnum;
import com.yunxi.dg.base.center.report.eo.EnterpriceCrossOrderEo;
import com.yunxi.dg.base.center.report.service.enterprice.IEnterpriceCrossTradeRelationService;
import com.yunxi.dg.base.center.report.service.enterprice.impl.handler.EnterpriceCrossAbstractSceneServiceImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(rollbackFor={Exception.class})
public class EnterpriceSaleOrderServiceImpl
extends EnterpriceCrossAbstractSceneServiceImpl {
    private static final Logger log = LoggerFactory.getLogger(EnterpriceSaleOrderServiceImpl.class);
    @Resource
    private IEnterpriceCrossOrderDomain orderDomain;
    @Resource
    private IEnterpriceCrossOrderLineDomain orderLineDomain;
    @Resource
    private IEnterpriceCrossTradeRelationService tradeRelationService;

    @Override
    public Boolean checkEnterpriceOrderAndHandleBusinessType(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        String relevanceTableName = context.getResultDto().getRelevanceTableName();
        if ("cs_order_sale".equals(relevanceTableName)) {
            EnterpriseDto saleOrderEnterprise = this.orderDomain.getSaleOrderEnterprise(context.getResultDto().getId());
            EnterpriseDto logicWarehouseEnterprise = this.orderDomain.getLogicWarehouseEnterprise(context.getResultDto().getDeliveryLogicWarehouseCode());
            if (saleOrderEnterprise != null && logicWarehouseEnterprise != null && saleOrderEnterprise.getEnterpriseCode().equals(logicWarehouseEnterprise.getEnterpriseCode())) {
                return Boolean.FALSE;
            }
            context.getResultDto().setBusinessType(BusinessTypeEnum.ORDER_SALE.getType());
            context.getResultDto().setDisplayBusinessType(DisplayBusinessTypeEnum.SALE_ORDER.getType());
            return Boolean.TRUE;
        }
        if ("cs_order_sale_refund".equals(relevanceTableName)) {
            EnterpriseDto saleOrderEnterprise = this.orderDomain.getAfterSaleOrderEnterprise(context.getResultDto().getId());
            EnterpriseDto logicWarehouseEnterprise = this.orderDomain.getLogicWarehouseEnterprise(context.getResultDto().getReceiveLogicWarehouseCode());
            if (saleOrderEnterprise != null && logicWarehouseEnterprise != null && saleOrderEnterprise.getEnterpriseCode().equals(logicWarehouseEnterprise.getEnterpriseCode())) {
                return Boolean.FALSE;
            }
            context.getResultDto().setBusinessType(BusinessTypeEnum.ORDER_SALE_REFUND.getType());
            context.getResultDto().setDisplayBusinessType(DisplayBusinessTypeEnum.AFTERSALE_ORDER.getType());
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public List<Long> createOrder(EnterpriceCrossReceiveDeliveryResultReqDto context) {
        EnterpriseDto saleEnterpriseDto;
        EnterpriseDto purchaseDto;
        String purchaseOrderType;
        boolean isBusinessTypeSaleOrder = context.getResultDto().getBusinessType().equals(BusinessTypeEnum.ORDER_SALE.getType());
        String saleOrderType = isBusinessTypeSaleOrder ? CompanyTradeTypeEnum.SALE_ORDER.getType() : CompanyTradeTypeEnum.AFTERSALE_ORDER.getType();
        String string = purchaseOrderType = isBusinessTypeSaleOrder ? CompanyTradeTypeEnum.PURCHASE_ORDER.getType() : CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType();
        if (isBusinessTypeSaleOrder) {
            purchaseDto = this.orderDomain.getSaleOrderEnterprise(context.getResultDto().getId());
            saleEnterpriseDto = this.orderDomain.getLogicWarehouseEnterprise(context.getResultDto().getDeliveryLogicWarehouseCode());
        } else {
            purchaseDto = this.orderDomain.getAfterSaleOrderEnterprise(context.getResultDto().getId());
            saleEnterpriseDto = this.orderDomain.getLogicWarehouseEnterprise(context.getResultDto().getReceiveLogicWarehouseCode());
        }
        EnterpriceCrossTradeRelationRespDto tradeRelationDto = this.getEnterpriceCrossTradeRelationForSaleOrderScene(purchaseDto.getEnterpriseCode(), saleEnterpriseDto.getEnterpriseCode());
        ArrayList<Long> orderIds = new ArrayList<Long>();
        if (isBusinessTypeSaleOrder) {
            orderIds.add(this.createSaleOrder(saleOrderType, context, saleEnterpriseDto, tradeRelationDto).getId());
            orderIds.add(this.createPurchaseOrder(purchaseOrderType, context, purchaseDto, tradeRelationDto).getId());
        } else {
            orderIds.add(this.createPurchaseOrder(purchaseOrderType, context, purchaseDto, tradeRelationDto).getId());
            orderIds.add(this.createSaleOrder(saleOrderType, context, saleEnterpriseDto, tradeRelationDto).getId());
        }
        return orderIds;
    }

    private EnterpriceCrossOrderEo createSaleOrder(String orderType, EnterpriceCrossReceiveDeliveryResultReqDto context, EnterpriseDto saleEnterpriseDto, EnterpriceCrossTradeRelationRespDto tradeRelationDto) {
        EnterpriceCrossOrderEo saleOrder = this.createEo();
        saleOrder.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType());
        saleOrder.setBusinessType(context.getResultDto().getBusinessType());
        saleOrder.setDisplayBusinessType(context.getResultDto().getDisplayBusinessType());
        saleOrder.setResultOrderId(context.getResultDto().getId());
        saleOrder.setType(orderType);
        saleOrder.setDocumentNo(this.orderDomain.createDocumentNo(saleOrder.getType()));
        if (saleEnterpriseDto == null) {
            this.setExceptionToSyncException(saleOrder, "\u83b7\u53d6\u9500\u552e\u516c\u53f8\u5931\u8d25");
        } else {
            saleOrder.setSaleEnterpriseId(saleEnterpriseDto.getEnterpriseId());
            saleOrder.setSaleEnterpriseCode(saleEnterpriseDto.getEnterpriseCode());
        }
        if (tradeRelationDto == null) {
            this.setExceptionToSyncException(saleOrder, "\u83b7\u53d6\u5ba2\u6237\u4fe1\u606f\u5931\u8d25");
        } else {
            saleOrder.setCustomerId(tradeRelationDto.getCustomerId());
            saleOrder.setCustomerCode(tradeRelationDto.getCustomerCode());
        }
        saleOrder.setCalculateCompanyCode(saleOrder.getSaleEnterpriseCode());
        this.orderDomain.insert((BaseEo)saleOrder);
        if (saleOrder.getType().equals(CompanyTradeTypeEnum.SALE_ORDER.getType())) {
            Boolean deductResult = this.orderLineDomain.createOrderLine(context.getResultDto(), context.getResultDetailDtoList(), saleOrder);
            this.deductFailSetSyncException(deductResult, saleOrder);
        }
        if (saleOrder.getType().equals(CompanyTradeTypeEnum.AFTERSALE_ORDER.getType())) {
            Boolean duductResult = this.orderLineDomain.saleOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), saleOrder);
            this.deductFailSetSyncException(duductResult, saleOrder);
        }
        return saleOrder;
    }

    private EnterpriceCrossOrderEo createPurchaseOrder(String orderType, EnterpriceCrossReceiveDeliveryResultReqDto context, EnterpriseDto purchaseDto, EnterpriceCrossTradeRelationRespDto tradeRelationDto) {
        EnterpriceCrossOrderEo purchaseOrderEo = this.createEo();
        purchaseOrderEo.setSyncStatus(EnterpriceCrossOrderSyncErpStatusEnum.SYNC_TODO.getType());
        purchaseOrderEo.setBusinessType(context.getResultDto().getBusinessType());
        purchaseOrderEo.setDisplayBusinessType(context.getResultDto().getDisplayBusinessType());
        purchaseOrderEo.setResultOrderId(context.getResultDto().getId());
        purchaseOrderEo.setType(orderType);
        purchaseOrderEo.setDocumentNo(this.orderDomain.createDocumentNo(purchaseOrderEo.getType()));
        if (purchaseDto == null) {
            this.setExceptionToSyncException(purchaseOrderEo, "\u83b7\u53d6\u91c7\u8d2d\u65b9\u5931\u8d25");
        } else {
            purchaseOrderEo.setPurchaseEnterpriseId(purchaseDto.getEnterpriseId());
            purchaseOrderEo.setPurchaseEnterpriseCode(purchaseDto.getEnterpriseCode());
        }
        if (tradeRelationDto == null) {
            this.setExceptionToSyncException(purchaseOrderEo, "\u83b7\u53d6\u4f9b\u5e94\u5546\uff08\u9500\u552e\u65b9\uff09\u5931\u8d25");
        } else {
            purchaseOrderEo.setSupplierId(tradeRelationDto.getSupplierId());
            purchaseOrderEo.setSupplierCode(tradeRelationDto.getSupplierCode());
        }
        purchaseOrderEo.setCalculateCompanyCode(purchaseOrderEo.getPurchaseEnterpriseCode());
        this.orderDomain.insert((BaseEo)purchaseOrderEo);
        if (purchaseOrderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_ORDER.getType())) {
            Boolean deductResult = this.orderLineDomain.createOrderLine(context.getResultDto(), context.getResultDetailDtoList(), purchaseOrderEo);
            this.deductFailSetSyncException(deductResult, purchaseOrderEo);
        }
        if (purchaseOrderEo.getType().equals(CompanyTradeTypeEnum.PURCHASE_AFTERSALE_ORDER.getType())) {
            Boolean duductResult = this.orderLineDomain.purchaseOrderReturnDeductAndCreateOrderLine(context.getResultDetailDtoList(), purchaseOrderEo);
            this.deductFailSetSyncException(duductResult, purchaseOrderEo);
        }
        return purchaseOrderEo;
    }

    private EnterpriceCrossTradeRelationRespDto getEnterpriceCrossTradeRelationForSaleOrderScene(String purchaseEnterpriseCode, String saleEnterpriseCode) {
        if (StrUtil.isEmpty((CharSequence)purchaseEnterpriseCode) || StrUtil.isEmpty((CharSequence)saleEnterpriseCode)) {
            return null;
        }
        return this.tradeRelationService.getByPurchaseEnterpriseCodeAndEnterpriseCode(purchaseEnterpriseCode, saleEnterpriseCode);
    }
}

