/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.entity.CostAllocRuleArchiveConverter;
import com.yunxi.dg.base.center.report.domain.entity.ICostAllocRuleArchiveDomain;
import com.yunxi.dg.base.center.report.dto.entity.CostAllocRuleArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchiveDto;
import com.yunxi.dg.base.center.report.dto.entity.CostArchivePageReqDto;
import com.yunxi.dg.base.center.report.eo.CostAllocRuleArchiveEo;
import com.yunxi.dg.base.center.report.service.entity.ICostAllocRuleArchiveService;
import com.yunxi.dg.base.center.report.service.entity.ICostArchiveService;
import com.yunxi.dg.base.center.report.service.utils.BeanConvertUtil;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class CostAllocRuleArchiveServiceImpl
extends BaseServiceImpl<CostAllocRuleArchiveDto, CostAllocRuleArchiveEo, ICostAllocRuleArchiveDomain>
implements ICostAllocRuleArchiveService {
    @Resource
    private ICostArchiveService iCostArchiveService;

    public CostAllocRuleArchiveServiceImpl(ICostAllocRuleArchiveDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<CostAllocRuleArchiveDto, CostAllocRuleArchiveEo> converter() {
        return CostAllocRuleArchiveConverter.INSTANCE;
    }

    @Override
    public List<CostAllocRuleArchiveDto> queryByRuleId(Long id, Integer type) {
        List costAllocRuleArchiveEos = ((ICostAllocRuleArchiveDomain)this.domain).selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(CostAllocRuleArchiveEo.class).eq(CostAllocRuleArchiveEo::getType, (Object)type)).eq(CostAllocRuleArchiveEo::getRuleId, (Object)id));
        if (CollectionUtil.isEmpty((Collection)costAllocRuleArchiveEos)) {
            return Collections.emptyList();
        }
        List allocRuleArchiveList = BeanConvertUtil.copyToList((Collection)costAllocRuleArchiveEos, CostAllocRuleArchiveDto.class);
        Map<Long, List<CostAllocRuleArchiveDto>> allocRuleArchiveIdMap = allocRuleArchiveList.stream().collect(Collectors.groupingBy(CostAllocRuleArchiveDto::getArchiveId));
        List<CostArchiveDto> costArchiveList = this.listCostArchiveByIds(allocRuleArchiveIdMap.keySet());
        this.setMappingCostArchive(allocRuleArchiveIdMap, costArchiveList);
        return allocRuleArchiveList;
    }

    @Override
    public int countByArchiveIds(List<Long> archiveIds) {
        return ((ICostAllocRuleArchiveDomain)this.domain).countByArchiveIds(archiveIds);
    }

    private void setMappingCostArchive(Map<Long, List<CostAllocRuleArchiveDto>> allocRuleArchiveIdMap, List<CostArchiveDto> costArchiveList) {
        for (CostArchiveDto costArchiveDto : costArchiveList) {
            List<CostAllocRuleArchiveDto> allocRuleArchiveDtos = allocRuleArchiveIdMap.get(costArchiveDto.getId());
            allocRuleArchiveDtos.forEach(e -> {
                e.setCategoryName(costArchiveDto.getCategoryName());
                e.setCategoryCode(costArchiveDto.getCategoryCode());
                e.setJoinCategoryName(costArchiveDto.getJoinCategoryName());
                e.setJoinCategoryCode(costArchiveDto.getJoinCategoryCode());
                e.setName(costArchiveDto.getName());
                e.setCode(costArchiveDto.getCode());
            });
        }
    }

    private List<CostArchiveDto> listCostArchiveByIds(Set<Long> ids) {
        CostArchivePageReqDto costArchivePageReqDto = new CostArchivePageReqDto();
        costArchivePageReqDto.setIdList((List)Lists.newArrayList(ids));
        return this.iCostArchiveService.queryList(costArchivePageReqDto);
    }
}

