/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.json.JSONUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectReportDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCollectTypeDto;
import com.yunxi.dg.base.center.report.dto.entity.CustomerRebateCountDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockCountDto;
import com.yunxi.dg.base.center.report.dto.entity.PurchaseSaleStockTypeDto;
import com.yunxi.dg.base.center.report.service.entity.ICustomerRebateCollectReportService;
import com.yunxi.dg.base.poi.constant.PoiFileModeMap;
import com.yunxi.dg.base.poi.dto.ExportBaseModeDto;
import com.yunxi.dg.base.poi.dto.ExportQueryParamsReqDto;
import com.yunxi.dg.base.poi.dto.ImportBaseModeDto;
import com.yunxi.dg.base.poi.service.AbstractBaseFileOperationCommonService;
import com.yunxi.dg.base.poi.utils.EasyPoiExportUtil;
import com.yunxi.dg.base.poi.utils.SystemConfig;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Service;

@Service(value="AbstractBaseFileOperationCommonService_customer_rebate_collect_report")
public class CustomerRebateCollectReportFileService
extends AbstractBaseFileOperationCommonService
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(CustomerRebateCollectReportFileService.class);
    @Resource
    private ICustomerRebateCollectReportService service;

    public void afterPropertiesSet() throws Exception {
        String key = "customer_rebate_collect_report";
        PoiFileModeMap.importTemplateMap.put((Object)key, ImportBaseModeDto.class);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)1);
        PoiFileModeMap.importTemplateMap.put((Object)key, (Object)"\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, ExportBaseModeDto.class);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)2);
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868");
        PoiFileModeMap.exportTemplateMap.put((Object)key, (Object)"\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa");
    }

    public String uploadExportDataFile(ExportQueryParamsReqDto exportQueryParamsReqDto, String fileName, Class<? extends ExportBaseModeDto> exportTemplate) {
        int RETRY_MAX_COUNT = Integer.parseInt(SystemConfig.getProperty((String)"base.mgmt.export.retry.max.count", (String)"3"));
        CustomerRebateCollectReportPageReqDto req = (CustomerRebateCollectReportPageReqDto)JSONUtil.toBean((String)exportQueryParamsReqDto.getFilter(), CustomerRebateCollectReportPageReqDto.class);
        ArrayList<CustomerRebateCollectReportDto> list = new ArrayList<CustomerRebateCollectReportDto>();
        int pageNum = 1;
        req.setPageSize(Integer.valueOf(1000));
        boolean hasNextPage = false;
        do {
            int count = 0;
            req.setPageNum(Integer.valueOf(pageNum));
            while (count < RETRY_MAX_COUNT) {
                try {
                    PageInfo<CustomerRebateCollectReportDto> page = this.service.pageWithoutAlign(req);
                    log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875\uff0c\u91cd\u8bd5\u6b21\u6570 {}", new Object[]{pageNum, page.getSize(), page.getPages(), count});
                    if (page.getList() != null && !page.getList().isEmpty()) {
                        list.addAll(page.getList());
                    }
                    hasNextPage = page.isHasNextPage();
                    count = RETRY_MAX_COUNT + 1;
                }
                catch (Exception e) {
                    log.error("\u83b7\u53d6\u6570\u636e\u5931\u8d25\u4e86\uff0c\u5f00\u59cb\u8fdb\u884c\u91cd\u8bd5\uff0c\u76ee\u524d\u91cd\u8bd5\u7684\u6b21\u6570={}", (Object)(++count), (Object)e);
                    if (count < RETRY_MAX_COUNT) continue;
                    throw new BizException("\u62c9\u53d6\u6570\u636e\u5931\u8d25\u4e86");
                }
            }
            ++pageNum;
        } while (!CollectionUtil.isEmpty(list) && hasNextPage);
        if (list.isEmpty()) {
            return null;
        }
        log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u5f00\u59cb\u5bf9\u9f50\u8fdb\u9500\u5b58\u7c7b\u578b");
        this.service.align(list);
        log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u5bf9\u9f50\u8fdb\u9500\u5b58\u7c7b\u578b\u5b8c\u6210\uff0c\u51c6\u5907\u8f6c\u6210 Workbook");
        Workbook workbook = this.getWorkbook(list);
        log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u8f6c\u6210 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u4e0a\u5230\u5bf9\u8c61\u5b58\u50a8");
        try {
            log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u5f00\u59cb\u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8");
            String url = EasyPoiExportUtil.getLoadWorkbookUrl((Workbook)workbook, (String)exportQueryParamsReqDto.getExportFileName());
            log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u6210\u529f\uff0curl={}", (Object)url);
            return url;
        }
        catch (Exception e) {
            log.error("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u4e0a\u4f20\u5230\u5bf9\u8c61\u5b58\u50a8\u5931\u8d25", (Throwable)e);
            return null;
        }
    }

    private Workbook getWorkbook(List<CustomerRebateCollectReportDto> list) {
        ExcelWriter writer = ExcelUtil.getBigWriter();
        ArrayList primaryTitles = Lists.newArrayList((Object[])new String[]{"\u7ecf\u8425\u5355\u4f4d", "\u671f\u95f4", "\u6838\u7b97\u516c\u53f8", "\u5ba2\u6237\u540d\u79f0", "\u5ba2\u6237\u7f16\u7801", "\u5ba2\u6237\u5f52\u5c5e", "\u7701\u533a", "\u671f\u521d\u8fd4\u5229\u4f59\u989d", "\u5165\u6c60\u8fd4\u5229\u5408\u8ba1", "\u51fa\u6c60\u8fd4\u5229\u5408\u8ba1", "\u671f\u672b\u8fd4\u5229\u4f59\u989d"});
        AtomicInteger col = new AtomicInteger(0);
        primaryTitles.forEach(title -> {
            int firstColumn = col.get();
            int lastColumn = col.addAndGet(1) - 1;
            writer.merge(0, 2, firstColumn, lastColumn, title, true);
        });
        this.writeTitles(writer, col, list.get(0).getNormalRebate(), "\u5e38\u89c4\u8fd4\u5229");
        this.writeTitles(writer, col, list.get(0).getSpecialRebate(), "\u4e13\u9879\u8fd4\u5229");
        writer.setCurrentRow(3);
        log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u5199\u5165\u6807\u9898\u5230 Workbook \u5b8c\u6210\uff0c\u51c6\u5907\u5199\u5165 {} \u6761\u6570\u636e", (Object)list.size());
        list.forEach(item -> {
            ArrayList row = Lists.newArrayList((Object[])new Object[]{this.toEmpty(item.getBusinessUnitName()), this.toEmpty(item.getBusinessDateRange()), this.toEmpty(item.getCompanyName()), this.toEmpty(item.getCustomerName()), this.toEmpty(item.getCustomerCode()), this.toEmpty(item.getShopName()), this.toEmpty(item.getBusinessArea()), this.plan(item.getPeriodBeginBalance()), this.plan(item.getChangeInAmount()), this.plan(item.getChangeOutAmount()), this.plan(item.getPeriodEndBalance())});
            row.addAll(this.toCells(item.getNormalRebate()));
            row.addAll(this.toCells(item.getSpecialRebate()));
            writer.writeRow((Iterable)row);
        });
        log.info("\u5ba2\u6237\u8fd4\u5229\u6c47\u603b\u8868\u5bfc\u51fa: \u5199\u5165 {} \u6761\u6570\u636e\u5b8c\u6210", (Object)list.size());
        return writer.getWorkbook();
    }

    private List<Object> toCells(CustomerRebateCollectTypeDto typeDto) {
        ArrayList<Object> result = new ArrayList<Object>();
        result.add(typeDto.getPeriodBeginBalance());
        typeDto.getInList().forEach(dto -> result.add(dto.getTradeAmount()));
        result.add(typeDto.getChangeInAmount());
        typeDto.getOutList().forEach(dto -> result.add(dto.getTradeAmount()));
        result.add(typeDto.getChangeOutAmount());
        return result;
    }

    private void writeTitles(ExcelWriter writer, AtomicInteger col, CustomerRebateCollectTypeDto typeDto, String firstTitle) {
        int y;
        int x;
        CustomerRebateCountDto dto;
        int i;
        CellStyle style = writer.getStyleSet().getHeadCellStyle();
        if (style == null) {
            style = writer.getStyleSet().getCellStyle();
        }
        int count = 1 + typeDto.getInList().size() + 1 + typeDto.getOutList().size() + 1;
        writer.merge(0, 0, col.get(), col.get() + count - 1, (Object)firstTitle, true);
        writer.merge(1, 2, col.get(), col.get(), (Object)"\u671f\u521d\u8fd4\u5229\u4f59\u989d", true);
        log.info("typeDto.getInList()={}", (Object)typeDto.getInList().size());
        log.info("typeDto.getOutList().size()={}", (Object)typeDto.getOutList().size());
        writer.merge(1, 1, col.get() + 1, col.get() + 1 + typeDto.getInList().size(), (Object)"\u8fd4\u5229\u5165\u6c60", true);
        writer.merge(1, 1, col.get() + 1 + typeDto.getInList().size() + 1, col.get() + 1 + typeDto.getInList().size() + typeDto.getOutList().size() + 1, (Object)"\u8fd4\u5229\u51fa\u6c60", true);
        for (i = 0; i < typeDto.getInList().size(); ++i) {
            dto = (CustomerRebateCountDto)typeDto.getInList().get(i);
            x = col.get() + 1 + i;
            y = 2;
            writer.writeCellValue(x, y, (Object)dto.getRebateBusinessTypeName());
            writer.setStyle(style, x, y);
        }
        writer.writeCellValue(col.get() + 1 + typeDto.getInList().size(), 2, (Object)"\u5165\u6c60\u5408\u8ba1");
        writer.setStyle(style, col.get() + 1 + typeDto.getInList().size(), 2);
        for (i = 0; i < typeDto.getOutList().size(); ++i) {
            dto = (CustomerRebateCountDto)typeDto.getOutList().get(i);
            x = col.get() + 1 + typeDto.getInList().size() + 1 + i;
            y = 2;
            writer.writeCellValue(x, y, (Object)dto.getRebateBusinessTypeName());
            writer.setStyle(style, x, y);
        }
        writer.writeCellValue(col.get() + 1 + typeDto.getInList().size() + 1 + typeDto.getOutList().size(), 2, (Object)"\u51fa\u6c60\u5408\u8ba1");
        writer.setStyle(style, col.get() + 1 + typeDto.getInList().size() + 1 + typeDto.getOutList().size(), 2);
        col.getAndAdd(count);
    }

    private List<String> typesToCells(List<PurchaseSaleStockCountDto> inList, List<PurchaseSaleStockTypeDto> types) {
        Map<String, PurchaseSaleStockCountDto> map = inList.stream().collect(Collectors.toMap(k -> k.getType(), v -> v, (a, b) -> {
            log.warn("\u91cd\u590d\u7684\u8fdb\u9500\u5b58\u7f16\u7801\uff1aa={}, b={}", a, b);
            return b;
        }));
        return types.stream().map(type -> {
            PurchaseSaleStockCountDto count = (PurchaseSaleStockCountDto)map.get(type.getCode());
            return this.plan(count != null ? count.getQuantity() : BigDecimal.ZERO);
        }).collect(Collectors.toList());
    }

    private String toEmpty(String value) {
        return value == null ? "" : value;
    }

    private String plan(BigDecimal value) {
        if (value == null) {
            return "";
        }
        return value.stripTrailingZeros().toPlainString();
    }
}

