/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.util.StrUtil;
import com.aliyun.openservices.shade.org.apache.commons.lang3.StringUtils;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DgShopConverter;
import com.yunxi.dg.base.center.report.domain.entity.IDgShopDomain;
import com.yunxi.dg.base.center.report.dto.constants.SourceTypeEnum;
import com.yunxi.dg.base.center.report.dto.entity.DgShopDto;
import com.yunxi.dg.base.center.report.dto.shop.request.DgShopQueryReqDto;
import com.yunxi.dg.base.center.report.dto.shop.response.DgShopRespDto;
import com.yunxi.dg.base.center.report.eo.DgShopEo;
import com.yunxi.dg.base.center.report.service.entity.IDgShopAssistService;
import com.yunxi.dg.base.center.report.service.entity.IDgShopService;
import com.yunxi.dg.base.center.report.utils.MybatisPlusUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.springframework.stereotype.Service;

@Service
public class DgShopServiceImpl
extends BaseServiceImpl<DgShopDto, DgShopEo, IDgShopDomain>
implements IDgShopService {
    @Resource
    private IDgShopAssistService iDgShopAssistService;

    public DgShopServiceImpl(IDgShopDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgShopDto, DgShopEo> converter() {
        return DgShopConverter.INSTANCE;
    }

    @Override
    public PageInfo<DgShopRespDto> queryPageShop(DgShopQueryReqDto queryReqDto) {
        PageInfo<DgShopRespDto> pageInfo;
        if (StringUtils.isNotBlank((CharSequence)queryReqDto.getStoreCode())) {
            queryReqDto.setStoreCodeList(Arrays.asList(queryReqDto.getStoreCode().trim().split("[,\uff0c ]")));
            queryReqDto.setStoreCode(null);
        }
        if (CollectionUtils.isEmpty((Collection)(pageInfo = this.iDgShopAssistService.queryPageShop(queryReqDto)).getList())) {
            return pageInfo;
        }
        pageInfo.getList().forEach(o -> {
            if (Objects.equals(SourceTypeEnum.CHANNEL.getType(), o.getSourceType())) {
                o.setSaleOrganizationName(null);
                o.setSaleOrganizationCode(null);
                o.setSaleOrganizationId(null);
            }
            o.setStoreType(o.getManageType());
        });
        return pageInfo;
    }

    @Override
    public List<DgShopRespDto> queryListShop(DgShopQueryReqDto reqDto) {
        return this.iDgShopAssistService.queryListShop(reqDto);
    }

    @Override
    public DgShopRespDto queryByCode(String code) {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setStoreCode(code);
        List<DgShopRespDto> dgShopRespDtos = this.queryListShop(reqDto);
        if (CollUtil.isEmpty(dgShopRespDtos)) {
            return null;
        }
        return dgShopRespDtos.get(0);
    }

    @Override
    public DgShopRespDto queryByName(String name) {
        DgShopQueryReqDto reqDto = new DgShopQueryReqDto();
        reqDto.setStoreName(name);
        List<DgShopRespDto> dgShopRespDtos = this.queryListShop(reqDto);
        if (CollUtil.isEmpty(dgShopRespDtos)) {
            return null;
        }
        return dgShopRespDtos.stream().filter(shop -> StrUtil.equals((CharSequence)shop.getStoreName(), (CharSequence)name)).findAny().orElse(null);
    }

    @Override
    public DgShopRespDto thisIsRealQueryByCode(String code) {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)MybatisPlusUtils.lambdaQuery(DgShopEo.class).eq(true, DgShopEo::getCode, (Object)code)).eq(true, BaseEo::getDr, (Object)0);
        DgShopEo shopEo = (DgShopEo)((IDgShopDomain)this.domain).selectOne(queryWrapper);
        return this.shopEosToDtos(shopEo);
    }

    private List<DgShopRespDto> shopEosToDtos(List<DgShopEo> eos) {
        ArrayList dtos = Lists.newArrayList();
        if (CollectionUtils.isEmpty(eos)) {
            return dtos;
        }
        eos.forEach(eo -> dtos.add(this.shopEosToDtos((DgShopEo)eo)));
        return dtos;
    }

    private DgShopRespDto shopEosToDtos(DgShopEo eo) {
        if (Objects.isNull(eo)) {
            return null;
        }
        DgShopRespDto dto = new DgShopRespDto();
        BeanUtil.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
        dto.setStoreCode(eo.getCode());
        dto.setStoreName(eo.getName());
        dto.setStoreType(eo.getManageType());
        dto.setCutPaymentType(eo.getCutPaymentType());
        dto.setSaleOrganizationCode(eo.getOrganizationCode());
        dto.setSaleOrganizationId(eo.getOrganizationId());
        dto.setLineType(eo.getType());
        dto.setStoreBriefIntroduction(eo.getBriefIntroduction());
        return dto;
    }
}

