/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.entity.impl;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.date.LocalDateTimeUtil;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.entity.DomesticSalesAccountsReportConverter;
import com.yunxi.dg.base.center.report.domain.entity.IAccountFlowDomain;
import com.yunxi.dg.base.center.report.domain.entity.IDomesticSalesAccountsReportDomain;
import com.yunxi.dg.base.center.report.dto.entity.DomesticSalesAccountsKeyDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticSalesAccountsReportDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticSalesAccountsReportJoinDto;
import com.yunxi.dg.base.center.report.dto.entity.DomesticSalesAccountsReportPageReqDto;
import com.yunxi.dg.base.center.report.dto.entity.ReportSyncReqDto;
import com.yunxi.dg.base.center.report.eo.DomesticSalesAccountsReportEo;
import com.yunxi.dg.base.center.report.eo.FinishProductInStorageReportEo;
import com.yunxi.dg.base.center.report.eo.account.AccountFlowEo;
import com.yunxi.dg.base.center.report.service.entity.IDomesticSalesAccountsReportService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DomesticSalesAccountsReportServiceImpl
extends BaseServiceImpl<DomesticSalesAccountsReportDto, DomesticSalesAccountsReportEo, IDomesticSalesAccountsReportDomain>
implements IDomesticSalesAccountsReportService {
    private static final Logger log = LoggerFactory.getLogger(DomesticSalesAccountsReportServiceImpl.class);
    @Resource
    private IAccountFlowDomain accountFlowDomain;
    private final DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public DomesticSalesAccountsReportServiceImpl(IDomesticSalesAccountsReportDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DomesticSalesAccountsReportDto, DomesticSalesAccountsReportEo> converter() {
        return DomesticSalesAccountsReportConverter.INSTANCE;
    }

    @Override
    public void syncWithParams(ReportSyncReqDto dto) {
        dto.paramsCheck(() -> this.accountFlowDomain.getMinUpdateTime());
        dto.syncByStep("\u5185\u9500\u8d26\u76ee\u8868", this::doSyncInternal);
    }

    private void doSyncInternal(LocalDateTime startTime, LocalDateTime endTime) {
        boolean hasNextPage;
        ArrayList keys = new ArrayList();
        int pageNum = 1;
        int pageSize = 1000;
        do {
            PageInfo page = this.accountFlowDomain.pageByUpdateTime(startTime, endTime, pageNum, pageSize);
            log.info("\u5185\u9500\u8d26\u76ee\u8868\u540c\u6b65: {} - {} \u67e5\u8be2\u5230\u7b2c {} \u9875\u6709 {} \u6761\u6570\u636e\uff0c\u5171 {} \u9875", new Object[]{startTime.format(this.formatter), endTime.format(this.formatter), pageNum, page.getSize(), page.getPages()});
            ++pageNum;
            hasNextPage = page.isHasNextPage();
            List list = page.getList();
            if (list == null || list.isEmpty()) continue;
            list.forEach(flow -> {
                DomesticSalesAccountsKeyDto key = this.flowToKey((AccountFlowEo)flow);
                if (!keys.contains(key)) {
                    keys.add(key);
                }
            });
        } while (hasNextPage);
        Map<LocalDateTime, List<DomesticSalesAccountsKeyDto>> group = keys.stream().collect(Collectors.groupingBy(DomesticSalesAccountsKeyDto::getBusinessDate));
        List reports = group.entrySet().stream().flatMap(entry -> this.toReports((List)entry.getValue()).stream()).collect(Collectors.toList());
    }

    private DomesticSalesAccountsKeyDto flowToKey(AccountFlowEo flow) {
        LocalDateTime businessDate = DomesticSalesAccountsReportServiceImpl.getBusinessDate(flow);
        return DomesticSalesAccountsKeyDto.builder().businessDate(businessDate).shopCode(flow.getShopCode()).build();
    }

    private static LocalDateTime getBusinessDate(AccountFlowEo flow) {
        return LocalDateTimeUtil.of((Date)flow.getBusinessDate()).toLocalDate().atTime(LocalTime.MIN);
    }

    private List<DomesticSalesAccountsReportJoinDto> toReports(List<DomesticSalesAccountsKeyDto> keys) {
        List flows = this.accountFlowDomain.queryByDomesticSalesAccountsKeys(keys);
        Map<DomesticSalesAccountsKeyDto, List<AccountFlowEo>> group = flows.stream().collect(Collectors.groupingBy(this::flowToKey));
        return keys.stream().map(key -> {
            List keyFlows = (List)group.get(key);
            return this.toReport(keyFlows);
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }

    private DomesticSalesAccountsReportJoinDto toReport(List<AccountFlowEo> flows) {
        if (flows == null || flows.isEmpty()) {
            return null;
        }
        AccountFlowEo flow = flows.get(0);
        Date businessDate = DateUtil.date((TemporalAccessor)DomesticSalesAccountsReportServiceImpl.getBusinessDate(flow)).toJdkDate();
        return null;
    }

    private void doSyncInternal(List<FinishProductInStorageReportEo> list) {
    }

    @Override
    public PageInfo<DomesticSalesAccountsReportDto> page(DomesticSalesAccountsReportPageReqDto dto) {
        return null;
    }

    @Override
    public LocalDateTime getLastOrderUpdateTime() {
        return null;
    }
}

