/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.es;

import cn.hutool.core.util.StrUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.huieryun.opensearch.provider.es68.RestSearchClientUtils;
import com.dtyunxi.huieryun.opensearch.vo.OSSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.OpenSearchVo;
import com.dtyunxi.huieryun.opensearch.vo.SearchResultVo;
import com.yunxi.dg.base.center.report.dto.es.base.BaseEsPageDto;
import com.yunxi.dg.base.center.report.utils.EsBuildJsonQueryHelper;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.util.EntityUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.RestHighLevelClient;
import org.elasticsearch.common.text.Text;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.search.SearchHits;
import org.elasticsearch.search.fetch.subphase.highlight.HighlightField;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RestSearchExtService {
    private static final Logger log = LoggerFactory.getLogger(RestSearchExtService.class);
    @Autowired
    private OpenSearchVo openSearchVo;

    public SearchResultVo esSearch(BaseEsPageDto dto) {
        try {
            if (StrUtil.isBlank((CharSequence)dto.getScrollId())) {
                return this.esSearchScroll(dto);
            }
            String json = String.format("{\"scroll_id\": \"%s\",\"scroll\": \"%s\"}", dto.getScrollId(), dto.getScroll());
            RestHighLevelClient client = RestSearchClientUtils.createClient((OpenSearchVo)this.openSearchVo);
            Request request = new Request("GET", String.format("/_search/scroll", dto.getIndexName()));
            request.setJsonEntity(json);
            Response response = client.getLowLevelClient().performRequest(request);
            return this.extractSearchResultVo(dto, response);
        }
        catch (Exception var7) {
            log.error("\u67e5\u8be2ES\u5f02\u5e38", (Throwable)var7);
            throw new BizException("\u67e5\u8be2ES\u5f02\u5e38");
        }
    }

    private SearchResultVo esSearchScroll(BaseEsPageDto dto) {
        try {
            RestHighLevelClient client = RestSearchClientUtils.createClient((OpenSearchVo)this.openSearchVo);
            String scroll = dto.isUseScroll() ? String.format("?scroll=%s", dto.getScroll()) : "";
            Request request = new Request("GET", String.format("/%s/_search%s", dto.getIndexName(), scroll));
            String json = EsBuildJsonQueryHelper.buildQueryJsonPage(dto);
            log.info("\u6784\u5efa\u67e5\u8be2es ->{}", (Object)json);
            request.setJsonEntity(json);
            Response response = client.getLowLevelClient().performRequest(request);
            return this.extractSearchResultVo(dto, response);
        }
        catch (Exception var7) {
            throw new RuntimeException("\u67e5\u8be2\u5f02\u5e38", var7);
        }
    }

    protected SearchResultVo extractSearchResultVo(BaseEsPageDto dto, Response response) throws IOException {
        SearchResponse searchResponse = this.convertResponseToSearchResponse(response);
        OSSearchVo vo = new OSSearchVo();
        vo.setPage(dto.getPageNum().intValue());
        vo.setPageSize(dto.getPageSize().intValue());
        vo.setUseScroll(dto.isUseScroll());
        SearchResultVo searchResultVo = this.wrapSearchResultVo(vo, searchResponse);
        return searchResultVo;
    }

    private SearchResponse convertResponseToSearchResponse(Response response) throws IOException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == RestStatus.OK.getStatus()) {
            String responseBody = EntityUtils.toString((HttpEntity)response.getEntity(), (Charset)StandardCharsets.UTF_8);
            JSONObject jsonObject = JSON.parseObject((String)responseBody);
            JSONObject hits = JSON.parseObject((String)jsonObject.get((Object)"hits").toString());
            XContentParser parser = JsonXContent.jsonXContent.createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, responseBody);
            SearchResponse searchResponse = SearchResponse.fromXContent((XContentParser)parser);
            if (!(hits.get((Object)"total") instanceof Map)) {
                searchResponse.getHits().totalHits = Long.valueOf(hits.get((Object)"total").toString());
            } else {
                Object total = JSON.parseObject((String)hits.get((Object)"total").toString()).get((Object)"value");
                searchResponse.getHits().totalHits = Long.valueOf(total.toString());
            }
            return searchResponse;
        }
        throw new ResponseException(response);
    }

    protected SearchResultVo wrapSearchResultVo(OSSearchVo vo, SearchResponse response) {
        SearchHits hits = response.getHits();
        long totalSize = this.getTotalSize(hits);
        if (totalSize == 0L) {
            return new SearchResultVo();
        }
        SearchResultVo result = new SearchResultVo();
        result.setTotalSize(totalSize);
        result.setPageSize(vo.getPageSize());
        result.setStartIndex(vo.getStartIndex());
        if (vo.isFetchSource()) {
            result.setDocValues(this.wrapDocValue(hits));
            if (vo.isUseScroll()) {
                result.setScrollId(response.getScrollId());
            }
        }
        return result;
    }

    protected long getTotalSize(SearchHits hits) {
        return hits.totalHits;
    }

    protected List<Map<String, Object>> wrapDocValue(SearchHits hits) {
        SearchHit[] searchHits = hits.getHits();
        ArrayList<Map<String, Object>> docValue = new ArrayList<Map<String, Object>>(searchHits.length);
        SearchHit[] var4 = searchHits;
        int var5 = searchHits.length;
        for (int var6 = 0; var6 < var5; ++var6) {
            SearchHit searchHit = var4[var6];
            Map highlightFields = searchHit.getHighlightFields();
            Map item = searchHit.getSourceAsMap();
            if (!highlightFields.isEmpty()) {
                StringBuilder highlightFieldStringBuilder = new StringBuilder();
                for (String key : highlightFields.keySet()) {
                    for (Text text : ((HighlightField)highlightFields.get(key)).fragments()) {
                        highlightFieldStringBuilder.append(text.string());
                    }
                    item.put(key, highlightFieldStringBuilder.toString());
                }
            }
            item.put("_score", Float.valueOf(searchHit.getScore()));
            docValue.add(item);
        }
        return docValue;
    }
}

