/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.agg;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.erp.dto.erp.ErpInventoryAvailNumberDto;
import com.yunxi.dg.base.center.erp.dto.erp.ErpInventoryNumQueryDto;
import com.yunxi.dg.base.center.erp.proxy.IExternalInventoryErpApiProxy;
import com.yunxi.dg.base.center.report.dao.mapper.agg.DgBasisOrderRelOrderInfoMapper;
import com.yunxi.dg.base.center.report.dao.mapper.inventory.DgOutNoticeOrderMapper;
import com.yunxi.dg.base.center.report.domain.customer.IDgCsShipmentEnterpriseDomain;
import com.yunxi.dg.base.center.report.domain.entity.IAdjustmentOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IOrderUnitConversionRecordDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgInOtherStorageOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutResultOrderDomain;
import com.yunxi.dg.base.center.report.dto.agg.DgBasisOrderRelOrderInfoRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgBusinessGoodsRespDto;
import com.yunxi.dg.base.center.report.dto.agg.DgInventoryBillGoodsDto;
import com.yunxi.dg.base.center.report.dto.agg.DgInventoryBillGoodsReqDto;
import com.yunxi.dg.base.center.report.dto.agg.DgRelOrderReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.BaseQueryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgDeliveryResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutNoticeOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.utils.OrderUnitConverterDto;
import com.yunxi.dg.base.center.report.dto.item.ItDirDto;
import com.yunxi.dg.base.center.report.enums.DgDocumentTypeEnum;
import com.yunxi.dg.base.center.report.enums.DgInventoryBizDateBizTypeEnum;
import com.yunxi.dg.base.center.report.enums.DgLogicWarehouseQualityEnum;
import com.yunxi.dg.base.center.report.enums.DgOrderTypeEnum;
import com.yunxi.dg.base.center.report.eo.OrderUnitConversionRecordEo;
import com.yunxi.dg.base.center.report.eo.adjustment.AdjustmentOrderDetailEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgInOtherStorageOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutResultOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.InventoryBatchEo;
import com.yunxi.dg.base.center.report.service.agg.IDgBasisOrderRelOrderInfoService;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.IReportDataSearchService;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.ReportDataSearchHelper;
import com.yunxi.dg.base.center.report.service.impl.inventory.utils.UnitConverUtils;
import com.yunxi.dg.base.center.report.service.item.IItDirService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgBasisOrderRelOrderInfoServiceImpl
implements IDgBasisOrderRelOrderInfoService {
    private static final Logger log = LoggerFactory.getLogger(DgBasisOrderRelOrderInfoServiceImpl.class);
    @Resource
    private IDgDeliveryNoticeOrderDomain iDgDeliveryNoticeOrderDomain;
    @Resource
    private IDgDeliveryResultOrderDomain iDgDeliveryResultOrderDomain;
    @Resource
    private IDgOutNoticeOrderDomain iDgOutNoticeOrderDomain;
    @Resource
    private IDgOutResultOrderDomain iDgOutResultOrderDomain;
    @Resource
    private DgBasisOrderRelOrderInfoMapper dgBasisOrderRelOrderInfoMapper;
    @Resource
    private DgOutNoticeOrderMapper outNoticeOrderMapper;
    @Resource
    private IAdjustmentOrderDetailDomain adjustmentOrderDetailDomain;
    @Resource
    private IOrderUnitConversionRecordDomain orderUnitConversionRecordDomain;
    @Resource
    private IDgCsShipmentEnterpriseDomain shipmentEnterpriseDomain;
    @Resource
    private IDgInOtherStorageOrderDomain iDgInOtherStorageOrderDomain;
    @Resource
    private IExternalInventoryErpApiProxy iExternalInventoryErpApiProxy;
    @Resource
    private ReportDataSearchHelper reportDataSearchHelper;
    @Resource
    private IItDirService dirService;

    @Override
    public RestResponse<List<DgBasisOrderRelOrderInfoRespDto>> queryRelOrderByRelevanceNo(DgRelOrderReqDto dgRelOrderReqDto) {
        ArrayList<DgBasisOrderRelOrderInfoRespDto> relOrderInfoList = new ArrayList<DgBasisOrderRelOrderInfoRespDto>();
        log.info("\u5173\u8054\u5355\u636e\u67e5\u8be2\u53c2\u6570:" + dgRelOrderReqDto);
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)dgRelOrderReqDto.getRelevanceNo()), (String)"\u5173\u8054\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List dgOutResultOrderEoList = ((ExtQueryChainWrapper)this.iDgOutResultOrderDomain.filter().eq((Object)"relevance_no", (Object)dgRelOrderReqDto.getRelevanceNo())).list();
        List<String> shippingCodeList = dgOutResultOrderEoList.stream().filter(o -> Objects.nonNull(o.getShippingCode())).map(DgOutResultOrderEo::getShippingCode).collect(Collectors.toList());
        List<String> shippingTypeList = dgOutResultOrderEoList.stream().filter(o -> Objects.nonNull(o.getShippingType())).map(DgOutResultOrderEo::getShippingType).collect(Collectors.toList());
        List<String> shippingCompanyList = dgOutResultOrderEoList.stream().filter(o -> Objects.nonNull(o.getShippingCompanyCode())).map(DgOutResultOrderEo::getShippingCompanyCode).collect(Collectors.toList());
        List<String> shippingCompanyNameList = dgOutResultOrderEoList.stream().filter(o -> Objects.nonNull(o.getShippingCompany())).map(DgOutResultOrderEo::getShippingCompany).collect(Collectors.toList());
        this.getDeliveryNoticeOrderInfo(dgRelOrderReqDto, relOrderInfoList, shippingCodeList, shippingTypeList, shippingCompanyList, shippingCompanyNameList);
        this.getDeliveryResultOrderInfo(dgRelOrderReqDto, relOrderInfoList);
        this.getOutNoticeOrderInfo(dgRelOrderReqDto, relOrderInfoList, shippingCodeList, shippingTypeList, shippingCompanyList, shippingCompanyNameList);
        this.getOutResultOrderInfo(dgRelOrderReqDto, relOrderInfoList);
        AtomicInteger ai = new AtomicInteger(1);
        relOrderInfoList.forEach(r -> r.setId(Long.valueOf(ai.getAndIncrement())));
        if (CollectionUtils.isEmpty(relOrderInfoList)) {
            return new RestResponse();
        }
        return new RestResponse(relOrderInfoList);
    }

    @Override
    public RestResponse<PageInfo<DgInventoryBillGoodsDto>> queryGoodByDocumentNo(DgInventoryBillGoodsReqDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        AssertUtils.isTrue(((StringUtils.isNotEmpty((CharSequence)dto.getRelevanceNo()) || StringUtils.isNotEmpty((CharSequence)dto.getDocumentNo()) || CollectionUtils.isNotEmpty((Collection)dto.getDocumentNoList())) && StringUtils.isNotEmpty((CharSequence)dto.getOrderType()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u6e05\u5355\u5355\u53f7\u6216\u8005\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        PageInfo<DgInventoryBillGoodsDto> pageInfo = this.queryInventoryBillGoods(dto);
        List<DgInventoryBillGoodsDto> dgInventoryBillGoodsDtos = pageInfo.getList();
        if (dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_NOTICE_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_RESULT_ORDER.getCode())) {
            dgInventoryBillGoodsDtos.addAll(this.handleAdjustment(dgInventoryBillGoodsDtos));
        }
        dgInventoryBillGoodsDtos = this.packagingMaterialsFilter(dgInventoryBillGoodsDtos, dto);
        this.handleUnitQuantity(dgInventoryBillGoodsDtos);
        return new RestResponse(pageInfo);
    }

    @Override
    public RestResponse<List<DgInventoryBillGoodsDto>> queryGoodDetailByDocumentNo(DgInventoryBillGoodsReqDto dto) {
        AssertUtils.isTrue(((StringUtils.isNotEmpty((CharSequence)dto.getRelevanceNo()) || StringUtils.isNotEmpty((CharSequence)dto.getDocumentNo()) || CollectionUtils.isNotEmpty((Collection)dto.getDocumentNoList())) && StringUtils.isNotEmpty((CharSequence)dto.getOrderType()) ? 1 : 0) != 0, (String)"\u5546\u54c1\u6e05\u5355\u5355\u53f7\u6216\u8005\u5355\u636e\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgInventoryBillGoodsDto> dgInventoryBillGoodsDtos = this.queryInventoryBillGoods(dto).getList();
        if (dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_NOTICE_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_RESULT_ORDER.getCode())) {
            dgInventoryBillGoodsDtos.addAll(this.handleAdjustment(dgInventoryBillGoodsDtos));
        }
        dgInventoryBillGoodsDtos = this.packagingMaterialsFilter(dgInventoryBillGoodsDtos, dto);
        this.handleUnitQuantity(dgInventoryBillGoodsDtos);
        return new RestResponse(dgInventoryBillGoodsDtos);
    }

    private List<DgInventoryBillGoodsDto> packagingMaterialsFilter(List<DgInventoryBillGoodsDto> dgInventoryBillGoodsDtos, DgInventoryBillGoodsReqDto dto) {
        if (!"packagingMaterials".equals(dto.getOrderLineClassify())) {
            return dgInventoryBillGoodsDtos.stream().filter(o -> !"packagingMaterials".equals(o.getOrderLineClassify())).collect(Collectors.toList());
        }
        return dgInventoryBillGoodsDtos.stream().filter(o -> "packagingMaterials".equals(o.getOrderLineClassify())).collect(Collectors.toList());
    }

    private void handleUnitQuantity(List<DgInventoryBillGoodsDto> dgInventoryBillGoodsDtos) {
        List<String> relevanceNoList = dgInventoryBillGoodsDtos.stream().map(DgInventoryBillGoodsDto::getRelevanceNo).collect(Collectors.toList());
        Map<String, OrderUnitConversionRecordEo> unitConversionMap = this.getOrderUnitConversionRecordEoMap(relevanceNoList);
        dgInventoryBillGoodsDtos.forEach(o -> {
            if (unitConversionMap.containsKey(o.getRelevanceNo() + o.getSkuCode() + o.getUnit())) {
                this.unitConversion((DgInventoryBillGoodsDto)o, (OrderUnitConversionRecordEo)unitConversionMap.get(o.getRelevanceNo() + o.getSkuCode() + o.getUnit()));
            }
            o.setInventoryProperty(Optional.ofNullable(o.getInventoryProperty()).orElse(DgLogicWarehouseQualityEnum.QUALIFIED.getCode()));
            if (StringUtils.isNotBlank((CharSequence)o.getExtension())) {
                JSONObject ext = JSONObject.parseObject((String)o.getExtension());
                o.setWeight(ext.getBigDecimal("weight"));
                o.setBomVersion(ext.getString("bomVersion"));
                o.setUnitPrice(ext.getBigDecimal("unitPrice"));
                o.setMixtureRatio(ext.getInteger("mixtureRatio"));
                o.setMixtureRatioDenominator(ext.getInteger("mixtureRatioDenominator"));
                if (o.getVolume() == null) {
                    o.setVolume(ext.getBigDecimal("volume"));
                }
                o.setWeight(ext.getBigDecimal("weight"));
                o.setItemAttribute((Integer)ObjectUtil.defaultIfNull((Object)ext.getInteger("itemAttribute"), (Object)0));
            }
        });
    }

    private Map<String, OrderUnitConversionRecordEo> getOrderUnitConversionRecordEoMap(List<String> relevanceNoList) {
        if (CollectionUtil.isEmpty(relevanceNoList)) {
            return Maps.newHashMap();
        }
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in((Object)"document_code", relevanceNoList)).list();
        return unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
    }

    private List<DgInventoryBillGoodsDto> handleAdjustment(List<DgInventoryBillGoodsDto> dgInventoryBillGoodsDtos) {
        int size = dgInventoryBillGoodsDtos.size();
        List adjustmentOrderDetailEos = ((ExtQueryChainWrapper)this.adjustmentOrderDetailDomain.filter().eq((Object)"adjustment_no", (Object)dgInventoryBillGoodsDtos.get(0).getRelevanceNo())).list();
        Map adjustmentDetailEoMap = adjustmentOrderDetailEos.stream().collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        Set filterSet = adjustmentOrderDetailEos.stream().map(o -> o.getSkuCode() + "_" + o.getBatch()).collect(Collectors.toSet());
        List skuCodes = adjustmentOrderDetailEos.stream().map(AdjustmentOrderDetailEo::getSkuCode).collect(Collectors.toList());
        List batches = adjustmentOrderDetailEos.stream().map(AdjustmentOrderDetailEo::getBatch).collect(Collectors.toList());
        Map inventoryBatchEoMap = this.dgBasisOrderRelOrderInfoMapper.queryBatch(skuCodes, batches).stream().filter(o -> filterSet.contains(o.getSkuCode() + "_" + o.getBatch())).collect(Collectors.toMap(o -> o.getSkuCode() + "_" + o.getBatch(), Function.identity(), (k1, k2) -> k1));
        return BeanUtil.copyToList(dgInventoryBillGoodsDtos, DgInventoryBillGoodsDto.class).stream().peek(r -> {
            InventoryBatchEo batchEo;
            r.setAdjustedType("\u51cf\u5c11");
            r.setId(Long.valueOf((long)size + r.getId()));
            AdjustmentOrderDetailEo adjustmentOrderDetailEo = (AdjustmentOrderDetailEo)adjustmentDetailEoMap.get(r.getSkuCode() + "_" + r.getBatch());
            if (Objects.nonNull(adjustmentOrderDetailEo)) {
                r.setBatch((String)ObjectUtils.defaultIfNull((Object)adjustmentOrderDetailEo.getOrigBatch(), (Object)r.getBatch()));
                r.setInventoryProperty((String)ObjectUtils.defaultIfNull((Object)adjustmentOrderDetailEo.getInventoryProperty(), (Object)r.getOldInventoryProperty()));
            }
            if (Objects.nonNull(batchEo = (InventoryBatchEo)inventoryBatchEoMap.get(r.getSkuCode() + "_" + r.getBatch()))) {
                r.setProduceTime(batchEo.getProduceTime());
                r.setExpireTime(batchEo.getExpireTime());
            }
        }).collect(Collectors.toList());
    }

    private PageInfo<DgInventoryBillGoodsDto> queryInventoryBillGoods(DgInventoryBillGoodsReqDto dto) {
        if (dto.getOrderType().equals(DgDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode())) {
            dto.setTableName(DgDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getTableName());
        }
        if (dto.getOrderType().equals(DgDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.RECEIVE_RESULT_ORDER.getCode())) {
            dto.setTableName(DgDocumentTypeEnum.DELIVERY_RESULT_ORDER.getTableName());
        }
        if (dto.getOrderType().equals(DgDocumentTypeEnum.OUT_NOTICE_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_NOTICE_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_NOTICE_ORDER.getCode())) {
            dto.setTableName(DgDocumentTypeEnum.OUT_NOTICE_ORDER.getTableName());
        }
        if (dto.getOrderType().equals(DgDocumentTypeEnum.OUT_RESULT_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_RESULT_ORDER.getCode()) || dto.getOrderType().equals(DgDocumentTypeEnum.IN_OUT_RESULT_ORDER.getCode())) {
            dto.setTableName(DgDocumentTypeEnum.OUT_RESULT_ORDER.getTableName());
        }
        return new PageInfo(this.dgBasisOrderRelOrderInfoMapper.queryGoodByDocumentNo(dto));
    }

    private void unitConversion(DgInventoryBillGoodsDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        BigDecimal toRate;
        dto.setUnit(unitConversionEo.getUnit());
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
        BigDecimal bigDecimal = toRate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getToNum().divide(unitConversionEo.getNum(), 6, RoundingMode.HALF_UP);
        if (BigDecimalUtils.gt((BigDecimal)rate, (BigDecimal)toRate).booleanValue()) {
            dto.setPlanQuantity(BigDecimalUtils.multiply((BigDecimal)dto.getPlanQuantity(), (BigDecimal)rate));
            dto.setDoneQuantity(BigDecimalUtils.multiply((BigDecimal)dto.getDoneQuantity(), (BigDecimal)rate));
            dto.setWaitQuantity(BigDecimalUtils.multiply((BigDecimal)dto.getWaitQuantity(), (BigDecimal)rate));
            dto.setDispatcherQuantity(BigDecimalUtils.multiply((BigDecimal)dto.getDispatcherQuantity(), (BigDecimal)rate));
        } else {
            dto.setPlanQuantity(BigDecimalUtils.divide((BigDecimal)dto.getPlanQuantity(), (BigDecimal)toRate, (int)6));
            dto.setDoneQuantity(BigDecimalUtils.divide((BigDecimal)dto.getDoneQuantity(), (BigDecimal)toRate, (int)6));
            dto.setWaitQuantity(BigDecimalUtils.divide((BigDecimal)dto.getWaitQuantity(), (BigDecimal)toRate, (int)6));
            dto.setDispatcherQuantity(BigDecimalUtils.divide((BigDecimal)dto.getDispatcherQuantity(), (BigDecimal)toRate, (int)6));
        }
    }

    @Override
    public RestResponse<PageInfo<DgBusinessGoodsRespDto>> queryGoodsPage(DgInventoryBillGoodsReqDto dto) {
        PageInfo dgBusinessGoodsRespDtoPageInfo;
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        DgInventoryBillGoodsReqDto dgInventoryBillGoodsReqDto = new DgInventoryBillGoodsReqDto();
        DgOrderTypeEnum dgOrderTypeEnum = StringUtils.isNotEmpty((CharSequence)dto.getOrderType()) ? DgOrderTypeEnum.getByCode((String)dto.getOrderType()) : DgOrderTypeEnum.OTHER_OUT;
        IReportDataSearchService reportDataSearchService = this.reportDataSearchHelper.chooseReportDataSearchService(dgOrderTypeEnum.getOrderTableName());
        if (reportDataSearchService != null) {
            PageInfo<DgBusinessGoodsRespDto> pageInfo = reportDataSearchService.queryList(BaseQueryPageReqDto.of((String)dto.getDocumentNo(), (String)dto.getOrderType()));
            this.wrap(dto, pageInfo.getList());
            return new RestResponse(pageInfo);
        }
        if (StringUtils.isEmpty((CharSequence)dto.getTableName())) {
            dto.setTableName(dgOrderTypeEnum.getTableName());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getOrderNoName())) {
            dto.setOrderNoName(dgOrderTypeEnum.getOrderNoName());
        }
        if (StringUtils.isEmpty((CharSequence)dto.getQuantityName())) {
            dto.setQuantityName(dgOrderTypeEnum.getQuantityName());
        }
        if (Objects.isNull(dgBusinessGoodsRespDtoPageInfo = new PageInfo(this.dgBasisOrderRelOrderInfoMapper.queryBusinessGood(dto))) || CollectionUtils.isEmpty((Collection)dgBusinessGoodsRespDtoPageInfo.getList())) {
            return new RestResponse((Object)dgBusinessGoodsRespDtoPageInfo);
        }
        dgInventoryBillGoodsReqDto.setRelevanceNo(dto.getDocumentNo());
        dgInventoryBillGoodsReqDto.setTableName(DgDocumentTypeEnum.OUT_RESULT_ORDER.getTableName());
        List dgInventoryBillGoodsDtos = this.dgBasisOrderRelOrderInfoMapper.queryGoodByDocumentNo(dgInventoryBillGoodsReqDto);
        List relNoList = dgInventoryBillGoodsDtos.stream().map(DgInventoryBillGoodsDto::getRelevanceNo).collect(Collectors.toList());
        List baseOrderUnitConversionList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(relNoList), (Object)"document_code", relNoList)).list();
        Map baseOrderUnitConversionMap = baseOrderUnitConversionList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getToUnit(), Function.identity(), (o2, o1) -> o2));
        dgInventoryBillGoodsDtos.forEach(o -> {
            if (baseOrderUnitConversionMap.containsKey(o.getRelevanceNo() + o.getSkuCode() + o.getUnit())) {
                this.unitConversion((DgInventoryBillGoodsDto)o, (OrderUnitConversionRecordEo)baseOrderUnitConversionMap.get(o.getRelevanceNo() + o.getSkuCode() + o.getUnit()));
            }
        });
        Map<Object, Object> resultGoodMap = new HashMap();
        Map<Object, Object> resultGoodMapWithoutBatch = new HashMap();
        if (CollectionUtils.isNotEmpty((Collection)dgInventoryBillGoodsDtos)) {
            resultGoodMap = dgInventoryBillGoodsDtos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getBatch() + r.getInventoryProperty()));
            resultGoodMapWithoutBatch = dgInventoryBillGoodsDtos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getInventoryProperty()));
        }
        HashMap finalResultGoodMap = resultGoodMap;
        HashMap finalResultGoodMapWithoutBatch = resultGoodMapWithoutBatch;
        dgBusinessGoodsRespDtoPageInfo.getList().forEach(r -> {
            r.setInventoryProperty(Optional.ofNullable(r.getInventoryProperty()).orElse(DgLogicWarehouseQualityEnum.QUALIFIED.getCode()));
            List list = (List)finalResultGoodMap.get(r.getSkuCode() + r.getBatch() + r.getInventoryProperty());
            List listWithoutBatch = (List)finalResultGoodMapWithoutBatch.get(r.getSkuCode() + r.getInventoryProperty());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                r.setBaseOrderGoodsList(list);
                r.setDoneQuantity(list.stream().map(OrderUnitConverterDto::getDoneQuantity).reduce(BigDecimal.ZERO, BigDecimal::add));
                r.setWaitQuantity(r.getPlanQuantity().subtract(r.getDoneQuantity()));
            } else {
                r.setBaseOrderGoodsList(listWithoutBatch);
                r.setDoneQuantity(BigDecimal.ZERO);
                r.setWaitQuantity(r.getPlanQuantity().subtract(r.getDoneQuantity()));
            }
        });
        List storageOrderNoList = dgBusinessGoodsRespDtoPageInfo.getList().stream().map(DgBusinessGoodsRespDto::getStorageOrderNo).collect(Collectors.toList());
        List unitConversionRecordEoList = ((ExtQueryChainWrapper)this.orderUnitConversionRecordDomain.filter().in(CollectionUtil.isNotEmpty(storageOrderNoList), (Object)"document_code", storageOrderNoList)).list();
        Map unitConversionMap = unitConversionRecordEoList.stream().collect(Collectors.toMap(o -> o.getDocumentCode() + o.getSkuCode() + o.getUnit(), Function.identity(), (o2, o1) -> o2));
        dgBusinessGoodsRespDtoPageInfo.getList().forEach(o -> {
            if (unitConversionMap.containsKey(o.getStorageOrderNo() + o.getSkuCode() + o.getUnit())) {
                this.unitConversion((DgBusinessGoodsRespDto)o, (OrderUnitConversionRecordEo)unitConversionMap.get(o.getStorageOrderNo() + o.getSkuCode() + o.getUnit()));
            }
        });
        List<String> skuCodeList = dgBusinessGoodsRespDtoPageInfo.getList().stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSkuCode())).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
        Map lastDirMap = Optional.ofNullable(this.dirService.queryLastDirBySkuCodes(skuCodeList)).orElse(new HashMap());
        dgBusinessGoodsRespDtoPageInfo.getList().forEach(o -> {
            ItDirDto itDirDto = (ItDirDto)lastDirMap.get(o.getSkuCode());
            if (Objects.nonNull(itDirDto)) {
                o.setLastDirId(itDirDto.getId());
                o.setLastDirName(itDirDto.getName());
            }
        });
        return new RestResponse((Object)dgBusinessGoodsRespDtoPageInfo);
    }

    private void wrap(DgInventoryBillGoodsReqDto dto, List<DgBusinessGoodsRespDto> goods) {
        if (CollectionUtils.isEmpty(goods)) {
            return;
        }
        if (StringUtils.equals((CharSequence)dto.getOrderType(), (CharSequence)DgOrderTypeEnum.PARTS_REQUISITION.getCode())) {
            this.SupplementErpAvailable(dto, goods);
        }
        DgInventoryBillGoodsReqDto dgInventoryBillGoodsReqDto = new DgInventoryBillGoodsReqDto();
        dgInventoryBillGoodsReqDto.setRelevanceNo(dto.getDocumentNo());
        dgInventoryBillGoodsReqDto.setTableName(DgDocumentTypeEnum.OUT_RESULT_ORDER.getTableName());
        List dgInventoryBillGoodsDtos = this.dgBasisOrderRelOrderInfoMapper.queryGoodByDocumentNo(dgInventoryBillGoodsReqDto);
        Map<String, List<DgInventoryBillGoodsDto>> resultGoodMap = dgInventoryBillGoodsDtos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getBatch() + r.getInventoryProperty()));
        Map<String, List<DgInventoryBillGoodsDto>> resultGoodMapWithoutBatch = dgInventoryBillGoodsDtos.stream().collect(Collectors.groupingBy(r -> r.getSkuCode() + r.getInventoryProperty()));
        List<String> skuCodeList = goods.stream().filter(e -> StringUtils.isNotEmpty((CharSequence)e.getSkuCode())).map(e -> e.getSkuCode()).distinct().collect(Collectors.toList());
        Map lastDirMap = Optional.ofNullable(this.dirService.queryLastDirBySkuCodes(skuCodeList)).orElse(new HashMap());
        goods.forEach(r -> {
            r.setInventoryProperty(Optional.ofNullable(r.getInventoryProperty()).orElse(DgLogicWarehouseQualityEnum.QUALIFIED.getCode()));
            List list = (List)resultGoodMap.get(r.getSkuCode() + r.getBatch() + r.getInventoryProperty());
            List listWithoutBatch = (List)resultGoodMapWithoutBatch.get(r.getSkuCode() + r.getInventoryProperty());
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                r.setBaseOrderGoodsList(list);
            } else {
                r.setBaseOrderGoodsList(listWithoutBatch);
            }
            ItDirDto itDirDto = (ItDirDto)lastDirMap.get(r.getSkuCode());
            if (Objects.nonNull(itDirDto)) {
                r.setLastDirId(itDirDto.getId());
                r.setLastDirName(itDirDto.getName());
            }
            if (CollectionUtils.isEmpty((Collection)r.getBaseOrderGoodsList())) {
                return;
            }
            r.getBaseOrderGoodsList().forEach(d -> {
                d.setDocumentCode(Optional.ofNullable(dto.getDocumentNo()).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).orElse(dto.getRelevanceNo()));
                d.setBaseTo(true);
                d.setConvedUnit(false);
            });
            UnitConverUtils.unitConvertBatch(r.getBaseOrderGoodsList());
        });
    }

    private void SupplementErpAvailable(DgInventoryBillGoodsReqDto dto, List<DgBusinessGoodsRespDto> goods) {
        List storageOrderEoList = ((ExtQueryChainWrapper)this.iDgInOtherStorageOrderDomain.filter().eq((Object)"storage_order_no", (Object)dto.getDocumentNo())).list();
        AssertUtils.notEmpty((Collection)storageOrderEoList, (String)"\u67e5\u4e0d\u5230\u8be5\u5355\u53f7");
        DgInOtherStorageOrderEo dgInOtherStorageOrderEo = (DgInOtherStorageOrderEo)storageOrderEoList.get(0);
        List skuCodeList = goods.stream().map(DgBusinessGoodsRespDto::getSkuCode).distinct().collect(Collectors.toList());
        ErpInventoryNumQueryDto erpInventoryNumQueryDto = new ErpInventoryNumQueryDto();
        erpInventoryNumQueryDto.setItemCodes(skuCodeList);
        erpInventoryNumQueryDto.setCompanyCode(dgInOtherStorageOrderEo.getSaleOrganizationCode());
        List availNumberDtoList = (List)Optional.ofNullable(RestResponseHelper.extractData((RestResponse)this.iExternalInventoryErpApiProxy.batchQueryAvailInventoryNumber(erpInventoryNumQueryDto))).orElse(Lists.newArrayList());
        HashMap skuCodeQuantityMap = Maps.newHashMap();
        for (ErpInventoryAvailNumberDto erpInventoryAvailNumberDto : availNumberDtoList) {
            skuCodeQuantityMap.put(erpInventoryAvailNumberDto.getItemCode(), BigDecimalUtils.parse((String)String.valueOf(erpInventoryAvailNumberDto.getAvailableQuantity())));
        }
        log.info("\u6839\u636e\u5546\u54c1\u67e5\u8be2\u5230erp\u5e93\u5b58\u6570\u91cf:{}", (Object)JSON.toJSONString((Object)skuCodeQuantityMap));
        goods.forEach(o -> {
            if (skuCodeQuantityMap.containsKey(o.getSkuCode())) {
                o.setErpAvailable((BigDecimal)skuCodeQuantityMap.get(o.getSkuCode()));
            }
        });
    }

    private void unitConversion(DgBusinessGoodsRespDto dto, OrderUnitConversionRecordEo unitConversionEo) {
        dto.setUnit(unitConversionEo.getUnit());
        BigDecimal rate = BigDecimal.ZERO.compareTo(unitConversionEo.getToNum()) == 0 ? BigDecimal.ONE : unitConversionEo.getNum().divide(unitConversionEo.getToNum(), 6, RoundingMode.HALF_UP);
    }

    private void getDeliveryNoticeOrderInfo(DgRelOrderReqDto dgRelOrderReqDto, List<DgBasisOrderRelOrderInfoRespDto> relOrderInfoList, List<String> shippingCodeList, List<String> shippingTypeList, List<String> shippingCompanyList, List<String> shippingCompanyNameList) {
        DgDeliveryNoticeOrderPageReqDto dgDeliveryNoticeOrderPageReqDto = new DgDeliveryNoticeOrderPageReqDto();
        dgDeliveryNoticeOrderPageReqDto.setRelevanceNoList((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dgRelOrderReqDto.getRelevanceNo()}));
        dgDeliveryNoticeOrderPageReqDto.setRelevanceNo(dgRelOrderReqDto.getRelevanceNo());
        dgDeliveryNoticeOrderPageReqDto.setRelevanceTableName(dgRelOrderReqDto.getRelevanceTableName());
        List dgDeliveryNoticeOrderDtos = this.iDgDeliveryNoticeOrderDomain.queryList(dgDeliveryNoticeOrderPageReqDto);
        Map<String, DgOutNoticeOrderEo> outNoticeOrderEoMap = this.getDgOutNoticeOrderEoByRelevanceNo(dgRelOrderReqDto.getRelevanceNo());
        for (DgDeliveryNoticeOrderDto dgDeliveryNoticeOrderDto : dgDeliveryNoticeOrderDtos) {
            DgOutNoticeOrderEo dgOutNoticeOrderEo;
            String orderType;
            DgBasisOrderRelOrderInfoRespDto deliveryNoticeOrderInfo = new DgBasisOrderRelOrderInfoRespDto();
            CubeBeanUtils.copyProperties((Object)deliveryNoticeOrderInfo, (Object)dgDeliveryNoticeOrderDto, (String[])new String[0]);
            if (ObjectUtil.equals((Object)dgRelOrderReqDto.getDocumentNo(), (Object)dgDeliveryNoticeOrderDto.getDocumentNo())) {
                deliveryNoticeOrderInfo.setDocumentNo(dgDeliveryNoticeOrderDto.getDocumentNo());
                deliveryNoticeOrderInfo.setOrderType(dgDeliveryNoticeOrderDto.getJumpDocumentType());
                deliveryNoticeOrderInfo.setPlatformOrderNo(dgDeliveryNoticeOrderDto.getExternalOrderNo());
                deliveryNoticeOrderInfo.setRelevanceNo(dgDeliveryNoticeOrderDto.getRelevanceNo());
                deliveryNoticeOrderInfo.setOrderNo(dgDeliveryNoticeOrderDto.getRelevanceNo());
                if (StringUtils.isNotBlank((CharSequence)dgDeliveryNoticeOrderDto.getRelevanceTableName())) {
                    deliveryNoticeOrderInfo.setOrderStatus(this.queryStatusByRelevanceNo(dgDeliveryNoticeOrderDto.getRelevanceTableName(), dgDeliveryNoticeOrderDto.getRelevanceNo()));
                }
                deliveryNoticeOrderInfo.setBusinessType(dgDeliveryNoticeOrderDto.getDisplayBusinessType());
                deliveryNoticeOrderInfo.setWmsOrderNo(dgDeliveryNoticeOrderDto.getWmsOrderNo());
                deliveryNoticeOrderInfo.setBizDate(dgDeliveryNoticeOrderDto.getBizDate());
                deliveryNoticeOrderInfo.setShippingCompany(dgDeliveryNoticeOrderDto.getShipmentEnterpriseCode());
                deliveryNoticeOrderInfo.setShippingCompanyName(dgDeliveryNoticeOrderDto.getShipmentEnterpriseName());
                deliveryNoticeOrderInfo.setShippingCode(dgDeliveryNoticeOrderDto.getShippingCode());
                deliveryNoticeOrderInfo.setShippingType(dgDeliveryNoticeOrderDto.getShippingType());
                deliveryNoticeOrderInfo.setShippingCodeList(shippingCodeList);
                deliveryNoticeOrderInfo.setShippingTypeList(shippingTypeList);
                deliveryNoticeOrderInfo.setShippingCompanyList(shippingCompanyList);
                deliveryNoticeOrderInfo.setShippingCompanyNameList(shippingCompanyNameList);
                relOrderInfoList.add(deliveryNoticeOrderInfo);
                continue;
            }
            deliveryNoticeOrderInfo.setOrderNo(dgDeliveryNoticeOrderDto.getDocumentNo());
            deliveryNoticeOrderInfo.setRelevanceNo(dgDeliveryNoticeOrderDto.getRelevanceNo());
            deliveryNoticeOrderInfo.setOrderStatus(dgDeliveryNoticeOrderDto.getOrderStatus());
            deliveryNoticeOrderInfo.setBusinessType(dgDeliveryNoticeOrderDto.getDisplayBusinessType());
            String string = orderType = "delivery".equals(dgDeliveryNoticeOrderDto.getOrderType()) ? "out" : "in";
            if (outNoticeOrderEoMap.containsKey(dgDeliveryNoticeOrderDto.getDocumentNo() + "-" + orderType) && StringUtils.isNotBlank((CharSequence)(dgOutNoticeOrderEo = outNoticeOrderEoMap.get(dgDeliveryNoticeOrderDto.getDocumentNo() + "-" + orderType)).getWmsReturnId())) {
                if ("in".equalsIgnoreCase(dgOutNoticeOrderEo.getOrderType()) && Objects.nonNull(dgOutNoticeOrderEo)) {
                    deliveryNoticeOrderInfo.setWmsOrderNo(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderEo.getInPhysicsWarehouseCode()) ? dgOutNoticeOrderEo.getInPhysicsWarehouseCode() + dgOutNoticeOrderEo.getWmsReturnId() : dgOutNoticeOrderEo.getWmsReturnId());
                } else {
                    deliveryNoticeOrderInfo.setWmsOrderNo(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderEo.getOutPhysicsWarehouseCode()) ? dgOutNoticeOrderEo.getOutPhysicsWarehouseCode() + dgOutNoticeOrderEo.getWmsReturnId() : dgOutNoticeOrderEo.getWmsReturnId());
                }
            }
            deliveryNoticeOrderInfo.setBizDate(dgDeliveryNoticeOrderDto.getBizDate());
            deliveryNoticeOrderInfo.setOrderType("delivery".equals(dgDeliveryNoticeOrderDto.getOrderType()) ? DgDocumentTypeEnum.DELIVERY_NOTICE_ORDER.getCode() : DgDocumentTypeEnum.RECEIVE_NOTICE_ORDER.getCode());
            deliveryNoticeOrderInfo.setShippingCompany(dgDeliveryNoticeOrderDto.getShipmentEnterpriseCode());
            deliveryNoticeOrderInfo.setShippingCompanyName(dgDeliveryNoticeOrderDto.getShipmentEnterpriseName());
            deliveryNoticeOrderInfo.setShippingCode(dgDeliveryNoticeOrderDto.getShippingCode());
            deliveryNoticeOrderInfo.setShippingType(dgDeliveryNoticeOrderDto.getShippingType());
            deliveryNoticeOrderInfo.setShippingCodeList(StringUtils.isNotBlank((CharSequence)dgDeliveryNoticeOrderDto.getShippingCode()) ? Arrays.asList(dgDeliveryNoticeOrderDto.getShippingCode()) : null);
            deliveryNoticeOrderInfo.setShippingTypeList(StringUtils.isNotBlank((CharSequence)dgDeliveryNoticeOrderDto.getShippingType()) ? Arrays.asList(dgDeliveryNoticeOrderDto.getShippingType()) : null);
            deliveryNoticeOrderInfo.setShippingCompanyList(StringUtils.isNotBlank((CharSequence)dgDeliveryNoticeOrderDto.getShipmentEnterpriseCode()) ? Arrays.asList(dgDeliveryNoticeOrderDto.getShipmentEnterpriseCode()) : null);
            deliveryNoticeOrderInfo.setShippingCompanyNameList(StringUtils.isNotBlank((CharSequence)dgDeliveryNoticeOrderDto.getShipmentEnterpriseName()) ? Arrays.asList(dgDeliveryNoticeOrderDto.getShipmentEnterpriseName()) : null);
            relOrderInfoList.add(deliveryNoticeOrderInfo);
        }
    }

    private void getDeliveryResultOrderInfo(DgRelOrderReqDto dgRelOrderReqDto, List<DgBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        DgDeliveryResultOrderPageReqDto dgDeliveryResultOrderPageReqDto = new DgDeliveryResultOrderPageReqDto();
        dgDeliveryResultOrderPageReqDto.setRelevanceNoList((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dgRelOrderReqDto.getRelevanceNo()}));
        dgDeliveryResultOrderPageReqDto.setRelevanceNo(dgRelOrderReqDto.getRelevanceNo());
        dgDeliveryResultOrderPageReqDto.setRelevanceTableName(dgRelOrderReqDto.getRelevanceTableName());
        List dgDeliveryResultOrderDtos = this.iDgDeliveryResultOrderDomain.queryList(dgDeliveryResultOrderPageReqDto);
        List shippingCodeList = dgDeliveryResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCode())).map(DgDeliveryResultOrderDto::getShippingCode).collect(Collectors.toList());
        List shippingTypeList = dgDeliveryResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingType())).map(DgDeliveryResultOrderDto::getShippingType).collect(Collectors.toList());
        List shippingCompanyList = dgDeliveryResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCompanyCode())).map(DgDeliveryResultOrderDto::getShippingCompanyCode).collect(Collectors.toList());
        List shippingCompanyNameList = dgDeliveryResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCompany())).map(DgDeliveryResultOrderDto::getShippingCompany).collect(Collectors.toList());
        for (DgDeliveryResultOrderDto dgDeliveryResultOrderDto : dgDeliveryResultOrderDtos) {
            DgBasisOrderRelOrderInfoRespDto deliveryResultOrderInfo = new DgBasisOrderRelOrderInfoRespDto();
            CubeBeanUtils.copyProperties((Object)deliveryResultOrderInfo, (Object)dgDeliveryResultOrderDto, (String[])new String[0]);
            if (ObjectUtil.equals((Object)dgRelOrderReqDto.getDocumentNo(), (Object)dgDeliveryResultOrderDto.getDocumentNo())) {
                deliveryResultOrderInfo.setDocumentNo(dgDeliveryResultOrderDto.getDocumentNo());
                deliveryResultOrderInfo.setOrderNo(dgDeliveryResultOrderDto.getRelevanceNo());
                deliveryResultOrderInfo.setRelevanceNo(dgDeliveryResultOrderDto.getRelevanceNo());
                deliveryResultOrderInfo.setPlatformOrderNo(dgDeliveryResultOrderDto.getExternalOrderNo());
                if (StringUtils.isNotBlank((CharSequence)dgDeliveryResultOrderDto.getRelevanceTableName())) {
                    deliveryResultOrderInfo.setOrderStatus(this.queryStatusByRelevanceNo(dgDeliveryResultOrderDto.getRelevanceTableName(), dgDeliveryResultOrderDto.getRelevanceNo()));
                }
                deliveryResultOrderInfo.setBusinessType(dgDeliveryResultOrderDto.getDisplayBusinessType());
                deliveryResultOrderInfo.setWmsOrderNo(dgDeliveryResultOrderDto.getWmsOrderNo());
                deliveryResultOrderInfo.setOrderType(dgDeliveryResultOrderDto.getJumpDocumentType());
                deliveryResultOrderInfo.setBizDate(dgDeliveryResultOrderDto.getBizDate());
                deliveryResultOrderInfo.setShippingCodeList(shippingCodeList);
                deliveryResultOrderInfo.setShippingTypeList(shippingTypeList);
                deliveryResultOrderInfo.setShippingCompanyList(shippingCompanyList);
                deliveryResultOrderInfo.setShippingCompanyNameList(shippingCompanyNameList);
                deliveryResultOrderInfo.setShippingCompany(dgDeliveryResultOrderDto.getShipmentEnterpriseCode());
                deliveryResultOrderInfo.setShippingCompanyName(dgDeliveryResultOrderDto.getShipmentEnterpriseName());
                deliveryResultOrderInfo.setShippingCode(dgDeliveryResultOrderDto.getShippingCode());
                deliveryResultOrderInfo.setShippingType(dgDeliveryResultOrderDto.getShippingType());
                relOrderInfoList.add(deliveryResultOrderInfo);
                continue;
            }
            deliveryResultOrderInfo.setDocumentNo(dgDeliveryResultOrderDto.getDocumentNo());
            deliveryResultOrderInfo.setRelevanceNo(dgDeliveryResultOrderDto.getRelevanceNo());
            deliveryResultOrderInfo.setOrderStatus(dgDeliveryResultOrderDto.getOrderStatus());
            deliveryResultOrderInfo.setBusinessType(dgDeliveryResultOrderDto.getDisplayBusinessType());
            deliveryResultOrderInfo.setBizDate(dgDeliveryResultOrderDto.getBizDate());
            deliveryResultOrderInfo.setWmsOrderNo(dgDeliveryResultOrderDto.getWmsOrderNo());
            deliveryResultOrderInfo.setOrderType("delivery".equals(dgDeliveryResultOrderDto.getOrderType()) ? DgDocumentTypeEnum.DELIVERY_RESULT_ORDER.getCode() : DgDocumentTypeEnum.RECEIVE_RESULT_ORDER.getCode());
            deliveryResultOrderInfo.setShippingCompany(dgDeliveryResultOrderDto.getShippingCompanyCode());
            deliveryResultOrderInfo.setShippingCompanyName(dgDeliveryResultOrderDto.getShippingCompany());
            deliveryResultOrderInfo.setShippingCode(dgDeliveryResultOrderDto.getShippingCode());
            deliveryResultOrderInfo.setShippingType(dgDeliveryResultOrderDto.getShippingType());
            deliveryResultOrderInfo.setShippingCodeList(StringUtils.isNotBlank((CharSequence)dgDeliveryResultOrderDto.getShippingCode()) ? Arrays.asList(dgDeliveryResultOrderDto.getShippingCode()) : null);
            deliveryResultOrderInfo.setShippingTypeList(StringUtils.isNotBlank((CharSequence)dgDeliveryResultOrderDto.getShippingType()) ? Arrays.asList(dgDeliveryResultOrderDto.getShippingType()) : null);
            deliveryResultOrderInfo.setShippingCompanyList(StringUtils.isNotBlank((CharSequence)dgDeliveryResultOrderDto.getShippingCompanyCode()) ? Arrays.asList(dgDeliveryResultOrderDto.getShippingCompanyCode()) : null);
            deliveryResultOrderInfo.setShippingCompanyNameList(StringUtils.isNotBlank((CharSequence)dgDeliveryResultOrderDto.getShippingCompany()) ? Arrays.asList(dgDeliveryResultOrderDto.getShippingCompany()) : null);
            relOrderInfoList.add(deliveryResultOrderInfo);
        }
    }

    private void getOutNoticeOrderInfo(DgRelOrderReqDto dgRelOrderReqDto, List<DgBasisOrderRelOrderInfoRespDto> relOrderInfoList, List<String> shippingCodeList, List<String> shippingTypeList, List<String> shippingCompanyList, List<String> shippingCompanyNameList) {
        DgOutNoticeOrderPageReqDto dgOutNoticeOrderPageReqDto = new DgOutNoticeOrderPageReqDto();
        dgOutNoticeOrderPageReqDto.setRelevanceNo(dgRelOrderReqDto.getRelevanceNo());
        dgOutNoticeOrderPageReqDto.setRelevanceNoList((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dgRelOrderReqDto.getRelevanceNo()}));
        dgOutNoticeOrderPageReqDto.setRelevanceTableName(dgRelOrderReqDto.getRelevanceTableName());
        List dgOutNoticeOrderDtos = this.iDgOutNoticeOrderDomain.queryList(dgOutNoticeOrderPageReqDto);
        for (DgOutNoticeOrderDto dgOutNoticeOrderDto : dgOutNoticeOrderDtos) {
            DgBasisOrderRelOrderInfoRespDto outNoticeOrderInfo = new DgBasisOrderRelOrderInfoRespDto();
            CubeBeanUtils.copyProperties((Object)outNoticeOrderInfo, (Object)dgOutNoticeOrderDto, (String[])new String[0]);
            if (ObjectUtil.equals((Object)dgRelOrderReqDto.getDocumentNo(), (Object)outNoticeOrderInfo.getDocumentNo())) {
                outNoticeOrderInfo.setOrderNo(dgOutNoticeOrderDto.getRelevanceNo());
                outNoticeOrderInfo.setDocumentNo(dgOutNoticeOrderDto.getDocumentNo());
                outNoticeOrderInfo.setRelevanceNo(dgOutNoticeOrderDto.getRelevanceNo());
                outNoticeOrderInfo.setPlatformOrderNo(dgOutNoticeOrderDto.getExternalOrderNo());
                if (StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderDto.getRelevanceTableName())) {
                    outNoticeOrderInfo.setOrderStatus(this.queryStatusByRelevanceNo(dgOutNoticeOrderDto.getRelevanceTableName(), dgOutNoticeOrderDto.getRelevanceNo()));
                }
                outNoticeOrderInfo.setBusinessType(dgOutNoticeOrderDto.getDisplayBusinessType());
                outNoticeOrderInfo.setWmsOrderNo(dgOutNoticeOrderDto.getWmsOrderNo());
                outNoticeOrderInfo.setOrderType(dgOutNoticeOrderDto.getJumpDocumentType());
                outNoticeOrderInfo.setBizDate(dgOutNoticeOrderDto.getBizDate());
                outNoticeOrderInfo.setShippingCompany(dgOutNoticeOrderDto.getShipmentEnterpriseCode());
                outNoticeOrderInfo.setShippingCompanyName(dgOutNoticeOrderDto.getShipmentEnterpriseName());
                outNoticeOrderInfo.setShippingCode(dgOutNoticeOrderDto.getShippingCode());
                outNoticeOrderInfo.setShippingType(dgOutNoticeOrderDto.getShippingType());
                outNoticeOrderInfo.setShippingCodeList(shippingCodeList);
                outNoticeOrderInfo.setShippingTypeList(shippingTypeList);
                outNoticeOrderInfo.setShippingCompanyList(shippingCompanyList);
                outNoticeOrderInfo.setShippingCompanyNameList(shippingCompanyNameList);
                relOrderInfoList.add(outNoticeOrderInfo);
                continue;
            }
            outNoticeOrderInfo.setDocumentNo(dgOutNoticeOrderDto.getDocumentNo());
            outNoticeOrderInfo.setRelevanceNo(dgOutNoticeOrderDto.getRelevanceNo());
            outNoticeOrderInfo.setOrderStatus(dgOutNoticeOrderDto.getOrderStatus());
            outNoticeOrderInfo.setBizDate(dgOutNoticeOrderDto.getBizDate());
            outNoticeOrderInfo.setBusinessType(dgOutNoticeOrderDto.getDisplayBusinessType());
            outNoticeOrderInfo.setWmsOrderNo(dgOutNoticeOrderDto.getWmsOrderNo());
            if ("out".equals(dgOutNoticeOrderDto.getOrderType())) {
                outNoticeOrderInfo.setOrderType(DgDocumentTypeEnum.OUT_NOTICE_ORDER.getCode());
            } else if ("in".equals(dgOutNoticeOrderDto.getOrderType())) {
                outNoticeOrderInfo.setOrderType(DgDocumentTypeEnum.IN_NOTICE_ORDER.getCode());
            } else if ("assembly_disassembly".equals(dgOutNoticeOrderDto.getOrderType())) {
                outNoticeOrderInfo.setOrderType(DgDocumentTypeEnum.IN_ASSEMBLY_DISASSEMBLY_NOTICE_ORDER.getCode());
            } else {
                outNoticeOrderInfo.setOrderType(DgDocumentTypeEnum.IN_OUT_NOTICE_ORDER.getCode());
            }
            outNoticeOrderInfo.setShippingCompany(dgOutNoticeOrderDto.getShipmentEnterpriseCode());
            outNoticeOrderInfo.setShippingCompanyName(dgOutNoticeOrderDto.getShipmentEnterpriseName());
            outNoticeOrderInfo.setShippingCode(dgOutNoticeOrderDto.getShippingCode());
            outNoticeOrderInfo.setShippingType(dgOutNoticeOrderDto.getShippingType());
            outNoticeOrderInfo.setShippingCodeList(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderDto.getShippingCode()) ? Arrays.asList(dgOutNoticeOrderDto.getShippingCode()) : null);
            outNoticeOrderInfo.setShippingTypeList(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderDto.getShippingType()) ? Arrays.asList(dgOutNoticeOrderDto.getShippingType()) : null);
            outNoticeOrderInfo.setShippingCompanyList(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderDto.getShipmentEnterpriseCode()) ? Arrays.asList(dgOutNoticeOrderDto.getShipmentEnterpriseCode()) : null);
            outNoticeOrderInfo.setShippingCompanyNameList(StringUtils.isNotBlank((CharSequence)dgOutNoticeOrderDto.getShipmentEnterpriseName()) ? Arrays.asList(dgOutNoticeOrderDto.getShipmentEnterpriseName()) : null);
            relOrderInfoList.add(outNoticeOrderInfo);
        }
    }

    private void getOutResultOrderInfo(DgRelOrderReqDto dgRelOrderReqDto, List<DgBasisOrderRelOrderInfoRespDto> relOrderInfoList) {
        DgOutResultOrderPageReqDto dgOutResultOrderPageReqDto = new DgOutResultOrderPageReqDto();
        dgOutResultOrderPageReqDto.setRelevanceNo(dgRelOrderReqDto.getRelevanceNo());
        dgOutResultOrderPageReqDto.setRelevanceNoList((List)com.google.common.collect.Lists.newArrayList((Object[])new String[]{dgRelOrderReqDto.getRelevanceNo()}));
        dgOutResultOrderPageReqDto.setRelevanceTableName(dgRelOrderReqDto.getRelevanceTableName());
        List dgOutResultOrderDtos = this.iDgOutResultOrderDomain.queryList(dgOutResultOrderPageReqDto);
        List shippingCodeList = dgOutResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCode())).map(DgOutResultOrderDto::getShippingCode).collect(Collectors.toList());
        List shippingTypeList = dgOutResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingType())).map(DgOutResultOrderDto::getShippingType).collect(Collectors.toList());
        List shippingCompanyList = dgOutResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCompanyCode())).map(DgOutResultOrderDto::getShippingCompanyCode).collect(Collectors.toList());
        List shippingCompanyNameList = dgOutResultOrderDtos.stream().filter(o -> Objects.nonNull(o.getShippingCompany())).map(DgOutResultOrderDto::getShippingCompany).collect(Collectors.toList());
        for (DgOutResultOrderDto dgOutResultOrderDto : dgOutResultOrderDtos) {
            DgBasisOrderRelOrderInfoRespDto dgOutResultOrderInfo = new DgBasisOrderRelOrderInfoRespDto();
            CubeBeanUtils.copyProperties((Object)dgOutResultOrderInfo, (Object)dgOutResultOrderDto, (String[])new String[0]);
            if (ObjectUtil.equals((Object)dgRelOrderReqDto.getDocumentNo(), (Object)dgOutResultOrderInfo.getDocumentNo())) {
                dgOutResultOrderInfo.setOrderNo(dgOutResultOrderDto.getRelevanceNo());
                dgOutResultOrderInfo.setDocumentNo(dgOutResultOrderDto.getDocumentNo());
                dgOutResultOrderInfo.setPlatformOrderNo(dgOutResultOrderDto.getExternalOrderNo());
                dgOutResultOrderInfo.setRelevanceNo(dgOutResultOrderDto.getRelevanceNo());
                if (StringUtils.isNotBlank((CharSequence)dgOutResultOrderDto.getRelevanceTableName())) {
                    dgOutResultOrderInfo.setOrderStatus(this.queryStatusByRelevanceNo(dgOutResultOrderDto.getRelevanceTableName(), dgOutResultOrderDto.getRelevanceNo()));
                }
                dgOutResultOrderInfo.setBusinessType(dgOutResultOrderDto.getDisplayBusinessType());
                dgOutResultOrderInfo.setWmsOrderNo(dgOutResultOrderDto.getWmsOrderNo());
                dgOutResultOrderInfo.setOrderType(dgOutResultOrderDto.getJumpDocumentType());
                dgOutResultOrderInfo.setShippingCompany(dgOutResultOrderDto.getShippingCompanyCode());
                dgOutResultOrderInfo.setShippingCompanyName(dgOutResultOrderDto.getShippingCompany());
                dgOutResultOrderInfo.setShippingCode(dgOutResultOrderDto.getShippingCode());
                dgOutResultOrderInfo.setShippingType(dgOutResultOrderDto.getShippingType());
                dgOutResultOrderInfo.setBizDate(DateUtil.format((Date)dgOutResultOrderDto.getBizDate(), (String)"yyyy-MM-dd HH:mm:ss"));
                dgOutResultOrderInfo.setShippingCodeList(shippingCodeList);
                dgOutResultOrderInfo.setShippingTypeList(shippingTypeList);
                dgOutResultOrderInfo.setShippingCompanyList(shippingCompanyList);
                dgOutResultOrderInfo.setShippingCompanyNameList(shippingCompanyNameList);
                relOrderInfoList.add(dgOutResultOrderInfo);
                continue;
            }
            dgOutResultOrderInfo.setDocumentNo(dgOutResultOrderDto.getDocumentNo());
            dgOutResultOrderInfo.setRelevanceNo(dgOutResultOrderDto.getRelevanceNo());
            dgOutResultOrderInfo.setOrderStatus(dgOutResultOrderDto.getOrderStatus());
            dgOutResultOrderInfo.setBusinessType(dgOutResultOrderDto.getDisplayBusinessType());
            dgOutResultOrderInfo.setBizDate(DateUtil.format((Date)dgOutResultOrderDto.getBizDate(), (String)"yyyy-MM-dd HH:mm:ss"));
            dgOutResultOrderInfo.setWmsOrderNo(dgOutResultOrderDto.getWmsOrderNo());
            if ("out".equals(dgOutResultOrderDto.getOrderType())) {
                dgOutResultOrderInfo.setOrderType(DgDocumentTypeEnum.OUT_RESULT_ORDER.getCode());
            } else if ("in".equals(dgOutResultOrderDto.getOrderType())) {
                dgOutResultOrderInfo.setOrderType(DgDocumentTypeEnum.IN_RESULT_ORDER.getCode());
            } else if ("assembly_disassembly".equals(dgOutResultOrderInfo.getOrderType())) {
                dgOutResultOrderInfo.setOrderType(DgDocumentTypeEnum.IN_ASSEMBLY_DISASSEMBLY_RESULT_ORDER.getCode());
            } else {
                dgOutResultOrderInfo.setOrderType(DgDocumentTypeEnum.IN_OUT_RESULT_ORDER.getCode());
            }
            dgOutResultOrderInfo.setShippingCompany(dgOutResultOrderDto.getShippingCompanyCode());
            dgOutResultOrderInfo.setShippingCompanyName(dgOutResultOrderDto.getShippingCompany());
            dgOutResultOrderInfo.setShippingCode(dgOutResultOrderDto.getShippingCode());
            dgOutResultOrderInfo.setShippingType(dgOutResultOrderDto.getShippingType());
            dgOutResultOrderInfo.setShippingCodeList(StringUtils.isNotBlank((CharSequence)dgOutResultOrderDto.getShippingCode()) ? Arrays.asList(dgOutResultOrderDto.getShippingCode()) : null);
            dgOutResultOrderInfo.setShippingTypeList(StringUtils.isNotBlank((CharSequence)dgOutResultOrderDto.getShippingType()) ? Arrays.asList(dgOutResultOrderDto.getShippingType()) : null);
            dgOutResultOrderInfo.setShippingCompanyList(StringUtils.isNotBlank((CharSequence)dgOutResultOrderDto.getShippingCompanyCode()) ? Arrays.asList(dgOutResultOrderDto.getShippingCompanyCode()) : null);
            dgOutResultOrderInfo.setShippingCompanyNameList(StringUtils.isNotBlank((CharSequence)dgOutResultOrderDto.getShippingCompany()) ? Arrays.asList(dgOutResultOrderDto.getShippingCompany()) : null);
            relOrderInfoList.add(dgOutResultOrderInfo);
        }
    }

    private void setShippingMsg(String shippingJson, DgBasisOrderRelOrderInfoRespDto basisOrderRelOrderOutfoRespDto) {
        if (StringUtils.isNotEmpty((CharSequence)shippingJson)) {
            try {
                List shippingInfoList = JSON.parseArray((String)shippingJson, DgWmsShippingInfoReqDto.class);
                if (CollectionUtils.isNotEmpty((Collection)shippingInfoList)) {
                    DgWmsShippingInfoReqDto shippingInfo = (DgWmsShippingInfoReqDto)shippingInfoList.get(0);
                    basisOrderRelOrderOutfoRespDto.setShippingCompany(shippingInfo.getShippingCompanyName());
                    basisOrderRelOrderOutfoRespDto.setShippingCode(this.getShippingCodes(shippingInfoList));
                    basisOrderRelOrderOutfoRespDto.setShippingType(shippingInfo.getLogisticsType());
                }
            }
            catch (Exception e) {
                log.error("\u8bbe\u7f6e\u4f9b\u5e94\u5546\u4fe1\u606f\u5f02\u5e38", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    private String getShippingCodes(List<DgWmsShippingInfoReqDto> shippingInfoList) {
        StringBuilder shippingCodes = new StringBuilder();
        for (DgWmsShippingInfoReqDto csWmsShippingInfoReqDto : shippingInfoList) {
            shippingCodes.append(csWmsShippingInfoReqDto.getShippingNo()).append(",");
        }
        return shippingCodes.substring(0, shippingCodes.length() - 1);
    }

    private Map<String, DgOutNoticeOrderEo> getDgOutNoticeOrderEoByRelevanceNo(String relevanceNo) {
        List noticeOrderEos = ((ExtQueryChainWrapper)this.iDgOutNoticeOrderDomain.filter().eq((Object)"relevance_no", (Object)relevanceNo)).list();
        if (CollectionUtils.isEmpty((Collection)noticeOrderEos)) {
            return Maps.newHashMap();
        }
        return noticeOrderEos.stream().collect(Collectors.toMap(x -> x.getPreOrderNo() + "-" + x.getOrderType(), Function.identity(), (k1, k2) -> k1));
    }

    private String queryStatusByRelevanceNo(String relevanceTableName, String relevanceNo) {
        DgInventoryBizDateBizTypeEnum typeEnum = DgInventoryBizDateBizTypeEnum.getStatusByCode((String)relevanceTableName);
        if (typeEnum != null && typeEnum.getTableName() != null) {
            if (typeEnum.getTableName().equals(DgInventoryBizDateBizTypeEnum.CS_ORDER_SALE_REFUND.getTableName())) {
                return this.dgBasisOrderRelOrderInfoMapper.queryStatusByRelevanceNoExt(typeEnum.getTableName(), typeEnum.getFieldName(), relevanceNo);
            }
            return this.dgBasisOrderRelOrderInfoMapper.queryStatusByRelevanceNo(typeEnum.getTableName(), typeEnum.getFieldName(), relevanceNo);
        }
        return null;
    }
}

