/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.customer.tob;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.das.user.IUsOrganizationDas;
import com.yunxi.dg.base.center.report.domain.customer.IDgREnterpriseOrganizationDomain;
import com.yunxi.dg.base.center.report.domain.user.IUsOrganizationDomain;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageQueryDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageReqDto;
import com.yunxi.dg.base.center.report.dto.customer.entity.CsOrganizationPageRespDto;
import com.yunxi.dg.base.center.report.eo.user.OrganizationEo;
import com.yunxi.dg.base.center.report.service.customer.tob.IDgOrganizationQueryService;
import com.yunxi.dg.base.center.report.utils.RequestUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.jetbrains.annotations.NotNull;
import org.springframework.stereotype.Service;

@Service
public class DgOrganizationQueryServiceImpl
implements IDgOrganizationQueryService {
    @Resource
    private IDgREnterpriseOrganizationDomain iDgREnterpriseOrganizationDomain;
    @Resource
    private IUsOrganizationDomain iUsOrganizationDomain;
    @Resource
    private IUsOrganizationDas iUsOrganizationDas;

    @Override
    public PageInfo<CsOrganizationPageRespDto> querySaleOrgByPage(CsOrganizationPageReqDto reqDto) {
        if (reqDto.getId() == null && CollectionUtils.isEmpty((Collection)reqDto.getRootIdList())) {
            reqDto.setRootIdList(this.getRootFuncOrgId("sales"));
        }
        PageInfo<CsOrganizationPageRespDto> page = this.queryOrgByPageSale(reqDto);
        List orgList = page.getList();
        page.setList(this.querySaleCompanyInfo(orgList));
        return page;
    }

    @Override
    public PageInfo<CsOrganizationPageRespDto> queryDepartmentByPage(CsOrganizationPageReqDto reqDto) {
        if (reqDto.getId() == null && CollectionUtils.isEmpty((Collection)reqDto.getRootIdList())) {
            reqDto.setRootIdList(this.getRootFuncOrgId("human_resource"));
        }
        return this.queryOrgByPage(reqDto);
    }

    @Override
    public PageInfo<CsOrganizationPageRespDto> queryInventoryByPage(CsOrganizationPageReqDto reqDto) {
        if (reqDto.getId() == null && CollectionUtils.isEmpty((Collection)reqDto.getRootIdList())) {
            reqDto.setRootIdList(this.getRootFuncOrgId("stock"));
        }
        return this.queryOrgByPage(reqDto);
    }

    @Override
    public List<CsOrganizationPageRespDto> querySaleOrgByList(CsOrganizationPageQueryDto reqDto) {
        List orgList = this.iUsOrganizationDomain.queryList(reqDto);
        return this.querySaleCompanyInfo(orgList);
    }

    @NotNull
    private List<CsOrganizationPageRespDto> querySaleCompanyInfo(List<CsOrganizationPageRespDto> orgList) {
        if (CollectionUtils.isEmpty(orgList)) {
            return new ArrayList<CsOrganizationPageRespDto>();
        }
        List ids = orgList.stream().map(CsOrganizationPageRespDto::getId).collect(Collectors.toList());
        List enterpriseDtos = this.iDgREnterpriseOrganizationDomain.queryEnterpriseByOrgId(ids);
        if (CollectionUtils.isEmpty((Collection)enterpriseDtos)) {
            return orgList;
        }
        Map orgIdEnterpriseMap = enterpriseDtos.stream().collect(Collectors.toMap(CsOrganizationPageRespDto::getId, Function.identity(), (o1, o2) -> o2));
        for (CsOrganizationPageRespDto dto : orgList) {
            CsOrganizationPageRespDto respDto = (CsOrganizationPageRespDto)orgIdEnterpriseMap.get(dto.getId());
            if (!Objects.nonNull(respDto)) continue;
            dto.setEnterpriseId(respDto.getEnterpriseId());
            dto.setEnterpriseCode(respDto.getEnterpriseCode());
            dto.setEnterpriseName(respDto.getEnterpriseName());
        }
        return orgList;
    }

    @Override
    public List<CsOrganizationPageRespDto> queryTobSaleOrgByList(CsOrganizationPageReqDto reqDto) {
        List<OrganizationEo> parentOrgList = this.getParentOrgList(reqDto);
        if (CollectionUtils.isEmpty(parentOrgList)) {
            return Collections.emptyList();
        }
        ArrayList<OrganizationEo> all = new ArrayList<OrganizationEo>();
        this.queryChildOrg(parentOrgList, all);
        all.addAll(parentOrgList);
        List idList = all.stream().map(OrganizationEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return Collections.emptyList();
        }
        CsOrganizationPageQueryDto queryDto = new CsOrganizationPageQueryDto();
        BeanUtil.copyProperties((Object)reqDto, (Object)queryDto, (String[])new String[0]);
        queryDto.setIdList(idList);
        List csOrganizationPageRespDtos = this.iUsOrganizationDomain.queryList(queryDto);
        return this.querySaleCompanyInfo(csOrganizationPageRespDtos);
    }

    private PageInfo<CsOrganizationPageRespDto> queryOrgByPage(CsOrganizationPageReqDto reqDto) {
        if (reqDto.getId() == null && CollectionUtils.isEmpty((Collection)reqDto.getRootIdList())) {
            return new PageInfo();
        }
        List secondChild = this.iUsOrganizationDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrganizationEo.class).eq(Objects.nonNull(reqDto.getId()), OrganizationEo::getId, (Object)reqDto.getId())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getRootIdList()), OrganizationEo::getId, (Collection)reqDto.getRootIdList()));
        if (CollectionUtils.isEmpty((Collection)secondChild)) {
            return new PageInfo();
        }
        ArrayList<OrganizationEo> all = new ArrayList<OrganizationEo>(secondChild);
        this.queryChildOrg(secondChild, all);
        List idList = all.stream().map(OrganizationEo::getId).distinct().collect(Collectors.toList());
        CsOrganizationPageQueryDto queryDto = new CsOrganizationPageQueryDto();
        BeanUtil.copyProperties((Object)reqDto, (Object)queryDto, (String[])new String[0]);
        queryDto.setIdList(idList);
        return this.iUsOrganizationDomain.queryPage(queryDto);
    }

    private PageInfo<CsOrganizationPageRespDto> queryOrgByPageSale(CsOrganizationPageReqDto reqDto) {
        List<OrganizationEo> parentOrgList = this.getParentOrgList(reqDto);
        if (CollectionUtils.isEmpty(parentOrgList)) {
            return new PageInfo();
        }
        ArrayList<OrganizationEo> all = new ArrayList<OrganizationEo>();
        this.queryChildOrg(parentOrgList, all);
        all.addAll(parentOrgList);
        List idList = all.stream().map(OrganizationEo::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(idList)) {
            return new PageInfo();
        }
        CsOrganizationPageQueryDto queryDto = new CsOrganizationPageQueryDto();
        BeanUtil.copyProperties((Object)reqDto, (Object)queryDto, (String[])new String[0]);
        queryDto.setIdList(idList);
        return this.iUsOrganizationDomain.queryPage(queryDto);
    }

    private List<OrganizationEo> getParentOrgList(CsOrganizationPageReqDto reqDto) {
        ArrayList<OrganizationEo> rootOrg = new ArrayList<OrganizationEo>();
        if (reqDto.getId() == null && CollectionUtils.isEmpty((Collection)reqDto.getRootIdList())) {
            String rootOrgId = RequestUtil.getHeader("Root-Organization-Id");
            if (StrUtil.isBlank((CharSequence)rootOrgId)) {
                return rootOrg;
            }
            OrganizationEo salesOrgRootId = this.iUsOrganizationDomain.getSalesOrgRootId(Long.valueOf(rootOrgId));
            if (Objects.isNull(salesOrgRootId)) {
                return rootOrg;
            }
            reqDto.setId(salesOrgRootId.getId());
            rootOrg.add(salesOrgRootId);
            return rootOrg;
        }
        List organizationEos = this.iUsOrganizationDomain.selectList((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(OrganizationEo.class).eq(reqDto.getId() != null, OrganizationEo::getId, (Object)reqDto.getId())).in(CollectionUtils.isNotEmpty((Collection)reqDto.getRootIdList()), OrganizationEo::getId, (Collection)reqDto.getRootIdList()));
        return organizationEos;
    }

    private void queryChildOrg(List<OrganizationEo> parent, List<OrganizationEo> all) {
        if (CollectionUtils.isEmpty(parent)) {
            return;
        }
        List parentIdList = parent.stream().map(OrganizationEo::getId).distinct().collect(Collectors.toList());
        List children = this.iUsOrganizationDomain.selectList((LambdaQueryWrapper)Wrappers.lambdaQuery(OrganizationEo.class).in(OrganizationEo::getParentId, parentIdList));
        if (CollectionUtils.isEmpty((Collection)children)) {
            return;
        }
        all.addAll(children);
        this.queryChildOrg(children, all);
    }

    private List<Long> getRootFuncOrgId(String funcType) {
        String header = RequestUtil.getHeader("Root-Organization-Id");
        if (StringUtils.isBlank((CharSequence)header)) {
            header = "1692432905039486978";
        }
        Long rootOrgId = Long.valueOf(header);
        List rootDepartmentList = this.iUsOrganizationDas.listChildOrgByOrgIdAndFuncType(Collections.singletonList(rootOrgId), funcType);
        return ((List)Optional.ofNullable(rootDepartmentList).orElse(new ArrayList())).stream().map(CsOrganizationPageRespDto::getId).collect(Collectors.toList());
    }
}

