/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.rest.RestResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.convert.inventory.DgPhysicsWarehouseConverter;
import com.yunxi.dg.base.center.report.domain.inventory.IDgPhysicsWarehouseDomain;
import com.yunxi.dg.base.center.report.dto.inventory.DgPhysicsWarehouseDto;
import com.yunxi.dg.base.center.report.eo.inventory.DgPhysicsWarehouseEo;
import com.yunxi.dg.base.center.report.service.inventory.IDgPhysicsWarehouseService;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPhysicsWarehouseServiceImpl
extends BaseServiceImpl<DgPhysicsWarehouseDto, DgPhysicsWarehouseEo, IDgPhysicsWarehouseDomain>
implements IDgPhysicsWarehouseService {
    private static final Logger log = LoggerFactory.getLogger(DgPhysicsWarehouseServiceImpl.class);

    public DgPhysicsWarehouseServiceImpl(IDgPhysicsWarehouseDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<DgPhysicsWarehouseDto, DgPhysicsWarehouseEo> converter() {
        return DgPhysicsWarehouseConverter.INSTANCE;
    }

    @Override
    public RestResponse<List<DgPhysicsWarehouseDto>> queryAll() {
        return new RestResponse((Object)((IDgPhysicsWarehouseDomain)this.domain).queryAll());
    }

    @Override
    public List<DgPhysicsWarehouseDto> queryByLogicWarehouseCodeList(List<String> logicWarehouseCodeList) {
        if (CollectionUtils.isEmpty(logicWarehouseCodeList)) {
            return null;
        }
        return ((IDgPhysicsWarehouseDomain)this.domain).queryByLogicWarehouseCodeList(logicWarehouseCodeList);
    }

    @Override
    public List<DgPhysicsWarehouseDto> queryPhyWarehouse(List<String> warehouseCodes) {
        ArrayList physicsWarehouseDtos = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(warehouseCodes)) {
            List physicsWarehouseEos = ((ExtQueryChainWrapper)((IDgPhysicsWarehouseDomain)this.domain).filter().in((Object)"warehouse_code", warehouseCodes)).list();
            CubeBeanUtils.copyCollection((Collection)physicsWarehouseDtos, (Collection)physicsWarehouseEos, DgPhysicsWarehouseDto.class);
        }
        return physicsWarehouseDtos;
    }
}

