/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.impl.inventory.query;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.dao.common.select.MultipartSelectGeneric;
import com.yunxi.dg.base.center.report.dao.common.select.SelectGeneric;
import com.yunxi.dg.base.center.report.dao.das.IUnitDgDas;
import com.yunxi.dg.base.center.report.dao.das.common.ISelectCommonDas;
import com.yunxi.dg.base.center.report.domain.entity.IOutNoticeOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.entity.IWarehouseAddressDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDetailDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgDeliveryResultOrderDomain;
import com.yunxi.dg.base.center.report.domain.inventory.IDgOutNoticeOrderDomain;
import com.yunxi.dg.base.center.report.dto.agg.DgBusinessGoodsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.BaseQueryPageReqDto;
import com.yunxi.dg.base.center.report.dto.inventory.InventoryStatisticsRespDto;
import com.yunxi.dg.base.center.report.dto.inventory.query.IQueryPageRespDto;
import com.yunxi.dg.base.center.report.eo.UnitDgEo;
import com.yunxi.dg.base.center.report.eo.WarehouseAddressEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgDeliveryResultOrderEo;
import com.yunxi.dg.base.center.report.eo.inventory.DgOutNoticeOrderEo;
import com.yunxi.dg.base.center.report.service.impl.inventory.query.IReportDataSearchService;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.compress.utils.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractReportDataSearchServiceImpl<T, R>
implements IReportDataSearchService<T, R> {
    private static final Logger log = LoggerFactory.getLogger(AbstractReportDataSearchServiceImpl.class);
    @Resource
    private ISelectCommonDas das;
    @Resource
    private IDgDeliveryResultOrderDomain dgDeliveryResultOrderDomain;
    @Resource
    private IDgDeliveryResultOrderDetailDomain dgDeliveryResultOrderDetailDomain;
    @Resource
    private IWarehouseAddressDomain warehouseAddressDomain;
    @Resource
    private IDgOutNoticeOrderDomain dgOutNoticeOrderDomain;
    @Resource
    private IOutNoticeOrderDetailDomain outNoticeOrderDetailDomain;
    @Resource
    private IUnitDgDas unitDgDas;
    private String tableName;
    private String alias;

    public AbstractReportDataSearchServiceImpl(String tableName, String alias) {
        this.tableName = tableName;
        this.alias = alias;
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public PageInfo<R> queryList(T t) {
        MultipartSelectGeneric generic = new MultipartSelectGeneric(this.tableName, this.alias);
        this.setFields(generic);
        this.setLeftJoinOn(generic);
        this.setWhere(generic, t);
        this.setOrderBy(generic);
        generic.end();
        Page page = this.das.queryPage((SelectGeneric)generic);
        if (null == page || CollectionUtil.isEmpty((Collection)page.getResult())) {
            return new PageInfo((List)Lists.newArrayList());
        }
        ArrayList results = Lists.newArrayList();
        Class<R> classType = this.getClassType();
        for (Map map : page) {
            results.add(BeanUtil.toBeanIgnoreCase((Object)map, classType, (boolean)false));
        }
        this.wrap(results);
        PageInfo resultPageInfo = new PageInfo();
        resultPageInfo.setPages(page.getPages());
        resultPageInfo.setTotal(page.getTotal());
        resultPageInfo.setList((List)results);
        return resultPageInfo;
    }

    @Override
    public PageInfo<DgBusinessGoodsRespDto> queryList(BaseQueryPageReqDto queryPageReqDto) {
        T t = this.convert2ReqDto(queryPageReqDto);
        PageInfo<R> pageInfo = this.queryList(t);
        return this.convert2RespDto(pageInfo);
    }

    protected T convert2ReqDto(BaseQueryPageReqDto queryPageReqDto) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u5f53\u524d\u8f6c\u6362");
    }

    protected PageInfo<DgBusinessGoodsRespDto> convert2RespDto(PageInfo<R> pageInfo) {
        throw new RuntimeException("\u4e0d\u652f\u6301\u5f53\u524d\u8f6c\u6362");
    }

    protected void wrap(List<R> resultList) {
        if (CollectionUtils.isNotEmpty(resultList) && resultList.get(0) instanceof IQueryPageRespDto) {
            Map<String, String> unitCode2NameMap = this.fetchUnitCode2NameMap();
            Set<String> physicsWarehouseCodes = resultList.stream().map(x -> {
                IQueryPageRespDto queryPageRespDto = (IQueryPageRespDto)x;
                return queryPageRespDto.getPhysicsWarehouseCode();
            }).collect(Collectors.toSet());
            Map<String, String> code2PhysicsWarehouseMap = this.getPhysicsWarehouse(physicsWarehouseCodes);
            log.info("\u67e5\u8be2\u7684\u7269\u7406\u4ed3\u5e93\u4fe1\u606f\uff1a{}", (Object)JSONObject.toJSONString(code2PhysicsWarehouseMap));
            resultList.forEach(x -> {
                IQueryPageRespDto queryPageRespDto = (IQueryPageRespDto)x;
                queryPageRespDto.setPhysicsWarehouseAddress((String)code2PhysicsWarehouseMap.get(queryPageRespDto.getPhysicsWarehouseCode()));
                queryPageRespDto.setUnitName((String)unitCode2NameMap.get(queryPageRespDto.getUnit()));
            });
        }
    }

    protected Class<R> getClassType() {
        Class<?> respClass = this.getClass();
        return (Class)((ParameterizedType)respClass.getGenericSuperclass()).getActualTypeArguments()[1];
    }

    protected void setOrderBy(MultipartSelectGeneric generic) {
        generic.orderBy("md.id", "DESC");
    }

    protected void setWhere(MultipartSelectGeneric generic, T t) {
        generic.equalsWhere("m.dr", (Object)"0");
        generic.equalsWhere("md.dr", (Object)"0");
    }

    protected void setLeftJoinOn(MultipartSelectGeneric generic) {
        generic.addLeftJoin("it_item_sku_dg", "iisd", "iisd.CODE = md.sku_code and iisd.dr = 0");
        generic.addLeftJoin("it_item_dg", "iig", "iig.id = iisd.item_id and iig.dr = 0");
        generic.addLeftJoin("cs_inventory_batch", "cib", "cib.sku_code = md.sku_code and cib.batch = md.batch and cib.dr = 0");
    }

    protected void setFields(MultipartSelectGeneric generic) {
        generic.addFields(this.getAllFieldList());
    }

    protected List<String> getAllFieldList() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.addAll(this.getExtFields());
        fields.addAll(this.getFieldList());
        return fields;
    }

    protected List<String> getFieldList() {
        ArrayList<String> fields = new ArrayList<String>();
        fields.add("iig.CODE AS spuCode");
        fields.add("iig.NAME AS spuName");
        fields.add("iig.STORAGE AS storageCondition");
        fields.add("cib.produce_time AS produceTime");
        fields.add("cib.expire_time AS expireTime");
        fields.add("cib.id AS inventoryBatchId");
        fields.add("iisd.display_name AS skuDisplayName");
        fields.add("iisd.package_num AS packageNum");
        fields.add("iisd.bar_code AS barCode");
        fields.add("iisd.spec_model as specModel");
        fields.add("iisd.volume as skuVolume");
        fields.add("iisd.volume_unit as volumeUnit");
        return fields;
    }

    protected List<String> getExtFields() {
        return new ArrayList<String>();
    }

    public Map<String, String> getPhysicsWarehouse(Set<String> physicsWarehouseCodes) {
        List inPhysicsWarehouseEoList = this.warehouseAddressDomain.queryByWarehouseCodes(new ArrayList<String>(physicsWarehouseCodes), "physics");
        return inPhysicsWarehouseEoList.stream().collect(Collectors.toMap(WarehouseAddressEo::getWarehouseCode, x -> x.getProvince() + x.getCity() + x.getDistrict() + x.getDetailAddress(), (existing, replacement) -> existing));
    }

    public Map<Long, InventoryStatisticsRespDto> getProcessingQuantityOfTheDocument(Set<String> orderNos, String ... status) {
        if (CollectionUtils.isEmpty(orderNos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        List deliveryResultOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgDeliveryResultOrderDomain.filter().in((Object)"relevance_no", orderNos)).in((Object)"order_status", (Object[])status)).list();
        if (CollectionUtils.isEmpty((Collection)deliveryResultOrderEos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        Map<String, String> documentNoMap = deliveryResultOrderEos.stream().collect(Collectors.toMap(DgDeliveryResultOrderEo::getDocumentNo, DgDeliveryResultOrderEo::getRelevanceNo));
        return ((ExtQueryChainWrapper)this.dgDeliveryResultOrderDetailDomain.filter().in((Object)"document_no", documentNoMap.keySet())).list().stream().map(x -> (InventoryStatisticsRespDto)BeanUtil.copyProperties((Object)x, InventoryStatisticsRespDto.class, (String[])new String[0])).collect(Collectors.toMap(r -> r.getPreOrderItemId(), Function.identity(), (o, o1) -> {
            o.setWaitQuantity(BigDecimalUtils.add((BigDecimal)o.getWaitQuantity(), (BigDecimal)o1.getWaitQuantity()));
            o.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
            o.setCancelQuantity(BigDecimalUtils.add((BigDecimal)o.getCancelQuantity(), (BigDecimal)o1.getCancelQuantity()));
            o.setPlanQuantity(BigDecimalUtils.add((BigDecimal)o.getPlanQuantity(), (BigDecimal)o1.getPlanQuantity()));
            return o;
        }));
    }

    public Map<Long, InventoryStatisticsRespDto> getOutQuantityOfTheDocument(Set<String> orderNos, String ... type) {
        if (CollectionUtils.isEmpty(orderNos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        List dgOutNoticeOrderEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.dgOutNoticeOrderDomain.filter().in((Object)"relevance_no", orderNos)).in((Object)"order_type", (Object[])type)).notIn((Object)"order_status", new Object[]{"ono_cancel", "ino_cancel"})).list();
        if (CollectionUtils.isEmpty((Collection)dgOutNoticeOrderEos)) {
            return new HashMap<Long, InventoryStatisticsRespDto>();
        }
        Set documentNoSet = dgOutNoticeOrderEos.stream().map(DgOutNoticeOrderEo::getDocumentNo).collect(Collectors.toSet());
        return ((ExtQueryChainWrapper)this.outNoticeOrderDetailDomain.filter().in((Object)"document_no", documentNoSet)).list().stream().map(x -> (InventoryStatisticsRespDto)BeanUtil.copyProperties((Object)x, InventoryStatisticsRespDto.class, (String[])new String[0])).collect(Collectors.toMap(r -> r.getPreOrderItemId(), Function.identity(), (o, o1) -> {
            o.setWaitQuantity(BigDecimalUtils.add((BigDecimal)o.getWaitQuantity(), (BigDecimal)o1.getWaitQuantity()));
            o.setDoneQuantity(BigDecimalUtils.add((BigDecimal)o.getDoneQuantity(), (BigDecimal)o1.getDoneQuantity()));
            o.setCancelQuantity(BigDecimalUtils.add((BigDecimal)o.getCancelQuantity(), (BigDecimal)o1.getCancelQuantity()));
            o.setPlanQuantity(BigDecimalUtils.add((BigDecimal)o.getPlanQuantity(), (BigDecimal)o1.getPlanQuantity()));
            return o;
        }));
    }

    public Map<String, String> fetchUnitCode2NameMap() {
        List list = this.unitDgDas.filter().list();
        return ((List)Optional.ofNullable(list).orElse(new ArrayList())).stream().collect(Collectors.toMap(UnitDgEo::getCode, UnitDgEo::getName, (v1, v2) -> v2));
    }
}

