/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.report.convert.reconciliation.FiltrationDispositionConverter;
import com.yunxi.dg.base.center.report.domain.reconciliation.IFiltrationDispositionDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionPageDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.FiltrationDispositionRespDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.FiltrationDispositionEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IFiltrationDispositionService;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.stereotype.Service;

@Service
public class FiltrationDispositionServiceImpl
extends BaseServiceImpl<FiltrationDispositionDto, FiltrationDispositionEo, IFiltrationDispositionDomain>
implements IFiltrationDispositionService {
    public FiltrationDispositionServiceImpl(IFiltrationDispositionDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<FiltrationDispositionDto, FiltrationDispositionEo> converter() {
        return FiltrationDispositionConverter.INSTANCE;
    }

    @Override
    public RestResponse<Long> insertFiltrationDisposition(FiltrationDispositionDto dto) {
        AssertUtils.notNull((Object)dto.getSource(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)dto.getFiltrationType(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        FiltrationDispositionEo dispositionEo = (FiltrationDispositionEo)this.converter().toEo((BaseDto)dto);
        ((IFiltrationDispositionDomain)this.domain).insert((BaseEo)dispositionEo);
        return new RestResponse((Object)dispositionEo.getId());
    }

    @Override
    public RestResponse<Void> batchInsertFiltration(List<FiltrationDispositionDto> dispositionDtoList) {
        if (CollectionUtils.isNotEmpty(dispositionDtoList)) {
            for (FiltrationDispositionDto dto : dispositionDtoList) {
                AssertUtils.notNull((Object)dto.getFiltrationType(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
                AssertUtils.notNull((Object)dto.getSource(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            }
        } else {
            return new RestResponse();
        }
        List dispositionEoList = this.converter().toEoList(dispositionDtoList);
        ((IFiltrationDispositionDomain)this.domain).insertBatch(dispositionEoList);
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Void> batchUpdateFiltration(List<FiltrationDispositionDto> dispositionDtoList) {
        if (CollectionUtils.isEmpty(dispositionDtoList)) {
            return new RestResponse();
        }
        for (FiltrationDispositionDto dto : dispositionDtoList) {
            AssertUtils.notNull((Object)dto.getId(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dto.getSource(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notNull((Object)dto.getFiltrationType(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        List dispositionEoList = this.converter().toEoList(dispositionDtoList);
        if (CollectionUtils.isNotEmpty(dispositionDtoList)) {
            for (FiltrationDispositionEo dispositionEo : dispositionEoList) {
                ((IFiltrationDispositionDomain)this.domain).updateSelective((BaseEo)dispositionEo);
            }
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<Long> deleteFiltrationDisposition(FiltrationDispositionDto dto) {
        AssertUtils.notNull((Object)dto.getId(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
        FiltrationDispositionEo dispositionEo = (FiltrationDispositionEo)((IFiltrationDispositionDomain)this.domain).selectByPrimaryKey(dto.getId());
        AssertUtils.notNull((Object)dispositionEo, (String)"\u8be5\u5e93\u5b58\u6570\u636e\u8fc7\u6ee4\u914d\u7f6e\u4e0d\u5b58\u5728");
        ((IFiltrationDispositionDomain)this.domain).deleteById(dispositionEo.getId());
        return new RestResponse((Object)dispositionEo.getId());
    }

    @Override
    public RestResponse<Void> batchDeleteFiltrationDisposition(List<FiltrationDispositionDto> dispositionDtoList) {
        if (CollectionUtils.isNotEmpty(dispositionDtoList)) {
            for (FiltrationDispositionDto dto : dispositionDtoList) {
                AssertUtils.notNull((Object)dto.getId(), (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u914d\u7f6eID\u4e0d\u80fd\u4e3a\u7a7a");
                FiltrationDispositionEo dispositionEo = (FiltrationDispositionEo)((IFiltrationDispositionDomain)this.domain).selectByPrimaryKey(dto.getId());
                AssertUtils.notNull((Object)dispositionEo, (String)"\u8be5\u6570\u636e\u8fc7\u6ee4\u914d\u7f6e\u4e0d\u5b58\u5728");
            }
            List ids = dispositionDtoList.stream().map(e -> e.getId()).collect(Collectors.toList());
            ((IFiltrationDispositionDomain)this.domain).getMapper().deleteBatchIds(ids);
        }
        return RestResponse.VOID;
    }

    @Override
    public RestResponse<PageInfo<FiltrationDispositionRespDto>> selectFiltrationDisposition(FiltrationDispositionPageDto dto) {
        PageHelper.startPage((int)dto.getPageNum(), (int)dto.getPageSize());
        FiltrationDispositionEo dispositionEo = new FiltrationDispositionEo();
        dispositionEo.setSource(dto.getSource());
        dispositionEo.setFiltrationType(dto.getFiltrationType());
        dispositionEo.setDispositionNo(dto.getDispositionNo());
        dispositionEo.setDispositionId(dto.getDispositionId());
        PageInfo pageInfo = new PageInfo(((IFiltrationDispositionDomain)this.domain).selectDisposition(dispositionEo));
        return new RestResponse((Object)pageInfo);
    }

    @Override
    public List<FiltrationDispositionEo> selectFiltrationByCode(String source, String filtrationType) {
        AssertUtils.notNull((Object)source, (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u6765\u6e90\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)filtrationType, (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IFiltrationDispositionDomain)this.domain).filter().eq((Object)"source", (Object)source)).eq((Object)"filtration_type", (Object)filtrationType)).list();
    }

    @Override
    public List<FiltrationDispositionEo> selectFiltrationByCondition(String dispositionNo, String filtrationType) {
        AssertUtils.notNull((Object)dispositionNo, (String)"\u89c4\u5219\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)filtrationType, (String)"\u5e93\u5b58\u8fc7\u6ee4\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((IFiltrationDispositionDomain)this.domain).filter().eq((Object)"disposition_no", (Object)dispositionNo)).eq((Object)"filtration_type", (Object)filtrationType)).list();
    }
}

