/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.eo.SqlFilter;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.report.constants.InventoryCompareTypeEnum;
import com.yunxi.dg.base.center.report.constants.YesNoEnum;
import com.yunxi.dg.base.center.report.constants.reconciliation.DateTypeEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.InventoryDiscrepancyConverter;
import com.yunxi.dg.base.center.report.dao.vo.InventoryDiscrepancyPageReqVo;
import com.yunxi.dg.base.center.report.domain.reconciliation.IInventoryDiscrepancyDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyDto;
import com.yunxi.dg.base.center.report.dto.reconciliation.InventoryDiscrepancyPageReqDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.InventoryDiscrepancyEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IInventoryDiscrepancyService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class InventoryDiscrepancyServiceImpl
extends BaseServiceImpl<InventoryDiscrepancyDto, InventoryDiscrepancyEo, IInventoryDiscrepancyDomain>
implements IInventoryDiscrepancyService {
    private static final Logger log = LoggerFactory.getLogger(InventoryDiscrepancyServiceImpl.class);

    public InventoryDiscrepancyServiceImpl(IInventoryDiscrepancyDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<InventoryDiscrepancyDto, InventoryDiscrepancyEo> converter() {
        return InventoryDiscrepancyConverter.INSTANCE;
    }

    @Override
    public RestResponse<PageInfo<InventoryDiscrepancyDto>> selectByParams(InventoryDiscrepancyPageReqDto pageReqDto) {
        PageHelper.startPage((int)pageReqDto.getPageNum(), (int)pageReqDto.getPageSize());
        InventoryDiscrepancyPageReqVo pageReqVo = new InventoryDiscrepancyPageReqVo();
        BeanUtils.copyProperties((Object)pageReqDto, (Object)pageReqVo);
        this.setResult(pageReqVo);
        PageInfo eoPageInfo = new PageInfo(((IInventoryDiscrepancyDomain)this.domain).selectByParams(pageReqVo));
        PageInfo dtoPageInfo = new PageInfo();
        if (CollectionUtils.isNotEmpty((Collection)eoPageInfo.getList())) {
            BeanUtils.copyProperties((Object)eoPageInfo, (Object)dtoPageInfo);
            List dtos = eoPageInfo.getList().stream().map(e -> {
                InventoryDiscrepancyDto dto = (InventoryDiscrepancyDto)this.converter().toDto((BaseEo)e);
                dto.setDifferenceMidwayNum(e.getDifferenceNum().add(e.getMidwayNum()));
                if (BigDecimal.ZERO.compareTo(dto.getDifferenceMidwayNum()) == 0) {
                    dto.setResult("0");
                } else {
                    dto.setResult("1");
                }
                dto.setTypeName(InventoryCompareTypeEnum.getName((String)dto.getType()));
                if (!Objects.equals(DateTypeEnum.DAY.getCode(), pageReqDto.getDateType()) && Objects.nonNull(e.getLastDayOfTheMonth()) && 1 == e.getLastDayOfTheMonth()) {
                    String[] split = dto.getBizDate().split("-");
                    dto.setBizDate(String.format("%s-%s", split[0], split[1]));
                }
                return dto;
            }).collect(Collectors.toList());
            dtoPageInfo.setList(dtos);
        }
        return new RestResponse((Object)dtoPageInfo);
    }

    private void setResult(InventoryDiscrepancyPageReqVo pageReqVo) {
        if (CollectionUtils.isNotEmpty((Collection)pageReqVo.getResultList()) && pageReqVo.getResultList().size() == 1) {
            String result = (String)pageReqVo.getResultList().get(0);
            if (YesNoEnum.NO.getCode().toString().equals(result)) {
                pageReqVo.setConsistent(result);
            } else {
                pageReqVo.setInConsistent(result);
            }
        }
    }

    @Override
    public List<InventoryDiscrepancyDto> queryListByParam(InventoryDiscrepancyPageReqDto dto) {
        InventoryDiscrepancyPageReqVo vo = new InventoryDiscrepancyPageReqVo();
        BeanUtils.copyProperties((Object)dto, (Object)vo);
        List eos = ((IInventoryDiscrepancyDomain)this.domain).selectByParams(vo);
        ArrayList<InventoryDiscrepancyDto> list = new ArrayList<InventoryDiscrepancyDto>();
        CubeBeanUtils.copyCollection(list, (Collection)eos, InventoryDiscrepancyDto.class);
        return list;
    }

    @Override
    public RestResponse<Long> updateRemark(InventoryDiscrepancyDto discrepancyDto) {
        AssertUtils.isTrue((null != discrepancyDto.getId() ? 1 : 0) != 0, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((boolean)StringUtils.isNotEmpty((CharSequence)discrepancyDto.getRemark()), (String)"\u5907\u6ce8\u4e0d\u80fd\u4e3a\u7a7a");
        InventoryDiscrepancyEo discrepancyEo = (InventoryDiscrepancyEo)((IInventoryDiscrepancyDomain)this.domain).selectByPrimaryKey(discrepancyDto.getId());
        AssertUtils.isTrue((null != discrepancyEo.getId() ? 1 : 0) != 0, (String)"\u65e0\u8be5\u5bf9\u8d26\u8bb0\u5f55");
        discrepancyEo.setRemark(discrepancyDto.getRemark());
        ((IInventoryDiscrepancyDomain)this.domain).updateSelective((BaseEo)discrepancyEo);
        return new RestResponse((Object)discrepancyEo.getId());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchDeleteInventoryDiscrepancy(List<InventoryDiscrepancyDto> inventoryDiscrepancyEoList, String bizDate) {
        log.info("\u5220\u9664\u76f8\u540c\u65e5\u671f+\u76f8\u540c\u903b\u8f91\u4ed3+\u76f8\u540csku+\u76f8\u540c\u72b6\u6001\u6570\u636e:{}", (Object)bizDate);
        List<String> skuCodes = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getSkuCode).distinct().collect(Collectors.toList());
        List<String> warehouseCodes = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getLogicWarehouseCode).distinct().collect(Collectors.toList());
        List<String> types = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getType).distinct().collect(Collectors.toList());
        List<String> sources = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getSource).distinct().collect(Collectors.toList());
        List<String> inventoryStatus = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getStatus).distinct().collect(Collectors.toList());
        String dateType = inventoryDiscrepancyEoList.stream().map(InventoryDiscrepancyDto::getDateType).findAny().orElse("");
        if (CollectionUtils.isNotEmpty(skuCodes) && skuCodes.size() > 4000) {
            List skuCodeList = Lists.partition(skuCodes, (int)2000);
            for (List partitionSkuCodes : skuCodeList) {
                this.updateInventoryDiscrepanyEo(bizDate, warehouseCodes, types, sources, inventoryStatus, dateType, partitionSkuCodes);
            }
        } else {
            this.updateInventoryDiscrepanyEo(bizDate, warehouseCodes, types, sources, inventoryStatus, dateType, skuCodes);
        }
    }

    private void updateInventoryDiscrepanyEo(String bizDate, List<String> warehouseCodes, List<String> types, List<String> sources, List<String> inventoryStatus, String dateType, List<String> skuCodes) {
        ExtQueryChainWrapper sqlFilters = ((IInventoryDiscrepancyDomain)this.domain).filter();
        if (StringUtils.isNotEmpty((CharSequence)dateType) && DateTypeEnum.CURRENT.getCode().equals(dateType)) {
            sqlFilters.eq((Object)"date_type", (Object)dateType);
        } else {
            sqlFilters.eq((Object)"biz_date", (Object)bizDate);
        }
        sqlFilters.in((Object)"source", sources);
        sqlFilters.in((Object)"sku_code", skuCodes);
        sqlFilters.in((Object)"type", types);
        sqlFilters.in((Object)"status", inventoryStatus);
        sqlFilters.in((Object)"logic_warehouse_code", warehouseCodes);
        Integer pageNum = 1;
        Integer pageSize = 2000;
        PageInfo pageInfo = sqlFilters.page(pageNum, pageSize);
        if (Objects.nonNull(pageInfo) && CollectionUtil.isNotEmpty((Collection)pageInfo.getList())) {
            List<Long> ids = pageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            this.updateInventoryDiscrepanyByIds(ids);
        }
        for (int i = pageInfo.getPages() - 1; i >= 0; --i) {
            PageInfo eoPageInfo = sqlFilters.page(Integer.valueOf(i), pageSize);
            log.info("\u67e5\u8be2\u4e09\u65b9\u5e93\u5b58\u8bb0\u5f55\u8868\u5b9e\u4f53\u5bf9\u8c61pageNum={},\u8fd4\u56depages={}", (Object)pageNum, Objects.nonNull(eoPageInfo) ? Integer.valueOf(eoPageInfo.getPages()) : null);
            if (!Objects.nonNull(eoPageInfo) || !CollectionUtil.isNotEmpty((Collection)eoPageInfo.getList())) continue;
            List<Long> ids = eoPageInfo.getList().stream().map(BaseEo::getId).distinct().collect(Collectors.toList());
            this.updateInventoryDiscrepanyByIds(ids);
        }
    }

    private void updateInventoryDiscrepanyByIds(List<Long> ids) {
        InventoryDiscrepancyEo inventoryEo = new InventoryDiscrepancyEo();
        ArrayList<SqlFilter> sqlFilterList = new ArrayList<SqlFilter>();
        sqlFilterList.add(SqlFilter.in((String)"id", ids));
        inventoryEo.setDr(1);
        inventoryEo.setSqlFilters(sqlFilterList);
        ((IInventoryDiscrepancyDomain)this.domain).updateSelectiveSqlFilter((BaseEo)inventoryEo);
    }
}

