/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.service.reconciliation.impl;

import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.rest.RestResponse;
import com.google.common.base.Throwables;
import com.yunxi.dg.base.center.inventory.api.IErpKeepAccountsDataQueryApi;
import com.yunxi.dg.base.center.inventory.dto.request.ErpSaleOutQueryDto;
import com.yunxi.dg.base.center.inventory.dto.request.ErpSaleReturnQueryDto;
import com.yunxi.dg.base.center.inventory.dto.response.ErpSaleOutRespDto;
import com.yunxi.dg.base.center.inventory.dto.response.ErpSaleReturnRespDto;
import com.yunxi.dg.base.center.report.constants.ErpBussinessTypeEnum;
import com.yunxi.dg.base.center.report.convert.reconciliation.KeepAccountsDetailConverter;
import com.yunxi.dg.base.center.report.domain.reconciliation.IKeepAccountsDetailDomain;
import com.yunxi.dg.base.center.report.dto.reconciliation.KeepAccountsDetailDto;
import com.yunxi.dg.base.center.report.eo.reconciliation.KeepAccountsDetailEo;
import com.yunxi.dg.base.center.report.service.reconciliation.IKeepAccountsDetailService;
import com.yunxi.dg.base.center.report.service.utils.DateTimeUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import com.yunxi.dg.base.framework.core.convert.IConverter;
import com.yunxi.dg.base.framework.core.domain.IBaseDomain;
import com.yunxi.dg.base.framework.core.service.impl.BaseServiceImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class KeepAccountsDetailServiceImpl
extends BaseServiceImpl<KeepAccountsDetailDto, KeepAccountsDetailEo, IKeepAccountsDetailDomain>
implements IKeepAccountsDetailService {
    private static final Logger log = LoggerFactory.getLogger(KeepAccountsDetailServiceImpl.class);
    @Resource
    private IErpKeepAccountsDataQueryApi erpKeepAccountsDataQueryApi;

    public KeepAccountsDetailServiceImpl(IKeepAccountsDetailDomain domain) {
        super((IBaseDomain)domain);
    }

    public IConverter<KeepAccountsDetailDto, KeepAccountsDetailEo> converter() {
        return KeepAccountsDetailConverter.INSTANCE;
    }

    @Override
    public RestResponse<Void> pullData(String reconciliationTime) {
        ErpSaleOutQueryDto queryDto = new ErpSaleOutQueryDto();
        if (StringUtils.isNotEmpty((CharSequence)reconciliationTime)) {
            queryDto.setCreateStartTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayBegin(reconciliationTime)));
            queryDto.setCreateEndTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayEnd(reconciliationTime)));
        } else {
            reconciliationTime = DateTimeUtils.getDateString(-1);
            queryDto.setCreateStartTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayBegin(reconciliationTime)));
            queryDto.setCreateEndTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayEnd(reconciliationTime)));
        }
        try {
            List erpSaleOutRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.erpKeepAccountsDataQueryApi.queryErpSaleOut(queryDto));
            if (CollectionUtils.isNotEmpty((Collection)erpSaleOutRespDtos)) {
                List<KeepAccountsDetailEo> detailEoList = this.setDetail(reconciliationTime, erpSaleOutRespDtos);
                this.batchSaveSaleKeepDetail(reconciliationTime, detailEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u51fa\u8bb0\u8d26\u660e\u7ec6\u5f02\u5e38\uff1a{},{}", (Object)reconciliationTime, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        ErpSaleReturnQueryDto returnQueryDto = new ErpSaleReturnQueryDto();
        if (StringUtils.isNotEmpty((CharSequence)reconciliationTime)) {
            returnQueryDto.setCreateStartTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayBegin(reconciliationTime)));
            returnQueryDto.setCreateEndTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayEnd(reconciliationTime)));
        } else {
            reconciliationTime = DateTimeUtils.getDateString(-1);
            returnQueryDto.setCreateEndTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayEnd(reconciliationTime)));
            returnQueryDto.setCreateStartTime(DateTimeUtils.parseDateTime(DateTimeUtils.getDayBegin(reconciliationTime)));
        }
        try {
            List erpSaleReturnRespDtos = (List)RestResponseHelper.extractData((RestResponse)this.erpKeepAccountsDataQueryApi.queryErpSaleReturn(returnQueryDto));
            if (CollectionUtils.isNotEmpty((Collection)erpSaleReturnRespDtos)) {
                List<KeepAccountsDetailEo> detailEoList = this.setReturnDetail(reconciliationTime, erpSaleReturnRespDtos);
                this.batchSaveReturnKeepDetail(reconciliationTime, detailEoList);
            }
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u9500\u552e\u9000\u8bb0\u8d26\u660e\u7ec6\u5f02\u5e38\uff1a{},{}", (Object)reconciliationTime, (Object)Throwables.getStackTraceAsString((Throwable)e));
        }
        return RestResponse.VOID;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveSaleKeepDetail(String reconciliationTime, List<KeepAccountsDetailEo> detailEoList) {
        KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
        detailEo.setChargeDate(DateTimeUtils.parseDate(reconciliationTime));
        detailEo.setErpBussinessType(ErpBussinessTypeEnum.OUT.getCode());
        ((IKeepAccountsDetailDomain)this.domain).getMapper().delete((BaseEo)detailEo);
        ((IKeepAccountsDetailDomain)this.domain).insertBatch(detailEoList);
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchSaveReturnKeepDetail(String reconciliationTime, List<KeepAccountsDetailEo> detailEoList) {
        KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
        detailEo.setChargeDate(DateTimeUtils.parseDate(reconciliationTime));
        detailEo.setErpBussinessType(ErpBussinessTypeEnum.IN.getCode());
        ((IKeepAccountsDetailDomain)this.domain).getMapper().delete((BaseEo)detailEo);
        ((IKeepAccountsDetailDomain)this.domain).insertBatch(detailEoList);
    }

    private List<KeepAccountsDetailEo> setDetail(String reconciliationTime, List<ErpSaleOutRespDto> outRespDtoList) {
        ArrayList<KeepAccountsDetailEo> detailEoList = new ArrayList<KeepAccountsDetailEo>();
        for (ErpSaleOutRespDto respDto : outRespDtoList) {
            KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
            detailEo.setChargeDate(DateTimeUtils.parseDate(reconciliationTime));
            detailEo.setSkuCode(respDto.getGoodsNo());
            detailEo.setSkuName(respDto.getGoodsName());
            detailEo.setBookingType(respDto.getOrderType());
            detailEo.setBookingNo(respDto.getChargeCode());
            detailEo.setErpOrderNo(respDto.getOrderNo());
            detailEo.setErpOrderType(respDto.getOrderType());
            detailEo.setErpCreateTime(respDto.getCreated());
            detailEo.setErpWarehouseCode(respDto.getWarehouseNo());
            detailEo.setErpWarehouseName(respDto.getWarehouseName());
            detailEo.setErpBussinessType(ErpBussinessTypeEnum.OUT.getCode());
            detailEo.setErpQuantity(respDto.getGoodsCount());
            detailEoList.add(detailEo);
        }
        return detailEoList;
    }

    private List<KeepAccountsDetailEo> setReturnDetail(String reconciliationTime, List<ErpSaleReturnRespDto> returnRespDtoList) {
        ArrayList<KeepAccountsDetailEo> detailEoList = new ArrayList<KeepAccountsDetailEo>();
        for (ErpSaleReturnRespDto respDto : returnRespDtoList) {
            KeepAccountsDetailEo detailEo = new KeepAccountsDetailEo();
            detailEo.setChargeDate(DateTimeUtils.parseDate(reconciliationTime));
            detailEo.setSkuCode(respDto.getGoodsNo());
            detailEo.setSkuName(respDto.getGoodsName());
            detailEo.setBookingType(respDto.getOrderType());
            detailEo.setBookingNo(respDto.getChargeCode());
            detailEo.setErpOrderNo(respDto.getOrderNo());
            detailEo.setErpOrderType(respDto.getOrderType());
            detailEo.setErpCreateTime(respDto.getCreated());
            detailEo.setErpWarehouseCode(respDto.getWarehouseNo());
            detailEo.setErpWarehouseName(respDto.getWarehouseName());
            detailEo.setErpBussinessType(ErpBussinessTypeEnum.IN.getCode());
            detailEo.setErpQuantity(respDto.getGoodsCount());
            detailEoList.add(detailEo);
        }
        return detailEoList;
    }
}

