/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.report.utils;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONUtil;
import com.alibaba.fastjson.JSON;
import com.yunxi.dg.base.center.report.annotations.EsConditions;
import com.yunxi.dg.base.center.report.annotations.EsDocTypeEnum;
import com.yunxi.dg.base.center.report.annotations.EsEqual;
import com.yunxi.dg.base.center.report.annotations.EsIn;
import com.yunxi.dg.base.center.report.annotations.EsNotIn;
import com.yunxi.dg.base.center.report.annotations.EsOptionType;
import com.yunxi.dg.base.center.report.annotations.EsRange;
import com.yunxi.dg.base.center.report.annotations.EsWildcard;
import com.yunxi.dg.base.center.report.dto.es.base.BaseEsDto;
import com.yunxi.dg.base.center.report.dto.es.base.BaseEsPageDto;
import com.yunxi.dg.base.center.report.dto.item.ShopItemPageSearchReqDto;
import com.yunxi.dg.base.commons.dto.SortDto;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.assertj.core.util.Lists;

public class EsBuildJsonQueryHelper {
    private static final String KEYWORD = ".keyword";

    public static String buildQueryJsonPage(BaseEsPageDto basePageDto) throws Exception {
        String msg = EsBuildJsonQueryHelper.getExtractObjStr(basePageDto);
        String sorts = EsBuildJsonQueryHelper.getSorts((BaseEsDto)basePageDto);
        int currentPage = (basePageDto.getPageNum() > 0 ? basePageDto.getPageNum() - 1 : 0) * basePageDto.getPageSize();
        String json = String.format("{\"from\":%s,\"size\":%s,\"query\":{ \"bool\":{\"must\":[%s]} } %s }", currentPage, basePageDto.getPageSize(), msg, sorts);
        return json;
    }

    public static String buildQueryJson(BaseEsDto basePageDto) throws Exception {
        String msg = EsBuildJsonQueryHelper.getExtractObjStr(basePageDto);
        String sorts = EsBuildJsonQueryHelper.getSorts(basePageDto);
        String json = String.format("{\"query\":{ \"bool\":{\"must\":[%s]} } %s }", msg, sorts);
        return json;
    }

    private static String getSorts(BaseEsDto baseEsDto) {
        if (CollectionUtil.isEmpty((Collection)baseEsDto.getSorts())) {
            return "";
        }
        StringBuffer msgStr = new StringBuffer();
        for (SortDto sort : baseEsDto.getSorts()) {
            msgStr.append(String.format("{\"%s\":{\"order\":\"%s\"}}", sort.getField(), sort.getDirection())).append(",");
        }
        msgStr.deleteCharAt(msgStr.length() - 1);
        return String.format(",\"sort\":[%s]", msgStr.toString());
    }

    private static String getEsRange(Field declaredField, Object obj) throws IllegalAccessException {
        EsRange annotation = declaredField.getAnnotation(EsRange.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        Object val = declaredField.get(obj);
        if (Objects.isNull(val)) {
            return "";
        }
        if (!(val instanceof List)) {
            return "";
        }
        List list = (List)val;
        int i = 0;
        HashMap map = new HashMap();
        for (EsOptionType esOptionType : annotation.type()) {
            map.put(esOptionType.name().toLowerCase(), list.get(i));
            ++i;
        }
        boolean isNested = annotation.docType().equals((Object)EsDocTypeEnum.NESTED);
        if (isNested) {
            return EsBuildJsonQueryHelper.buildNestedDsl(annotation.key(), "{\"range\":{\"%s\":%s}}", JSONUtil.toJsonStr(map));
        }
        return String.format("{\"range\":{\"%s\":%s}}", annotation.key(), JSON.toJSONString(map));
    }

    private static String getExtractObj(Object object) throws IllegalAccessException {
        String msg = EsBuildJsonQueryHelper.getExtractObjStr(object);
        if (StrUtil.isBlank((CharSequence)msg)) {
            return "";
        }
        return String.format(" { \"bool\": {\"must\":[%s]}}", msg);
    }

    private static String getExtractObjStr(Object object) throws IllegalAccessException {
        StringBuffer msg = new StringBuffer();
        for (Field declaredMethod : object.getClass().getDeclaredFields()) {
            String esNotIn;
            String esRange;
            String esConditions;
            String esWildcard;
            String esEqual;
            declaredMethod.setAccessible(true);
            String esIn = EsBuildJsonQueryHelper.getEsIn(declaredMethod, object);
            if (StrUtil.isNotBlank((CharSequence)esIn)) {
                msg.append(esIn).append(",");
            }
            if (StrUtil.isNotBlank((CharSequence)(esEqual = EsBuildJsonQueryHelper.getEsEqual(declaredMethod, object)))) {
                msg.append(esEqual).append(",");
            }
            if (StrUtil.isNotBlank((CharSequence)(esWildcard = EsBuildJsonQueryHelper.getEsWildcard(declaredMethod, object)))) {
                msg.append(esWildcard).append(",");
            }
            if (StrUtil.isNotBlank((CharSequence)(esConditions = EsBuildJsonQueryHelper.getEsConditions(declaredMethod, object)))) {
                msg.append(esConditions).append(",");
            }
            if (StrUtil.isNotBlank((CharSequence)(esRange = EsBuildJsonQueryHelper.getEsRange(declaredMethod, object)))) {
                msg.append(esRange).append(",");
            }
            if (!StrUtil.isNotBlank((CharSequence)(esNotIn = EsBuildJsonQueryHelper.getEsNotIn(declaredMethod, object)))) continue;
            msg.append(esNotIn).append(",");
        }
        msg.deleteCharAt(msg.length() - 1);
        return msg.toString();
    }

    private static String getEsConditions(Field declaredField, Object obj) throws IllegalAccessException {
        EsConditions annotation = declaredField.getAnnotation(EsConditions.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        List list = (List)declaredField.get(obj);
        if (Objects.isNull(list)) {
            return "";
        }
        if (annotation.optionType().equals((Object)EsOptionType.OR)) {
            StringBuffer msgStr = new StringBuffer();
            for (Object o : list) {
                String msg = EsBuildJsonQueryHelper.getExtractObj(o);
                msgStr.append(msg).append(",");
            }
            msgStr.deleteCharAt(msgStr.length() - 1);
            return String.format("{\"bool\":{\"should\":[%s]}}", msgStr);
        }
        return null;
    }

    private static String getEsWildcard(Field declaredField, Object obj) throws IllegalAccessException {
        EsWildcard annotation = declaredField.getAnnotation(EsWildcard.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        Object valObj = declaredField.get(obj);
        if (Objects.isNull(valObj)) {
            return "";
        }
        StringBuffer str = new StringBuffer();
        int i = 0;
        boolean isNested = annotation.docType().equals((Object)EsDocTypeEnum.NESTED);
        for (String key : annotation.keys()) {
            String json;
            if (valObj instanceof List) {
                json = String.format(" {\"wildcard\": {\"%s\": \"*%s*\" } }", key, ((List)valObj).get(i));
                if (isNested) {
                    json = EsBuildJsonQueryHelper.buildNestedDsl(key, " {\"wildcard\": {\"%s\": \"*%s*\" } }", ((List)valObj).get(i));
                }
                str.append(json).append(",");
                ++i;
                continue;
            }
            json = String.format(" {\"wildcard\": {\"%s\": \"*%s*\" } }", key, valObj);
            if (isNested) {
                json = EsBuildJsonQueryHelper.buildNestedDsl(key, " {\"wildcard\": {\"%s\": \"*%s*\" } }", valObj);
            }
            str.append(json).append(",");
        }
        str.deleteCharAt(str.length() - 1);
        return String.format("{ \"bool\": {\"should\": [%s]}}", str.toString());
    }

    private static String getEsIn(Field declaredField, Object obj) throws IllegalAccessException {
        EsIn annotation = declaredField.getAnnotation(EsIn.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        Object o = declaredField.get(obj);
        if (Objects.isNull(o)) {
            return "";
        }
        String key = annotation.key();
        boolean isNested = annotation.docType().equals((Object)EsDocTypeEnum.NESTED);
        if (o instanceof List) {
            if (isNested) {
                return EsBuildJsonQueryHelper.buildNestedDsl(key, "{\"terms\":{\"%s\":%s}}", JSONUtil.toJsonStr((Object)o));
            }
            return String.format("{\"terms\": { \"%s\":%s } }", key, JSONUtil.toJsonStr((Object)o));
        }
        return "";
    }

    private static String getEsEqual(Field declaredField, Object obj) throws IllegalAccessException {
        EsEqual annotation = declaredField.getAnnotation(EsEqual.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        Object o = declaredField.get(obj);
        if (Objects.isNull(o)) {
            return "";
        }
        String key = annotation.key();
        boolean isNested = annotation.docType().equals((Object)EsDocTypeEnum.NESTED);
        if (isNested) {
            return EsBuildJsonQueryHelper.buildNestedDsl(key, "{\"term\":{\"%s\":%s}}", o);
        }
        return String.format("{\"term\": { \"%s\": \"%s\" } }", key, o);
    }

    private static String getEsNotIn(Field declaredField, Object obj) throws IllegalAccessException {
        EsNotIn annotation = declaredField.getAnnotation(EsNotIn.class);
        if (Objects.isNull(annotation)) {
            return "";
        }
        Object o = declaredField.get(obj);
        if (Objects.isNull(o)) {
            return "";
        }
        String key = annotation.key();
        boolean isNested = annotation.docType().equals((Object)EsDocTypeEnum.NESTED);
        if (o instanceof List) {
            List list = (List)o;
            if (isNested) {
                return String.format("{\"bool\": {\"must_not\":%s}} ", EsBuildJsonQueryHelper.buildNestedDsl(key, "{\"terms\":{\"%s\":%s}}", JSONUtil.toJsonStr((Object)list)));
            }
            return String.format("{\"bool\": {\"must_not\":{\"terms\":{\"%s\":%s}}}} ", key, JSONUtil.toJsonStr((Object)list));
        }
        return "";
    }

    private static String buildNestedDsl(String key, String dsl, Object value) {
        String nestedKey = key.replace(KEYWORD, "");
        String[] keys = nestedKey.split("\\.");
        if (keys.length <= 1) {
            return String.format(dsl, key, value);
        }
        String nestedDsl = "{\"nested\": {\"path\": \"%s\",\"query\": %s}}";
        String joinJson = "";
        for (int i = keys.length - 1; i > 0; --i) {
            joinJson = keys.length == i + 1 ? String.format(nestedDsl, nestedKey.substring(0, nestedKey.indexOf(keys[i]) - 1), String.format(dsl, key, value.toString())) : String.format(nestedDsl, nestedKey.substring(0, nestedKey.indexOf(keys[i]) - 1), joinJson);
        }
        return joinJson;
    }

    public static void main(String[] args) throws Exception {
        ShopItemPageSearchReqDto reqDto = new ShopItemPageSearchReqDto();
        reqDto.setShopId(Long.valueOf(100L));
        reqDto.setItemAttribute(Integer.valueOf(1));
        reqDto.setSkuShelfStatus(Integer.valueOf(1));
        reqDto.setSkuIdList((List)Lists.newArrayList((Object[])new Long[]{2L, 4L, 5L}));
        reqDto.setKeyword("\u54c8\u54c8\u54c8");
        System.out.println(EsBuildJsonQueryHelper.buildQueryJsonPage((BaseEsPageDto)reqDto));
    }
}

