/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.share.service.calc.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.lock.api.Mutex;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.item.ItemSkuDto;
import com.yunxi.dg.base.center.share.dto.calc.PreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.ReleasePreemptDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.CalcInventoryDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDetailDto;
import com.yunxi.dg.base.center.share.dto.calc.base.OperationDto;
import com.yunxi.dg.base.center.share.enums.VirtualWarehouseTypeEnum;
import com.yunxi.dg.base.center.share.enums.WarehouseClassifyEnum;
import com.yunxi.dg.base.center.share.eo.ChannelInventoryEo;
import com.yunxi.dg.base.center.share.eo.ChannelWarehouseEo;
import com.yunxi.dg.base.center.share.eo.InventoryPreemptionEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedEo;
import com.yunxi.dg.base.center.share.eo.InventorySharedWarehouseEo;
import com.yunxi.dg.base.center.share.eo.VirtualInventoryEo;
import com.yunxi.dg.base.center.share.eo.VirtualWarehouseEo;
import com.yunxi.dg.base.center.share.exception.WarehouseAbleException;
import com.yunxi.dg.base.center.share.service.calc.IVirtualPreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.ReleasePreemptAble;
import com.yunxi.dg.base.center.share.service.calc.impl.WarehouseCommonAble;
import com.yunxi.dg.base.commons.enums.EnableDisableEnum;
import com.yunxi.dg.base.commons.helper.YesNoHelper;
import com.yunxi.dg.base.commons.utils.LogUtils;
import com.yunxi.dg.base.commons.utils.decimal.BigDecimalUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class VirtualPreemptAble
extends WarehouseCommonAble
implements IVirtualPreemptAble {
    private static final Logger log = LoggerFactory.getLogger(VirtualPreemptAble.class);
    @Autowired
    ReleasePreemptAble releasePreemptAble;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void preempt(PreemptDto dto) {
        log.info("ShVirtualPreemptAble:preempt ==> dto:{}", (Object)LogUtils.buildLogContent((Object)dto));
        this.checkParam((OperationDto)dto);
        this.checkParamDetails((OperationDto)dto);
        List<InventoryPreemptionEo> channelPreemptionEos = this.queryPreemptEos(Lists.newArrayList((Object[])new String[]{dto.getSourceNo()}), WarehouseClassifyEnum.CHANNEL.getCode());
        if (CollectionUtils.isEmpty(channelPreemptionEos)) {
            log.info("\u6e20\u9053\u4ed3\u6ca1\u6709\u9884\u5360\u8bb0\u5f55\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360");
            throw new WarehouseAbleException("\u6e20\u9053\u4ed3\u6ca1\u6709\u9884\u5360\u8bb0\u5f55\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360", new Object[0]);
        }
        String channelWarehouseCode = channelPreemptionEos.get(0).getWarehouseCode();
        List<VirtualWarehouseEo> virtualWarehouseEos = this.queryVirtualWarehouseByChannelWarehouseCode(Lists.newArrayList((Object[])new String[]{channelWarehouseCode}));
        if (CollectionUtils.isEmpty(virtualWarehouseEos)) {
            log.info("\u6e20\u9053\u4ed3\u627e\u4e0d\u5230\u4f9b\u8d27\u5173\u7cfb\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360");
            return;
        }
        List virtualWarehouseCodes = virtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List inventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"virtual_warehouse_code", virtualWarehouseCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedEos)) {
            log.info("\u6e20\u9053\u4ed3\u5173\u8054\u4f9b\u8d27\u4ed3\u627e\u4e0d\u5230\u6709\u6548\u4f9b\u8d27\u7b56\u7565\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360");
            return;
        }
        Set shareCodes = inventorySharedEos.stream().map(InventorySharedEo::getSharedCode).collect(Collectors.toSet());
        List inventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", shareCodes)).eq((Object)"status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isEmpty((Collection)inventorySharedWarehouseEos)) {
            log.info("\u4f9b\u8d27\u7b56\u7565\u627e\u4e0d\u5230\u5173\u8054\u903b\u8f91\u4ed3\u8bb0\u5f55\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360");
            return;
        }
        Set shareLogicWarehouseCodes = inventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        String logLogicWarehouseCode = ((OperationDetailDto)dto.getDetails().get(0)).getWarehouseCode();
        log.info("\u6e20\u9053\u5185\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}", shareLogicWarehouseCodes);
        log.info("\u4e0a\u62a5\u903b\u8f91\u4ed3\u7f16\u7801\uff1a{}", (Object)logLogicWarehouseCode);
        boolean isAcrossChannel = !shareLogicWarehouseCodes.contains(logLogicWarehouseCode);
        log.info("\u662f\u5426\u8de8\u6e20\u9053\u9884\u5360 : {}", (Object)isAcrossChannel);
        List logInventorySharedWarehouseEos = this.inventorySharedWarehouseDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)logLogicWarehouseCode)).eq((Object)"status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        log.info("\u67e5\u8be2\u4e0a\u62a5\u903b\u8f91\u4ed3\u4f9b\u8d27\u5173\u7cfb\uff1a{}", (Object)LogUtils.buildLogContent((Collection)logInventorySharedWarehouseEos));
        if (isAcrossChannel) {
            log.info("\u8fdb\u5165\u8de8\u6e20\u9053\u4e1a\u52a1\u5904\u7406...............");
            if (CollectionUtils.isEmpty((Collection)logInventorySharedWarehouseEos)) {
                log.info("\u8de8\u6e20\u9053\u4e1a\u52a1\u5904\u7406\uff0c\u903b\u8f91\u4ed3\u627e\u4e0d\u5230\u5bf9\u5e94\u4f9b\u8d27\u7b56\u7565\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360\uff0c\u91ca\u653e\u539f\u6e20\u9053\u4ed3\uff0c\u4f9b\u8d27\u4ed3\u9884\u5360");
                ReleasePreemptDto releasePreemptDto = new ReleasePreemptDto();
                releasePreemptDto.setSourceNo(dto.getSourceNo());
                releasePreemptDto.setSourceType(dto.getSourceType());
                releasePreemptDto.setExternalOrderNo(dto.getExternalOrderNo());
                releasePreemptDto.setIsErrorForNotFoundPreempt(Boolean.valueOf(false));
                this.releasePreemptAble.releasePreempt(releasePreemptDto);
                return;
            }
        }
        HashSet allCargoCodes = Sets.newHashSet();
        HashSet allVirtualWarehouseCodes = Sets.newHashSet();
        List virtualPreemptionEos = this.queryPreemptEos(Lists.newArrayList((Object[])new String[]{dto.getSourceNo()}), WarehouseClassifyEnum.VIRTUAL.getCode());
        List releaseVirtualWarehouseCodes = virtualPreemptionEos.stream().map(InventoryPreemptionEo::getWarehouseCode).distinct().collect(Collectors.toList());
        List releaseCargoCodes = virtualPreemptionEos.stream().map(InventoryPreemptionEo::getSkuCode).distinct().collect(Collectors.toList());
        allCargoCodes.addAll(releaseCargoCodes);
        allVirtualWarehouseCodes.addAll(releaseVirtualWarehouseCodes);
        List logicShareCodes = logInventorySharedWarehouseEos.stream().map(InventorySharedWarehouseEo::getSharedCode).distinct().collect(Collectors.toList());
        List logicInventorySharedEos = this.inventorySharedDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().in((Object)"shared_code", logicShareCodes)).eq((Object)"shared_status", (Object)EnableDisableEnum.ENABLE.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        List<String> logicToVirtualWarehouseCodes = logicInventorySharedEos.stream().map(InventorySharedEo::getVirtualWarehouseCode).distinct().collect(Collectors.toList());
        List<VirtualWarehouseEo> logicToVirtualWarehouseEos = this.queryEnableVirtualWarehouseByCodes(logicToVirtualWarehouseCodes);
        List logicVirtualGroupIds = logicToVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getGroupId).distinct().collect(Collectors.toList());
        List logicVirtualGroupWarehouseEos = this.virtualWarehouseDomain.getMapper().selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(VirtualWarehouseEo.class).in(VirtualWarehouseEo::getGroupId, logicVirtualGroupIds)).eq(VirtualWarehouseEo::getWarehouseStatus, (Object)EnableDisableEnum.ENABLE.getCode())).eq(BaseEo::getDr, (Object)YesNoHelper.NO));
        List logicVirtualGroupWarehouseCodes = logicVirtualGroupWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).distinct().collect(Collectors.toList());
        allVirtualWarehouseCodes.addAll(logicVirtualGroupWarehouseCodes);
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(Lists.newArrayList((Iterable)allVirtualWarehouseCodes));
        List<Object> channelWarehouseEos = Lists.newArrayList();
        for (Map.Entry<String, List<ChannelWarehouseEo>> entry : virtualToChannelMap.entrySet()) {
            channelWarehouseEos.addAll((Collection)entry.getValue());
        }
        channelWarehouseEos = channelWarehouseEos.stream().distinct().collect(Collectors.toList());
        virtualWarehouseEos = this.queryEnableVirtualWarehouseByCodes(Lists.newArrayList((Iterable)allVirtualWarehouseCodes));
        List<ItemSkuDto> skuDtoList = this.queryItemSkuListByCodes(Lists.newArrayList((Iterable)allCargoCodes));
        List<VirtualInventoryEo> virtualInventoryEos = this.queryVirtualInventoryEos(skuDtoList, virtualWarehouseEos);
        List<ChannelInventoryEo> channelInventoryEos = this.queryChannelInventoryEos(skuDtoList, channelWarehouseEos);
        ArrayList calcVirtualInventoryEos = Lists.newArrayList();
        ArrayList calcChannelInventoryEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)calcVirtualInventoryEos, virtualInventoryEos, VirtualInventoryEo.class);
        CubeBeanUtils.copyCollection((Collection)calcChannelInventoryEos, channelInventoryEos, ChannelInventoryEo.class);
        ArrayList virtualCalcDtoList = Lists.newArrayList();
        ArrayList channelCalcDtoList = Lists.newArrayList();
        if (virtualWarehouseEos.size() > 1 || isAcrossChannel) {
            log.info("\u8fdb\u5165\u91ca\u653e\u539f\u4f9b\u8d27\u4ed3\u5e93\u5b58\u4e1a\u52a1...............");
            CalcInventoryDto releaseVirtualInventoryDto = this.releaseVirtualInventory(dto, virtualInventoryEos, virtualPreemptionEos);
            if (null == releaseVirtualInventoryDto) {
                log.info("\u4f9b\u8d27\u4ed3\u8ba1\u7b97\u5bf9\u8c61\u4e3a\u7a7a");
                return;
            }
            releaseVirtualInventoryDto.setValidNegative(Boolean.valueOf(false));
            virtualCalcDtoList.add(releaseVirtualInventoryDto);
            CalcInventoryDto releaseOtherChannelCalcDto = this.getCalcOtherChannelDto(releaseVirtualInventoryDto, channelWarehouseCode, isAcrossChannel);
            channelCalcDtoList.add(releaseOtherChannelCalcDto);
        }
        log.info("\u901a\u8fc7\u903b\u8f91\u4ed31\uff1a{}, \u67e5\u8be2\u5173\u8054\u7684\u4f9b\u8d27\u4ed3\u96c6\u5408\uff1a{}", (Object)logLogicWarehouseCode, (Object)LogUtils.buildLogContent((Collection)logicVirtualGroupWarehouseEos));
        ArrayList searchVirtualWarehouseEos = Lists.newArrayList((Iterable)logicVirtualGroupWarehouseEos);
        if (!isAcrossChannel) {
            searchVirtualWarehouseEos.removeIf(o -> !virtualWarehouseCodes.contains(o.getWarehouseCode()));
            log.info("\u901a\u8fc7\u903b\u8f91\u4ed32\uff1a{}, \u67e5\u8be2\u4e0e\u6e20\u9053\u4ed3\u5173\u8054\u7684\u4f9b\u8d27\u4ed3\u4ea4\u96c6\uff1a{}", (Object)logLogicWarehouseCode, (Object)LogUtils.buildLogContent((Collection)searchVirtualWarehouseEos));
            if (CollectionUtils.isEmpty((Collection)searchVirtualWarehouseEos)) {
                log.info("\u67e5\u8be2\u4e0e\u6e20\u9053\u4ed3\u5173\u8054\u7684\u4f9b\u8d27\u4ed3\u4ea4\u96c6\u4e3a\u7a7a");
                return;
            }
        }
        Set searchWarehouseCodes = searchVirtualWarehouseEos.stream().map(VirtualWarehouseEo::getWarehouseCode).collect(Collectors.toSet());
        virtualPreemptionEos = this.inventoryPreemptionDomain.getMapper().selectList((Wrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"source_no", (Object)dto.getSourceNo())).eq((Object)"valid", (Object)EnableDisableEnum.ENABLE.getCode())).in((Object)"warehouse_code", searchWarehouseCodes)).eq((Object)"warehouse_classify", (Object)WarehouseClassifyEnum.VIRTUAL.getCode())).eq((Object)"dr", (Object)YesNoHelper.NO));
        if (CollectionUtils.isNotEmpty((Collection)virtualPreemptionEos)) {
            log.info("\u5df2\u5b58\u5728\u76f8\u5173\u4f9b\u8d27\u4ed3\u6709\u6548\u9884\u5360\u8bb0\u5f55\uff0c\u4e2d\u6b62\u4f9b\u8d27\u4ed3\u9884\u5360");
            return;
        }
        CalcInventoryDto preemptCalcVirtualDto = this.doPreempt(dto, searchVirtualWarehouseEos, skuDtoList, virtualInventoryEos);
        preemptCalcVirtualDto.setValidNegative(Boolean.valueOf(false));
        virtualCalcDtoList.add(preemptCalcVirtualDto);
        CalcInventoryDto preemptOtherChannelCalcDto = this.getCalcOtherChannelDto(preemptCalcVirtualDto, channelWarehouseCode, false);
        preemptOtherChannelCalcDto.setValidNegative(Boolean.valueOf(false));
        channelCalcDtoList.add(preemptOtherChannelCalcDto);
        this.calcAble.calcBatchChannelAndOtherChannel(Lists.newArrayList(), channelCalcDtoList, calcChannelInventoryEos);
        this.calcAble.calcBatchVirtual(virtualCalcDtoList, calcVirtualInventoryEos);
    }

    private CalcInventoryDto doPreempt(PreemptDto dto, List<VirtualWarehouseEo> searchVirtualWarehouseEos, List<ItemSkuDto> skuDtoList, List<VirtualInventoryEo> virtualInventoryEos) {
        ArrayList virtualCalcDetailDtoList = Lists.newArrayList();
        searchVirtualWarehouseEos = searchVirtualWarehouseEos.stream().sorted(Comparator.comparing(VirtualWarehouseEo::getWarehouseType).reversed()).collect(Collectors.toList());
        Map<Long, List<VirtualWarehouseEo>> virtualGroupMap = searchVirtualWarehouseEos.stream().collect(Collectors.groupingBy(VirtualWarehouseEo::getGroupId));
        List detailParams = dto.getDetails().stream().sorted(Comparator.comparing(OperationDetailDto::getSkuCode)).collect(Collectors.toList());
        for (OperationDetailDto detail : detailParams) {
            VirtualInventoryEo virtualInventoryEo;
            BigDecimal searchNum = detail.getNum();
            if (BigDecimalUtils.leZero((BigDecimal)searchNum).booleanValue()) continue;
            String searchSkuCode = detail.getSkuCode();
            for (Map.Entry<Long, List<VirtualWarehouseEo>> virtualGroupEntry : virtualGroupMap.entrySet()) {
                List virtualWarehouseEos = virtualGroupEntry.getValue().stream().sorted(Comparator.comparing(VirtualWarehouseEo::getWarehouseCode)).collect(Collectors.toList());
                Iterator iterator = virtualWarehouseEos.iterator();
                while (iterator.hasNext()) {
                    CalcInventoryDetailDto virtualCalcDetail;
                    VirtualWarehouseEo virtualWarehouseEo = (VirtualWarehouseEo)iterator.next();
                    VirtualInventoryEo virtualInventoryEo2 = virtualInventoryEos.stream().filter(o -> StringUtils.equals((CharSequence)virtualWarehouseEo.getWarehouseCode(), (CharSequence)o.getWarehouseCode()) && StringUtils.equals((CharSequence)searchSkuCode, (CharSequence)o.getSkuCode())).findFirst().orElse(null);
                    if (null == virtualInventoryEo2 || BigDecimalUtils.leZero((BigDecimal)virtualInventoryEo2.getAvailable()).booleanValue()) continue;
                    if (BigDecimalUtils.le((BigDecimal)searchNum, (BigDecimal)virtualInventoryEo2.getAvailable()).booleanValue()) {
                        virtualCalcDetail = new CalcInventoryDetailDto();
                        virtualCalcDetail.setInventoryId(virtualInventoryEo2.getId());
                        virtualCalcDetail.setChangePreempt(searchNum);
                        virtualCalcDetail.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)searchNum));
                        virtualCalcDetail.setSkuCode(virtualInventoryEo2.getSkuCode());
                        virtualCalcDetail.setWarehouseCode(virtualInventoryEo2.getWarehouseCode());
                        virtualCalcDetail.setOperate("\u9884\u5360");
                        virtualCalcDetailDtoList.add(virtualCalcDetail);
                        searchNum = BigDecimal.ZERO;
                        break;
                    }
                    virtualCalcDetail = new CalcInventoryDetailDto();
                    searchNum = BigDecimalUtils.subtract((BigDecimal)searchNum, (BigDecimal)virtualInventoryEo2.getAvailable());
                    virtualCalcDetail.setInventoryId(virtualInventoryEo2.getId());
                    virtualCalcDetail.setChangePreempt(virtualInventoryEo2.getAvailable());
                    virtualCalcDetail.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)virtualInventoryEo2.getAvailable()));
                    virtualCalcDetail.setSkuCode(virtualInventoryEo2.getSkuCode());
                    virtualCalcDetail.setWarehouseCode(virtualInventoryEo2.getWarehouseCode());
                    virtualCalcDetail.setOperate("\u9884\u5360");
                    virtualCalcDetailDtoList.add(virtualCalcDetail);
                }
                if (!BigDecimalUtils.eqZero((BigDecimal)searchNum).booleanValue()) continue;
                break;
            }
            if (!BigDecimalUtils.gtZero((BigDecimal)searchNum).booleanValue()) continue;
            log.info("\u8fdb\u5165\u53cd\u5411\u9884\u5360\u4f9b\u8d27\u4ed3\u5f3a\u5360\u903b\u8f91: {}, {}", (Object)searchSkuCode, (Object)searchNum);
            VirtualWarehouseEo virtualWarehouseEo = searchVirtualWarehouseEos.stream().filter(o -> Objects.equals(o.getWarehouseType(), VirtualWarehouseTypeEnum.OVERALL.getCode())).findFirst().orElse(null);
            if (null == virtualWarehouseEo) continue;
            boolean isExist = false;
            for (CalcInventoryDetailDto virtualCalcDetailDto : virtualCalcDetailDtoList) {
                if (!StringUtils.equals((CharSequence)virtualCalcDetailDto.getWarehouseCode(), (CharSequence)virtualWarehouseEo.getWarehouseCode()) || !StringUtils.equals((CharSequence)virtualCalcDetailDto.getSkuCode(), (CharSequence)searchSkuCode)) continue;
                virtualCalcDetailDto.setChangePreempt(BigDecimalUtils.add((BigDecimal)virtualCalcDetailDto.getChangePreempt(), (BigDecimal)searchNum));
                virtualCalcDetailDto.setChangeAvailable(BigDecimalUtils.add((BigDecimal)virtualCalcDetailDto.getChangeAvailable(), (BigDecimal)BigDecimalUtils.negate((BigDecimal)searchNum)));
                isExist = true;
                break;
            }
            if (isExist || null == (virtualInventoryEo = (VirtualInventoryEo)this.virtualInventoryDomain.getMapper().selectOne((Wrapper)((QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"warehouse_code", (Object)virtualWarehouseEo.getWarehouseCode())).eq((Object)"sku_code", (Object)searchSkuCode)).eq((Object)"dr", (Object)YesNoHelper.NO)))) continue;
            CalcInventoryDetailDto virtualCalcDetail = new CalcInventoryDetailDto();
            virtualCalcDetail.setInventoryId(virtualInventoryEo.getId());
            virtualCalcDetail.setChangePreempt(searchNum);
            virtualCalcDetail.setChangeAvailable(BigDecimalUtils.negate((BigDecimal)searchNum));
            virtualCalcDetail.setSkuCode(virtualInventoryEo.getSkuCode());
            virtualCalcDetail.setWarehouseCode(virtualInventoryEo.getWarehouseCode());
            virtualCalcDetail.setOperate("\u9884\u5360");
            virtualCalcDetailDtoList.add(virtualCalcDetail);
        }
        CalcInventoryDto preemptVirtualCalc = new CalcInventoryDto();
        preemptVirtualCalc.setSourceNo(dto.getSourceNo());
        preemptVirtualCalc.setExternalOrderNo(dto.getExternalOrderNo());
        preemptVirtualCalc.setSourceType(dto.getSourceType());
        preemptVirtualCalc.setType("virtual");
        preemptVirtualCalc.setDetails((List)virtualCalcDetailDtoList);
        List<InventoryPreemptionEo> virtualPreemptEos = this.createVirtualPreemptEos(preemptVirtualCalc, searchVirtualWarehouseEos, skuDtoList, virtualInventoryEos);
        if (CollectionUtils.isNotEmpty(virtualPreemptEos)) {
            this.inventoryPreemptionDomain.insertPreemptList(virtualPreemptEos);
        }
        return preemptVirtualCalc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CalcInventoryDto releaseVirtualInventory(PreemptDto preemptDto, List<VirtualInventoryEo> virtualInventoryEos, List<InventoryPreemptionEo> virtualPreemptionEos) {
        if (StringUtils.isBlank((CharSequence)preemptDto.getExternalOrderNo())) {
            log.info("\u5916\u90e8\u5355\u53f7\u4e0d\u5b58\u5728, \u65e0\u6cd5\u91ca\u653e\u4f9b\u8d27\u4ed3\u9884\u5360");
            return null;
        }
        Mutex mutex = this.lock(preemptDto.getExternalOrderNo());
        try {
            if (CollectionUtils.isEmpty(virtualPreemptionEos)) {
                log.info("\u539f\u6e20\u9053\u6ca1\u6709\u4f9b\u8d27\u4ed3\u9884\u5360\u8bb0\u5f55~");
                CalcInventoryDto calcInventoryDto = null;
                return calcInventoryDto;
            }
            CalcInventoryDto calcInventoryDto = new CalcInventoryDto();
            calcInventoryDto.setSourceNo(preemptDto.getSourceNo());
            calcInventoryDto.setExternalOrderNo(preemptDto.getExternalOrderNo());
            calcInventoryDto.setSourceType(preemptDto.getSourceType());
            calcInventoryDto.setType("virtual");
            calcInventoryDto.setRemark(preemptDto.getRemark());
            ArrayList details = Lists.newArrayList();
            Map virtualInventoryEoMap = virtualInventoryEos.stream().collect(Collectors.toMap(BaseEo::getId, Function.identity()));
            for (InventoryPreemptionEo preemptionEo : virtualPreemptionEos) {
                VirtualInventoryEo virtualInventoryEo = (VirtualInventoryEo)virtualInventoryEoMap.get(preemptionEo.getInventoryId());
                CalcInventoryDetailDto calcInventoryDetailDto = new CalcInventoryDetailDto();
                calcInventoryDetailDto.setInventoryId(preemptionEo.getInventoryId());
                calcInventoryDetailDto.setChangePreempt(BigDecimalUtils.negate((BigDecimal)preemptionEo.getPreemptNum()));
                calcInventoryDetailDto.setChangeAvailable(preemptionEo.getPreemptNum());
                calcInventoryDetailDto.setWarehouseCode(preemptionEo.getWarehouseCode());
                calcInventoryDetailDto.setSkuCode(preemptionEo.getSkuCode());
                calcInventoryDetailDto.setOperate("\u91ca\u653e\u9884\u5360");
                virtualInventoryEo.setAvailable(BigDecimalUtils.add((BigDecimal)virtualInventoryEo.getAvailable(), (BigDecimal)calcInventoryDetailDto.getChangeAvailable()));
                details.add(calcInventoryDetailDto);
            }
            calcInventoryDto.setDetails((List)details);
            this.updateInventoryPreemptionValidBatch(EnableDisableEnum.DISABLE.getCode(), virtualPreemptionEos);
            CalcInventoryDto calcInventoryDto2 = calcInventoryDto;
            return calcInventoryDto2;
        }
        finally {
            this.unlock(mutex);
        }
    }

    private CalcInventoryDto getCalcOtherChannelDto(CalcInventoryDto virtualCalcDto, String channelWarehouseCode, Boolean isAcrossChannel) {
        List<String> preemptVirtualWarehouseCodes = virtualCalcDto.getDetails().stream().map(CalcInventoryDetailDto::getWarehouseCode).distinct().collect(Collectors.toList());
        Map<String, List<ChannelWarehouseEo>> virtualToChannelMap = this.queryChannelWarehouseByVirtualWarehouseCodes(preemptVirtualWarehouseCodes);
        if (!isAcrossChannel.booleanValue()) {
            for (List<ChannelWarehouseEo> channelWarehouseEoList : virtualToChannelMap.values()) {
                channelWarehouseEoList.removeIf(o -> StringUtils.equals((CharSequence)o.getWarehouseCode(), (CharSequence)channelWarehouseCode));
            }
        }
        return this.createOtherChannelCalcDto(virtualToChannelMap, virtualCalcDto, null);
    }
}

