/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.dao.das.impl;

import com.alibaba.druid.util.StringUtils;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.dao.das.IOrderDas;
import com.yunxi.dg.base.center.trade.dao.mapper.OrderMapper;
import com.yunxi.dg.base.center.trade.eo.OrderEo;
import com.yunxi.dg.base.center.trade.eo.TradeItemEo;
import com.yunxi.dg.base.center.trade.vo.OrderQueryVo;
import com.yunxi.dg.base.center.trade.vo.OrderStatisticsEo;
import com.yunxi.dg.base.center.trade.vo.OrderStatisticsVo;
import com.yunxi.dg.base.center.trade.vo.OrderStatusCountVo;
import com.yunxi.dg.base.framework.core.db.das.AbstractDas;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Repository;

@Repository
public class OrderDasImpl
extends AbstractDas<OrderEo, Long>
implements IOrderDas {
    @Resource
    private OrderMapper mapper;

    public OrderMapper getMapper() {
        return this.mapper;
    }

    @Override
    public OrderEo lockByOrderNo(String orderNo) {
        if (StringUtils.isEmpty((CharSequence)orderNo)) {
            throw new BizException("\u8ba2\u5355\u53f7\u4e0d\u80fd\u7a7a");
        }
        if (!StringUtils.isEmpty((CharSequence)orderNo)) {
            return this.mapper.lockByOrderNo(orderNo);
        }
        return null;
    }

    @Override
    public OrderEo findByOrderNo(String orderNo) {
        OrderEo selectParam = new OrderEo();
        selectParam.setOrderNo(orderNo);
        List list = this.getMapper().findList((BaseEo)selectParam);
        return CollectionUtils.isEmpty((Collection)list) ? null : (OrderEo)list.get(0);
    }

    @Override
    public List<OrderStatusCountVo> countOrderByStatus(OrderQueryVo orderQueryVo) {
        return this.mapper.countOrderByStatus(orderQueryVo);
    }

    @Override
    public List<OrderStatusCountVo> countOrderByStatusTob(OrderQueryVo orderQueryVo) {
        return this.mapper.countOrderByStatusTob(orderQueryVo);
    }

    @Override
    public OrderStatusCountVo countAfterSalesTob(OrderQueryVo orderQueryVo) {
        return this.mapper.countAfterSalesTob(orderQueryVo);
    }

    @Override
    public int countRefererIdOrderNum(OrderQueryVo orderEo) {
        OrderEo orderEo1 = this.mapper.countRefererIdOrderNum(orderEo);
        if (orderEo1 != null) {
            return orderEo1.getTotalItemNum();
        }
        return 0;
    }

    @Override
    public List<TradeItemEo> countItem(OrderQueryVo orderQueryVo) {
        return this.mapper.countItem(orderQueryVo);
    }

    @Override
    public BigDecimal sumPayAmount(OrderQueryVo orderEo) {
        OrderEo orderEo1 = this.mapper.sumPayAmount(orderEo);
        if (orderEo1 != null) {
            return orderEo1.getPayAmount();
        }
        return BigDecimal.ZERO;
    }

    @Override
    public Set<OrderEo> queryRefererIdNoReply(OrderQueryVo orderEo) {
        return this.mapper.queryRefererIdNoReply(orderEo);
    }

    @Override
    public Date getFirstPlaceOrderByCustomerId(Long customerId) {
        return this.mapper.getFirstPlaceOrderByCustomerId(customerId.toString());
    }

    @Override
    public void clearTradeItemBatch(String orderNo) {
        this.mapper.clearTradeItemBatch(orderNo);
    }

    @Override
    public List<OrderStatisticsVo> statisticsOrder(OrderStatisticsEo orderStatisticsEo) {
        return this.mapper.statisticsOrder(orderStatisticsEo);
    }
}

