CREATE TABLE IF NOT EXISTS `ex_example` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `tenant_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '租户id',
  `instance_id` bigint(20) NOT NULL DEFAULT '-1' COMMENT '实例id',
  `create_time` datetime DEFAULT CURRENT_TIMESTAMP COMMENT '创建时间',
  `create_person` varchar(64) NOT NULL DEFAULT '' COMMENT '创建人',
  `update_time` datetime DEFAULT NULL COMMENT '更新时间',
  `update_person` varchar(64) NOT NULL DEFAULT '' COMMENT '更新人',
  `dr` tinyint(4) NOT NULL DEFAULT '0' COMMENT '逻辑删除标记',
  `code` varchar(32) NOT NULL COMMENT '编码',
  `name` varchar(64) NOT NULL DEFAULT '' COMMENT '名称',
  PRIMARY KEY (`id`) USING BTREE,
  KEY `idx_code` (`code`) USING BTREE,
  KEY `idx_name` (`name`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COMMENT='示例表';

insert into ex_example( `id`, `tenant_id`, `instance_id`, `create_time`, `create_person`, `dr`, `code`, `name`) values ( 1234567, -1, -1, '2022-12-14 00:00:00', 'root', 0, 'testcode001', 'testname001' );
