/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.plugin.mq.ICommonsMqService;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.response.SaleOrderRespDto;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.cache.CacheWrapper;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderLevelEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgSaleOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.entity.SaleOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgOutDeliveryResultReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgSaleOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderEo;
import com.yunxi.dg.base.center.trade.utils.DgBeanUtils;
import com.yunxi.dg.base.center.trade.utils.DgNoGreateUtil;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgSaleOrderDomainImpl
extends BaseDomainImpl<DgSaleOrderEo>
implements IDgSaleOrderDomain,
IResetRedisNoIndexCommon {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgSaleOrderDas das;
    @Resource
    private IDgSaleOrderItemDomain saleOrderItemDomain;
    @Resource
    private IDgAfterSaleOrderDomain afterSaleOrderDomain;
    @Resource
    private IDgSaleOrderAddrDomain saleOrderAddrDomain;
    @Resource
    private ICommonsMqService commonsMqService;
    @Resource
    private DgNoGreateUtil dgNoGreateUtil;
    @Resource
    private CacheWrapper cacheWrapper;

    public ICommonDas<DgSaleOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public DgSaleOrderEo createChildOrder(DgSaleOrderEo childOrderEo) {
        childOrderEo.setSaleOrderNo(this.dgNoGreateUtil.generateOrderNo());
        childOrderEo.setOrderLevel(DgSaleOrderLevelEnum.CHILD.getType());
        this.das.insert((BaseEo)childOrderEo);
        this.LOGGER.info("[\u62c6\u5355]\u5b50\u8ba2\u5355({})\u7684\u57fa\u672c\u4fe1\u606f\u4e3a\uff1a{}", (Object)childOrderEo.getSaleOrderNo(), (Object)JSON.toJSONString((Object)childOrderEo));
        return childOrderEo;
    }

    @Override
    public int updateSaleOrderById(Long orderId, DgSaleOrderEo updateEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (this.cacheWrapper != null) {
            this.cacheWrapper.removeCache(orderId);
            this.das.removeCache((Object)orderId);
        }
        updateEo.setId(orderId);
        int updateSelective = this.das.updateSelective((BaseEo)updateEo);
        if (this.cacheWrapper != null) {
            this.cacheWrapper.removeCache(orderId);
            this.das.removeCache((Object)orderId);
        }
        return updateSelective;
    }

    @Override
    public DgSaleOrderEo queryEoById(Long id) {
        DgSaleOrderEo saleOrder = (DgSaleOrderEo)this.das.selectByPrimaryKey(id);
        return saleOrder;
    }

    @Override
    public DgSaleOrderEo queryByEo(DgSaleOrderEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"performOrderInfoEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return saleOrderEo;
    }

    @Override
    public DgSaleOrderEo queryByOrderNo(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getSaleOrderNo, (Object)orderNo);
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return saleOrderEo;
    }

    @Override
    public void modifySaleOrder(SaleOrderDto modifyReqDto) {
        DgSaleOrderEo saleOrderEo = new DgSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)saleOrderEo, (Object)modifyReqDto, (String[])new String[0]);
        this.updateSaleOrderById(saleOrderEo.getId(), saleOrderEo);
    }

    @Override
    public DgPerformOrderRespDto querySaleOrderById(Long id) {
        AssertUtils.notNull((Object)id, (String)"\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgSaleOrderEo saleOrderEo = this.queryEoById(id);
        AssertUtils.notNull((Object)saleOrderEo, (String)"\u9500\u552e\u8ba2\u5355\u4e0d\u5b58\u5728");
        DgPerformOrderRespDto saleOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderRespDto, (Object)saleOrderEo, (String[])new String[0]);
        return saleOrderRespDto;
    }

    @Override
    public int optimisticModifySaleOrder(DgSaleOrderEo saleOrderEo, UpdateWrapper<DgSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        this.LOGGER.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgSaleOrderEo)queryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo, queryWrapper);
        int optCount = this.das.getMapper().update((Object)saleOrderEo, queryWrapper);
        if (this.das.isUseCache()) {
            DgSaleOrderEo entity = (DgSaleOrderEo)queryWrapper.getEntity();
            this.das.removeLogicCache((BaseEo)entity);
            this.das.removeCache((Object)entity.getId());
            this.das.removeCacheByExample((BaseEo)entity);
        }
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    private void popOrderStatusLog(DgSaleOrderEo saleOrderEo, UpdateWrapper<DgSaleOrderEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgSaleOrderEo)updateWrapper.getEntity()).getId());
        DgSaleOrderEo saleOrderDasOne = (DgSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    @Override
    public void sendMsgForDeliveryResult(DgPerformOrderRespDto saleOrderRespDto, DgOmsSaleOrderStatus saleOrderStatus, DgOutDeliveryResultReqDto outDeliveryResultReqDto) {
        AssertUtils.notNull((Object)saleOrderRespDto, (String)"saleOrderRespDto \u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        Integer status = 0;
        switch (saleOrderStatus) {
            case WAIT_DELIVERY: {
                status = 1;
                break;
            }
            case DELIVERY_ALL: {
                status = 3;
                break;
            }
            case COMPLETE: {
                status = 4;
                break;
            }
        }
        HashMap<String, Object> msgMap = new HashMap<String, Object>();
        msgMap.put("orderNo", saleOrderRespDto.getPlatformOrderNo());
        msgMap.put("status", status);
        msgMap.put("consignType", saleOrderRespDto.getConsignType());
        msgMap.put("platformOrderStatus", saleOrderRespDto.getPlatformOrderStatus());
        msgMap.put("platformParentOrderNo", saleOrderRespDto.getPlatformParentOrderNo());
        msgMap.put("orderSourceSystemCode", saleOrderRespDto.getOrderSourceSystemCode());
        msgMap.put("orderSourceSystemName", saleOrderRespDto.getOrderSourceSystemName());
        msgMap.put("orderSource", saleOrderRespDto.getOrderSource());
        if (Objects.nonNull(outDeliveryResultReqDto)) {
            msgMap.put("saleOrderNo", saleOrderRespDto.getSaleOrderNo());
            msgMap.put("saleOrderId", saleOrderRespDto.getId());
            msgMap.put("shipmentEnterpriseCode", outDeliveryResultReqDto.getShipmentEnterpriseCode());
            msgMap.put("shipmentEnterpriseName", outDeliveryResultReqDto.getShipmentEnterpriseName());
            msgMap.put("shippingNo", outDeliveryResultReqDto.getShippingNo());
            msgMap.put("outNoticeOrderNo", outDeliveryResultReqDto.getOutNoticeOrderNo());
            msgMap.put("channelCode", saleOrderRespDto.getPerformOrderSnapshotDto().getChannelCode());
            msgMap.put("shippingInfoList", outDeliveryResultReqDto.getShippingInfoList());
            List<DgSaleOrderItemRespDto> saleOrderItemRespDtos = this.saleOrderItemDomain.queryOrderItemByOrderId(saleOrderRespDto.getId());
            Map itemRespDtoMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(SaleOrderItemDto::getSkuCode, Function.identity(), (v1, v2) -> v2));
            Map orderItemRespDtoMap = saleOrderItemRespDtos.stream().collect(Collectors.toMap(SaleOrderItemDto::getId, Function.identity(), (v1, v2) -> v2));
            ArrayList itemMapList = Lists.newArrayList();
            ((List)Optional.ofNullable(outDeliveryResultReqDto.getDeliveryDetailList()).orElse(new ArrayList())).forEach(item -> Optional.ofNullable(itemRespDtoMap.get(item.getLongCode())).ifPresent(saleOrderItemRespDto -> {
                HashMap itemMap = Maps.newHashMap();
                itemMap.put("itemCode", saleOrderItemRespDto.getItemCode());
                itemMap.put("skuCode", saleOrderItemRespDto.getSkuCode());
                itemMap.put("packId", saleOrderItemRespDto.getPackId());
                itemMap.put("itemNum", item.getOutQuantity());
                if (item.getTradeOrderItemId() != null && orderItemRespDtoMap.get(item.getTradeOrderItemId()) != null) {
                    SaleOrderItemDto oriOrderItemRespDto = (SaleOrderItemDto)orderItemRespDtoMap.get(item.getTradeOrderItemId());
                    itemMap.put("platformOrderItemNo", oriOrderItemRespDto.getPlatformOrderItemNo());
                    itemMap.put("gift", oriOrderItemRespDto.getGift());
                    itemMap.put("tradeOrderItemId", item.getTradeOrderItemId());
                } else {
                    itemMap.put("platformOrderItemNo", saleOrderItemRespDto.getPlatformOrderItemNo());
                }
                itemMapList.add(itemMap);
            }));
            List itemDtoList = saleOrderItemRespDtos.stream().filter(dto -> SaleItemStatusEnum.NORMAL.getCode().equals(dto.getStatus())).map(dto -> {
                HashMap itemMap = Maps.newHashMap();
                itemMap.put("itemCode", dto.getItemCode());
                itemMap.put("skuCode", dto.getSkuCode());
                itemMap.put("packId", dto.getPackId());
                itemMap.put("itemNum", dto.getItemNum());
                itemMap.put("platformOrderItemNo", dto.getPlatformOrderItemNo());
                itemMap.put("tradeOrderItemId", dto.getId());
                return itemMap;
            }).collect(Collectors.toList());
            msgMap.put("goodsList", itemMapList);
            msgMap.put("orderItemList", itemDtoList);
        }
        if (Objects.nonNull(saleOrderRespDto.getExchangeOrderNo())) {
            DgAfterSaleOrderRespDto afterDgPerformOrderRespDto = this.afterSaleOrderDomain.queryByNo(saleOrderRespDto.getExchangeOrderNo());
            Optional.ofNullable(afterDgPerformOrderRespDto).ifPresent(afterSaleOrder -> msgMap.put("platformRefundOrderSn", afterSaleOrder.getPlatformRefundOrderSn()));
        }
        MessageVo messageVo = new MessageVo();
        messageVo.setData((Object)JSON.toJSONString(msgMap));
        this.LOGGER.info("[\u51fa\u5e93\u56de\u4f20\u53d1\u9001mq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("DELIVERY_RESULT_B2B_MESSAGE_TAG", (Object)messageVo);
    }

    @Override
    public void sendMsgSaleOrderCreated(DgPerformOrderRespDto respDto) {
        List<DgSaleOrderItemRespDto> itemPageInfoList;
        AssertUtils.notNull((Object)respDto, (String)"\u5165\u53c2\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)respDto.getId(), (String)"\u5165\u53c2\u8ba2\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        MessageVo messageVo = new MessageVo();
        JSONObject object = JSON.parseObject((String)JSON.toJSONString((Object)respDto));
        DgPerformOrderAddrRespDto saleOrderAddrRespDto = this.saleOrderAddrDomain.queryAddressByOrderId(respDto.getId());
        if (saleOrderAddrRespDto != null) {
            object.put("saleOrderAddrRespDto", (Object)saleOrderAddrRespDto);
        }
        if (CollectionUtils.isNotEmpty(itemPageInfoList = this.saleOrderItemDomain.queryOrderItemByOrderId(respDto.getId()))) {
            object.put("saleOrderItemExtRespDto", itemPageInfoList);
        }
        messageVo.setData((Object)object.toJSONString());
        this.LOGGER.info("[\u9500\u552e\u8ba2\u5355\u521b\u5efa\u6210\u529fmq]\u53d1\u9001mq\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)messageVo));
        this.commonsMqService.publishMessage("SALE_ORDER_CREATED_MESSAGE_TAG", (Object)messageVo);
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderIds);
        List saleOrderEos = this.commonDas().getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)saleOrderEos)) {
            return null;
        }
        return saleOrderEos.stream().map(DgBeanUtils.origOrderEo2PerformOrderDtoFunc).collect(Collectors.toList());
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgSaleOrderEo saleOrderEo = (DgSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return saleOrderEo.getSaleOrderNo();
    }

    @Override
    public List<SaleOrderRespDto> queryChildByOriOrderNo(String saleOrderNo) {
        AssertUtils.notBlank((String)saleOrderNo, (String)"originalOrderNo\u7236\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryChildOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryChildOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderEo::getOriginalOrderNo, (Object)saleOrderNo);
        List saleOrderEos = this.das.getMapper().selectList((Wrapper)queryChildOrderWrapper);
        ArrayList respDtoList = Lists.newArrayList();
        DtoHelper.eoList2DtoList((Collection)saleOrderEos, (Collection)respDtoList, SaleOrderRespDto.class);
        return respDtoList;
    }
}

