/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.utils.DgOrderOptLabelUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderInfoDomainImpl
extends BaseDomainImpl<DgPerformOrderInfoEo>
implements IDgPerformOrderInfoDomain,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderInfoDomainImpl.class);
    @Resource
    private IDgPerformOrderInfoDas das;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    private final Function<DgPerformOrderInfoEo, DgPerformOrderRespDto> eo2DtoListFunc = performOrderInfoEo -> {
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        DgPerformOrderExtensionDto performOrderExtensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderExtensionDto).ifPresent(dto -> respDto.setPerformOrderExtensionDto(dto));
        DgPerformOrderPaymentDto performOrderPaymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderPaymentDto).ifPresent(dto -> respDto.setPerformOrderPaymentDto(dto));
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderSnapshotDto).ifPresent(dto -> respDto.setPerformOrderSnapshotDto(dto));
        return respDto;
    };

    public ICommonDas<DgPerformOrderInfoEo> commonDas() {
        return this.das;
    }

    @Override
    public int updateSaleOrderById(Long orderId, DgPerformOrderInfoEo updateEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        updateEo.setId(orderId);
        int updateSelective = this.das.updateSelective((BaseEo)updateEo);
        return updateSelective;
    }

    @Override
    public void modifySaleOrder(DgPerformOrderInfoDto modifyReqDto) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)modifyReqDto, (String[])new String[0]);
        this.updateSaleOrderById(performOrderInfoEo.getId(), performOrderInfoEo);
    }

    @Override
    public DgPerformOrderInfoEo queryEoById(Long id) {
        return (DgPerformOrderInfoEo)this.das.selectByPrimaryKey(id);
    }

    @Override
    public DgPerformOrderInfoEo queryByOrderNo(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getSaleOrderNo, (Object)orderNo);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return performOrderInfoEo;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryByOrderNos(List<String> orderNos) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(orderNos), (String)"orderNos \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderInfoEo::getSaleOrderNo, orderNos);
        List list = this.das.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public DgPerformOrderInfoEo queryByEo(DgPerformOrderInfoEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return performOrderInfoEo;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByDto(DgPerformOrderInfoEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List performOrderInfoEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        return performOrderInfoEos;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderIds);
        List performOrderInfoEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderInfoEos)) {
            return null;
        }
        return performOrderInfoEos;
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgPerformOrderInfoEo saleOrderEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return saleOrderEo.getSaleOrderNo();
    }

    @Override
    public int optimisticModifySaleOrder(DgPerformOrderInfoEo saleOrderEo, int idealCount, boolean needThrow) {
        log.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), idealCount, needThrow});
        if (Objects.isNull(saleOrderEo)) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (saleOrderEo.getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo);
        int optCount = this.das.getMapper().updateSelective((BaseEo)saleOrderEo);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    @Override
    public int optimisticModifySaleOrder(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> queryWrapper, int idealCount, boolean needThrow) {
        log.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgPerformOrderInfoEo)queryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo, queryWrapper);
        int optCount = this.das.getMapper().update((Object)saleOrderEo, queryWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    private void popOrderStatusLog(DgPerformOrderInfoEo saleOrderEo) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)saleOrderEo.getId());
        DgPerformOrderInfoEo saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    private void popOrderStatusLog(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgPerformOrderInfoEo)updateWrapper.getEntity()).getId());
        DgPerformOrderInfoEo saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    @Override
    public void removeLabel(Long saleOrderId, String oriLabel, String ... optLabels) {
        log.info("[\u8ba2\u5355\u6253\u6807\u79fb\u9664] saleOrderId={}, oriLabel={}, optLabel={}", new Object[]{saleOrderId, oriLabel, optLabels});
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)optLabels, (String)"optLabels \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setId(saleOrderId);
        String newLabel = DgOrderOptLabelUtils.removeLabel(oriLabel, optLabels);
        updateEo.setOptLabel(newLabel);
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    public void removePlanShipmentEnterpriseInfo(Long orderId) {
        this.das.removePlanShipmentEnterpriseInfo(orderId);
    }

    @Override
    public void cleanSourceData(Long orderId) {
        this.das.cleanSourceData(orderId);
    }

    @Override
    public void removeShipmentEnterprise(Long orderId) {
        this.das.removeShipmentEnterprise(orderId);
    }

    private DgPerformOrderRespDto eo2DtoFunc(DgPerformOrderInfoEo performOrderInfoEo) {
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        DgPerformOrderExtensionDto performOrderExtensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderExtensionDto).ifPresent(dto -> respDto.setPerformOrderExtensionDto(dto));
        DgPerformOrderPaymentDto performOrderPaymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderPaymentDto).ifPresent(dto -> respDto.setPerformOrderPaymentDto(dto));
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderSnapshotDto).ifPresent(dto -> respDto.setPerformOrderSnapshotDto(dto));
        return respDto;
    }
}

