/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgGiftEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderItemDomainImpl
extends BaseDomainImpl<DgPerformOrderItemEo>
implements IDgPerformOrderItemDomain {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderItemDomainImpl.class);
    @Resource
    private IDgPerformOrderItemDas das;
    @Resource
    private IDgPerformOrderItemExtensionDomain itemExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderGoodsItemDomain performOrderGoodsItemDomain;
    @Value(value="${yunxi.dg.base.goods.split.type:2}")
    private Integer defaultGoodsSplitType;

    public ICommonDas<DgPerformOrderItemEo> commonDas() {
        return this.das;
    }

    public void logicDeleteById(Long id) {
        IDgPerformOrderItemDomain.super.logicDeleteById(id);
        this.itemExtensionDomain.logicDeleteByOrderItemId(id);
    }

    @Override
    public void createSplitOrderItem(DgPerformOrderInfoEo oriSaleOrder, DgPerformOrderInfoEo childSaleOrder, List<DgSplitOrderItemReqDto> goodsList) {
        AssertUtils.notNull((Object)oriSaleOrder, (String)"oriSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrder, (String)"childSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(goodsList, (String)"goodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.debug("[\u62c6\u5355]\u5f00\u59cb\u62c6\u8ba2\u5355\u5546\u54c1\uff0c\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(goodsList));
        LambdaQueryWrapper queryOrderItemWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)oriSaleOrder.getId());
        List<DgPerformOrderItemRespDto> orderItemEos = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWapper);
        AssertUtils.notEmpty(orderItemEos, (String)String.format("saleOrderId=%s\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728", oriSaleOrder.getId()));
        Map skusMap = orderItemEos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        goodsList.forEach(splitOrderItemReqDto -> {
            DgPerformOrderItemRespDto orderItemEo = (DgPerformOrderItemRespDto)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                log.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)oriSaleOrder, (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            DgPerformOrderItemEo splitOrderitemEo = new DgPerformOrderItemEo();
            CubeBeanUtils.copyProperties((Object)splitOrderitemEo, (Object)orderItemEo, (String[])new String[]{"id"});
            if (orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()).compareTo(BigDecimal.ZERO) < 0) {
                log.error("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355(skucode={})\u5269\u4f59\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getItemNum(), splitOrderItemReqDto.getGoodsNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
            splitOrderitemEo.setItemNum(splitOrderItemReqDto.getGoodsNum());
            orderItemEo.setItemNum(orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()));
            splitOrderitemEo.setOrderId(childSaleOrder.getId());
            splitOrderitemEo.setOriginalOrderItemId(orderItemEo.getId());
            splitOrderitemEo.setLogicalWarehouseId(childSaleOrder.getLogicalWarehouseId());
            splitOrderitemEo.setLogicalWarehouseCode(childSaleOrder.getLogicalWarehouseCode());
            splitOrderitemEo.setLogicalWarehouseName(childSaleOrder.getLogicalWarehouseName());
            splitOrderitemEo.setDeliveryItemBatchNo(splitOrderItemReqDto.getBatch());
            splitOrderitemEo.setBatchNo(splitOrderItemReqDto.getBatch());
            if (orderItemEo.getVolume() != null && orderItemEo.getVolume().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newVolume = orderItemEo.getVolume().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setVolume(newVolume);
                log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newVolume);
            }
            if (orderItemEo.getWeight() != null && orderItemEo.getWeight().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newWeight = orderItemEo.getWeight().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setWeight(newWeight);
                log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newWeight);
            }
            if (orderItemEo.getLineAmount() != null && orderItemEo.getSalePrice() != null) {
                splitOrderitemEo.setLineAmount(orderItemEo.getSalePrice().multiply(splitOrderItemReqDto.getGoodsNum()));
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal orderTotalAmount = BigDecimal.ZERO;
            splitOrderitemEo.setPayAmount(payAmount);
            splitOrderitemEo.setOrderTotalAmount(orderTotalAmount);
            this.das.insert((BaseEo)splitOrderitemEo);
            this.modifyGoodsItemRelation(splitOrderitemEo, childSaleOrder, (DgSplitOrderItemReqDto)splitOrderItemReqDto, oriSaleOrder);
            log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5206\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderItemReqDto));
        });
    }

    private void modifyGoodsItemRelation(DgPerformOrderItemEo childSaleOrderItemEo, DgPerformOrderInfoEo childSaleOrder, DgSplitOrderItemReqDto dgSplitOrderItemReqDto, DgPerformOrderInfoEo oriSaleOrder) {
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setOrderItemId(childSaleOrderItemEo.getId());
        modifyGoodsItemRowVo.setOrderId(childSaleOrder.getId());
        modifyGoodsItemRowVo.setOrderNo(childSaleOrder.getSaleOrderNo());
        modifyGoodsItemRowVo.setChangeNum(Integer.valueOf(childSaleOrderItemEo.getItemNum().intValue()));
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(dgSplitOrderItemReqDto.getOriginalOrderGoodsId());
        modifyGoodsItemRowVo.setQuerySaleOrderId(oriSaleOrder.getId());
        modifyGoodsItemRowVo.setGoodsSplitType(oriSaleOrder.getGoodsSplitType());
        this.performOrderGoodsItemDomain.modifyGoodsItemRelation(modifyGoodsItemRowVo);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)orderId);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtos = this.selectList((Wrapper<DgPerformOrderItemEo>)queryItemWrapper);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderIds(List<Long> orderIdList) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemEo::getOrderId, orderIdList);
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryItemWrapper);
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        return resultList;
    }

    @Override
    public void modifyOrderItemAmount(List<DgPerformOrderItemReqDto> performOrderItemReqDtos) {
        AssertUtils.notEmpty(performOrderItemReqDtos, (String)"performOrderItemReqDtos \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, performOrderItemReqDtos, DgPerformOrderItemEo.class);
        for (DgPerformOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            this.das.updateSelective((BaseEo)saleOrderItemEo);
        }
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsBySkuCodes(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(skuCodeList, (String)"skuCodeList \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemEo.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)saleOrderId)).in(DgPerformOrderItemEo::getSkuCode, skuCodeList);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemEo);
        return saleOrderItemRespDtoList;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        return this.queryNormalItemsByOrderIds(Lists.newArrayList((Object[])new Long[]{orderId}));
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        AssertUtils.notEmpty(orderIdList, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemEo::getOrderId, orderIdList)).eq(DgPerformOrderItemEo::getStatus, (Object)SaleItemStatusEnum.NORMAL.getCode());
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(orderItemIds, (String)"orderItemIds \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)orderId)).in(BaseEo::getId, orderItemIds);
        List list = this.das.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtos, (Collection)list, DgPerformOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(List<Long> orderItemIds) {
        AssertUtils.notEmpty(orderItemIds, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemEo::getOrderId, orderItemIds);
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public DgPerformOrderItemChangeVo insertBatchItemVo(DgPerformOrderItemChangeVo saleOrderItermChangeVo) {
        AssertUtils.notEmpty((Collection)saleOrderItermChangeVo.getPerformOrderItemRespDtos(), (String)"\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList performOrderItemEos = Lists.newArrayList();
        ArrayList performOrderItemExtEos = Lists.newArrayList();
        saleOrderItermChangeVo.getPerformOrderItemRespDtos().forEach(dto -> {
            dto.setId(Long.valueOf(IdGenrator.getDistributedId()));
            DgPerformOrderItemExtensionDto itemExtensionDto = Objects.isNull(dto.getPerformOrderItemExtensionDto()) ? new DgPerformOrderItemExtensionDto() : dto.getPerformOrderItemExtensionDto();
            itemExtensionDto.setOrderItemId(dto.getId());
            if (dto.getMainOrderId() == null) {
                dto.setMainOrderId(dto.getOrderId());
                dto.setMainOrderItemId(dto.getId());
                dto.setMainItemId(dto.getItemId());
                dto.setMainItemCode(dto.getMainItemCode());
                dto.setMainItemName(dto.getItemName());
                dto.setMainSkuId(dto.getSkuId());
                dto.setMainSkuCode(dto.getSkuCode());
                dto.setMainSkuName(dto.getMainSkuName());
            }
            if (dto.getSurplusCanRefundPayAmount() == null && DgGiftEnum.GIFT.getType().equals(dto.getGift())) {
                dto.setSurplusCanRefundPayAmount(BigDecimal.ZERO);
            }
            dto.setGoodsSplitType(this.defaultGoodsSplitType);
            DgPerformOrderItemEo eo = new DgPerformOrderItemEo();
            CubeBeanUtils.copyProperties((Object)eo, (Object)dto, (String[])new String[0]);
            DgPerformOrderItemExtensionEo extEo = new DgPerformOrderItemExtensionEo();
            CubeBeanUtils.copyProperties((Object)extEo, (Object)itemExtensionDto, (String[])new String[]{"id"});
            performOrderItemEos.add(eo);
            performOrderItemExtEos.add(extEo);
        });
        AssertUtils.isTrue((performOrderItemEos.size() == performOrderItemExtEos.size() ? 1 : 0) != 0, (String)"\u5546\u54c1\u6570\u636e\u4e0e\u5546\u54c1\u6269\u5c55\u4fe1\u606f\u6570\u91cf\u4e0d\u4e00\u81f4");
        this.das.insertBatch((List)performOrderItemEos);
        this.itemExtensionDomain.insertBatch(performOrderItemExtEos);
        this.performOrderGoodsItemDomain.saveGoodsItems(saleOrderItermChangeVo);
        return saleOrderItermChangeVo;
    }

    private List<DgPerformOrderItemRespDto> selectList(Wrapper<DgPerformOrderItemEo> queryWrapper) {
        List performOrderItemEos = this.das.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderItemEos)) {
            return null;
        }
        ArrayList<DgPerformOrderItemRespDto> performOrderItemRespDtos = new ArrayList<DgPerformOrderItemRespDto>();
        CubeBeanUtils.copyCollection(performOrderItemRespDtos, (Collection)performOrderItemEos, DgPerformOrderItemRespDto.class);
        performOrderItemRespDtos.forEach(respDto -> {
            DgPerformOrderItemExtensionEo performOrderItemExtensionEo = this.itemExtensionDomain.selectByOrderItemId(respDto.getId());
            DgPerformOrderItemExtensionDto performOrderItemExtensionDto = new DgPerformOrderItemExtensionDto();
            CubeBeanUtils.copyProperties((Object)performOrderItemExtensionDto, (Object)performOrderItemExtensionEo, (String[])new String[0]);
            respDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
        });
        return performOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)saleOrderId)).eq(DgPerformOrderItemEo::getStatus, (Object)DgSaleItemStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            queryOrderItemWrapper.in(DgPerformOrderItemEo::getSkuCode, skuCodeList);
        }
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public int optimisticModifySaleOrderItem(DgPerformOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgPerformOrderItemEo> updateQueryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        log.info("optimisticModifySaleOrderItem\u5165\u53c2saleOrderItemEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderItemEo), JSON.toJSONString(updateQueryWrapper), idealCount, needThrow});
        if (updateQueryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgPerformOrderItemEo)updateQueryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderItemEo);
        int optCount = this.das.getMapper().update((Object)saleOrderItemEo, updateQueryWrapper);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u5173\u8054\u7684\u8ba2\u5355\u660e\u7ec6\u4e0d\u5141\u8bb8\u66f4\u65b0");
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getStatus()) || StringUtils.isNotBlank((CharSequence)saleOrderItemEo.getRefundStatus())) {
            ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
            modifyGoodsItemRowVo.setQuerySaleOrderId(((DgPerformOrderItemEo)updateQueryWrapper.getEntity()).getOrderId());
            modifyGoodsItemRowVo.setQueryBelongOrderItemId(((DgPerformOrderItemEo)updateQueryWrapper.getEntity()).getId());
            modifyGoodsItemRowVo.setChangeNum(needChangeItemNum);
            modifyGoodsItemRowVo.setStatus(saleOrderItemEo.getStatus());
            modifyGoodsItemRowVo.setRefundStatus(saleOrderItemEo.getRefundStatus());
            this.performOrderGoodsItemDomain.modifyGoodsItems(modifyGoodsItemRowVo);
        }
        return optCount;
    }
}

