/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.cache;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SaleIntransitCache {
    private static final Logger log = LoggerFactory.getLogger(SaleIntransitCache.class);
    @Resource
    private ICacheService cacheService;
    public static final String SALE_ORDER_INTRANSIT_GROUP = "SALE_ORDER_INTRANSIT_GROUP";
    public static final String SALE_ORDER_SPLIT_INTERCEPT_GROUP = "SALE_ORDER_SPLIT_INTERCEPT_GROUP";
    public static final String SALE_ORDER_ITEM_INTRANSIT_GROUP = "SALE_ORDER_ITEM_INTRANSIT_GROUP";
    public static final Integer SALE_ORDER_INTRANSIT_TIME = 1209600;

    public void setSaleIntranst(String saleOrderNo, Boolean intransitFlag) {
        if (null == intransitFlag) {
            intransitFlag = Boolean.TRUE;
        }
        boolean b = this.cacheService.setCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo, (Object)intransitFlag, SALE_ORDER_INTRANSIT_TIME.intValue());
        log.info("\u65b0\u589e\u7f13\u5b58\u6570\u636e={},intransitFlag={},{}", new Object[]{saleOrderNo, intransitFlag, b});
    }

    public void setSaleItemIntranst(String saleOrderNo, Map<String, Boolean> saleItemMap) {
        this.cacheService.setCache(SALE_ORDER_ITEM_INTRANSIT_GROUP, saleOrderNo, (Object)JSONObject.toJSONString(saleItemMap), SALE_ORDER_INTRANSIT_TIME.intValue());
    }

    public Boolean getSaleIntranst(String saleOrderNo) {
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return Boolean.FALSE;
        }
        Boolean flag = (Boolean)this.cacheService.getCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo, Boolean.class);
        log.info("\u83b7\u53d6\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)flag);
        return Objects.isNull(flag) ? Boolean.TRUE : flag;
    }

    public Map<String, Boolean> getSaleItemIntranst(String saleOrderNo) {
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return new HashMap<String, Boolean>();
        }
        String cache = (String)this.cacheService.getCache(SALE_ORDER_ITEM_INTRANSIT_GROUP, saleOrderNo, String.class);
        log.info("\u83b7\u53d6\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)cache);
        return Objects.isNull(cache) ? new HashMap() : (Map)JSONObject.parseObject((String)cache, HashMap.class);
    }

    public void delSaleIntranst(String saleOrderNo) {
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return;
        }
        boolean b = this.cacheService.delCache(SALE_ORDER_INTRANSIT_GROUP, saleOrderNo);
        this.cacheService.delCache(SALE_ORDER_ITEM_INTRANSIT_GROUP, saleOrderNo);
        log.info("\u5220\u9664\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)b);
    }

    public void setSaleSplitIntercept(String saleOrderNo, Boolean interceptFlag) {
        if (null == interceptFlag) {
            interceptFlag = Boolean.FALSE;
        }
        boolean b = this.cacheService.setCache(SALE_ORDER_SPLIT_INTERCEPT_GROUP, saleOrderNo, (Object)interceptFlag, SALE_ORDER_INTRANSIT_TIME.intValue());
        log.info("\u65b0\u589e\u62c6\u5355\u62e6\u622a\u7f13\u5b58\u6570\u636e={},intransitFlag={},{}", new Object[]{saleOrderNo, interceptFlag, b});
    }

    public Boolean getSaleSplitIntercep(String saleOrderNo) {
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return Boolean.FALSE;
        }
        Boolean flag = (Boolean)this.cacheService.getCache(SALE_ORDER_SPLIT_INTERCEPT_GROUP, saleOrderNo, Boolean.class);
        log.info("\u83b7\u53d6\u62c6\u5355\u62e6\u622a\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)flag);
        return Objects.isNull(flag) ? Boolean.FALSE : flag;
    }

    public void delSaleSplitIntercep(String saleOrderNo) {
        if (StringUtils.isBlank((CharSequence)saleOrderNo)) {
            return;
        }
        boolean b = this.cacheService.delCache(SALE_ORDER_SPLIT_INTERCEPT_GROUP, saleOrderNo);
        log.info("\u5220\u9664\u62c6\u5355\u62e6\u622a\u7f13\u5b58\u6570\u636e={},{}", (Object)saleOrderNo, (Object)b);
    }
}

