/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReflectionUtils {
    private static final Logger log = LoggerFactory.getLogger(ReflectionUtils.class);
    private static final Map<Class, List<Field>> classFieldCache = new ConcurrentHashMap<Class, List<Field>>();

    public static String getMethodCapitalize(Field field, String str) {
        Class<?> fieldType = field.getType();
        return StringUtils.concatCapitalize((String)(Boolean.TYPE.equals(fieldType) ? "is" : "get"), (String)str);
    }

    @Deprecated
    public static String setMethodCapitalize(Field field, String str) {
        Class<?> fieldType = field.getType();
        return StringUtils.concatCapitalize((String)"set", (String)str);
    }

    public static Object getMethodValue(Class<?> cls, Object entity, String str) {
        Map<String, Field> fieldMaps = ReflectionUtils.getFieldMap(cls);
        String methodName = ReflectionUtils.getMethodCapitalize(fieldMaps.get(str), str);
        AssertUtils.notNull(fieldMaps, (String)String.format("Error: NoSuchField in %s for %s.  Cause:", cls.getSimpleName(), str));
        return ReflectionUtils.getValueByMethodName(cls, entity, methodName);
    }

    public static Object getValueByMethodName(Class<?> cls, Object entity, String methodStr) {
        Map<String, Field> fieldMaps = ReflectionUtils.getFieldMap(cls);
        try {
            AssertUtils.notNull(fieldMaps, (String)String.format("Error: NoSuchField in %s for %s.  Cause:", cls.getSimpleName(), methodStr));
            Method method = cls.getMethod(methodStr, new Class[0]);
            return method.invoke(entity, new Object[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Error: NoSuchMethod in %s.  Cause:", cls.getSimpleName()), e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error: Cannot execute a private method. in %s.  Cause:", cls.getSimpleName()), e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException("Error: InvocationTargetException on getMethodValue.  Cause:" + e);
        }
    }

    public static Object getMethodValue(Object entity, String str) {
        if (null == entity) {
            return null;
        }
        return ReflectionUtils.getMethodValue(entity.getClass(), entity, str);
    }

    public static Class getSuperClassGenericType(Class clazz, int index) {
        Type genType = clazz.getGenericSuperclass();
        if (!(genType instanceof ParameterizedType)) {
            log.warn(String.format("Warn: %s's superclass not ParameterizedType", clazz.getSimpleName()));
            return Object.class;
        }
        Type[] params = ((ParameterizedType)genType).getActualTypeArguments();
        if (index >= params.length || index < 0) {
            log.warn(String.format("Warn: Index: %s, Size of %s's Parameterized Type: %s .", index, clazz.getSimpleName(), params.length));
            return Object.class;
        }
        if (!(params[index] instanceof Class)) {
            log.warn(String.format("Warn: %s not set the actual class on superclass generic parameter", clazz.getSimpleName()));
            return Object.class;
        }
        return (Class)params[index];
    }

    public static Map<String, Field> getFieldMap(Class<?> clazz) {
        List<Field> fieldList = ReflectionUtils.getFieldList(clazz);
        return CollectionUtils.isNotEmpty(fieldList) ? fieldList.stream().collect(Collectors.toMap(Field::getName, field -> field)) : Collections.emptyMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Field> getFieldList(Class<?> clazz) {
        if (Objects.isNull(clazz)) {
            return Collections.emptyList();
        }
        List<Field> fields = classFieldCache.get(clazz);
        if (CollectionUtils.isEmpty(fields)) {
            Map<Class, List<Field>> map = classFieldCache;
            synchronized (map) {
                fields = ReflectionUtils.doGetFieldList(clazz);
                classFieldCache.put(clazz, fields);
            }
        }
        return fields;
    }

    public static List<Field> doGetFieldList(Class<?> clazz) {
        if (clazz.getSuperclass() != null) {
            List fieldList = Stream.of(clazz.getDeclaredFields()).filter(field -> !Modifier.isStatic(field.getModifiers())).filter(field -> !Modifier.isTransient(field.getModifiers())).collect(Collectors.toCollection(LinkedList::new));
            Class<?> superClass = clazz.getSuperclass();
            return ReflectionUtils.excludeOverrideSuperField(fieldList, ReflectionUtils.getFieldList(superClass));
        }
        return Collections.emptyList();
    }

    public static List<Field> excludeOverrideSuperField(List<Field> fieldList, List<Field> superFieldList) {
        Map fieldMap = fieldList.stream().collect(Collectors.toMap(Field::getName, Function.identity()));
        superFieldList.stream().filter(field -> !fieldMap.containsKey(field.getName())).forEach(fieldList::add);
        return fieldList;
    }

    public static Method getMethod(Class<?> cls, Field field) {
        try {
            return cls.getDeclaredMethod(ReflectionUtils.getMethodCapitalize(field, field.getName()), new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(String.format("Error: NoSuchMethod in %s.  Cause:", cls.getName()), e);
        }
    }

    public static void setMethod(Object entity, String fielName, Object value) {
        Objects.requireNonNull(entity);
        Class<?> cls = entity.getClass();
        Map<String, Field> fieldMaps = ReflectionUtils.getFieldMap(cls);
        try {
            AssertUtils.notNull(fieldMaps, (String)String.format("Error: NoSuchField in %s for %s.  Cause:", cls.getSimpleName(), fielName));
            Field field = fieldMaps.get(fielName);
            field.setAccessible(true);
            field.set(entity, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(String.format("Error: Cannot execute a private method. in %s.  Cause:", cls.getSimpleName()), e);
        }
    }
}

