/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderAbolishEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderDomainImpl
extends BaseDomainImpl<DgAfterSaleOrderEo>
implements IDgAfterSaleOrderDomain,
IResetRedisNoIndexCommon {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgAfterSaleOrderDas das;

    public ICommonDas<DgAfterSaleOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)this.das.selectByPrimaryKey(id);
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    @Override
    public DgAfterSaleOrderRespDto queryByNo(String afterSaleOrderNo) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        List saleOrderEos;
        if (StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformOrderNo()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getSaleOrderNo()) && CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformOrderNo(), (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getSaleOrderNo(), (String)"saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            if (CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
                throw new BizException("platformRefundOrderSnList\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getPlatformRefundOrderSn, (Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getAfterSaleOrderType, (Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        return resultList;
    }

    @Override
    public int optimisticModifyAfterSale(DgAfterSaleOrderEo dgAfterSaleOrderEo, LambdaQueryWrapper<DgAfterSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        this.logger.info("optimisticModifyAfterSale\u5165\u53c2afterSaleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)dgAfterSaleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)dgAfterSaleOrderEo);
        int optCount = this.das.getMapper().update((Object)dgAfterSaleOrderEo, queryWrapper);
        if (this.das.isUseCache()) {
            DgAfterSaleOrderEo entity = (DgAfterSaleOrderEo)queryWrapper.getEntity();
            this.das.removeLogicCache((BaseEo)entity);
            this.das.removeCache((Object)entity.getId());
            this.das.removeCacheByExample((BaseEo)entity);
        }
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u552e\u540e\u5355\u72b6\u6001\u5931\u8d25, idealCount: " + idealCount + ", optCount: " + optCount);
        }
        return optCount;
    }

    @Override
    public void batchModifyInnerRemark(List<Long> ids, String innerRemark) {
        List dgAfterSaleOrderEos = this.das.selectByIds(ids);
        dgAfterSaleOrderEos.stream().forEach(eo -> {
            eo.setInnerRemark(innerRemark);
            this.das.updateSelective((BaseEo)eo);
        });
    }

    @Override
    public void modifyAfterSaleOrderReason(Long afterSaleOrderId, String afterSaleOrderReason) {
        ArrayList idList = Lists.newArrayList();
        idList.add(afterSaleOrderId);
        List dgAfterSaleOrderEos = this.das.selectByIds((List)idList);
        AssertUtils.notEmpty((Collection)dgAfterSaleOrderEos, (String)"\u67e5\u8be2\u4e0d\u5230\u5bf9\u5e94\u7684\u552e\u540e\u5355");
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)dgAfterSaleOrderEos.get(0);
        dgAfterSaleOrderEo.setAfterSaleOrderReason(afterSaleOrderReason);
        this.das.updateSelective((BaseEo)dgAfterSaleOrderEo);
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryBySaleOrderNo(String saleOrderNo) {
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((CharSequence)saleOrderNo)) {
            wrapper.eq((Object)"sale_order_no", (Object)saleOrderNo);
        }
        List dgAfterSaleOrderEos = this.getMapper().selectList((Wrapper)wrapper);
        ArrayList<DgAfterSaleOrderRespDto> dgAfterSaleOrderRespDto = new ArrayList<DgAfterSaleOrderRespDto>();
        CubeBeanUtils.copyCollection(dgAfterSaleOrderRespDto, (Collection)dgAfterSaleOrderEos, DgAfterSaleOrderRespDto.class);
        return dgAfterSaleOrderRespDto;
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return afterSaleOrderEo.getAfterSaleOrderNo();
    }
}

