/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.dg;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.dtyunxi.cube.commons.dto.DtoHelper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.exceptions.BizException;
import com.dtyunxi.util.IdGenrator;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgGoodItemDeliveryStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleOrderGoodsSplitTypeEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderGoodsItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.DgPerformOrderGoodsItemQueryVo;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.mode.IDgCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderGoodsItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderGoodsItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderGoodsItemEo;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@ConditionalOnProperty(name={"perform.order.domain.dg.enable"}, havingValue="true")
@Component
public class DgPerformOrderGoodsItemExtDomainImpl
implements IDgPerformOrderGoodsItemExtDomain {
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgCalculatorAmountModeDomain calculatorAmountMode;
    @Resource
    private IDgPerformOrderGoodsItemDas performOrderGoodsItemDas;
    @Resource
    private IDgPerformOrderGoodsItemDomain performOrderGoodsItemDomain;

    @Override
    public void saveGoodsItems(DgPerformOrderItemChangeVo shipmentItermChangeVo) {
        List saleOrderItemEos = shipmentItermChangeVo.getPerformOrderItemRespDtos();
        Long saleOrderId = shipmentItermChangeVo.getSaleOrderId();
        Long originOrderId = shipmentItermChangeVo.getOriginOrderId();
        String saleOrderNo = shipmentItermChangeVo.getSaleOrderNo();
        AssertUtils.notEmpty((Collection)saleOrderItemEos, (String)"saleOrderItemEos \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)originOrderId, (String)"originOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notBlank((String)saleOrderNo, (String)"saleOrderNo \u4e0d\u80fd\u4e3a\u7a7a");
        BigDecimal totalItemCount = saleOrderItemEos.stream().map(DgPerformOrderItemDto::getItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
        this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u9700\u8981\u63d2\u5165\u5546\u54c1\u884c\u7684\u603b\u91cf\u4e3a\uff1a{}", (Object)totalItemCount);
        long start = System.currentTimeMillis();
        for (DgPerformOrderItemRespDto saleOrderItemEo : saleOrderItemEos) {
            DgPerformOrderItemRespDto saleOrderItemRespDto = new DgPerformOrderItemRespDto();
            CubeBeanUtils.copyProperties((Object)saleOrderItemRespDto, (Object)saleOrderItemEo, (String[])new String[0]);
            BigDecimal averagePayAmount = this.calculatorAmountMode.calculateAverageAmount(saleOrderItemEo.getPayAmount(), saleOrderItemEo.getItemNum(), 2, 4);
            this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)averagePayAmount);
            BigDecimal averageRealPayAmount = this.calculatorAmountMode.calculateAverageAmount(saleOrderItemEo.getRealPayAmount(), saleOrderItemEo.getItemNum(), 2, 4);
            this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)averageRealPayAmount);
            BigDecimal averageDiscountAmount = this.calculatorAmountMode.calculateAverageAmount(saleOrderItemEo.getDiscountAmount(), saleOrderItemEo.getItemNum(), 2, 4);
            this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u4f18\u60e0\u91d1\u989d\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)averageDiscountAmount);
            BigDecimal averageIntegral = this.calculatorAmountMode.calculateAverageIntegral(saleOrderItemEo.getItemIntegral(), saleOrderItemEo.getItemNum());
            this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u8ba1\u7b97skucode={}\u7684\u660e\u7ec6\u884c\u5747\u644a\u79ef\u5206\u4e3a\uff1a{}", (Object)saleOrderItemEo.getSkuCode(), (Object)averageIntegral);
            switch (SaleOrderGoodsSplitTypeEnum.enumOf((Integer)saleOrderItemEo.getGoodsSplitType())) {
                case NONE: {
                    break;
                }
                case SINGLE: {
                    this.singleMode(shipmentItermChangeVo, saleOrderItemEo, averagePayAmount, averageRealPayAmount, averageDiscountAmount, averageIntegral);
                    break;
                }
                case MULTILINE: {
                    this.multilineMode(shipmentItermChangeVo, saleOrderItemEo, averagePayAmount, averageRealPayAmount, averageDiscountAmount, averageIntegral);
                }
            }
        }
        long end = System.currentTimeMillis();
        this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u6279\u91cf\u64cd\u4f5c\u6267\u884c\u7684\u603b\u65f6\u957f\uff1a{}", (Object)(end - start));
    }

    @Override
    public List<DgPerformOrderGoodsItemRespDto> queryAfterSaleOrderLinkGoodsItems(DgPerformOrderGoodsItemQueryVo performOrderGoodsItemQueryVo, Long firstId, Integer pageSize) {
        if (CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getOrderIds()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderIds()) && CollectionUtils.isEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds())) {
            throw new BizException("-1", "\u67e5\u8be2\u5165\u53c2\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        LambdaQueryWrapper queryGoodsItemsWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryGoodsItemsWrapper.eq(BaseEo::getDr, (Object)0)).orderByAsc(BaseEo::getId);
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getOrderIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getOrderId, (Collection)performOrderGoodsItemQueryVo.getOrderIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getOrderItemIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getOrderItemId, (Collection)performOrderGoodsItemQueryVo.getOrderItemIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getPlatformOrderItemNo, (Collection)performOrderGoodsItemQueryVo.getPlatformOrderItemNos());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getMainOrderId, (Collection)performOrderGoodsItemQueryVo.getMainOrderIds());
        }
        if (CollectionUtils.isNotEmpty((Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds())) {
            queryGoodsItemsWrapper.in(DgPerformOrderGoodsItemEo::getMainOrderItemId, (Collection)performOrderGoodsItemQueryVo.getMainOrderItemIds());
        }
        if (Objects.nonNull(performOrderGoodsItemQueryVo.getPlatformOrderNo())) {
            queryGoodsItemsWrapper.eq(DgPerformOrderGoodsItemEo::getPlatformOrderNo, (Object)performOrderGoodsItemQueryVo.getPlatformOrderNo());
        }
        if (firstId != null) {
            queryGoodsItemsWrapper.gt(BaseEo::getId, (Object)firstId);
        }
        if (performOrderGoodsItemQueryVo.isGourdByOrderId() && performOrderGoodsItemQueryVo.isGourdPlatformOrderItemNo() && performOrderGoodsItemQueryVo.isGourdByOrderItemId()) {
            queryGoodsItemsWrapper.groupBy((Object[])new SFunction[]{DgPerformOrderGoodsItemEo::getOrderId, DgPerformOrderGoodsItemEo::getPlatformOrderItemNo, DgPerformOrderGoodsItemEo::getOrderItemId});
        } else if (performOrderGoodsItemQueryVo.isGourdByOrderId()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getOrderId);
        } else if (performOrderGoodsItemQueryVo.isGourdPlatformOrderItemNo()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getPlatformOrderItemNo);
        } else if (performOrderGoodsItemQueryVo.isGourdByOrderItemId()) {
            queryGoodsItemsWrapper.groupBy(DgPerformOrderGoodsItemEo::getOrderItemId);
        }
        Page page = new Page((long)((Integer)ObjectUtil.defaultIfNull((Object)0, (Object)1)).intValue(), (long)((Integer)ObjectUtil.defaultIfNull((Object)pageSize, (Object)10)).intValue(), false);
        page = this.performOrderGoodsItemDas.getMapper().selectPage((IPage)page, (Wrapper)queryGoodsItemsWrapper);
        ArrayList<DgPerformOrderGoodsItemRespDto> saleGoodsItemRespDtos = new ArrayList<DgPerformOrderGoodsItemRespDto>();
        DtoHelper.eoList2DtoList((Collection)page.getRecords(), saleGoodsItemRespDtos, DgPerformOrderGoodsItemRespDto.class);
        return saleGoodsItemRespDtos;
    }

    @Override
    public int modifyGoodsItems(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        return this.performOrderGoodsItemDomain.modifyGoodsItems(modifyGoodsItemRowVo);
    }

    @Override
    public void removeOrderItem(ModifyGoodsItemRowVo modifyGoodsItemRowVo) {
        this.performOrderGoodsItemDomain.removeOrderItem(modifyGoodsItemRowVo);
    }

    private void singleMode(DgPerformOrderItemChangeVo shipmentItermChangeVo, DgPerformOrderItemRespDto saleOrderItemEo, BigDecimal averagePayAmount, BigDecimal averageRealPayAmount, BigDecimal averageDiscountAmount, BigDecimal averageIntegral) {
        DgPerformOrderItemRespDto saleOrderItemRespDto = new DgPerformOrderItemRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderItemRespDto, (Object)saleOrderItemEo, (String[])new String[0]);
        DgPerformOrderGoodsItemEo saleGoodsItemEo = new DgPerformOrderGoodsItemEo();
        CubeBeanUtils.copyProperties((Object)saleGoodsItemEo, (Object)saleOrderItemEo, (String[])new String[0]);
        saleGoodsItemEo.setOrderItemId(saleOrderItemEo.getId());
        saleGoodsItemEo.setOrderNo(shipmentItermChangeVo.getSaleOrderNo());
        saleGoodsItemEo.setItemNum(BigDecimal.ONE);
        saleGoodsItemEo.setOrderId(shipmentItermChangeVo.getSaleOrderId());
        saleGoodsItemEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
        saleGoodsItemEo.setOriginOrderId(shipmentItermChangeVo.getOriginOrderId());
        saleGoodsItemEo.setDeliveryStatus(DgGoodItemDeliveryStatusEnum.WAIT_DELIVERY.getCode());
        if (saleGoodsItemEo.getMainOrderId() == null) {
            saleGoodsItemEo.setMainOrderId(saleOrderItemEo.getOrderId());
            saleGoodsItemEo.setMainOrderItemId(saleOrderItemEo.getId());
        }
        saleGoodsItemEo.setStatus(Optional.ofNullable(saleOrderItemEo.getStatus()).orElse(SaleItemStatusEnum.NORMAL.getCode()));
        this.calculatorAmountMode.calculatorGoodItemAmountForCreate(saleOrderItemRespDto, saleGoodsItemEo, averagePayAmount, averageRealPayAmount, averageDiscountAmount, averageIntegral, 0);
        this.insertBatchItems(Lists.newArrayList((Object[])new DgPerformOrderGoodsItemEo[]{saleGoodsItemEo}));
    }

    private void multilineMode(DgPerformOrderItemChangeVo shipmentItermChangeVo, DgPerformOrderItemRespDto saleOrderItemEo, BigDecimal averagePayAmount, BigDecimal averageRealPayAmount, BigDecimal averageDiscountAmount, BigDecimal averageIntegral) {
        ArrayList batchInsertEoList = Lists.newArrayList();
        DgPerformOrderItemRespDto saleOrderItemRespDto = new DgPerformOrderItemRespDto();
        CubeBeanUtils.copyProperties((Object)saleOrderItemRespDto, (Object)saleOrderItemEo, (String[])new String[0]);
        for (int i = 0; i < saleOrderItemEo.getItemNum().intValue(); ++i) {
            DgPerformOrderGoodsItemEo saleGoodsItemEo = new DgPerformOrderGoodsItemEo();
            CubeBeanUtils.copyProperties((Object)saleGoodsItemEo, (Object)saleOrderItemEo, (String[])new String[0]);
            saleGoodsItemEo.setOrderItemId(saleOrderItemEo.getId());
            saleGoodsItemEo.setOrderNo(shipmentItermChangeVo.getSaleOrderNo());
            saleGoodsItemEo.setItemNum(BigDecimal.ONE);
            saleGoodsItemEo.setOrderId(shipmentItermChangeVo.getSaleOrderId());
            saleGoodsItemEo.setId(Long.valueOf(IdGenrator.getDistributedId()));
            saleGoodsItemEo.setOriginOrderId(shipmentItermChangeVo.getOriginOrderId());
            saleGoodsItemEo.setDeliveryStatus(DgGoodItemDeliveryStatusEnum.WAIT_DELIVERY.getCode());
            if (saleGoodsItemEo.getMainOrderId() == null) {
                saleGoodsItemEo.setMainOrderId(saleOrderItemEo.getOrderId());
                saleGoodsItemEo.setMainOrderItemId(saleOrderItemEo.getId());
            }
            saleGoodsItemEo.setStatus(Optional.ofNullable(saleOrderItemEo.getStatus()).orElse(SaleItemStatusEnum.NORMAL.getCode()));
            this.calculatorAmountMode.calculatorGoodItemAmountForCreate(saleOrderItemRespDto, saleGoodsItemEo, averagePayAmount, averageRealPayAmount, averageDiscountAmount, averageIntegral, i);
            batchInsertEoList.add(saleGoodsItemEo);
            if (batchInsertEoList.size() < BATCH_INSERT_THRESHOLD) continue;
            this.insertBatchItems(batchInsertEoList);
            batchInsertEoList = Lists.newArrayList();
        }
        this.insertBatchItems(batchInsertEoList);
    }

    private void insertBatchItems(List<DgPerformOrderGoodsItemEo> batchInsertEo) {
        long start = System.currentTimeMillis();
        if (CollectionUtils.isNotEmpty(batchInsertEo)) {
            this.performOrderGoodsItemDas.insertBatch(batchInsertEo);
        }
        long end = System.currentTimeMillis();
        this.LOGGER.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u5f53\u524d\u63d2\u5165:{}\u6761\uff0c\u8017\u65f6\uff1a{}", (Object)batchInsertEo.size(), (Object)(end - start));
    }
}

