/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.dg;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgSaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.constants.SaleItemStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemDas;
import com.yunxi.dg.base.center.trade.dao.vo.ModifyGoodsItemRowVo;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderGoodsItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.impl.BaseExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemExtensionDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemExtensionEo;
import com.yunxi.dg.base.center.trade.exception.DgPcpTradeExceptionCode;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"perform.order.domain.dg.enable"}, havingValue="true")
public class DgPerformOrderItemExtDomainImpl
implements IDgPerformOrderItemExtDomain,
BaseExtDomain<DgPerformOrderItemReqDto, DgPerformOrderItemRespDto> {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderItemExtDomainImpl.class);
    @Resource
    private IDgPerformOrderItemDas performOrderItemDas;
    @Resource
    private IDgPerformOrderExtDomain performOrderExtDomain;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IDgPerformOrderItemExtensionDomain performOrderItemExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderGoodsItemDomain performOrderGoodsItemDomain;

    @Override
    public void createSplitOrderItem(DgPerformOrderInfoEo oriSaleOrder, DgPerformOrderInfoEo childSaleOrder, List<DgSplitOrderItemReqDto> goodsList) {
        AssertUtils.notNull((Object)oriSaleOrder, (String)"oriSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notNull((Object)childSaleOrder, (String)"childSaleOrder\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        AssertUtils.notEmpty(goodsList, (String)"goodsList\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        log.debug("[\u62c6\u5355]\u5f00\u59cb\u62c6\u8ba2\u5355\u5546\u54c1\uff0c\u8bf7\u6c42\u62c6\u5355\u7684\u53c2\u6570\u4e3a\uff1a{}", (Object)JSON.toJSONString(goodsList));
        LambdaQueryWrapper queryOrderItemWapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)oriSaleOrder.getId());
        List<DgPerformOrderItemRespDto> orderItemEos = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWapper);
        AssertUtils.notEmpty(orderItemEos, (String)String.format("saleOrderId=%s\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728", oriSaleOrder.getId()));
        Map skusMap = orderItemEos.stream().collect(Collectors.toMap(BaseDto::getId, Function.identity()));
        goodsList.forEach(splitOrderItemReqDto -> {
            DgPerformOrderItemRespDto orderItemEo = (DgPerformOrderItemRespDto)skusMap.get(splitOrderItemReqDto.getOriginalOrderGoodsId());
            if (Objects.isNull(orderItemEo)) {
                log.warn("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355\u4e2d\uff08saleOrderId={}\uff09\u4e0d\u5b58\u5728skuCode={}\u7684\u5546\u54c1", (Object)oriSaleOrder, (Object)splitOrderItemReqDto.getGoodsSku());
                AssertUtils.notNull((Object)orderItemEo, (String)"\u539f\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728\uff01");
            }
            DgPerformOrderItemEo splitOrderitemEo = new DgPerformOrderItemEo();
            CubeBeanUtils.copyProperties((Object)splitOrderitemEo, (Object)orderItemEo, (String[])new String[]{"id"});
            if (orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()).compareTo(BigDecimal.ZERO) < 0) {
                log.error("[\u624b\u52a8\u62c6\u5355]\u539f\u8ba2\u5355(skucode={})\u5269\u4f59\u5546\u54c1\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u62c6\u5206\u7684\u6570\u91cf\u4e3a\uff1a{}", new Object[]{orderItemEo.getSkuCode(), orderItemEo.getItemNum(), splitOrderItemReqDto.getGoodsNum()});
                throw DgPcpTradeExceptionCode.SPLIT_ORDER_GOOD_COUNT_ILLEGAL.builderException();
            }
            splitOrderitemEo.setItemNum(splitOrderItemReqDto.getGoodsNum());
            orderItemEo.setItemNum(orderItemEo.getItemNum().subtract(splitOrderItemReqDto.getGoodsNum()));
            splitOrderitemEo.setOrderId(childSaleOrder.getId());
            splitOrderitemEo.setOriginalOrderItemId(orderItemEo.getId());
            splitOrderitemEo.setLogicalWarehouseId(childSaleOrder.getLogicalWarehouseId());
            splitOrderitemEo.setLogicalWarehouseCode(childSaleOrder.getLogicalWarehouseCode());
            splitOrderitemEo.setLogicalWarehouseName(childSaleOrder.getLogicalWarehouseName());
            splitOrderitemEo.setDeliveryItemBatchNo(splitOrderItemReqDto.getBatch());
            if (orderItemEo.getVolume() != null && orderItemEo.getVolume().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newVolume = orderItemEo.getVolume().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setVolume(newVolume);
                log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newVolume);
            }
            if (orderItemEo.getWeight() != null && orderItemEo.getWeight().compareTo(BigDecimal.ZERO) > 0) {
                BigDecimal newWeight = orderItemEo.getWeight().divide(orderItemEo.getItemNum()).multiply(splitOrderItemReqDto.getGoodsNum());
                splitOrderitemEo.setWeight(newWeight);
                log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5355\u540eskucode={}\u7684\u4f53\u79ef\u4e3a\uff1a{}", (Object)orderItemEo.getSkuCode(), (Object)newWeight);
            }
            if (orderItemEo.getLineAmount() != null && orderItemEo.getSalePrice() != null) {
                splitOrderitemEo.setLineAmount(orderItemEo.getSalePrice().multiply(splitOrderItemReqDto.getGoodsNum()));
            }
            BigDecimal payAmount = BigDecimal.ZERO;
            BigDecimal orderTotalAmount = BigDecimal.ZERO;
            splitOrderitemEo.setPayAmount(payAmount);
            splitOrderitemEo.setOrderTotalAmount(orderTotalAmount);
            this.performOrderItemDas.insert((BaseEo)splitOrderitemEo);
            this.modifyGoodsItemRelation(splitOrderitemEo, childSaleOrder, (DgSplitOrderItemReqDto)splitOrderItemReqDto, oriSaleOrder);
            log.info("[\u624b\u52a8\u62c6\u5355]\u62c6\u5206\u6210\u529f\uff1a{}", (Object)JSON.toJSONString((Object)splitOrderItemReqDto));
        });
    }

    @Override
    public DgPerformOrderItemRespDto queryById(Long orderId) {
        return this.selectByPrimaryKey(orderId);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryList(DgPerformOrderItemReqDto reqDto) {
        AssertUtils.notNull((Object)reqDto, (String)"reqDto \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemEo performOrderItemEo = new DgPerformOrderItemEo();
        CubeBeanUtils.copyProperties((Object)performOrderItemEo, (Object)reqDto, (String[])new String[0]);
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper((Object)performOrderItemEo);
        if (CollectionUtils.isNotEmpty((Collection)reqDto.getSkuCodeList())) {
            queryItemEo.in(DgPerformOrderItemEo::getSkuCode, (Collection)reqDto.getSkuCodeList());
        }
        queryItemEo.eq(BaseEo::getDr, (Object)0);
        return this.selectList((Wrapper<DgPerformOrderItemEo>)queryItemEo);
    }

    @Override
    public PageInfo<DgPerformOrderItemExtRespDto> queryPageById(Long orderId, Integer pageNum, Integer pageSize) {
        DgPerformOrderItemEo saleOrderItemEo = new DgPerformOrderItemEo();
        saleOrderItemEo.setOrderId(orderId);
        saleOrderItemEo.setOrderBy("sku_code");
        PageInfo eoPageInfo = this.performOrderItemDomain.selectPage((BaseEo)saleOrderItemEo, pageNum, pageSize);
        PageInfo dtoPageInfo = new PageInfo();
        CubeBeanUtils.copyProperties((Object)dtoPageInfo, (Object)eoPageInfo, (String[])new String[]{"list", "navigatepageNums"});
        ArrayList dtoList = new ArrayList();
        CubeBeanUtils.copyCollection(dtoList, (Collection)eoPageInfo.getList(), DgPerformOrderItemExtRespDto.class);
        dtoPageInfo.setList(dtoList);
        return dtoPageInfo;
    }

    private void modifyGoodsItemRelation(DgPerformOrderItemEo childSaleOrderItemEo, DgPerformOrderInfoEo childSaleOrder, DgSplitOrderItemReqDto dgSplitOrderItemReqDto, DgPerformOrderInfoEo oriSaleOrder) {
        ModifyGoodsItemRowVo modifyGoodsItemRowVo = new ModifyGoodsItemRowVo();
        modifyGoodsItemRowVo.setOrderItemId(childSaleOrderItemEo.getId());
        modifyGoodsItemRowVo.setOrderId(childSaleOrder.getId());
        modifyGoodsItemRowVo.setOrderNo(childSaleOrder.getSaleOrderNo());
        modifyGoodsItemRowVo.setChangeNum(Integer.valueOf(childSaleOrderItemEo.getItemNum().intValue()));
        modifyGoodsItemRowVo.setQueryBelongOrderItemId(dgSplitOrderItemReqDto.getOriginalOrderGoodsId());
        modifyGoodsItemRowVo.setQuerySaleOrderId(oriSaleOrder.getId());
        modifyGoodsItemRowVo.setGoodsSplitType(oriSaleOrder.getGoodsSplitType());
        this.performOrderGoodsItemDomain.modifyGoodsItemRelation(modifyGoodsItemRowVo);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)orderId);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtos = this.selectList((Wrapper<DgPerformOrderItemEo>)queryItemWrapper);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderIds(List<Long> orderIdList) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemEo::getOrderId, orderIdList);
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryItemWrapper);
        if (CollectionUtils.isEmpty(resultList)) {
            return null;
        }
        return resultList;
    }

    @Override
    public void modifyOrderItemAmount(List<DgPerformOrderItemReqDto> performOrderItemReqDtos) {
        AssertUtils.notEmpty(performOrderItemReqDtos, (String)"performOrderItemReqDtos \u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList saleOrderItemEos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemEos, performOrderItemReqDtos, DgPerformOrderItemEo.class);
        for (DgPerformOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            this.performOrderItemDas.updateSelective((BaseEo)saleOrderItemEo);
        }
    }

    @Override
    public int insert(DgPerformOrderItemReqDto performOrderItemReqDto) {
        return 0;
    }

    @Override
    public int updateSelective(DgPerformOrderItemReqDto performOrderItemReqDto) {
        AssertUtils.notNull((Object)performOrderItemReqDto, (String)"performOrderItemReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)performOrderItemReqDto.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemEo updateEo = new DgPerformOrderItemEo();
        CubeBeanUtils.copyProperties((Object)updateEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        return this.performOrderItemDomain.updateSelective((BaseEo)updateEo);
    }

    @Override
    public void reducePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
        log.info("[\u6263\u51cf\u8ba2\u5355\u5546\u54c1\u884c\u53ef\u7533\u8bf7\u6570]\u8ba2\u5355\u5546\u54c1\u884c\u5217\u8868\uff1a{}", (Object)JSON.toJSONString(itemReqDtoList));
        List<DgPerformOrderItemRespDto> orderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        Map orderItemMap = orderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderItemDto::getItemCode, Function.identity()));
        itemReqDtoList.forEach(afterSaleOrderDto -> {
            BigDecimal returnItemNum;
            DgPerformOrderItemRespDto dgPerformOrderItemRespDto = (DgPerformOrderItemRespDto)orderItemMap.get(afterSaleOrderDto.getItemCode());
            BigDecimal surplusCanReturnItemNum = dgPerformOrderItemRespDto.getSurplusCanReturnItemNum();
            AssertUtils.isTrue((surplusCanReturnItemNum.compareTo(returnItemNum = new BigDecimal(afterSaleOrderDto.getItemNum())) >= 0 ? 1 : 0) != 0, (String)"\u5546\u54c1:{}\u7684\u5269\u4f59\u53ef\u9000\u6570\u91cf\u4e0d\u8db3: {}, \u9000\u8d27\u6570\u91cf\uff1a{}", (Object[])new Object[]{afterSaleOrderDto.getItemName(), surplusCanReturnItemNum, afterSaleOrderDto.getItemNum()});
            this.performOrderItemDas.reducePerformOrderItemReturnNum(dgPerformOrderItemRespDto.getId(), afterSaleOrderDto.getItemNum());
        });
    }

    @Override
    public void releasePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
        List<DgPerformOrderItemRespDto> orderItemRespDtos = this.performOrderItemDomain.queryOrderItemByOrderId(saleOrderId);
        Map orderItemMap = orderItemRespDtos.stream().collect(Collectors.toMap(DgPerformOrderItemDto::getItemCode, Function.identity()));
        itemReqDtoList.forEach(afterSaleOrderDto -> {
            DgPerformOrderItemRespDto dgPerformOrderItemRespDto = (DgPerformOrderItemRespDto)orderItemMap.get(afterSaleOrderDto.getItemCode());
            this.performOrderItemDas.releasePerformOrderItemReturnNum(dgPerformOrderItemRespDto.getId(), afterSaleOrderDto.getItemNum());
        });
    }

    @Override
    public BigDecimal getOrderOutDeliveredCount(Long orderId) {
        return null;
    }

    @Override
    public void modifyOrderItemOutDeliveredResult(DgPerformOrderReqDto dgPerformOrderReqDto) {
    }

    @Override
    public void logicDelete(DgPerformOrderItemReqDto performOrderItemReqDto) {
        AssertUtils.notNull((Object)performOrderItemReqDto, (String)"performOrderItemReqDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemEo performOrderItemEo = new DgPerformOrderItemEo();
        CubeBeanUtils.copyProperties((Object)performOrderItemEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        this.performOrderItemDomain.delete((BaseEo)performOrderItemEo);
    }

    @Override
    public void logicDeleteById(Long id) {
        AssertUtils.notEmpty((Object)id, (String)"id \u4e0d\u80fd\u4e3a\u7a7a");
        this.performOrderItemDomain.logicDeleteById(id);
        this.performOrderItemExtensionDomain.logicDeleteByOrderItemId(id);
    }

    @Override
    public DgPerformOrderItemRespDto selectByPrimaryKey(Long id) {
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemEo.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)id);
        DgPerformOrderItemEo performOrderItemEo = (DgPerformOrderItemEo)this.performOrderItemDomain.getMapper().selectOne((Wrapper)queryItemEo);
        return this.fillItemResult(performOrderItemEo);
    }

    @Override
    public DgPerformOrderItemRespDto selectOne(DgPerformOrderItemReqDto performOrderItemReqDto) {
        AssertUtils.notNull((Object)performOrderItemReqDto, (String)"reqDto \u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderItemEo performOrderItemEo = new DgPerformOrderItemEo();
        CubeBeanUtils.copyProperties((Object)performOrderItemEo, (Object)performOrderItemReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper((Object)performOrderItemEo);
        queryItemEo.eq(BaseEo::getDr, (Object)0);
        DgPerformOrderItemEo itemEo = (DgPerformOrderItemEo)this.performOrderItemDomain.getMapper().selectOne((Wrapper)queryItemEo);
        return this.fillItemResult(itemEo);
    }

    @Override
    public List<DgPerformOrderItemRespDto> selectList(DgPerformOrderItemReqDto performOrderItemReqDto) {
        return this.queryList(performOrderItemReqDto);
    }

    @Override
    public int insertBatch(List<DgPerformOrderItemReqDto> collection) {
        AssertUtils.isTrue((boolean)CollectionUtils.isNotEmpty(collection), (String)"\u6279\u91cf\u63d2\u5165\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList itemEos = new ArrayList();
        CubeBeanUtils.copyCollection(itemEos, collection, DgPerformOrderItemEo.class);
        return this.performOrderItemDomain.insertBatch(itemEos);
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsBySkuCodes(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(skuCodeList, (String)"skuCodeList \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemEo.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)saleOrderId)).in(DgPerformOrderItemEo::getSkuCode, skuCodeList);
        List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemEo);
        return saleOrderItemRespDtoList;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        return this.queryNormalItemsByOrderIds(Lists.newArrayList((Object[])new Long[]{orderId}));
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        AssertUtils.notEmpty(orderIdList, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderItemEo::getOrderId, orderIdList)).eq(DgPerformOrderItemEo::getStatus, (Object)SaleItemStatusEnum.NORMAL.getCode());
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        AssertUtils.notNull((Object)orderId, (String)"orderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notEmpty(orderItemIds, (String)"orderItemIds \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)orderId)).in(BaseEo::getId, orderItemIds);
        List list = this.performOrderItemDas.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList saleOrderItemRespDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)saleOrderItemRespDtos, (Collection)list, DgPerformOrderItemRespDto.class);
        return saleOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(List<Long> orderItemIds) {
        AssertUtils.notEmpty(orderItemIds, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderItemIds);
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public DgPerformOrderItemChangeVo insertBatchItemVo(DgPerformOrderItemChangeVo saleOrderItermChangeVo) {
        return this.performOrderItemDomain.insertBatchItemVo(saleOrderItermChangeVo);
    }

    @Override
    private List<DgPerformOrderItemRespDto> selectList(Wrapper<DgPerformOrderItemEo> queryWrapper) {
        List performOrderItemEos = this.performOrderItemDas.getMapper().selectList(queryWrapper);
        if (CollectionUtils.isEmpty((Collection)performOrderItemEos)) {
            return null;
        }
        ArrayList<DgPerformOrderItemRespDto> performOrderItemRespDtos = new ArrayList<DgPerformOrderItemRespDto>();
        CubeBeanUtils.copyCollection(performOrderItemRespDtos, (Collection)performOrderItemEos, DgPerformOrderItemRespDto.class);
        performOrderItemRespDtos.forEach(respDto -> this.fillItemResult((DgPerformOrderItemRespDto)respDto));
        return performOrderItemRespDtos;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItems(Long saleOrderId, List<String> skuCodeList) {
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderItemEo::getOrderId, (Object)saleOrderId)).eq(DgPerformOrderItemEo::getStatus, (Object)DgSaleItemStatusEnum.NORMAL.getCode());
        if (CollectionUtils.isNotEmpty(skuCodeList)) {
            queryOrderItemWrapper.in(DgPerformOrderItemEo::getSkuCode, skuCodeList);
        }
        List<DgPerformOrderItemRespDto> resultList = this.selectList((Wrapper<DgPerformOrderItemEo>)queryOrderItemWrapper);
        return resultList;
    }

    @Override
    public int optimisticModifySaleOrderItem(DgPerformOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgPerformOrderItemEo> queryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        return this.performOrderItemDomain.optimisticModifySaleOrderItem(saleOrderItemEo, queryWrapper, idealCount, needChangeItemNum, needThrow);
    }

    private DgPerformOrderItemRespDto fillItemResult(DgPerformOrderItemEo itemEo) {
        if (Objects.isNull(itemEo)) {
            return null;
        }
        DgPerformOrderItemRespDto respDto = new DgPerformOrderItemRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)itemEo, (String[])new String[0]);
        this.fillItemResult(respDto);
        return respDto;
    }

    private void fillItemResult(DgPerformOrderItemRespDto respDto) {
        if (Objects.isNull(respDto)) {
            return;
        }
        DgPerformOrderItemExtensionEo performOrderItemExtensionEo = this.performOrderItemExtensionDomain.selectByOrderItemId(respDto.getId());
        DgPerformOrderItemExtensionDto performOrderItemExtensionDto = new DgPerformOrderItemExtensionDto();
        CubeBeanUtils.copyProperties((Object)performOrderItemExtensionDto, (Object)performOrderItemExtensionEo, (String[])new String[0]);
        respDto.setPerformOrderItemExtensionDto(performOrderItemExtensionDto);
    }
}

