/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.dg;

import com.alibaba.fastjson.JSON;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderExtDomain;
import com.yunxi.dg.base.center.trade.domain.order.IOrderLabelExtDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgOrderLabelItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"perform.order.domain.dg.enable"}, havingValue="true")
public class DgOrderLabelExtDomainImpl
implements IOrderLabelExtDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOrderLabelExtDomainImpl.class);
    private static final Set<DgOrderLabelEnum> EXTENDS_LABEL = Sets.newHashSet((Object[])new DgOrderLabelEnum[]{DgOrderLabelEnum.PRE_SALE_ORDER, DgOrderLabelEnum.SALE_ORDER_CREATE, DgOrderLabelEnum.ITEM_GIFT, DgOrderLabelEnum.ITEM_COMBINATION, DgOrderLabelEnum.REFUND_ITEM});
    @Resource
    private IDgPerformOrderExtDomain performOrderDomain;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IDgOrderLabelRecordDomain labelRecordDomain;
    @Resource
    private IDgOrderLabelItemDomain labelItemDomain;

    @Override
    public void markSplitTag(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        this.labelRecordDomain.addOrderLabelRecord(saleOrderId, DgOrderLabelEnum.SPLIT);
    }

    @Override
    public void markSplitTagForChildOrder(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoDto performOrderInfoDto = this.performOrderDomain.queryBaseInfoById(saleOrderId);
        List<DgPerformOrderRespDto> childOrderList = this.performOrderDomain.queryChildByOriOrderNo(performOrderInfoDto.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            for (DgPerformOrderInfoDto dgPerformOrderInfoDto : childOrderList) {
                this.labelRecordDomain.addOrderLabelRecord(dgPerformOrderInfoDto.getId(), DgOrderLabelEnum.SPLIT);
            }
            log.info("[\u5b50\u8ba2\u5355\u6253\u6807]\u5b8c\u6210\u6253\u6807\u5b50\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(childOrderList));
        }
    }

    @Override
    public void markTagForChildOrder(Long saleOrderId) {
        AssertUtils.notNull((Object)saleOrderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoDto performOrderInfoDto = this.performOrderDomain.queryBaseInfoById(saleOrderId);
        List<DgPerformOrderRespDto> childOrderList = this.performOrderDomain.queryChildByOriOrderNo(performOrderInfoDto.getSaleOrderNo());
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            for (DgPerformOrderInfoDto dgPerformOrderInfoDto : childOrderList) {
                this.labelRecordDomain.addOrderLabelRecord(dgPerformOrderInfoDto.getId(), DgOrderLabelEnum.CHILD_ORDER);
            }
            log.info("[\u5b50\u8ba2\u5355\u6253\u6807]\u5b8c\u6210\u6253\u6807\u5b50\u8ba2\u5355\uff1a{}", (Object)JSON.toJSONString(childOrderList));
        }
    }

    @Override
    public void markLabelByExtendsParentOrder(List<DgPerformOrderRespDto> childOrderList) {
        if (CollectionUtils.isNotEmpty(childOrderList)) {
            DgPerformOrderRespDto saleOrderRespDto = childOrderList.get(0);
            DgBizPerformOrderRespDto parentOrder = this.performOrderDomain.queryBizDtoByOrderNo(saleOrderRespDto.getOriginalOrderNo());
            AssertUtils.notNull((Object)parentOrder, (String)"\u7236\u8ba2\u5355\u4e0d\u5b58\u5728");
            List extendsLabels = EXTENDS_LABEL.stream().map(DgOrderLabelEnum::getCode).collect(Collectors.toList());
            List labelRecordRespDtos = Optional.ofNullable(this.labelRecordDomain.queryByOrderIds(Lists.newArrayList((Object[])new Long[]{parentOrder.getId()}))).orElseGet(Collections::emptyList).stream().filter(orderLabelRecordRespDto -> extendsLabels.contains(orderLabelRecordRespDto.getLabelCode())).collect(Collectors.toList());
            List orderLabelItemRespDtos = Optional.ofNullable(this.labelItemDomain.queryByOrderId(parentOrder.getId())).orElseGet(Collections::emptyList).stream().filter(orderLabelRecordRespDto -> extendsLabels.contains(orderLabelRecordRespDto.getLabelCode())).collect(Collectors.toList());
            Map<Long, List<DgOrderLabelItemDto>> orderItemLabelMap = orderLabelItemRespDtos.stream().collect(Collectors.groupingBy(DgOrderLabelItemDto::getOrderItemId));
            log.info("[\u6807\u8bc6\u7ee7\u627f]\u5b50\u8ba2\u5355\u9700\u8981\u7ee7\u627f\u7236\u8ba2\u5355\u7684\u8ba2\u5355\u6807\u8bc6\u6709\uff1a{}\uff0c \u5546\u54c1\u884c\u7ee7\u627f\u7684\u6807\u8bc6\u6709\uff1a{}", (Object)JSON.toJSONString(labelRecordRespDtos), (Object)JSON.toJSONString(orderLabelItemRespDtos));
            List<Long> orderIdList = childOrderList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List<DgPerformOrderItemRespDto> saleOrderItemRespDtoList = this.performOrderItemDomain.queryOrderItemByOrderIds(orderIdList);
            AssertUtils.notEmpty(saleOrderItemRespDtoList, (String)"\u901a\u8fc7orderId\u83b7\u53d6\u4e0d\u5230\u5546\u54c1\u884c\u4fe1\u606f");
            Map<Long, List<DgPerformOrderItemDto>> orderItemMap = saleOrderItemRespDtoList.stream().collect(Collectors.groupingBy(DgPerformOrderItemDto::getOrderId));
            orderItemMap.forEach((orderId, saleOrderItemRespDtos) -> {
                log.info("[\u6807\u8bc6\u7ee7\u627f]\u8ba2\u5355id={}\uff0c \u8ba2\u5355\u9700\u8981\u7ee7\u627f\u7684\u6807\u8bc6\u6709\uff1a{}", orderId, (Object)JSON.toJSONString((Object)saleOrderItemRespDtos));
                labelRecordRespDtos.forEach(orderLabelRecordRespDto -> {
                    DgOrderLabelEnum orderLabelEnum = (DgOrderLabelEnum)DgOrderLabelEnum.CODE_LOOKUP.get(orderLabelRecordRespDto.getLabelCode());
                    this.labelRecordDomain.addOrderLabelRecord((Long)orderId, orderLabelEnum);
                });
                Optional.ofNullable(saleOrderItemRespDtos).ifPresent(saleOrderItemList -> saleOrderItemList.forEach(saleOrderItemRespDto -> {
                    List labelItemListOfNeedExtends = (List)orderItemLabelMap.get(saleOrderItemRespDto.getOriginalOrderItemId());
                    log.info("[\u6807\u8bc6\u7ee7\u627f]\u5546\u54c1\u884cid={}\uff0c \u9700\u8981\u7ee7\u627f\u7684\u6807\u8bc6\u6709\uff1a{}", (Object)saleOrderItemRespDto.getId(), (Object)JSON.toJSONString((Object)labelItemListOfNeedExtends));
                    if (CollectionUtils.isNotEmpty((Collection)labelItemListOfNeedExtends)) {
                        labelItemListOfNeedExtends.forEach(label -> {
                            DgOrderLabelEnum orderLabelEnum = (DgOrderLabelEnum)DgOrderLabelEnum.CODE_LOOKUP.get(label.getLabelCode());
                            this.labelItemDomain.addOrderLabelItem((Long)orderId, saleOrderItemRespDto.getId(), orderLabelEnum);
                        });
                    }
                }));
            });
        }
    }

    @Override
    public void markVirtualOrderLabel(Long orderId) {
        log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u865a\u62df\u8ba2\u5355\u6807\u8bc6", (Object)orderId);
        this.labelRecordDomain.addOrderLabelRecord(orderId, DgOrderLabelEnum.VIRTUAL_ORDER);
    }

    @Override
    public void markOrderGiftByOrderId(DgPerformOrderRespDto respDto) {
        this.labelRecordDomain.addOrderLabelRecord(respDto.getId(), DgOrderLabelEnum.ITEM_GIFT);
    }

    @Override
    public void markOrderSourcePromotion(DgBizPerformOrderReqDto reqDto) {
        if (DgSaleOrderSourceEnum.PROMOTION.getType().equals(reqDto.getOrderSource())) {
            log.info("[\u6253\u6807]\u8ba2\u5355={},\u6253\u6267\u884c\u4fc3\u9500\u6d3b\u52a8\u8ba2\u5355\u6807\u8bc6", (Object)reqDto.getId());
            this.labelRecordDomain.addOrderLabelRecord(reqDto.getId(), DgOrderLabelEnum.ORDER_PROMOTION);
        }
    }
}

