/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.impl.tc;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryDetailResultDto;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OutDeliveryResultReqDto;
import com.github.pagehelper.PageInfo;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.yunxi.dg.base.center.trade.dao.das.IDgSaleOrderItemDas;
import com.yunxi.dg.base.center.trade.domain.order.IDgPerformOrderItemExtDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderItemModifyReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgSplitOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.tc.TcPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemExtRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderItemRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemEo;
import com.yunxi.dg.base.center.trade.eo.DgSaleOrderItemEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.center.trade.vo.DgPerformOrderItemChangeVo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"perform.order.domain.tc.enable"}, havingValue="true")
public class DgTcPerformOrderItemExtDomainImpl
implements IDgPerformOrderItemExtDomain {
    private static final Logger LOGGER = LoggerFactory.getLogger(DgTcPerformOrderItemExtDomainImpl.class);
    @Resource
    private IDgSaleOrderItemDas dgSaleOrderItemDas;

    @Override
    public DgPerformOrderItemRespDto queryById(Long orderId) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryList(DgPerformOrderItemReqDto reqDto) {
        return null;
    }

    @Override
    public PageInfo<DgPerformOrderItemExtRespDto> queryPageById(Long orderId, Integer pageNum, Integer pageSize) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderId(Long orderId) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List orderItemEos = this.dgSaleOrderItemDas.getMapper().selectList((Wrapper)queryItemWrapper);
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)orderItemEos, DgPerformOrderItemRespDto.class);
        return list;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderIds(List<Long> orderIdList) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsBySkuCodes(Long saleOrderId, List<String> skuCodeList) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemByOrderId(Long orderId) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItemsByOrderIds(List<Long> orderIdList) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(Long orderId, List<Long> orderItemIds) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryOrderItemByOrderItemIds(List<Long> orderItemIds) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> queryNormalItems(Long saleOrderId, List<String> skuCodeList) {
        return null;
    }

    @Override
    public void createSplitOrderItem(DgPerformOrderInfoEo oriSaleOrder, DgPerformOrderInfoEo childSaleOrder, List<DgSplitOrderItemReqDto> goodsList) {
    }

    @Override
    public int optimisticModifySaleOrderItem(DgPerformOrderItemEo saleOrderItemEo, LambdaQueryWrapper<DgPerformOrderItemEo> queryWrapper, int idealCount, Integer needChangeItemNum, boolean needThrow) {
        return 0;
    }

    @Override
    public DgPerformOrderItemChangeVo insertBatchItemVo(DgPerformOrderItemChangeVo saleOrderItermChangeVo) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)saleOrderItermChangeVo.getPerformOrderItemRespDtos(), (String)"\u8ba2\u5355\u5546\u54c1\u8d27\u54c1\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList list = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)list, (Collection)saleOrderItermChangeVo.getPerformOrderItemRespDtos(), DgSaleOrderItemEo.class);
        this.dgSaleOrderItemDas.insertBatch((List)list);
        return saleOrderItermChangeVo;
    }

    @Override
    public void modifyOrderItemAmount(List<DgPerformOrderItemReqDto> shipmentItemDtos) {
    }

    @Override
    public int insert(DgPerformOrderItemReqDto dgPerformOrderItemReqDto) {
        return 0;
    }

    @Override
    public int updateSelective(DgPerformOrderItemReqDto performOrderItemReqDto) {
        return 0;
    }

    @Override
    public void reducePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
    }

    @Override
    public void releasePerformOrderReturnItemNum(Long saleOrderId, List<DgAfterSaleOrderItemModifyReqDto> itemReqDtoList) {
    }

    @Override
    public void logicDelete(DgPerformOrderItemReqDto dgPerformOrderItemReqDto) {
    }

    @Override
    public void logicDeleteById(Long id) {
    }

    @Override
    public DgPerformOrderItemRespDto selectByPrimaryKey(Long id) {
        return null;
    }

    @Override
    public DgPerformOrderItemRespDto selectOne(DgPerformOrderItemReqDto dgPerformOrderItemReqDto) {
        return null;
    }

    @Override
    public List<DgPerformOrderItemRespDto> selectList(DgPerformOrderItemReqDto dgPerformOrderItemReqDto) {
        return null;
    }

    @Override
    public int insertBatch(List<DgPerformOrderItemReqDto> collection) {
        return 0;
    }

    @Override
    public BigDecimal getOrderOutDeliveredCount(Long orderId) {
        LambdaQueryWrapper queryItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryItemWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)orderId);
        List saleOrderItemEos = this.dgSaleOrderItemDas.getMapper().selectList((Wrapper)queryItemWrapper);
        AssertUtils.notEmpty(saleOrderItemEos, "\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        BigDecimal totalOutDeliveryCount = saleOrderItemEos.stream().filter(Objects::nonNull).map(item -> Optional.ofNullable(item.getOutItemNum()).orElse(BigDecimal.ZERO)).reduce(BigDecimal.ZERO, BigDecimal::add);
        totalOutDeliveryCount = Optional.ofNullable(totalOutDeliveryCount).orElse(BigDecimal.ZERO);
        return totalOutDeliveryCount;
    }

    @Override
    public void modifyOrderItemOutDeliveredResult(DgPerformOrderReqDto dgPerformOrderReqDto) {
        TcPerformOrderReqDto tcPerformOrderReqDto = (TcPerformOrderReqDto)dgPerformOrderReqDto;
        Long saleOrderId = tcPerformOrderReqDto.getId();
        OutDeliveryResultReqDto reqDto = tcPerformOrderReqDto.getOutDeliveryResultReqDto();
        com.yunxi.dg.base.commons.utils.AssertUtils.notEmpty((Collection)reqDto.getDeliveryDetailList(), (String)"\u51fa\u5e93\u5546\u54c1\u4e3a\u7a7a");
        LambdaQueryWrapper queryItemEo = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryItemEo.eq(BaseEo::getDr, (Object)0)).eq(DgSaleOrderItemEo::getOrderId, (Object)saleOrderId)).orderByAsc((Object[])new SFunction[]{BaseEo::getId, DgSaleOrderItemEo::getGift});
        List saleOrderItemEos = this.dgSaleOrderItemDas.getMapper().selectList((Wrapper)queryItemEo);
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u539f\u5546\u54c1\u5217\u8868\u4e3a\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderItemEos));
        AssertUtils.notEmpty(saleOrderItemEos, "\u8ba2\u5355\u5546\u54c1\u4e0d\u5b58\u5728");
        Map<String, Map<String, BigDecimal>> longCodeGroupMap = reqDto.getDeliveryDetailList().stream().collect(Collectors.groupingBy(OutDeliveryDetailResultDto::getLongCode, Collectors.collectingAndThen(Collectors.toList(), saveOrderItems -> {
            Map<String, BigDecimal> batchCountMap = saveOrderItems.stream().collect(Collectors.groupingBy(OutDeliveryDetailResultDto::getBatch, Collectors.collectingAndThen(Collectors.toList(), batchOutDeliveryDetailResults -> batchOutDeliveryDetailResults.stream().filter(Objects::nonNull).map(OutDeliveryDetailResultDto::getOutQuantity).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add))));
            return batchCountMap;
        })));
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u56de\u4f20\u5206\u7ec4\u5904\u7406\u540e\u7684\u6570\u636e\u4e3a\uff1a{}", (Object)JSON.toJSONString(longCodeGroupMap));
        HashMap outDeliveredMap = Maps.newHashMap();
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u51fa\u5e93\u5339\u914d\u987a\u5e8f\uff1a{}", (Object)JSON.toJSONString((Object)saleOrderItemEos));
        HashMap outDeliveredResultMap = Maps.newHashMap();
        this.expectOutDelivery(saleOrderItemEos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap);
        this.updateOutDeliveryResult(outDeliveredResultMap);
    }

    private void updateOutDeliveryResult(Map<Long, DgSaleOrderItemEo> outDeliveredResultMap) {
        List<DgSaleOrderItemEo> updateOrderItemEos = outDeliveredResultMap.entrySet().stream().map(Map.Entry::getValue).collect(Collectors.toList());
        updateOrderItemEos.sort(Comparator.comparing(BaseEo::getId));
        updateOrderItemEos.forEach(updateOrderItemEo -> this.dgSaleOrderItemDas.updateSelective((BaseEo)updateOrderItemEo));
    }

    private void expectOutDelivery(List<DgSaleOrderItemEo> saleOrderItemEos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgSaleOrderItemEo> outDeliveredResultMap) {
        saleOrderItemEos.sort(Comparator.comparing(DgSaleOrderItemEo::getGift));
        this.scanOrderItems(saleOrderItemEos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, saleOrderItemEo) -> {
            BigDecimal batchCount;
            if (batchCountMap != null && (batchCount = (BigDecimal)batchCountMap.get(saleOrderItemEo.getDeliveryItemBatchNo())) != null) {
                this.deductOutDelivery(outDeliveredMap, (DgSaleOrderItemEo)saleOrderItemEo, saleOrderItemEo.getDeliveryItemBatchNo(), batchCount, outDeliveredResultMap);
            }
        });
        this.scanOrderItems(saleOrderItemEos, longCodeGroupMap, outDeliveredMap, outDeliveredResultMap, (batchCountMap, saleOrderItemEo) -> {
            if (batchCountMap != null) {
                batchCountMap.forEach((batchNo, count) -> this.deductOutDelivery(outDeliveredMap, (DgSaleOrderItemEo)saleOrderItemEo, (String)batchNo, (BigDecimal)count, outDeliveredResultMap));
            }
        });
    }

    private void deductOutDelivery(Map<String, Map<String, BigDecimal>> outDeliveredMap, DgSaleOrderItemEo saleOrderItemEo, String deliveryItemBatchNo, BigDecimal batchCount, Map<Long, DgSaleOrderItemEo> outDeliveredResultMap) {
        BigDecimal availableCount = this.calAvailableCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, batchCount);
        BigDecimal needCount = saleOrderItemEo.getItemNum().subtract(Optional.ofNullable(saleOrderItemEo.getOutItemNum()).orElse(BigDecimal.ZERO));
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u53ef\u7528\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}\uff0c\u9700\u8981\u51fa\u5e93\u6570\u91cf\u4e3a\uff1a{}", (Object)availableCount, (Object)needCount);
        BigDecimal outItemNum = saleOrderItemEo.getOutItemNum() == null ? BigDecimal.ZERO : saleOrderItemEo.getOutItemNum();
        saleOrderItemEo.setOutItemNum(outItemNum);
        if (availableCount.compareTo(needCount) >= 0) {
            LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u5df2\u5168\u90e8\u51fa\u5e93", (Object)saleOrderItemEo.getId());
            this.updateItemOutDeliveryCount(saleOrderItemEo.getId(), saleOrderItemEo.getItemNum(), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, needCount);
        } else if (BigDecimal.ZERO.compareTo(availableCount) < 0) {
            LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u5546\u54c1orderItemId={},\u90e8\u5206\u51fa\u5e93\uff0c\u5df2\u51fa\u5e93\u6570\u91cf\u4e3a\uff1aoutItemNum={}\uff0cavailableCount={}", new Object[]{saleOrderItemEo.getId(), saleOrderItemEo.getOutItemNum(), availableCount});
            this.updateItemOutDeliveryCount(saleOrderItemEo.getId(), saleOrderItemEo.getOutItemNum().add(availableCount), outDeliveredResultMap);
            this.calDeliveredCount(outDeliveredMap, saleOrderItemEo.getSkuCode(), deliveryItemBatchNo, availableCount);
        }
    }

    private void scanOrderItems(List<DgSaleOrderItemEo> saleOrderItemEos, Map<String, Map<String, BigDecimal>> longCodeGroupMap, Map<String, Map<String, BigDecimal>> outDeliveredMap, Map<Long, DgSaleOrderItemEo> outDeliveredResultMap, BiConsumer<Map<String, BigDecimal>, DgSaleOrderItemEo> callHandle) {
        for (DgSaleOrderItemEo saleOrderItemEo : saleOrderItemEos) {
            if (saleOrderItemEo.getItemNum().equals(saleOrderItemEo.getOutItemNum())) {
                LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u8ba2\u5355\u5546\u54c1\u884cid\u4e3a{}\u5df2\u5168\u90e8\u51fa\u5e93", (Object)saleOrderItemEo.getId());
                continue;
            }
            Map<String, BigDecimal> batchCountMap = longCodeGroupMap.get(saleOrderItemEo.getSkuCode());
            callHandle.accept(batchCountMap, saleOrderItemEo);
        }
    }

    private void calDeliveredCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String skuCode, String batchNo, BigDecimal count) {
        HashMap batchCountMap = outDeliveredMap.get(skuCode);
        if (batchCountMap == null) {
            batchCountMap = Maps.newHashMap();
            batchCountMap.put(batchNo, count);
            outDeliveredMap.put(skuCode, batchCountMap);
        } else {
            BigDecimal usedCount = Optional.ofNullable(batchCountMap.get(batchNo)).orElse(BigDecimal.ZERO).add(count);
            batchCountMap.put(batchNo, usedCount);
        }
        LOGGER.info("[\u51fa\u5e93\u56de\u4f20]\u5df2\u51fa\u5e93\u7684\u8bb0\u5f55\u7edf\u8ba1\uff1a{}", (Object)JSON.toJSONString((Object)batchCountMap));
    }

    private BigDecimal calAvailableCount(Map<String, Map<String, BigDecimal>> outDeliveredMap, String longCode, String batchNo, BigDecimal batchCount) {
        Map<String, BigDecimal> batchCountMap = outDeliveredMap.get(longCode);
        if (batchCountMap == null) {
            return batchCount;
        }
        BigDecimal count = batchCountMap.get(batchNo);
        if (count != null) {
            return batchCount.subtract(count);
        }
        return batchCount;
    }

    private void updateItemOutDeliveryCount(Long orderItemId, BigDecimal outDeliveryCount, Map<Long, DgSaleOrderItemEo> outDeliveredResultMap) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)orderItemId, (String)"orderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        outDeliveredResultMap.compute(orderItemId, (k, updateItemEo) -> {
            if (updateItemEo == null) {
                updateItemEo = new DgSaleOrderItemEo();
                updateItemEo.setOutItemNum(outDeliveryCount);
                updateItemEo.setId(orderItemId);
                return updateItemEo;
            }
            BigDecimal totalDeliveryCount = updateItemEo.getOutItemNum().add(outDeliveryCount);
            updateItemEo.setOutItemNum(totalDeliveryCount);
            return updateItemEo;
        });
    }
}

