/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.cache;

import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.core.toolkit.support.SerializedLambda;
import com.dtyunxi.huieryun.cache.api.ICacheService;
import com.yunxi.dg.base.center.trade.cache.CachesStrategy;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class AbstractCache {
    protected ICacheService cacheService;
    protected CacheManager cacheManager;
    protected Cache cache;

    AbstractCache() {
    }

    public <T> List<String> getColumnNames(SFunction<T, ?> ... columns) {
        List<String> columnNameList = Arrays.stream(columns).map(item -> {
            SerializedLambda lambda = LambdaUtils.resolve((SFunction)item);
            return lambda.getImplMethodName();
        }).collect(Collectors.toList());
        return columnNameList;
    }

    public String getCacheKey(String cacheKey) {
        Object key = this.cache.get((Object)cacheKey).get();
        if (key != null) {
            return (String)key;
        }
        return null;
    }

    public <T> void setLocalCache(String key, T entity, CachesStrategy cachesStrategy) {
        Cache cache = this.cacheManager.getCache(cachesStrategy.name());
        cache.put((Object)key, entity);
    }

    public <T> T getLocalCache(String key, Class<T> clzz, CachesStrategy cachesStrategy) {
        Cache cache = this.cacheManager.getCache(cachesStrategy.name());
        Object v = cache.get((Object)Optional.ofNullable(key).orElse(""), clzz);
        if (v != null) {
            return (T)v;
        }
        return null;
    }

    public void cleanLocalCache(String key, CachesStrategy cachesStrategy) {
        Cache cache = this.cacheManager.getCache(cachesStrategy.name());
        cache.evictIfPresent((Object)key);
    }

    public <T> void setCache(String key, T entity, int seconds) {
        this.cacheService.setCache(key, entity, seconds);
    }

    public <T> void setCache(String key, T entity, CachesStrategy cachesStrategy) {
        this.setCache(key, entity, cachesStrategy.getTtl());
    }

    public <T> T getCache(String key, Class<T> clzz) {
        return (T)this.cacheService.getCache(key, clzz);
    }

    public void cleanCache(String key) {
        this.cacheService.delCache(key);
    }
}

