/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.util.IdGenrator;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemLineAmountDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderItemLineDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IOrderLineReleationItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.oms.DgOmsOrderItemLineAmoutReqDto;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.enums.ItemLineCancelStatusEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.OrderLineReleationItemLineEo;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgPerformOrderItemLineDomainImpl
extends BaseDomainImpl<DgPerformOrderItemLineEo>
implements IDgPerformOrderItemLineDomain {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderItemLineDomainImpl.class);
    private static final Integer BATCH_INSERT_THRESHOLD = 2000;
    @Resource
    private IDgOmsOrderCalculatorAmountModeDomain omsOrderAmountCalculatorModeDomain;
    @Resource
    private IOrderLineReleationItemLineDomain orderLineReleationItemLineDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain performOrderItemLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDas das;
    @Resource
    private IDgPerformOrderItemLineAmountDas amountDas;

    public ICommonDas<DgPerformOrderItemLineEo> commonDas() {
        return this.das;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByOrderId(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(DgPerformOrderItemLineEo::getOrderId, (Object)orderId)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return performOrderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByOrderIds(List<Long> orderIds) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.in(DgPerformOrderItemLineEo::getOrderId, orderIds)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return performOrderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryInfoByOrderId(Long orderId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(DgPerformOrderItemLineEo::getOrderId, (Object)orderId)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList<DgPerformOrderItemLineDto> performOrderItemLineDtos = new ArrayList<DgPerformOrderItemLineDto>();
        CubeBeanUtils.copyCollection(performOrderItemLineDtos, (Collection)performOrderItemLineEos, DgPerformOrderItemLineDto.class);
        this.selectReleationInfoList(performOrderItemLineDtos);
        return performOrderItemLineDtos;
    }

    private void selectReleationInfoList(List<DgPerformOrderItemLineDto> performOrderItemLineDtos) {
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(performOrderItemLineDtos)) {
            List<DgPerformOrderItemLineAmountDto> orderItemLineAmountDtos = this.performOrderItemLineAmountDomain.queryByOrderItemLineIds(performOrderItemLineDtos.stream().map(BaseDto::getId).collect(Collectors.toList()));
            if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderItemLineAmountDtos)) {
                Map<Long, List<DgPerformOrderItemLineAmountDto>> orderItemLineAmountMap = orderItemLineAmountDtos.stream().collect(Collectors.groupingBy(DgPerformOrderItemLineAmountDto::getOrderItemLineId));
                performOrderItemLineDtos.forEach(orderItemLine -> {
                    List amountDtoList = (List)orderItemLineAmountMap.get(orderItemLine.getId());
                    orderItemLine.setPerformOrderItemLineAmountDtoList(amountDtoList);
                });
            } else {
                log.error("\u5546\u54c1\u884c\u91d1\u989d\u4fe1\u606f\u4e0d\u5b58\u5728");
            }
        } else {
            log.error("\u5546\u54c1\u884c\u4fe1\u606f\u4e0d\u5b58\u5728");
        }
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryInfoByOrderIds(List<Long> orderIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderIds)) {
            return com.google.common.collect.Lists.newArrayList();
        }
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.in(DgPerformOrderItemLineEo::getOrderId, orderIds)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        ArrayList<DgPerformOrderItemLineDto> performOrderItemLineDtos = new ArrayList<DgPerformOrderItemLineDto>();
        CubeBeanUtils.copyCollection(performOrderItemLineDtos, (Collection)performOrderItemLineEos, DgPerformOrderItemLineDto.class);
        this.selectReleationInfoList(performOrderItemLineDtos);
        return performOrderItemLineDtos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByOrderLineId(Long orderLineId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.eq(DgPerformOrderItemLineEo::getOrderLineId, (Object)orderLineId)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return performOrderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryAllItemLineByOrderLineId(Long orderLineId) {
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderItemWrapper.eq(DgPerformOrderItemLineEo::getOrderLineId, (Object)orderLineId)).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return performOrderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByOrderLineIds(List<Long> orderLineIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderLineIds)) {
            return new ArrayList<DgPerformOrderItemLineEo>(0);
        }
        LambdaQueryWrapper queryOrderItemWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderItemWrapper.in(DgPerformOrderItemLineEo::getOrderLineId, orderLineIds)).eq(DgPerformOrderItemLineEo::getShFlag, (Object)YesOrNoEnum.NO.getType())).eq(BaseEo::getDr, (Object)0);
        List performOrderItemLineEos = this.das.getMapper().selectList((Wrapper)queryOrderItemWrapper);
        return performOrderItemLineEos;
    }

    @Override
    public void deleteByOrderId(Long orderId) {
        this.das.deleteByOrderId(orderId);
    }

    @Override
    public void singleMode(List<DgPerformOrderLineEo> orderLineEos, List<DgPerformOrderLineAmountEo> amountEos) {
        List orderItemLines;
        Map<Long, List<DgPerformOrderLineAmountEo>> orderLineAmountMap = amountEos.stream().collect(Collectors.groupingBy(DgPerformOrderLineAmountEo::getOrderLineId));
        ArrayList<DgPerformOrderItemLineEo> batchInsertEoList = new ArrayList<DgPerformOrderItemLineEo>();
        ArrayList<DgPerformOrderItemLineAmountEo> amountEoList = new ArrayList<DgPerformOrderItemLineAmountEo>();
        ArrayList<OrderLineReleationItemLineEo> batchReleationInsertEoList = new ArrayList<OrderLineReleationItemLineEo>();
        List channelOrderLineIds = orderLineEos.stream().map(DgPerformOrderLineEo::getPlatformOrderItemNo).collect(Collectors.toList());
        Map<Object, Object> orderItemLineIdMap = new HashMap();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(channelOrderLineIds) && org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)(orderItemLines = ((ExtQueryChainWrapper)this.filter().in((Object)"order_line_id", channelOrderLineIds)).select(new String[]{"id", "order_line_id"}).list()))) {
            orderItemLineIdMap = orderItemLines.stream().collect(Collectors.toMap(dgPerformOrderItemLineEo -> dgPerformOrderItemLineEo.getOrderLineId().toString(), BaseEo::getId));
        }
        for (DgPerformOrderLineEo orderLineEo : orderLineEos) {
            log.info("\u5546\u54c1{} \u7684\u8ba1\u4ef7\u6570\u91cf\u662f {} ", (Object)orderLineEo.getSkuCode(), (Object)orderLineEo.getCalcItemNum());
            DgPerformOrderItemLineEo orderItemLineEo = new DgPerformOrderItemLineEo();
            CubeBeanUtils.copyProperties((Object)orderItemLineEo, (Object)orderLineEo, (String[])new String[0]);
            Long id = IdGenrator.getDistributedId();
            orderItemLineEo.setId(id);
            orderItemLineEo.setOrderId(orderLineEo.getOrderId());
            orderItemLineEo.setOrderNo(orderLineEo.getOrderNo());
            if (ObjectUtil.isNotEmpty(orderItemLineIdMap) && ObjectUtil.isNotEmpty((Object)orderItemLineIdMap.get(orderItemLineEo.getPlatformOrderItemNo()))) {
                orderItemLineEo.setPlatformOrderItemNo(((Long)orderItemLineIdMap.get(orderItemLineEo.getPlatformOrderItemNo())).toString());
            }
            orderItemLineEo.setOrderLineId(orderLineEo.getId());
            orderItemLineEo.setItemNum(orderLineEo.getItemNum());
            orderItemLineEo.setCalcItemNum(orderLineEo.getCalcItemNum());
            batchInsertEoList.add(orderItemLineEo);
            OrderLineReleationItemLineEo orderLineReleationItemLineEo = new OrderLineReleationItemLineEo();
            orderLineReleationItemLineEo.setOrderLineId(orderLineEo.getId());
            orderLineReleationItemLineEo.setOrderItemLineId(id);
            batchReleationInsertEoList.add(orderLineReleationItemLineEo);
            List<DgPerformOrderLineAmountEo> orderLineAmounts = orderLineAmountMap.get(orderItemLineEo.getOrderLineId());
            for (DgPerformOrderLineAmountEo orderLineAmount : orderLineAmounts) {
                DgPerformOrderItemLineAmountEo orderItemLineAmountEo = new DgPerformOrderItemLineAmountEo();
                CubeBeanUtils.copyProperties((Object)orderItemLineAmountEo, (Object)orderLineAmount, (String[])new String[]{"id"});
                orderItemLineAmountEo.setOrderItemLineId(id);
                if (DgOrderAmountSourceEnum.ORDER_LINE_BASE.getCode().equals(orderLineAmount.getAmountSource())) {
                    orderItemLineAmountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
                    switch (orderLineAmount.getAccountType()) {
                        case "LINE_SALE_TOTAL": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_SALE_TOTAL.getCode());
                            break;
                        }
                        case "LINE_ORIG_PRICE": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_ORIG_PRICE.getCode());
                            break;
                        }
                        case "LINE_ACTUAL_PRICE": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_ACTUAL_PRICE.getCode());
                            break;
                        }
                        case "LINE_DISCOUNT_AMOUNT": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_DISCOUNT_AMOUNT.getCode());
                            break;
                        }
                        case "LINE_SUPPLY_PRICE": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_SUPPLY_PRICE.getCode());
                            break;
                        }
                        case "LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
                            break;
                        }
                        case "LINE_SETTLEMENT_AMOUNT": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_SETTLEMENT_AMOUNT.getCode());
                            break;
                        }
                        case "LINE_COST_AMOUNT": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_COST_AMOUNT.getCode());
                            break;
                        }
                        case "LINE_HANDMADE_DISCOUNT_AMOUNT": {
                            orderItemLineAmountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_LINE_HANDMADE_DISCOUNT_AMOUNT.getCode());
                        }
                    }
                }
                amountEoList.add(orderItemLineAmountEo);
            }
        }
        this.insertBatchItems(batchInsertEoList);
        this.insertBatchItemAmount(amountEoList);
        this.orderLineReleationItemLineDomain.insertBatch(batchReleationInsertEoList);
    }

    @Override
    public void multilineMode(DgPerformOrderLineEo orderLineEo, DgOmsOrderItemLineAmoutReqDto amoutReqDto, DgPerformOrderLineDetailDto dgPerformOrderLineDetailDto) {
        String homeInstallation = dgPerformOrderLineDetailDto.getHomeInstallation();
        ArrayList batchInsertEoList = new ArrayList();
        ArrayList amountEoList = new ArrayList();
        ArrayList<OrderLineReleationItemLineEo> batchReleationInsertEoList = new ArrayList<OrderLineReleationItemLineEo>();
        log.info("\u5546\u54c1{} \u7684\u6570\u91cf\u662f {} ", (Object)orderLineEo.getSkuCode(), (Object)orderLineEo.getCalcItemNum());
        for (int i = 0; i < orderLineEo.getCalcItemNum().intValue(); ++i) {
            DgPerformOrderItemLineEo orderItemLineEo = new DgPerformOrderItemLineEo();
            CubeBeanUtils.copyProperties((Object)orderItemLineEo, (Object)orderLineEo, (String[])new String[0]);
            Long id = IdGenrator.getDistributedId();
            orderItemLineEo.setId(id);
            orderItemLineEo.setOrderId(orderLineEo.getOrderId());
            orderItemLineEo.setOrderNo(orderLineEo.getOrderNo());
            orderItemLineEo.setOrderLineId(orderLineEo.getId());
            orderItemLineEo.setItemNum(BigDecimal.ONE);
            orderItemLineEo.setCalcItemNum(BigDecimal.ONE);
            orderItemLineEo.setHomeInstallation(homeInstallation);
            batchInsertEoList.add((DgPerformOrderItemLineEo)orderItemLineEo);
            List<DgPerformOrderItemLineAmountEo> subAmounts = this.omsOrderAmountCalculatorModeDomain.calculatorItemLineAmountForCreate(orderItemLineEo, amoutReqDto, i, id);
            amountEoList.addAll(subAmounts);
            if (batchInsertEoList.size() >= BATCH_INSERT_THRESHOLD) {
                this.insertBatchItems(batchInsertEoList);
                this.insertBatchItemAmount(amountEoList);
                batchInsertEoList = com.google.common.collect.Lists.newArrayList();
                amountEoList = com.google.common.collect.Lists.newArrayList();
            }
            OrderLineReleationItemLineEo orderLineReleationItemLineEo = new OrderLineReleationItemLineEo();
            orderLineReleationItemLineEo.setOrderLineId(orderLineEo.getId());
            orderLineReleationItemLineEo.setOrderItemLineId(id);
            batchReleationInsertEoList.add(orderLineReleationItemLineEo);
        }
        this.insertBatchItems(batchInsertEoList);
        this.insertBatchItemAmount(amountEoList);
        this.orderLineReleationItemLineDomain.insertBatch(batchReleationInsertEoList);
    }

    @Override
    public void removeOrderItem(DgPerformOrderItemLineDto modifyOrderLineRowDto) {
        com.yunxi.dg.base.commons.utils.AssertUtils.notNull((Object)modifyOrderLineRowDto.getOrderLineId(), (String)"belongOrderItemId \u4e0d\u80fd\u4e3a\u7a7a");
        UpdateWrapper wrapper = new UpdateWrapper();
        wrapper.eq((Object)"order_line_id", (Object)modifyOrderLineRowDto.getOrderLineId());
        wrapper.set((Object)"dr", (Object)1);
        this.das.getMapper().delete((Wrapper)wrapper);
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryAfsItemLineDtosBySaleItemLineIds(List<Long> orderItemLineIds, List<String> reufndStatusList) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderItemLineIds), (String)"\u53c2\u6570ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sh_flag", (Object)YesOrNoEnum.YES.getType())).in((Object)"sh_releation_item_line_id", orderItemLineIds)).notIn((Object)"refund_status", reufndStatusList)).eq((Object)"dr", (Object)0)).list();
        ArrayList list = com.google.common.collect.Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderItemLineEos)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        }
        return list;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByAfterOrderId(Long afsId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((afsId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_id", (Object)afsId)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByAfterOrderItemId(Long afsiId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((afsiId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_item_id", (Object)afsiId)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByAfterOrderIds(List<Long> afsOrderIdList) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(afsOrderIdList), (String)"\u53c2\u6570\u552e\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"after_sale_order_id", afsOrderIdList)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineByAfsOrderItemIds(List<Long> orderLineIdList) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderLineIdList), (String)"\u53c2\u6570\u552e\u540e\u8ba2\u5355\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).eq((Object)"sh_flag", (Object)YesOrNoEnum.YES.getType())).in((Object)"order_line_id", orderLineIdList)).list();
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryAfsItemLineDtosByAfsOrderLineIds(List<Long> orderLineIds, List<Long> afsOrderIds) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderLineIds), (String)"\u53c2\u6570ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sh_flag", (Object)YesOrNoEnum.YES.getType())).in((Object)"order_line_id", orderLineIds)).in((Object)"after_sale_order_id", afsOrderIds)).eq((Object)"dr", (Object)0)).list();
        ArrayList list = com.google.common.collect.Lists.newArrayList();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty((Collection)orderItemLineEos)) {
            CubeBeanUtils.copyCollection((Collection)list, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        }
        return list;
    }

    @Override
    public List<DgPerformOrderItemLineDto> queryItemLineDtosByOrderLineIds(List<Long> orderLineIds) {
        AssertUtils.isFalse(CollectionUtils.isEmpty(orderLineIds), "\u53c2\u6570\u9500\u552e\u8ba2\u5355\u884cID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderLineReleationItemLineDomain.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)releationItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u884c\u4e0e\u5546\u54c1\u884c\u5173\u8054\u5173\u7cfb");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)0)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        ArrayList orderItemLineDtos = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)orderItemLineDtos, (Collection)orderItemLineEos, DgPerformOrderItemLineDto.class);
        Map releationItemLineEoMap = releationItemLineEos.stream().collect(Collectors.toMap(OrderLineReleationItemLineEo::getOrderItemLineId, Function.identity()));
        for (DgPerformOrderItemLineDto orderItemLineDto : orderItemLineDtos) {
            orderItemLineDto.setOrderLineId(((OrderLineReleationItemLineEo)releationItemLineEoMap.get(orderItemLineDto.getId())).getOrderLineId());
        }
        return orderItemLineDtos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryItemLineEosByOrderId(Long orderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<DgPerformOrderLineEo> dgPerformOrderLineEos = this.dgPerformOrderLineDomain.queryEosByOrderId(orderId);
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(dgPerformOrderLineEos), (String)"\u4e3a\u627e\u5230\u8ba2\u5355\u5173\u8054\u7684\u8ba2\u5355\u884c\u4fe1\u606f");
        List orderLineIds = dgPerformOrderLineEos.stream().map(BaseEo::getId).collect(Collectors.toList());
        List releationItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.orderLineReleationItemLineDomain.filter().in((Object)"order_line_id", orderLineIds)).eq((Object)"dr", (Object)0)).list();
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty((Collection)releationItemLineEos), (String)"\u672a\u627e\u5230\u8ba2\u5355\u884c\u5173\u8054\u7684\u5546\u54c1\u884c\u4fe1\u606f");
        List orderItemLineIds = releationItemLineEos.stream().map(OrderLineReleationItemLineEo::getOrderItemLineId).collect(Collectors.toList());
        List orderItemLineEos = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"id", orderItemLineIds)).eq((Object)"sh_flag", (Object)0)).eq((Object)"dr", (Object)0)).list();
        AssertUtils.isFalse(CollectionUtils.isEmpty((Collection)orderItemLineEos), "\u672a\u627e\u5230\u9500\u552e\u8ba2\u5355\u5546\u54c1\u884c\u4fe1\u606f");
        return orderItemLineEos;
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryByOrderId(Long orderId) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"order_id", (Object)orderId)).eq((Object)"dr", (Object)0)).eq((Object)"sh_flag", (Object)YesOrNoEnum.NO.getType())).list();
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryByOrderIds(List<Long> orderIds) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderIds)) {
            return Collections.emptyList();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"order_id", orderIds)).eq((Object)"dr", (Object)0)).eq((Object)"sh_flag", (Object)YesOrNoEnum.NO.getType())).list();
    }

    @Override
    public void cancelItemLine(Long id) {
        if (id != null) {
            DgPerformOrderItemLineEo itemLineEo = new DgPerformOrderItemLineEo();
            itemLineEo.setId(id);
            itemLineEo.setCancelStatus(ItemLineCancelStatusEnum.YES.getType());
            this.das.updateSelective((BaseEo)itemLineEo);
        }
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryAfsItemLineEosByAfsOrderId(Long afsOrderId) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((afsOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u552e\u540e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_id", (Object)afsOrderId)).list();
    }

    private void insertBatchItems(List<DgPerformOrderItemLineEo> batchInsertEos) {
        long start = System.currentTimeMillis();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(batchInsertEos)) {
            this.das.insertBatch(batchInsertEos);
        }
        long end = System.currentTimeMillis();
        log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u5f53\u524d\u63d2\u5165:{}\u6761\uff0c\u8017\u65f6\uff1a{}", (Object)batchInsertEos.size(), (Object)(end - start));
    }

    private void insertBatchItemAmount(List<DgPerformOrderItemLineAmountEo> batchInsertEos) {
        long start = System.currentTimeMillis();
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(batchInsertEos)) {
            this.amountDas.insertBatch(batchInsertEos);
        }
        long end = System.currentTimeMillis();
        log.info("[\u6279\u91cf\u63d2\u5165\u5546\u54c1\u884c]\u5f53\u524d\u63d2\u5165:{}\u6761\uff0c\u8017\u65f6\uff1a{}", (Object)batchInsertEos.size(), (Object)(end - start));
    }

    @Override
    public void updateOrderLinePayRecord(Long id) {
        this.das.updateOrderLinePayRecord(id);
    }

    @Override
    public List<DgPerformOrderItemLineEo> queryEosByOrderIdsAndDeliveryStatus(List<Long> orderIds, Integer deliveryStatus) {
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty(orderIds), (String)"\u67e5\u8be2\u53c2\u6570orderIds\u4e0d\u80fd\u4e3a\u7a7a");
        com.yunxi.dg.base.commons.utils.AssertUtils.isFalse((deliveryStatus == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570deliveryStatus\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"delivery_status", (Object)deliveryStatus)).in((Object)"order_id", orderIds)).list();
    }
}

