/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSON;
import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.DgSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformNoticeSyncRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSplitReleationDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderWarehouseInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IPayRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAmountDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderWarehouseInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.PayRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgWmsShippingInfoReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgBizPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderAddrRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgRelatedOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSplitReleationEo;
import com.yunxi.dg.base.center.trade.vo.OrderItemLimitRespVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DgOmsOrderInfoQueryDomainImpl
implements IDgOmsOrderInfoQueryDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderInfoQueryDomainImpl.class);
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderWarehouseInfoDomain performOrderWarehouseInfoDomain;
    @Resource
    private IDgPerformOrderAmountDomain performOrderAmountDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderItemLineDomain performOrderItemLineDomain;
    @Resource
    private IDgPerformOrderSplitReleationDomain performOrderSplitReleationDomain;
    @Resource
    private IDgPerformOrderItemDomain performOrderItemDomain;
    @Resource
    private IDgPerformOrderAddrDomain performOrderAddrDomain;
    @Resource
    private IPayRecordDomain payRecordDomain;
    @Resource
    private IDgPerformNoticeSyncRecordDomain dgPerformNoticeSyncRecordDomain;

    @Override
    public String getLatestNo() {
        return this.performOrderInfoDomain.getLatestNo();
    }

    @Override
    public DgPerformOrderRespDto queryDtoById(Long orderId) {
        AssertUtils.notNull((Object)orderId, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setId(orderId);
        return this.eo2DtoAndQueryReleationInfo(this.performOrderInfoDomain.queryByEo(performOrderInfoEo));
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByIds(List<Long> orderIds) {
        AssertUtils.notNull(orderIds, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderInfoDomain.queryListByOrderIds(orderIds).stream().map(this::eo2DtoAndQueryReleationInfo).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByIdsNoReleationInfo(List<Long> orderIds) {
        AssertUtils.notNull(orderIds, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderInfoDomain.queryListByOrderIds(orderIds).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public DgPerformOrderRespDto queryDtoByOrderNo(String sourceNo) {
        AssertUtils.notNull((Object)sourceNo, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setSaleOrderNo(sourceNo);
        return this.eo2DtoAndQueryReleationInfo(this.performOrderInfoDomain.queryByEo(performOrderInfoEo));
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.notNull((Object)platformOrderNo, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setPlatformOrderNo(platformOrderNo);
        return this.performOrderInfoDomain.queryListByDto(performOrderInfoEo).stream().map(this::eo2DtoAndQueryReleationInfo).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByPlatformOrderNos(List<String> platformOrderNos) {
        AssertUtils.notNull(platformOrderNos, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderInfoDomain.queryDtoByPlatformOrderNos(platformOrderNos).stream().map(this::eo2DtoAndQueryReleationInfo).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByPlatformId(Long platformOrderId) {
        AssertUtils.notNull((Object)platformOrderId, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        performOrderInfoEo.setPlatformOrderId(platformOrderId);
        return this.performOrderInfoDomain.queryListByDto(performOrderInfoEo).stream().map(this::eo2DtoAndQueryReleationInfo).collect(Collectors.toList());
    }

    @Override
    public DgPerformOrderRespDto queryByDto(DgPerformOrderReqDto queryDto) {
        AssertUtils.notNull((Object)queryDto, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((Objects.nonNull(queryDto.getId()) || Objects.nonNull(queryDto.getSaleOrderNo()) ? 1 : 0) != 0, (String)"\u672a\u6ee1\u8db3\u67e5\u8be2\u6761\u4ef6");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryDto, (String[])new String[0]);
        return this.eo2DtoAndQueryReleationInfo(this.performOrderInfoDomain.queryByEo(performOrderInfoEo));
    }

    @Override
    public List<DgPerformOrderRespDto> queryListByDto(DgPerformOrderReqDto queryDto) {
        AssertUtils.notNull((Object)queryDto, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryDto, (String[])new String[0]);
        return this.performOrderInfoDomain.queryListByDto(performOrderInfoEo).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public DgBizPerformOrderRespDto orderRelatedInformation(String orderNo) {
        AssertUtils.notNull((Object)orderNo, (String)"\u8ba2\u5355orderNo\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        DgPerformOrderRespDto respDto = this.queryDtoByOrderNo(orderNo);
        DgBizPerformOrderRespDto dto = new DgBizPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)dto, (Object)respDto, (String[])new String[0]);
        List<DgPerformOrderRespDto> performOrderRespDtos = this.queryAllChildByOrderId(respDto.getId());
        if (CollectionUtil.isNotEmpty(performOrderRespDtos)) {
            List relatedOrderRespDtos = performOrderRespDtos.stream().map(item -> {
                DgRelatedOrderRespDto relatedOrderRespDto = new DgRelatedOrderRespDto();
                relatedOrderRespDto.setId(item.getId());
                relatedOrderRespDto.setSaleOrderNo(item.getSaleOrderNo());
                relatedOrderRespDto.setMainOrderNo(respDto.getSaleOrderNo());
                relatedOrderRespDto.setOrderStatus(item.getOrderStatus());
                relatedOrderRespDto.setMainOrder(Boolean.FALSE);
                relatedOrderRespDto.setOrignalOrderNo(item.getOriginalOrderNo());
                return relatedOrderRespDto;
            }).collect(Collectors.toList());
            dto.setRelatedOrderList(relatedOrderRespDtos);
        } else {
            dto.setRelatedOrderList(new ArrayList());
        }
        DgPerformOrderAddrDto orderAddrDasOne = this.performOrderAddrDomain.queryAddressByOrderId(respDto.getId());
        DgPerformOrderAddrRespDto orderAddrRespDto = new DgPerformOrderAddrRespDto();
        CubeBeanUtils.copyProperties((Object)orderAddrRespDto, (Object)orderAddrDasOne, (String[])new String[0]);
        dto.setOrderAddrRespDto(orderAddrRespDto);
        List<DgPerformOrderItemLineDto> orderItemLineDtos = this.performOrderItemLineDomain.queryInfoByOrderId(respDto.getId());
        dto.setOrderItemLineList(orderItemLineDtos);
        dto.setOrderItemLineList(orderItemLineDtos);
        ArrayList payRecordDtoList = Lists.newArrayList();
        List payRecordEos = ((ExtQueryChainWrapper)this.payRecordDomain.filter().eq((Object)"order_no", (Object)respDto.getSaleOrderNo())).list();
        if (CollectionUtils.isNotEmpty((Collection)payRecordEos)) {
            CubeBeanUtils.copyCollection((Collection)payRecordDtoList, (Collection)payRecordEos, PayRecordDto.class);
        }
        dto.setPayRecordDtoList((List)payRecordDtoList);
        return dto;
    }

    @Override
    public DgPerformOrderRespDto queryByDtoNoReleationInfo(DgPerformOrderReqDto queryDto) {
        AssertUtils.notNull((Object)queryDto, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isTrue((Objects.nonNull(queryDto.getId()) || Objects.nonNull(queryDto.getSaleOrderNo()) ? 1 : 0) != 0, (String)"\u672a\u6ee1\u8db3\u67e5\u8be2\u6761\u4ef6");
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)queryDto, (String[])new String[0]);
        return this.eo2Dto(this.performOrderInfoDomain.queryByEo(performOrderInfoEo));
    }

    @Override
    public List<DgPerformOrderRespDto> queryAllChildByOrderNo(String sourceNo) {
        DgPerformOrderInfoEo oriOrder = this.performOrderInfoDomain.queryByOrderNo(sourceNo);
        List<DgPerformOrderSplitReleationEo> releationEos = this.performOrderSplitReleationDomain.queryByOrderId(oriOrder.getId());
        List<DgPerformOrderInfoEo> childOrders = this.performOrderInfoDomain.queryListByOrderIds(releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList()));
        List<Object> allList = new ArrayList<DgPerformOrderInfoEo>();
        allList.addAll(childOrders);
        List<Long> ids = childOrders.stream().filter(childOrder -> DgSaleOrderStatusEnum.SPLIT.getCode().equals(childOrder.getOrderStatus())).map(BaseEo::getId).collect(Collectors.toList());
        log.info("\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", ids);
        int i = 1;
        while (CollectionUtil.isNotEmpty(ids)) {
            List<DgPerformOrderSplitReleationEo> subReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
            List<DgPerformOrderInfoEo> subChildOrders = this.performOrderInfoDomain.queryListByOrderIds(subReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList()));
            allList.addAll(subChildOrders);
            List subIds = subChildOrders.stream().filter(childOrder -> DgSaleOrderStatusEnum.SPLIT.getCode().equals(childOrder.getOrderStatus())).map(BaseEo::getId).collect(Collectors.toList());
            log.info("{} \u7ea7\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", (Object)i, ids);
            if (CollectionUtil.isNotEmpty(subIds)) {
                ids = subIds;
                ++i;
                continue;
            }
            ids = new ArrayList<Long>();
        }
        allList = allList.stream().filter(order -> !DgSaleOrderStatusEnum.SPLIT.getCode().equals(order.getOrderStatus())).collect(Collectors.toList());
        ArrayList<DgPerformOrderRespDto> list = new ArrayList<DgPerformOrderRespDto>();
        CubeBeanUtils.copyCollection(list, allList, DgPerformOrderRespDto.class);
        return list;
    }

    @Override
    public List<DgPerformOrderRespDto> queryAllChildByOrderId(Long orderId) {
        List<DgPerformOrderSplitReleationEo> releationEos = this.performOrderSplitReleationDomain.queryByOrderId(orderId);
        List<Object> allList = new ArrayList<DgPerformOrderInfoEo>();
        if (CollectionUtil.isNotEmpty(releationEos)) {
            List<DgPerformOrderInfoEo> childOrders = this.performOrderInfoDomain.queryListByOrderIds(releationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList()));
            allList.addAll(childOrders);
            List<Long> ids = childOrders.stream().filter(childOrder -> DgSaleOrderStatusEnum.SPLIT.getCode().equals(childOrder.getOrderStatus())).map(BaseEo::getId).collect(Collectors.toList());
            log.info("\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", ids);
            int i = 1;
            while (CollectionUtil.isNotEmpty(ids)) {
                List<DgPerformOrderSplitReleationEo> subReleationEos = this.performOrderSplitReleationDomain.queryByOrderIds(ids);
                List<DgPerformOrderInfoEo> subChildOrders = this.performOrderInfoDomain.queryListByOrderIds(subReleationEos.stream().map(DgPerformOrderSplitReleationEo::getChildOrderId).collect(Collectors.toList()));
                allList.addAll(subChildOrders);
                List subIds = subChildOrders.stream().filter(childOrder -> DgSaleOrderStatusEnum.SPLIT.getCode().equals(childOrder.getOrderStatus())).map(BaseEo::getId).collect(Collectors.toList());
                log.info("{} \u7ea7\u5df2\u62c6\u5206\u5b50\u5355\uff1a{}", (Object)i, ids);
                if (CollectionUtil.isNotEmpty(subIds)) {
                    ids = subIds;
                    ++i;
                    continue;
                }
                ids = new ArrayList<Long>();
            }
            allList = allList.stream().filter(order -> !DgSaleOrderStatusEnum.SPLIT.getCode().equals(order.getOrderStatus())).collect(Collectors.toList());
        }
        ArrayList<DgPerformOrderRespDto> list = new ArrayList<DgPerformOrderRespDto>();
        CubeBeanUtils.copyCollection(list, allList, DgPerformOrderRespDto.class);
        return list;
    }

    private DgPerformOrderRespDto eo2DtoAndQueryReleationInfo(DgPerformOrderInfoEo performOrderInfoEo) {
        List shippingInfoList;
        if (Objects.isNull(performOrderInfoEo)) {
            return null;
        }
        Long orderId = performOrderInfoEo.getId();
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        DgPerformOrderExtensionDto extensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)extensionDto, (String)"extensionDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderPaymentDto paymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)paymentDto, (String)"paymentDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderSnapshotDto snapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(orderId);
        AssertUtils.notNull((Object)snapshotDto, (String)"snapshotDto \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderWarehouseInfoDto warehouseInfoDto = this.performOrderWarehouseInfoDomain.selectDtoByOrderId(orderId);
        DgPerformOrderAmountDto amountDto = this.performOrderAmountDomain.selectDtoByOrderId(orderId);
        List<DgPerformOrderLineDto> performOrderDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(orderId);
        performOrderRespDto.setPerformOrderExtensionDto(extensionDto);
        performOrderRespDto.setPerformOrderPaymentDto(paymentDto);
        performOrderRespDto.setPerformOrderSnapshotDto(snapshotDto);
        if (null != warehouseInfoDto) {
            performOrderRespDto.setPerformOrderWarehouseInfoDto(warehouseInfoDto);
            CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)warehouseInfoDto, (String[])new String[]{"id"});
        }
        if (null != warehouseInfoDto && StringUtils.isNotBlank((CharSequence)warehouseInfoDto.getLogisticsInfo()) && CollectionUtil.isNotEmpty((Collection)(shippingInfoList = JSON.parseArray((String)warehouseInfoDto.getLogisticsInfo(), DgWmsShippingInfoReqDto.class))) && shippingInfoList.size() > 1) {
            performOrderRespDto.setShippingCompanyCode(((DgWmsShippingInfoReqDto)shippingInfoList.get(0)).getShippingCompanyCode());
            performOrderRespDto.setShippingCompanyName(((DgWmsShippingInfoReqDto)shippingInfoList.get(0)).getShippingCompanyName());
            performOrderRespDto.setShippingNo(((DgWmsShippingInfoReqDto)shippingInfoList.get(0)).getShippingNo());
        }
        if (null != amountDto) {
            performOrderRespDto.setPerformOrderAmountDto(amountDto);
            CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)amountDto, (String[])new String[]{"id"});
        }
        performOrderRespDto.setOrderLineList(performOrderDtoList);
        return performOrderRespDto;
    }

    private DgPerformOrderRespDto eo2Dto(DgPerformOrderInfoEo performOrderInfoEo) {
        if (Objects.isNull(performOrderInfoEo)) {
            return null;
        }
        DgPerformOrderRespDto performOrderRespDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)performOrderRespDto, (Object)performOrderInfoEo, (String[])new String[0]);
        return performOrderRespDto;
    }

    @Override
    public List<DgPerformOrderRespDto> queryDtoByOrderNoList(List<String> sourceNoList) {
        AssertUtils.notEmpty(sourceNoList, (String)"\u67e5\u8be2\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        return this.performOrderInfoDomain.queryByOrderNos(sourceNoList).stream().map(this::eo2Dto).collect(Collectors.toList());
    }

    @Override
    public List<String> queryAllMergeOrderNos(String mergeOrderNo) {
        if (StringUtils.isBlank((CharSequence)mergeOrderNo)) {
            return Lists.newArrayList();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().select(new String[]{"sale_order_no"}).eq((Object)"merge_order_no", (Object)mergeOrderNo)).eq((Object)"dr", (Object)0)).list();
        return list.stream().map(DgPerformOrderInfoEo::getSaleOrderNo).collect(Collectors.toList());
    }

    @Override
    public List<DgPerformOrderRespDto> queryInfoListByOrderNos(List<String> saleOrderNos) {
        if (CollectionUtils.isEmpty(saleOrderNos)) {
            return Lists.newArrayList();
        }
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.performOrderInfoDomain.filter().in((Object)"sale_order_no", saleOrderNos)).eq((Object)"dr", (Object)0)).list();
        return BeanUtil.copyToList((Collection)list, DgPerformOrderRespDto.class);
    }

    @Override
    public List<OrderItemLimitRespVo> countNormalOrderItem(String orderType, List<String> normalStatus, Long receivingStoreId, Long customerId, List<Long> skuIds, String saleOrderNo) {
        return this.performOrderInfoDomain.countNormalOrderItem(orderType, normalStatus, receivingStoreId, customerId, skuIds, saleOrderNo);
    }

    @Override
    public List<OrderItemLimitRespVo> countAfterOrderItem(String orderType, List<String> normalStatus, Long receivingStoreId, Long customerId, List<Long> skuIds) {
        return this.performOrderInfoDomain.countAfterOrderItem(orderType, normalStatus, receivingStoreId, customerId, skuIds);
    }
}

