/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;

public class DateTimeUtils {
    private static final String DATE_PATTERN = "yyyy-MM-dd";
    private static final String COMPACT_DATE_PATTERN = "yyyyMMdd";
    private static final String COMPACT_TIME_PATTERN = "HHmmss";
    private static final String MM_TIME_PATTERN = "HH:mm";
    private static final String HOURS_TIME_PATTERN = "HH";
    private static final String MM_TIME_PATTERN_CHINA = "HH\u5206mm\u79d2";
    private static final String C_MM_TIME_PATTERN = "ahh:mm";
    private static final String TIME_PATTERN = "HH:mm:ss";
    private static final String MIL_PATTERN = "HH:mm:ss:SSS";
    private static final String TIME_PATTERN_WEEK = "yyyy-MM-dd E";
    private static final String DATE_PATTERN_CN = "yyyy\u5e74MM\u6708dd\u65e5";
    private static final String MONTH_DAY_CN = "MM\u6708dd\u65e5";
    private static final String DATE_TIME_ALL = "yyyy.MM.dd HH:mm:ss";
    private static final String DATE_DAY = "dd\u65e5";
    private static final String MOUTH_DATE_PATTERN = "yyyy-MM";
    private static String[] parsePatterns = new String[]{"yyyy-MM-dd", "yyyy\u5e74MM\u6708dd\u65e5", "yyyy-MM-dd HH:mm:ss", "yyyy-MM-dd HH:mm", "yyyy/MM/dd", "yyyy/MM/dd HH:mm:ss", "yyyy/MM/dd HH:mm", "yyyyMMdd"};

    public static Date parseDate(String string, String fromat) {
        if (string == null) {
            return null;
        }
        String[] pointPattern = StringUtils.isBlank((CharSequence)fromat) ? new String[]{fromat} : parsePatterns;
        try {
            return DateUtils.parseDate((String)string, (String[])pointPattern);
        }
        catch (ParseException var4) {
            return null;
        }
    }

    public static Date parseDate(String string) {
        return DateTimeUtils.parseDate(string, null);
    }

    public static final String convertDateToWeekString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(TIME_PATTERN_WEEK).format(aDate);
    }

    public static final String convertDateToString(Date aDate, String pattern) {
        return aDate == null ? null : new SimpleDateFormat(pattern).format(aDate);
    }

    public static final String convertDateToString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(DATE_PATTERN).format(aDate);
    }

    public static final String convertDateToCnString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(DATE_PATTERN_CN).format(aDate);
    }

    public static final Date convertCnStringToDate(String cnString) throws ParseException {
        return StringUtils.isBlank((CharSequence)cnString) ? null : new SimpleDateFormat(DATE_PATTERN_CN).parse(cnString);
    }

    public static final String convertDateToAllString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(DATE_TIME_ALL).format(aDate);
    }

    public static Date convertStringToDate(String strDate) throws ParseException {
        return StringUtils.isBlank((CharSequence)strDate) ? null : new SimpleDateFormat(DATE_PATTERN).parse(strDate);
    }

    public static final String convertDateToCompactString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(COMPACT_DATE_PATTERN).format(aDate);
    }

    public static Date convertCompactStringToDate(String strDate) throws ParseException {
        return new SimpleDateFormat(COMPACT_DATE_PATTERN).parse(strDate);
    }

    public static final String convertTimeToCompactString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat("yyyyMMddHHmmss").format(aDate);
    }

    public static final String convertTimeToMandDay(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat("MM\u6708dd\u65e5 HH:mm").format(aDate);
    }

    public static Date convertCompactStringToTime(String strDate) throws ParseException {
        return new SimpleDateFormat("yyyyMMddHHmmss").parse(strDate);
    }

    public static java.sql.Date convertStringToSqlDate(String strDate) throws ParseException {
        return new java.sql.Date(new SimpleDateFormat(DATE_PATTERN).parse(strDate).getTime());
    }

    public static final String convertMmTimeToString(Date aTime) {
        return aTime == null ? null : new SimpleDateFormat(MM_TIME_PATTERN).format(aTime);
    }

    public static final String convertMmTimeToChinaString(Date aTime) {
        return aTime == null ? null : new SimpleDateFormat(MM_TIME_PATTERN_CHINA).format(aTime);
    }

    public static final String convertCMmTimeToString(Date aTime) {
        return aTime == null ? null : new SimpleDateFormat(C_MM_TIME_PATTERN).format(aTime);
    }

    public static Date convertStringToMmTime(String strMmTime) throws ParseException {
        return StringUtils.isBlank((CharSequence)strMmTime) ? null : new Date(new SimpleDateFormat(MM_TIME_PATTERN).parse(strMmTime).getTime());
    }

    public static Date convertStringToCMmTime(String strMmTime) throws ParseException {
        return new Date(new SimpleDateFormat("yyyy-MM-dd ahh:mm").parse(strMmTime).getTime());
    }

    public static final String convertDateTimeToString(Date aDateTime) {
        return aDateTime == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(aDateTime);
    }

    public static final String convertDateTimeToMilString(Date aDateTime) {
        return aDateTime == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm:ss:SSS").format(aDateTime);
    }

    public static final String convertDateTimeToMmString(Date aDateTime) {
        return aDateTime == null ? null : new SimpleDateFormat("yyyy-MM-dd HH:mm").format(aDateTime);
    }

    public static final String convertDateTimeToHoursString(Date aDateTime) {
        return aDateTime == null ? null : new SimpleDateFormat("yyyy-MM-dd HH").format(aDateTime);
    }

    public static final Date convertMmStringToDateTime(String strMmDateTime) throws ParseException {
        return StringUtils.isBlank((CharSequence)strMmDateTime) ? null : new Date(new SimpleDateFormat("yyyy-MM-dd HH:mm").parse(strMmDateTime).getTime());
    }

    public static Date convertStringToDateTime(String strDateTime) throws ParseException {
        return StringUtils.isBlank((CharSequence)strDateTime) ? null : new Date(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(strDateTime).getTime());
    }

    public static Date convertStringToDateTime(String datePattern, String strDateTime) {
        try {
            return new Date(new SimpleDateFormat(datePattern).parse(strDateTime).getTime());
        }
        catch (ParseException var3) {
            throw new IllegalArgumentException(var3);
        }
    }

    public static Date getMonthEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        tmpCalendar.add(2, 1);
        tmpCalendar.add(14, -1);
        tmpCalendar.set(14, 0);
        return tmpCalendar.getTime();
    }

    public static Date getMonthEndTime(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return DateTimeUtils.getMonthEndTime(calendar);
    }

    public static Date getMonthEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getMonthEndTime(calendar);
    }

    public static Date getMonthStartTime(int year, int month) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        return DateTimeUtils.getMonthStartTime(calendar);
    }

    public static Date getMonthStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(5, 1);
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        return tmpCalendar.getTime();
    }

    public static Date getMonthStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getMonthStartTime(calendar);
    }

    public static Date getDayEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        tmpCalendar.add(5, 1);
        tmpCalendar.add(14, -1);
        tmpCalendar.set(14, 0);
        return tmpCalendar.getTime();
    }

    public static Date getDayEndTime(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return DateTimeUtils.getDayEndTime(calendar);
    }

    public static Date getDayEndTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getDayEndTime(calendar);
    }

    public static Date getDayEndTimeIfTimeNull(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Date date_pattern = DateTimeUtils.parseDate(date, DATE_PATTERN);
        if (date_pattern != null) {
            return DateTimeUtils.parseDate(date);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return DateTimeUtils.getDayEndTime(calendar);
    }

    public static Date getDayEndTime(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return DateTimeUtils.getDayEndTime(calendar);
    }

    public static Date getDayStartTime(int year, int month, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(1, year);
        calendar.set(2, month - 1);
        calendar.set(5, day);
        return DateTimeUtils.getDayStartTime(calendar);
    }

    public static Date getDayStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        return tmpCalendar.getTime();
    }

    public static Date getDayStartTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getDayStartTime(calendar);
    }

    public static Date getDayStartTime(String date) {
        if (StringUtils.isBlank((CharSequence)date)) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(DateTimeUtils.convertStringToDateTime(DATE_PATTERN, date));
        return DateTimeUtils.getDayStartTime(calendar);
    }

    public static Date getWeekStartTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        tmpCalendar.setFirstDayOfWeek(2);
        tmpCalendar.set(7, tmpCalendar.getFirstDayOfWeek());
        return tmpCalendar.getTime();
    }

    public static Date getWeekStartTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getWeekStartTime(calendar);
    }

    public static Date getWeekEndTime(Calendar calendar) {
        Calendar tmpCalendar = (Calendar)calendar.clone();
        tmpCalendar.set(11, 0);
        tmpCalendar.set(12, 0);
        tmpCalendar.set(13, 0);
        tmpCalendar.set(14, 0);
        tmpCalendar.setFirstDayOfWeek(2);
        tmpCalendar.set(7, tmpCalendar.getFirstDayOfWeek());
        tmpCalendar.add(5, 7);
        tmpCalendar.set(14, -1);
        tmpCalendar.set(14, 0);
        return tmpCalendar.getTime();
    }

    public static Date getWeekEndTime(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return DateTimeUtils.getWeekEndTime(calendar);
    }

    public static String getDayOfWeekStr(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String str = "";
        switch (calendar.get(7)) {
            case 1: {
                str = "\u661f\u671f\u65e5";
                break;
            }
            case 2: {
                str = "\u661f\u671f\u4e00";
                break;
            }
            case 3: {
                str = "\u661f\u671f\u4e8c";
                break;
            }
            case 4: {
                str = "\u661f\u671f\u4e09";
                break;
            }
            case 5: {
                str = "\u661f\u671f\u56db";
                break;
            }
            case 6: {
                str = "\u661f\u671f\u4e94";
                break;
            }
            case 7: {
                str = "\u661f\u671f\u516d";
            }
        }
        return str;
    }

    public static String getDayOfWeekStrExt(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        String str = "";
        switch (calendar.get(7)) {
            case 1: {
                str = "\u5468\u65e5";
                break;
            }
            case 2: {
                str = "\u5468\u4e00";
                break;
            }
            case 3: {
                str = "\u5468\u4e8c";
                break;
            }
            case 4: {
                str = "\u5468\u4e09";
                break;
            }
            case 5: {
                str = "\u5468\u56db";
                break;
            }
            case 6: {
                str = "\u5468\u4e94";
                break;
            }
            case 7: {
                str = "\u5468\u516d";
            }
        }
        return str;
    }

    public static int getHourOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(11);
    }

    public static int getMinuteOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(12);
    }

    public static int getYearOfDay(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        return calendar.get(1);
    }

    public static Date getCurentWeekStartTime() {
        return DateTimeUtils.getWeekStartTime(new Date());
    }

    public static Date getCurentWeekEndTime() {
        return DateTimeUtils.getWeekEndTime(new Date());
    }

    public static Date getCurentMonthStartTime() {
        return DateTimeUtils.getMonthStartTime(new Date());
    }

    public static Date getCurentMonthEndTime() {
        return DateTimeUtils.getMonthEndTime(new Date());
    }

    public static String getTimeString(Long millisecond) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTimeInMillis(millisecond);
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(calendar.getTime());
    }

    public static int betweenDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 == year2) {
            return day2 - day1;
        }
        int timeDistance = 0;
        for (int i = year1; i < year2; ++i) {
            if ((i % 4 != 0 || i % 100 == 0) && i % 400 != 0) {
                timeDistance += 365;
                continue;
            }
            timeDistance += 366;
        }
        return timeDistance + (day2 - day1);
    }

    public static Integer betweenMonths(Date date1, Date date2) {
        Calendar c1 = Calendar.getInstance();
        Calendar c2 = Calendar.getInstance();
        c1.setTime(date1);
        c2.setTime(date2);
        int year = c2.get(1) - c1.get(1);
        if (year < 0) {
            year = -year;
            return year * 12 + c1.get(2) - c2.get(2);
        }
        return year * 12 + c2.get(2) - c1.get(2);
    }

    public static Date addDay(Date date, int day) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, day);
        return calendar.getTime();
    }

    public static Date addYear(Date date, int year) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(1, year);
        return calendar.getTime();
    }

    public static Date addAndSubMin(Date date, int min) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(12, min);
        return calendar.getTime();
    }

    public static Integer betweenYears(Date startDate, Date endDate) {
        Calendar startCalendar = Calendar.getInstance();
        Calendar endCalendar = Calendar.getInstance();
        startCalendar.setTime(startDate);
        endCalendar.setTime(endDate);
        return endCalendar.get(1) - startCalendar.get(1);
    }

    public static Integer calculateAge(Date birthday) {
        Integer age = birthday == null ? 0 : DateTimeUtils.betweenYears(birthday, new Date());
        return age == 0 ? 1 : age;
    }

    public static int getDateDifference(Date startDate, Date endDate) {
        return DateTimeUtils.getMillisecondDifference(startDate, endDate) / 1000;
    }

    public static int getMillisecondDifference(Date startDate, Date endDate) {
        long a = startDate.getTime();
        long b = endDate.getTime();
        return (int)(b - a);
    }

    public static Date getPointDayOfThisWeek(Date data, int day) {
        Calendar c = Calendar.getInstance();
        c.setTime(data);
        int dayofweek = c.get(7) - 1;
        if (dayofweek == 0) {
            dayofweek = 7;
        }
        c.add(5, -dayofweek + day);
        new SimpleDateFormat(DATE_PATTERN);
        return c.getTime();
    }

    public static String formatDuring(long mss) {
        long days = mss / 86400000L;
        long hours = mss % 86400000L / 3600000L;
        long minutes = mss % 3600000L / 60000L;
        long seconds = mss % 60000L / 1000L;
        return (days > 0L ? days + "\u5929" : "") + (hours > 0L ? hours + "\u65f6" : "") + (minutes > 0L ? minutes + "\u5206" : "") + (seconds > 0L ? seconds + "\u79d2 " : "");
    }

    public static String getCurrentYear() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy");
        Date date = new Date();
        return sdf.format(date);
    }

    public static boolean isToday(Date date) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        int year1 = c1.get(1);
        int month1 = c1.get(2) + 1;
        int day1 = c1.get(5);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(new Date());
        int year2 = c2.get(1);
        int month2 = c2.get(2) + 1;
        int day2 = c2.get(5);
        return year1 == year2 && month1 == month2 && day1 == day2;
    }

    public static Date getFirstDayByMonth(String dateStr) throws Exception {
        dateStr = dateStr + "-01";
        return DateTimeUtils.convertStringToDate(dateStr);
    }

    public static Date getNextFirstDayByMonth(String dateStr) throws Exception {
        Date date = DateTimeUtils.getFirstDayByMonth(dateStr);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(2, 1);
        return calendar.getTime();
    }

    public static final String getDayString(Date aDate) {
        return aDate == null ? null : new SimpleDateFormat(DATE_DAY).format(aDate);
    }

    public static Object getHowSecondAfterTime(Integer second, boolean isDateGormat) throws Exception {
        long currentTime = System.currentTimeMillis() + (long)(second * 1000);
        Date date = new Date(currentTime);
        return isDateGormat ? date : DateTimeUtils.convertDateTimeToString(date);
    }

    public static Date getBeforeMonthStartTime(Date date, int num) {
        Date dayStartTime = DateTimeUtils.getDayStartTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayStartTime);
        calendar.add(2, num);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public static Date getBeforeMonthEndTime(Date date, int num) {
        Date dayEndTime = DateTimeUtils.getDayEndTime(date);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(dayEndTime);
        calendar.add(2, num);
        calendar.set(5, 0);
        return calendar.getTime();
    }

    public static Date getFirstDayDateOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMinimum(6);
        cal.set(6, last);
        return cal.getTime();
    }

    public static Date getLastDayOfYear(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int last = cal.getActualMaximum(6);
        cal.set(6, last);
        return cal.getTime();
    }

    public static boolean checkIsEffect(Date startDay, Date endDay) {
        Date date = new Date();
        return startDay.before(date) && endDay.after(date);
    }

    public static Date getChangeDate(Date date, int key, int value) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(key, value);
        return calendar.getTime();
    }

    public static String getCurrentDateTime() {
        Long time = System.currentTimeMillis() / 1000L;
        String timestamp = String.valueOf(time);
        return timestamp;
    }

    public static String getNowChangeStr(int key, int value) {
        Calendar calendar = Calendar.getInstance();
        Date date = new Date();
        calendar.setTime(date);
        calendar.add(key, value);
        Date changeDate = calendar.getTime();
        SimpleDateFormat formatter = new SimpleDateFormat(DATE_PATTERN);
        String dateString = formatter.format(changeDate);
        return dateString;
    }

    public static Date getStartDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.clear(14);
        return calendar.getTime();
    }

    public static Date getEndDayTime() {
        Calendar calendar = Calendar.getInstance();
        calendar.set(11, 23);
        calendar.set(12, 59);
        calendar.set(13, 59);
        calendar.clear(14);
        return calendar.getTime();
    }
}

