/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderAbolishEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderStatusEnum;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderExchangeAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderLogisticsWarehouseDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderReturnAddressDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderExchangeAddressEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderLogisticsWarehouseEo;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderReturnAddressEo;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class DgAfterSaleOrderDomainImpl
extends BaseDomainImpl<DgAfterSaleOrderEo>
implements IDgAfterSaleOrderDomain,
IResetRedisNoIndexCommon {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Resource
    private IDgAfterSaleOrderDas das;
    @Resource
    private IDgAfterSaleOrderDomain dgAfterSaleOrderDomain;
    @Resource
    private IDgAfterSaleOrderReturnAddressDomain dgAfterSaleOrderReturnAddressDomain;
    @Resource
    private IDgAfterSaleOrderExchangeAddressDomain dgAfterSaleOrderExchangeAddressDomain;
    @Resource
    private IDgAfterSaleOrderLogisticsWarehouseDomain dgAfterSaleOrderLogisticsWarehouseDomain;
    @Resource
    private SqlSessionTemplate sqlSessionTemplate;

    public ICommonDas<DgAfterSaleOrderEo> commonDas() {
        return this.das;
    }

    @Override
    public DgAfterSaleOrderRespDto queryById(Long id) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)this.das.selectByPrimaryKey(id);
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    @Override
    public DgAfterSaleOrderRespDto queryByNo(String afterSaleOrderNo) {
        DgAfterSaleOrderEo dgAfterSaleOrderEo = (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
        DgAfterSaleOrderRespDto afterSaleOrderRespDto = new DgAfterSaleOrderRespDto();
        CubeBeanUtils.copyProperties((Object)afterSaleOrderRespDto, (Object)dgAfterSaleOrderEo, (String[])new String[0]);
        return afterSaleOrderRespDto;
    }

    @Override
    public List<DgAfterSaleOrderRespDto> queryByBizAfterSaleOrderReqDto(DgBizAfterSaleOrderReqDto bizAfterSaleOrderReqDto) {
        List saleOrderEos;
        if (StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformOrderNo()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn()) && StringUtils.isBlank((CharSequence)bizAfterSaleOrderReqDto.getSaleOrderNo()) && CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformOrderNo(), (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getPlatformRefundOrderSn(), (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)bizAfterSaleOrderReqDto.getSaleOrderNo(), (String)"saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            if (CollectionUtils.isEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
                throw new BizException("platformRefundOrderSnList\u4e0d\u80fd\u4e3a\u7a7a");
            }
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderEo, (Object)bizAfterSaleOrderReqDto, (String[])new String[0]);
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getPlatformRefundOrderSn, (Collection)bizAfterSaleOrderReqDto.getPlatformRefundOrderSnList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList())) {
            queryWrapper.in(DgAfterSaleOrderEo::getAfterSaleOrderType, (Collection)bizAfterSaleOrderReqDto.getAfterSaleOrderTypeList());
        }
        if (CollectionUtils.isNotEmpty((Collection)bizAfterSaleOrderReqDto.getNotInStatus())) {
            queryWrapper.notIn(DgAfterSaleOrderEo::getStatus, (Collection)bizAfterSaleOrderReqDto.getNotInStatus());
        }
        if (CollectionUtils.isEmpty((Collection)(saleOrderEos = this.das.getMapper().selectList((Wrapper)queryWrapper)))) {
            return Lists.newArrayList();
        }
        ArrayList resultList = Lists.newArrayList();
        CubeBeanUtils.copyCollection((Collection)resultList, (Collection)saleOrderEos, DgAfterSaleOrderRespDto.class);
        this.queryAfsOrderOtherTableInfo(resultList);
        return resultList;
    }

    @Override
    public List<DgAfterSaleOrderEo> queryDtosByplatformOrderReqDto(String platformRefundOrderSn, String platformOrdeerNo) {
        if (StringUtils.isBlank((CharSequence)platformOrdeerNo) && StringUtils.isBlank((CharSequence)platformRefundOrderSn)) {
            AssertUtils.notBlank((String)platformOrdeerNo, (String)"platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
            AssertUtils.notBlank((String)platformRefundOrderSn, (String)"platformRefundOrderSn\u4e0d\u80fd\u4e3a\u7a7a");
        }
        DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)dgAfterSaleOrderEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        queryWrapper.eq(DgAfterSaleOrderEo::getAbolishFlag, (Object)DgAfterSaleOrderAbolishEnum.NO.getCode());
        queryWrapper.eq(DgAfterSaleOrderEo::getPlatformOrderNo, (Object)platformOrdeerNo);
        queryWrapper.eq(DgAfterSaleOrderEo::getPlatformRefundOrderSn, (Object)platformRefundOrderSn);
        HashSet notAllowStatus = Sets.newHashSet((Object[])new String[]{DgAfterSaleOrderStatusEnum.ABOLISH.getCode(), DgAfterSaleOrderStatusEnum.CANCEL.getCode()});
        queryWrapper.notIn(DgAfterSaleOrderEo::getStatus, (Collection)notAllowStatus);
        queryWrapper.orderByDesc(DgAfterSaleOrderEo::getPlatformCreated);
        return this.das.getMapper().selectList((Wrapper)queryWrapper);
    }

    @Override
    public int optimisticModifyAfterSale(DgAfterSaleOrderEo afterSaleOrderEo, LambdaQueryWrapper<DgAfterSaleOrderEo> queryWrapper, int idealCount, boolean needThrow) {
        this.logger.info("optimisticModifyAfterSale\u5165\u53c2afterSaleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)afterSaleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)afterSaleOrderEo);
        this.popOrderStatusLog(afterSaleOrderEo, queryWrapper);
        int optCount = this.das.getMapper().update((Object)afterSaleOrderEo, queryWrapper);
        if (this.das.isUseCache()) {
            this.logger.info("\u5220\u9664\u5168\u90e8\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
            DgAfterSaleOrderEo entity = (DgAfterSaleOrderEo)queryWrapper.getEntity();
            this.das.removeLogicCache((BaseEo)entity);
            this.das.removeCache((Object)entity.getId());
            this.das.removeCacheByExample((BaseEo)entity);
        } else {
            this.logger.info("\u5220\u9664\u4e00\u7ea7\u7f13\u5b58");
            this.sqlSessionTemplate.clearCache();
        }
        return optCount;
    }

    private void popOrderStatusLog(DgAfterSaleOrderEo afterSaleOrderEo, LambdaQueryWrapper<DgAfterSaleOrderEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgAfterSaleOrderEo)updateWrapper.getEntity()).getId());
        DgAfterSaleOrderEo dgAftersaleOrderDasOne = (DgAfterSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = dgAftersaleOrderDasOne.getAfterSaleOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)afterSaleOrderEo.getStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(afterSaleOrderEo.getStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            afterSaleOrderEo.setAfterSaleOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    private void queryAfsOrderOtherTableInfo(List<DgAfterSaleOrderRespDto> dgAfterSaleOrderRespDtos) {
        List<DgAfterSaleOrderLogisticsWarehouseEo> logisticsWarehouseEos;
        List<DgAfterSaleOrderExchangeAddressEo> exchangeAddressEos;
        List<Long> afsIds = dgAfterSaleOrderRespDtos.stream().map(BaseDto::getId).collect(Collectors.toList());
        List<DgAfterSaleOrderReturnAddressEo> returnAddressEos = this.dgAfterSaleOrderReturnAddressDomain.selectByAfterSaleOrderIds(afsIds);
        if (CollectionUtils.isNotEmpty(returnAddressEos)) {
            Map returnAddressEoMap = returnAddressEos.stream().collect(Collectors.toMap(DgAfterSaleOrderReturnAddressEo::getAfterSaleOrderId, Function.identity()));
            for (DgAfterSaleOrderRespDto dgAfterSaleOrderRespDto : dgAfterSaleOrderRespDtos) {
                if (returnAddressEoMap.get(dgAfterSaleOrderRespDto.getId()) == null) continue;
                CubeBeanUtils.copyProperties((Object)dgAfterSaleOrderRespDto, returnAddressEoMap.get(dgAfterSaleOrderRespDto.getId()), (String[])new String[]{"id"});
            }
        }
        if (CollectionUtils.isNotEmpty(exchangeAddressEos = this.dgAfterSaleOrderExchangeAddressDomain.selectByAfterSaleOrderIds(afsIds))) {
            Map exchangeAddressEoMap = exchangeAddressEos.stream().collect(Collectors.toMap(DgAfterSaleOrderExchangeAddressEo::getAfterSaleOrderId, Function.identity()));
            for (DgAfterSaleOrderRespDto respDto : dgAfterSaleOrderRespDtos) {
                if (exchangeAddressEoMap.get(respDto.getId()) == null) continue;
                CubeBeanUtils.copyProperties((Object)respDto, exchangeAddressEoMap.get(respDto.getId()), (String[])new String[]{"id"});
            }
        }
        if (CollectionUtils.isNotEmpty(logisticsWarehouseEos = this.dgAfterSaleOrderLogisticsWarehouseDomain.selectByAfterSaleOrderIds(afsIds))) {
            Map map = logisticsWarehouseEos.stream().collect(Collectors.toMap(DgAfterSaleOrderLogisticsWarehouseEo::getAfterSaleOrderId, Function.identity()));
            for (DgAfterSaleOrderRespDto respDto : dgAfterSaleOrderRespDtos) {
                if (map.get(respDto.getId()) == null) continue;
                CubeBeanUtils.copyProperties((Object)respDto, map.get(respDto.getId()), (String[])new String[]{"id"});
            }
        }
    }

    @Override
    public void modifyAfterSaleOrderDeliveryInfo(DgAfterSaleOrderRespDto afterSaleOrderRespDto) {
        AssertUtils.notNull((Object)afterSaleOrderRespDto.getId(), (String)"\u552e\u540e\u5355id\u4e0d\u80fd\u4e3a\u7a7a");
        this.das.modifyAfterSaleOrderDeliveryInfo(afterSaleOrderRespDto);
    }

    @Override
    public void updateBatchPlanPickUpDate(List<DgAfterSaleOrderDto> reqDtoList) {
        this.das.updateBatchPlanPickUpDate(reqDtoList);
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgAfterSaleOrderEo afterSaleOrderEo = (DgAfterSaleOrderEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return afterSaleOrderEo.getAfterSaleOrderNo();
    }

    @Override
    public void batchModifyInnerRemarkByAfsIds(List<Long> afsIds, String innerRemark) {
        this.das.batchModifyInnerRemarkByAfsIds(afsIds, innerRemark);
    }

    @Override
    public void batchModifyAfterSaleOrderReasonByAfsIds(List<Long> afsIds, String reason) {
        this.das.batchModifyAfterSaleOrderReasonByAfsIds(afsIds, reason);
    }

    @Override
    public void batchModifyAfterSaleOrderTransferNoByAfsIds(Set<Long> afsIds, String transferNo) {
        List orderIds = CollectionUtil.split(afsIds, (int)200);
        for (List orders : orderIds) {
            this.das.batchModifyAfterSaleOrderTransferNoByAfsIds(new HashSet(orders), transferNo);
        }
    }

    @Override
    public List<DgAfterSaleOrderEo> queryEosByPlatformRefundOrderSn(String platformRefundOrderSn) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformRefundOrderSn), (String)"\u53c2\u6570\u5e73\u53f0\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_refund_order_sn", (Object)platformRefundOrderSn)).eq((Object)"abolish_flag", (Object)DgAfterSaleOrderAbolishEnum.NO.getCode())).notIn((Object)"status", Arrays.asList(DgAfterSaleOrderStatusEnum.CLOSE.getCode(), DgAfterSaleOrderStatusEnum.CANCEL.getCode(), DgAfterSaleOrderStatusEnum.ABOLISH.getCode()))).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryEosByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"abolish_flag", (Object)DgAfterSaleOrderAbolishEnum.NO.getCode())).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryBySaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u53c2\u6570\u9500\u552e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public void updateDeliveryStatus(Long exchangeOrderId, String deliveryStatus) {
        if (exchangeOrderId != null && StringUtils.isNotBlank((CharSequence)deliveryStatus)) {
            DgAfterSaleOrderEo dgAfterSaleOrderEo = new DgAfterSaleOrderEo();
            dgAfterSaleOrderEo.setId(exchangeOrderId);
            dgAfterSaleOrderEo.setDeliveryStatus(deliveryStatus);
            this.das.updateSelective((BaseEo)dgAfterSaleOrderEo);
        }
    }

    @Override
    public List<DgAfterSaleOrderEo> queryBySaleOrderId(Long saleOrderId) {
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570\u9500\u552e\u8ba2\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).eq((Object)"sale_order_id", (Object)saleOrderId)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryBySaleOrderIds(List<Long> ids) {
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(ids), (String)"\u53c2\u6570\u9500\u552e\u8ba2\u5355ID\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).in((Object)"sale_order_id", ids)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryEffectiveEosByOrderId(Long saleOrderId) {
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> statusList = Arrays.asList(DgAfterSaleOrderStatusEnum.CANCEL.getCode(), DgAfterSaleOrderStatusEnum.CLOSE.getCode(), DgAfterSaleOrderStatusEnum.ABOLISH.getCode());
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_id", (Object)saleOrderId)).notIn((Object)"status", statusList)).list();
    }

    @Override
    public DgAfterSaleOrderEo queryByExchangeSaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570\u6362\u51fa\u9500\u552e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"exchange_sale_order_no", (Object)saleOrderNo)).one();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryEosBySaleOrderIdAndStatus(Long orderId, ArrayList<String> statusList) {
        AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u9500\u552e\u5355ID\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)CollectionUtils.isEmpty(statusList), (String)"\u552e\u540e\u5355\u72b6\u6001\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_id", (Object)orderId)).in((Object)"status", statusList)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public DgAfterSaleOrderEo queryByAfterSaleOrderNo(String afterSaleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)afterSaleOrderNo), (String)"\u552e\u540e\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return (DgAfterSaleOrderEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).eq((Object)"dr", (Object)0)).one();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryByPlatformRefundOrderSn(List<String> platformOrderRefundSns) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"platform_refund_order_sn", platformOrderRefundSns)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> queryByPlatformRefundOrderSn(String platformOrderRefundSn) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_refund_order_sn", (Object)platformOrderRefundSn)).eq((Object)"dr", (Object)0)).notIn((Object)"status", new Object[]{"CANCEL", "ABOLISH"})).list();
    }

    @Override
    public Boolean queryTKTKExistByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u67e5\u8be2\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).notIn((Object)"status", new Object[]{DgAfterSaleOrderStatusEnum.ABOLISH.getCode()})).list();
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public Boolean queryTKTKExistBySaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).notIn((Object)"status", new Object[]{DgAfterSaleOrderStatusEnum.ABOLISH.getCode()})).list();
        return CollectionUtils.isNotEmpty((Collection)list);
    }

    @Override
    public DgAfterSaleOrderEo queryEoByNo(String afterSaleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)afterSaleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570afterSaleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return (DgAfterSaleOrderEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"after_sale_order_no", (Object)afterSaleOrderNo)).one();
    }

    @Override
    public void updateRefundTypeToNull(Long id) {
        this.das.updateRefundTypeToNull(id);
    }

    @Override
    public List<DgAfterSaleOrderEo> getExistAfterSaleOrdersBySaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList notInStatus = Lists.newArrayList((Object[])new String[]{DgAfterSaleOrderStatusEnum.ABOLISH.getCode(), DgAfterSaleOrderStatusEnum.CANCEL.getCode()});
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).notIn((Object)"status", (Collection)notInStatus)).list();
    }

    @Override
    public List<DgAfterSaleOrderEo> getExistAfterSaleOrdersByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u67e5\u8be2\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        ArrayList notInStatus = Lists.newArrayList((Object[])new String[]{DgAfterSaleOrderStatusEnum.ABOLISH.getCode(), DgAfterSaleOrderStatusEnum.CANCEL.getCode()});
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).notIn((Object)"status", (Collection)notInStatus)).list();
    }
}

