/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.entity.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.cube.utils.bean.CubeBeanUtils;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.yundt.cube.center.trade.api.constant.YesOrNoEnum;
import com.dtyunxi.yundt.cube.center.trade.api.dto.request.OrderRemarkReqDto;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.dao.mapper.DgPerformOrderInfoMapper;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAddrDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderExtensionDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderItemLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderLineDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderPaymentDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderSnapshotDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IResetRedisNoIndexCommon;
import com.yunxi.dg.base.center.trade.domain.order.event.PerformOrderInfoUpdateEvent;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderExtensionDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderPaymentDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderSnapshotDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgModifyOrderRemarkReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgOrderStatusLogRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAddrEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderLineEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderPaymentEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderSnapshotEo;
import com.yunxi.dg.base.center.trade.utils.DgOrderOptLabelUtils;
import com.yunxi.dg.base.center.trade.vo.OrderItemLimitRespVo;
import com.yunxi.dg.base.center.trade.vo.SaleOrderAuditVo;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.framework.core.db.das.ICommonDas;
import com.yunxi.dg.base.framework.core.domain.BaseDomainImpl;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.stereotype.Service;
import org.springframework.transaction.support.TransactionSynchronizationManager;

@Service
public class DgPerformOrderInfoDomainImpl
extends BaseDomainImpl<DgPerformOrderInfoEo>
implements IDgPerformOrderInfoDomain,
IResetRedisNoIndexCommon {
    private static final Logger log = LoggerFactory.getLogger(DgPerformOrderInfoDomainImpl.class);
    @Resource
    private IDgPerformOrderInfoDas das;
    @Resource
    private ApplicationEventPublisher publisher;
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgPerformOrderPaymentDomain performOrderPaymentDomain;
    @Resource
    private IDgPerformOrderSnapshotDomain performOrderSnapshotDomain;
    @Resource
    private IDgPerformOrderExtensionDomain performOrderExtensionDomain;
    @Resource
    private IDgPerformOrderLineDomain dgPerformOrderLineDomain;
    @Resource
    private IDgPerformOrderLineAmountDomain dgPerformOrderLineAmountDomain;
    @Resource
    private IDgPerformOrderItemLineDomain dgPerformOrderItemLineDomain;
    @Resource
    private IDgPerformOrderItemLineAmountDomain dgPerformOrderItemLineAmountDomain;
    @Resource
    private DgPerformOrderInfoMapper dgPerformOrderInfoMapper;
    @Resource
    private IDgPerformOrderAddrDomain dgPerformOrderAddrDomain;
    @Resource
    private IDgOrderLabelRecordDomain dgOrderLabelRecordDomain;
    private final Function<DgPerformOrderInfoEo, DgPerformOrderRespDto> eo2DtoListFunc = performOrderInfoEo -> {
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        DgPerformOrderExtensionDto performOrderExtensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderExtensionDto).ifPresent(dto -> respDto.setPerformOrderExtensionDto(dto));
        DgPerformOrderPaymentDto performOrderPaymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderPaymentDto).ifPresent(dto -> respDto.setPerformOrderPaymentDto(dto));
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderSnapshotDto).ifPresent(dto -> respDto.setPerformOrderSnapshotDto(dto));
        return respDto;
    };

    public ICommonDas<DgPerformOrderInfoEo> commonDas() {
        return this.das;
    }

    @Override
    public int updateSaleOrderById(Long orderId, DgPerformOrderInfoEo updateEo) {
        AssertUtils.notNull((Object)orderId, (String)"orderId\u4e0d\u80fd\u4e3a\u7a7a");
        updateEo.setId(orderId);
        int updateSelective = this.das.updateSelective((BaseEo)updateEo);
        return updateSelective;
    }

    @Override
    public void modifySaleOrder(DgPerformOrderInfoDto modifyReqDto) {
        DgPerformOrderInfoEo performOrderInfoEo = new DgPerformOrderInfoEo();
        CubeBeanUtils.copyProperties((Object)performOrderInfoEo, (Object)modifyReqDto, (String[])new String[0]);
        this.updateSaleOrderById(performOrderInfoEo.getId(), performOrderInfoEo);
    }

    @Override
    public DgPerformOrderInfoEo queryEoById(Long id) {
        return (DgPerformOrderInfoEo)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).eq((Object)"id", (Object)id)).one();
    }

    @Override
    public DgPerformOrderInfoEo queryByOrderNo(String orderNo) {
        AssertUtils.notBlank((String)orderNo, (String)"orderNo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).eq(DgPerformOrderInfoEo::getSaleOrderNo, (Object)orderNo);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return performOrderInfoEo;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryByOrderNos(List<String> orderNos) {
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(orderNos), (String)"orderNos \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderInfoEo::getSaleOrderNo, orderNos);
        List list = this.das.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryDtoByPlatformOrderNos(List<String> orderNos) {
        AssertUtils.isTrue((boolean)org.apache.commons.collections.CollectionUtils.isNotEmpty(orderNos), (String)"orderNos \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(DgPerformOrderInfoEo::getPlatformOrderNo, orderNos);
        List list = this.das.getMapper().selectList((Wrapper)queryWrapper);
        return list;
    }

    @Override
    public DgPerformOrderInfoEo queryByEo(DgPerformOrderInfoEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryWrapper);
        return performOrderInfoEo;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByDto(DgPerformOrderInfoEo queryEo) {
        AssertUtils.notNull((Object)queryEo, (String)"queryEo \u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper((Object)queryEo);
        queryWrapper.eq(BaseEo::getDr, (Object)0);
        List performOrderInfoEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        return performOrderInfoEos;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryListByOrderIds(List<Long> orderIds) {
        AssertUtils.notEmpty(orderIds, (String)"orderId\u5217\u8868\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.eq(BaseEo::getDr, (Object)0)).in(BaseEo::getId, orderIds);
        List performOrderInfoEos = this.das.getMapper().selectList((Wrapper)queryWrapper);
        if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)performOrderInfoEos)) {
            return null;
        }
        return performOrderInfoEos;
    }

    @Override
    public String getLatestNo() {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)queryOrderWrapper.orderByDesc(BaseEo::getCreateTime)).orderByDesc(BaseEo::getId)).last(" limit 1");
        DgPerformOrderInfoEo saleOrderEo = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        return saleOrderEo.getSaleOrderNo();
    }

    @Override
    public int optimisticModifySaleOrder(DgPerformOrderInfoEo saleOrderEo, int idealCount, boolean needThrow) {
        log.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), idealCount, needThrow});
        if (Objects.isNull(saleOrderEo)) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (saleOrderEo.getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo);
        int optCount = this.das.getMapper().updateSelective((BaseEo)saleOrderEo);
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        return optCount;
    }

    @Override
    public int optimisticModifySaleOrder(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> queryWrapper, int idealCount, boolean needThrow) {
        log.info("optimisticModifySaleOrder\u5165\u53c2saleOrderEo={}\uff0cqueryWrapper={}\uff0cidealCount={}\uff0cneedThrow={}", new Object[]{JSON.toJSONString((Object)saleOrderEo), JSON.toJSONString(queryWrapper), idealCount, needThrow});
        if (queryWrapper.isEmptyOfWhere()) {
            throw new BizException("-1", "\u66f4\u65b0\u6761\u4ef6\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        if (((DgPerformOrderInfoEo)queryWrapper.getEntity()).getId() == null) {
            throw new BizException("-1", "\u66f4\u65b0id\u4e0d\u5141\u8bb8\u4e3a\u7a7a");
        }
        this.das.setUpdateSystemFields((BaseEo)saleOrderEo);
        this.popOrderStatusLog(saleOrderEo, queryWrapper);
        int optCount = this.das.getMapper().update((Object)saleOrderEo, queryWrapper);
        if (this.das.isUseCache()) {
            DgPerformOrderInfoEo entity = (DgPerformOrderInfoEo)queryWrapper.getEntity();
            this.das.removeLogicCache((BaseEo)entity);
            this.das.removeCache((Object)entity.getId());
            this.das.removeCacheByExample((BaseEo)entity);
        }
        if (needThrow && optCount != idealCount) {
            throw new BizException("-1", "\u66f4\u65b0\u8ba2\u5355\u72b6\u6001\u5931\u8d25");
        }
        if (TransactionSynchronizationManager.isSynchronizationActive()) {
            this.publisher.publishEvent((Object)new PerformOrderInfoUpdateEvent(((DgPerformOrderInfoEo)queryWrapper.getEntity()).getId()));
        }
        return optCount;
    }

    private void popOrderStatusLog(DgPerformOrderInfoEo saleOrderEo) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)saleOrderEo.getId());
        DgPerformOrderInfoEo saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    private void popOrderStatusLog(DgPerformOrderInfoEo saleOrderEo, UpdateWrapper<DgPerformOrderInfoEo> updateWrapper) {
        LambdaQueryWrapper queryOrderWrapper = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)queryOrderWrapper.eq(BaseEo::getDr, (Object)0)).eq(BaseEo::getId, (Object)((DgPerformOrderInfoEo)updateWrapper.getEntity()).getId());
        DgPerformOrderInfoEo saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
        if (Objects.isNull(saleOrderDasOne)) {
            int retryCount = 0;
            while (Objects.isNull(saleOrderDasOne) && retryCount <= 10) {
                try {
                    saleOrderDasOne = (DgPerformOrderInfoEo)this.das.getMapper().selectOne((Wrapper)queryOrderWrapper);
                    log.info("\u672a\u67e5\u8be2\u5230\u6570\u636e\uff0c\u7b2c{}\u6b21\u91cd\u8bd5", (Object)retryCount);
                    if (!Objects.isNull(saleOrderDasOne)) continue;
                    ++retryCount;
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }
        String orderSteps = saleOrderDasOne.getOrderSteps();
        List<DgOrderStatusLogRespDto> orderStatusLogRespDtos = Lists.newArrayList();
        if (StringUtils.isNotBlank((CharSequence)orderSteps)) {
            orderStatusLogRespDtos = JSON.parseArray((String)orderSteps, DgOrderStatusLogRespDto.class);
        }
        if (StringUtils.isNotBlank((CharSequence)saleOrderEo.getOrderStatus())) {
            DgOrderStatusLogRespDto orderStatusLogRespDto = new DgOrderStatusLogRespDto();
            orderStatusLogRespDto.setOrderStatus(saleOrderEo.getOrderStatus());
            orderStatusLogRespDto.setOptDate(new Date());
            orderStatusLogRespDto.setOptPerson((String)ObjectUtil.defaultIfNull((Object)ServiceContext.getContext().getRequestUserCode(), (Object)"system"));
            orderStatusLogRespDtos.add(orderStatusLogRespDto);
            saleOrderEo.setOrderSteps(JSON.toJSONString(orderStatusLogRespDtos));
        }
    }

    @Override
    public void removeLabel(Long saleOrderId, String oriLabel, String ... optLabels) {
        log.info("[\u8ba2\u5355\u6253\u6807\u79fb\u9664] saleOrderId={}, oriLabel={}, optLabel={}", new Object[]{saleOrderId, oriLabel, optLabels});
        AssertUtils.notNull((Object)saleOrderId, (String)"saleOrderId \u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.notNull((Object)optLabels, (String)"optLabels \u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
        updateEo.setId(saleOrderId);
        String newLabel = DgOrderOptLabelUtils.removeLabel(oriLabel, optLabels);
        updateEo.setOptLabel(newLabel);
        this.updateSaleOrderById(saleOrderId, updateEo);
    }

    @Override
    public void removePlanShipmentEnterpriseInfo(Long orderId) {
        this.das.removePlanShipmentEnterpriseInfo(orderId);
    }

    @Override
    public void cleanSourceData(Long orderId) {
        this.das.cleanSourceData(orderId);
    }

    @Override
    public void removeLogicalWarehouseCode(Long orderId) {
        this.das.removeLogicalWarehouseCode(orderId);
    }

    @Override
    public void removeShipmentEnterprise(Long orderId) {
        this.das.removeShipmentEnterprise(orderId);
    }

    @Override
    public void removeDeliveryLogicalWarehouseCode(Long saleOrderId) {
        this.das.removeDeliveryLogicalWarehouseCode(saleOrderId);
    }

    @Override
    public void modifyOrderRemark(OrderRemarkReqDto reqDto) {
        if (reqDto.getId() != null) {
            DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.das.selectByPrimaryKey(reqDto.getId());
            if (dgPerformOrderInfoEo != null) {
                DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
                updateEo.setId(reqDto.getId());
                if (reqDto.getCoverFlag().booleanValue()) {
                    updateEo.setRemark(reqDto.getRemark());
                } else {
                    updateEo.setRemark(dgPerformOrderInfoEo.getRemark() == null ? "" : dgPerformOrderInfoEo.getRemark().concat(reqDto.getRemark()));
                }
                this.das.updateSelective((BaseEo)updateEo);
            }
        } else {
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)reqDto.getIds())) {
                return;
            }
            List dgPerformOrderInfoEos = ((ExtQueryChainWrapper)this.das.filter().in((Object)"id", (Collection)reqDto.getIds())).list();
            if (org.apache.commons.collections.CollectionUtils.isEmpty((Collection)dgPerformOrderInfoEos)) {
                return;
            }
            for (DgPerformOrderInfoEo dgPerformOrderInfoEo : dgPerformOrderInfoEos) {
                DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
                updateEo.setId(dgPerformOrderInfoEo.getId());
                updateEo.setRemark(dgPerformOrderInfoEo.getRemark() == null ? "" : dgPerformOrderInfoEo.getRemark().concat(reqDto.getRemark()));
                this.das.updateSelective((BaseEo)updateEo);
            }
        }
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public DgPerformOrderInfoEo queryEoBySaleOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).one();
    }

    @Override
    public List<DgPerformOrderInfoEo> querySplitEoByPlatformOrderNo(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).ne((Object)"order_status", (Object)DgOmsSaleOrderStatus.SPLIT.getCode())).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public void modifyOrderSellerRemark(DgModifyOrderRemarkReqDto reqDto) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)reqDto.getPlatformOrderNo()), (String)"\u5e73\u53f0\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        List orderInfoEos = ((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)reqDto.getPlatformOrderNo())).list();
        AssertUtils.isFalse((boolean)org.apache.commons.collections.CollectionUtils.isEmpty((Collection)orderInfoEos), (String)"\u6839\u636e\u5e73\u53f0\u8ba2\u5355\u53f7\u627e\u4e0d\u5230\u8ba2\u5355\u4fe1\u606f");
        for (DgPerformOrderInfoEo orderInfoEo : orderInfoEos) {
            DgPerformOrderInfoEo updateEo = new DgPerformOrderInfoEo();
            updateEo.setId(orderInfoEo.getId());
            if (StringUtils.isNotBlank((CharSequence)reqDto.getSellerRemark())) {
                updateEo.setSellerRemark(reqDto.getSellerRemark());
            }
            if (StringUtils.isNotBlank((CharSequence)reqDto.getBuyerRemark())) {
                updateEo.setBuyerRemark(reqDto.getBuyerRemark());
            }
            this.das.updateSelective((BaseEo)updateEo);
        }
    }

    @Override
    public void logicDeleteRelationInfoByOrderIds(List<String> platformOrderNos) {
        List orderInfoEoList = ((ExtQueryChainWrapper)this.dgPerformOrderInfoDomain.filter().in((Object)"platform_order_no", platformOrderNos)).list();
        if (CollectionUtils.isEmpty((Collection)orderInfoEoList)) {
            return;
        }
        List orderInfoEos = orderInfoEoList.stream().filter(eo -> eo.getOrderStatus().equals(DgOmsSaleOrderStatus.CREATED.getCode())).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isEmpty(orderInfoEos)) {
            return;
        }
        List orderIds = orderInfoEoList.stream().map(BaseEo::getId).collect(Collectors.toList());
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(orderIds)) {
            this.dgPerformOrderInfoMapper.deleteLogicByIds(orderIds);
            this.performOrderSnapshotDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderSnapshotEo.class).in(DgPerformOrderSnapshotEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.performOrderPaymentDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderPaymentEo.class).in(DgPerformOrderPaymentEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.dgPerformOrderLineDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderLineEo.class).in(DgPerformOrderLineEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.dgPerformOrderLineAmountDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderLineAmountEo.class).in(DgPerformOrderLineAmountEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.dgPerformOrderItemLineDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderItemLineEo.class).in(DgPerformOrderItemLineEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.dgPerformOrderItemLineAmountDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderItemLineAmountEo.class).in(DgPerformOrderItemLineAmountEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
            this.dgPerformOrderAddrDomain.getMapper().updateAll(null, (Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)Wrappers.lambdaUpdate(DgPerformOrderAddrEo.class).in(DgPerformOrderAddrEo::getOrderId, orderIds)).eq(BaseEo::getDr, (Object)YesOrNoEnum.NO.getType())).set(BaseEo::getDr, (Object)YesOrNoEnum.YES.getType()));
        }
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNos(List<String> platformOrderNos) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"platform_order_no", platformOrderNos)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public DgPerformOrderRespDto queryDtoById(Long saleOrderId) {
        AssertUtils.isFalse((saleOrderId == null ? 1 : 0) != 0, (String)"\u67e5\u8be2\u53c2\u6570saleOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)this.das.selectByPrimaryKey(saleOrderId);
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)dgPerformOrderInfoEo, (String[])new String[0]);
        return respDto;
    }

    @Override
    public DgPerformOrderRespDto queryDtoByOrderNo(String saleOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)saleOrderNo), (String)"\u67e5\u8be2\u53c2\u6570saleOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo dgPerformOrderInfoEo = (DgPerformOrderInfoEo)((ExtQueryChainWrapper)this.das.filter().eq((Object)"sale_order_no", (Object)saleOrderNo)).one();
        AssertUtils.isFalse((dgPerformOrderInfoEo == null ? 1 : 0) != 0, (String)"\u672a\u67e5\u8be2\u5230\u8ba2\u5355\u4fe1\u606f");
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        CubeBeanUtils.copyProperties((Object)respDto, (Object)dgPerformOrderInfoEo, (String[])new String[0]);
        return respDto;
    }

    @Override
    public List<DgPerformOrderRespDto> queryOrderByAddressIds(List<Long> addressIds) {
        return this.das.queryOrderByAddressIds(addressIds);
    }

    @Override
    public void modifyBusinessRevokeReason(Long orderId, String businessRevokeReason) {
        AssertUtils.isFalse((orderId == null ? 1 : 0) != 0, (String)"\u53c2\u6570orderId\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo infoEo = new DgPerformOrderInfoEo();
        infoEo.setId(orderId);
        infoEo.setRevokeReason(businessRevokeReason);
        this.das.updateSelective((BaseEo)infoEo);
    }

    @Override
    public void modifyFinancialRevokeReason(Long id, String financialRevokeReason) {
        AssertUtils.isFalse((id == null ? 1 : 0) != 0, (String)"\u53c2\u6570id\u4e0d\u80fd\u4e3a\u7a7a");
        DgPerformOrderInfoEo info = new DgPerformOrderInfoEo();
        info.setId(id);
        info.setRevokeReason(financialRevokeReason);
        this.das.updateSelective((BaseEo)info);
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNoAndPlatformOrderIdNotNull(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).isNotNull((Object)"platform_order_id")).list();
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNoAndPlatformOrderIdIsNull(String platformOrderNo) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).isNull((Object)"platform_order_id")).list();
    }

    @Override
    public List<OrderItemLimitRespVo> countNormalOrderItem(String orderType, List<String> normalStatus, Long receivingStoreId, Long customerId, List<Long> skuIds, String saleOrderNo) {
        return this.das.countNormalOrderItem(orderType, normalStatus, receivingStoreId, customerId, skuIds, saleOrderNo);
    }

    @Override
    public List<OrderItemLimitRespVo> countAfterOrderItem(String orderType, List<String> normalStatus, Long receivingStoreId, Long customerId, List<Long> skuIds) {
        return this.das.countAfterOrderItem(orderType, normalStatus, receivingStoreId, customerId, skuIds);
    }

    private DgPerformOrderRespDto eo2DtoFunc(DgPerformOrderInfoEo performOrderInfoEo) {
        DgPerformOrderRespDto respDto = new DgPerformOrderRespDto();
        DgPerformOrderExtensionDto performOrderExtensionDto = this.performOrderExtensionDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderExtensionDto).ifPresent(dto -> respDto.setPerformOrderExtensionDto(dto));
        DgPerformOrderPaymentDto performOrderPaymentDto = this.performOrderPaymentDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderPaymentDto).ifPresent(dto -> respDto.setPerformOrderPaymentDto(dto));
        DgPerformOrderSnapshotDto performOrderSnapshotDto = this.performOrderSnapshotDomain.selectDtoByOrderId(performOrderInfoEo.getId());
        Optional.ofNullable(performOrderSnapshotDto).ifPresent(dto -> respDto.setPerformOrderSnapshotDto(dto));
        return respDto;
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoBySaleOrderNos(List<String> saleOrderNos) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"sale_order_no", saleOrderNos)).eq((Object)"dr", (Object)0)).list();
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNoAndOrderType(String platformOrderNo, String orderType) {
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)platformOrderNo), (String)"\u8bf7\u6c42\u53c2\u6570platformOrderNo\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)orderType), (String)"\u8bf7\u6c42\u53c2\u6570orderType\u4e0d\u80fd\u4e3a\u7a7a");
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"platform_order_no", new Object[]{platformOrderNo})).eq((Object)"dr", (Object)0)).eq((Object)"order_type", (Object)orderType)).list();
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByPlatformOrderNoAndExchangeOrderId(String platformOrderNo, Long exchangeOrderId) {
        AssertUtils.notNull((Object)exchangeOrderId, (String)"\u8bf7\u6c42\u53c2\u6570exchangeOrderId\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isNotBlank((CharSequence)platformOrderNo)) {
            return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"platform_order_no", (Object)platformOrderNo)).eq((Object)"dr", (Object)0)).eq((Object)"exchange_order_id", (Object)exchangeOrderId)).list();
        }
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().eq((Object)"dr", (Object)0)).eq((Object)"exchange_order_id", (Object)exchangeOrderId)).list();
    }

    @Override
    public List<DgPerformOrderRespDto> queryPerformOrderList(DgPerformOrderReqDto reqDto) {
        return this.das.queryPerformOrderList(reqDto);
    }

    @Override
    public List<SaleOrderAuditVo> queryOrderAuditByOrderNos(List<String> saleOrderNos) {
        return this.das.queryOrderAuditByOrderNos(saleOrderNos);
    }

    @Override
    public List<DgPerformOrderInfoEo> queryEoByDistributionOrderNos(List<String> distributionOrderNos) {
        return ((ExtQueryChainWrapper)((ExtQueryChainWrapper)this.das.filter().in((Object)"distribution_order_no", distributionOrderNos)).eq((Object)"dr", (Object)0)).list();
    }
}

