/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.domain.order.oms;

import com.dtyunxi.eo.BaseEo;
import com.yunxi.dg.base.center.trade.constants.amount.DgOmsOrderAmountTypeEnum;
import com.yunxi.dg.base.center.trade.constants.amount.DgOrderAmountSourceEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderAmountDomain;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderCalculatorAmountModeDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderLineBizQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderInfoDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderItemDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderLineDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgF2BPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPreviewPerformOrderItemReqDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.oms.DgOmsOrderItemLineAmoutReqDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.f2b.preview.DgF2BOrderPreviewContext;
import com.yunxi.dg.base.center.trade.dto.response.DgPerformOrderLineDetailDto;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineAmountEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderItemLineEo;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Resource;
import org.apache.commons.collections.MapUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NamedThreadLocal;
import org.springframework.stereotype.Component;

@Component
public class DgOmsOrderCalculatorAmountModeDomain
implements IDgOmsOrderCalculatorAmountModeDomain {
    private static final Logger log = LoggerFactory.getLogger(DgOmsOrderCalculatorAmountModeDomain.class);
    private static final ThreadLocal<Map<String, BigDecimal>> CACHE_DIGIT_DIFFERENCE = new NamedThreadLocal("\u66ff\u6362\u8865\u5dee\u79ef\u5206\u548c\u91d1\u989d\u7f13\u5b58");
    private static final String ACCUMULATED_REALPAYAMOUNT = "accumulatedRealPayAmount";
    private static final String ACCUMULATED_ITEMINTEGRAL = "accumulatedItemIntegral";
    @Resource
    private IDgPerformOrderInfoDomain performOrderInfoDomain;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IDgOmsOrderLineBizQueryDomain omsOrderLineBizQueryDomain;
    @Resource
    private IDgPerformOrderAmountDomain dgPerformOrderAmountDomain;

    @Override
    public BigDecimal calculateAverageAmount(BigDecimal amount, BigDecimal count, int newScale, int roundingMode) {
        return Optional.ofNullable(amount).orElse(BigDecimal.ZERO).divide(count, newScale, roundingMode);
    }

    @Override
    public List<DgPerformOrderItemLineAmountEo> calculatorItemLineAmountForCreate(DgPerformOrderItemLineEo orderItemLineEo, DgOmsOrderItemLineAmoutReqDto amoutReqDto, int indexGoodItem, Long id) {
        ArrayList<DgPerformOrderItemLineAmountEo> list = new ArrayList<DgPerformOrderItemLineAmountEo>();
        BigDecimal payAmount = BigDecimal.ZERO;
        BigDecimal realPayAmount = BigDecimal.ZERO;
        BigDecimal discountAmount = BigDecimal.ZERO;
        if (amoutReqDto.getCalcItemNum().intValue() - 1 > indexGoodItem) {
            payAmount = amoutReqDto.getAveragePayAmount();
            realPayAmount = amoutReqDto.getAverageRealPayAmount();
            discountAmount = amoutReqDto.getAverageDiscountAmount();
        } else {
            payAmount = Optional.ofNullable(amoutReqDto.getPayAmount()).orElse(BigDecimal.ZERO).subtract(amoutReqDto.getAveragePayAmount().multiply(BigDecimal.valueOf(indexGoodItem)));
            realPayAmount = Optional.ofNullable(amoutReqDto.getRealPayAmount()).orElse(BigDecimal.ZERO).subtract(amoutReqDto.getAverageRealPayAmount().multiply(BigDecimal.valueOf(indexGoodItem)));
            discountAmount = Optional.ofNullable(amoutReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO).subtract(amoutReqDto.getAverageDiscountAmount().multiply(BigDecimal.valueOf(indexGoodItem)));
            log.info("[\u91d1\u989d\u8ba1\u7b97]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u884c\u7684\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d={},\u4f18\u60e0\u91d1\u989d={}", new Object[]{payAmount, discountAmount, realPayAmount});
        }
        DgPerformOrderItemLineAmountEo payEo = new DgPerformOrderItemLineAmountEo();
        payEo.setOrderId(orderItemLineEo.getOrderId());
        payEo.setOrderItemLineId(orderItemLineEo.getId());
        payEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
        payEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_ORIG_PRICE.getCode());
        payEo.setAmount(payAmount);
        list.add(payEo);
        DgPerformOrderItemLineAmountEo surplusCanRefundPayEo = new DgPerformOrderItemLineAmountEo();
        surplusCanRefundPayEo.setOrderId(orderItemLineEo.getOrderId());
        surplusCanRefundPayEo.setOrderItemLineId(orderItemLineEo.getId());
        surplusCanRefundPayEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
        surplusCanRefundPayEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_SURPLIUS_CAN_REFUND_PAY_AMOUNT.getCode());
        surplusCanRefundPayEo.setAmount(payAmount);
        list.add(surplusCanRefundPayEo);
        DgPerformOrderItemLineAmountEo realPayEo = new DgPerformOrderItemLineAmountEo();
        realPayEo.setOrderId(orderItemLineEo.getOrderId());
        realPayEo.setOrderItemLineId(orderItemLineEo.getId());
        realPayEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
        realPayEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_ACTUAL_PRICE.getCode());
        realPayEo.setAmount(realPayAmount);
        list.add(realPayEo);
        DgPerformOrderItemLineAmountEo discountEo = new DgPerformOrderItemLineAmountEo();
        discountEo.setOrderId(orderItemLineEo.getOrderId());
        discountEo.setOrderItemLineId(orderItemLineEo.getId());
        discountEo.setAmountSource(DgOrderAmountSourceEnum.ORDER_ITEM_BASE.getCode());
        discountEo.setAccountType(DgOmsOrderAmountTypeEnum.ITEM_DISCOUNT_AMOUNT.getCode());
        discountEo.setAmount(discountAmount);
        list.add(discountEo);
        return list;
    }

    @Override
    public void calculatorOrderAmountBySplit(List<DgPerformOrderRespDto> childOrderList) {
        for (int i = 1; i < childOrderList.size(); ++i) {
            DgPerformOrderRespDto orderRespDto = childOrderList.get(i);
            orderRespDto.setId(orderRespDto.getId());
            orderRespDto.setFreightCost(BigDecimal.ZERO);
            this.performOrderInfoDomain.modifySaleOrder((DgPerformOrderInfoDto)orderRespDto);
        }
    }

    @Override
    public void calculatorGroupItemAmount(DgPerformOrderItemReqDto orderItemReqDto, DgPerformOrderLineDetailDto orderLineDetailDto, int index) {
        BigDecimal itemTotalSaleAmount = orderItemReqDto.getSubItemList().parallelStream().map(item -> item.getSalePrice().multiply(item.getItemNum().multiply(orderItemReqDto.getItemNum()))).reduce(BigDecimal.ZERO, BigDecimal::add);
        log.info("[\u91d1\u989d\u8ba1\u7b97]\u7ec4\u5408\u5546\u54c1\u7684\u603b\u9500\u552e\u4ef7={}", (Object)itemTotalSaleAmount);
        if (orderItemReqDto.getSubItemList().size() - 1 > index) {
            DgPerformOrderItemReqDto subItem = (DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(index);
            BigDecimal platformSupplyPrice = BigDecimal.ZERO;
            if (orderItemReqDto.getPlatformSupplyPrice() != null) {
                platformSupplyPrice = orderItemReqDto.getPlatformSupplyPrice().multiply(subItem.getPriceAllocationRatio()).setScale(2, 4);
                orderLineDetailDto.setPlatformSupplyPrice(platformSupplyPrice);
                subItem.setPlatformSupplyPrice(platformSupplyPrice);
            }
            BigDecimal payAmount = orderLineDetailDto.getGroupItemPayAmount().multiply(subItem.getPriceAllocationRatio()).setScale(2, 4);
            orderLineDetailDto.setPayAmount(payAmount);
            BigDecimal discountAmount = orderLineDetailDto.getGroupItemDiscountAmount().multiply(subItem.getPriceAllocationRatio()).setScale(2, 4);
            orderLineDetailDto.setDiscountAmount(discountAmount);
            BigDecimal price = payAmount.divide(orderLineDetailDto.getCalcItemNum(), 6, 4);
            orderLineDetailDto.setPrice(price);
            orderLineDetailDto.setTransactionPrice(price);
            BigDecimal realPayAmount = orderItemReqDto.getRealPayAmount().multiply(subItem.getPriceAllocationRatio()).setScale(2, 4);
            orderLineDetailDto.setRealPayAmount(realPayAmount);
            subItem.setRealPayAmount(realPayAmount);
            BigDecimal saleAmount = realPayAmount.add(discountAmount);
            BigDecimal salePrice = saleAmount.divide(orderLineDetailDto.getCalcItemNum(), 6, 4).setScale(6, 4);
            orderLineDetailDto.setSalePrice(salePrice);
            orderLineDetailDto.setSaleAmount(saleAmount);
            log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={},\u5546\u54c1\u6570\u91cf\uff1a{}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u6210\u4ea4\u5355\u4ef7={},\u5b9e\u4ed8\u5355\u4ef7={}, \u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}, \u4f9b\u8d27\u4ef7={}", new Object[]{orderLineDetailDto.getSkuCode(), orderLineDetailDto.getItemNum(), payAmount, price, realPayAmount, discountAmount, saleAmount, platformSupplyPrice});
            subItem.setPayAmount(payAmount);
            subItem.setDiscountAmount(discountAmount);
        } else {
            BigDecimal hadPaymentAmount = BigDecimal.ZERO;
            BigDecimal hadDiscountAmount = BigDecimal.ZERO;
            BigDecimal hadRealPaymentAmount = BigDecimal.ZERO;
            BigDecimal hadPlatformSupplyPrice = BigDecimal.ZERO;
            for (int i = 0; i < orderItemReqDto.getSubItemList().size() - 1; ++i) {
                DgPerformOrderItemReqDto saleOrderItemReqDto = (DgPerformOrderItemReqDto)orderItemReqDto.getSubItemList().get(i);
                hadPaymentAmount = hadPaymentAmount.add(Optional.ofNullable(saleOrderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO));
                hadDiscountAmount = hadDiscountAmount.add(Optional.ofNullable(saleOrderItemReqDto.getDiscountAmount()).orElse(BigDecimal.ZERO));
                hadRealPaymentAmount = hadRealPaymentAmount.add(Optional.ofNullable(saleOrderItemReqDto.getRealPayAmount()).orElse(BigDecimal.ZERO));
                if (orderItemReqDto.getPlatformSupplyPrice() == null) continue;
                hadPlatformSupplyPrice = hadPlatformSupplyPrice.add(saleOrderItemReqDto.getPlatformSupplyPrice());
            }
            BigDecimal payAmount = orderItemReqDto.getPayAmount().subtract(hadPaymentAmount);
            BigDecimal discountAmount = orderItemReqDto.getDiscountAmount().subtract(hadDiscountAmount);
            BigDecimal realPayAmount = orderItemReqDto.getRealPayAmount().subtract(hadRealPaymentAmount);
            BigDecimal platformSupplyPrice = BigDecimal.ZERO;
            if (orderItemReqDto.getPlatformSupplyPrice() != null) {
                platformSupplyPrice = orderItemReqDto.getPlatformSupplyPrice().subtract(hadPlatformSupplyPrice);
            }
            BigDecimal saleAmount = realPayAmount.add(discountAmount);
            BigDecimal salePrice = saleAmount.divide(orderLineDetailDto.getCalcItemNum(), 6, 4).setScale(6, 4);
            BigDecimal price = payAmount.divide(orderLineDetailDto.getCalcItemNum(), 6, 4);
            orderLineDetailDto.setPayAmount(payAmount);
            orderLineDetailDto.setDiscountAmount(discountAmount);
            orderLineDetailDto.setSalePrice(salePrice);
            orderLineDetailDto.setSaleAmount(saleAmount);
            orderLineDetailDto.setRealPayAmount(realPayAmount);
            orderLineDetailDto.setPrice(price);
            orderLineDetailDto.setTransactionPrice(price);
            if (orderItemReqDto.getPlatformSupplyPrice() != null) {
                orderLineDetailDto.setPlatformSupplyPrice(platformSupplyPrice);
            }
            log.info("[\u91d1\u989d\u8ba1\u7b97]\u8ba1\u7b97\u7ec4\u5408\u5546\u54c1skuCode={},\u5546\u54c1\u6570\u91cf\uff1a{}, \u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{},\u6210\u4ea4\u5355\u4ef7={},\u5b9e\u4ed8\u5355\u4ef7={},\u4f18\u60e0\u91d1\u989d={}, \u4f18\u60e0\u540e\u7684\u96f6\u552e\u4ef7={}, \u4f9b\u8d27\u4ef7={}", new Object[]{orderLineDetailDto.getSkuCode(), orderLineDetailDto.getItemNum(), payAmount, price, realPayAmount, discountAmount, saleAmount, platformSupplyPrice});
        }
    }

    @Override
    public void calculatorOrderAmount(List<DgPerformOrderRespDto> childOrderList) {
        childOrderList.forEach(dto -> {
            List<DgPerformOrderLineDto> orderLineDtoList = this.omsOrderLineBizQueryDomain.queryOrderLineByOrderId(dto.getId());
            BigDecimal goodsTotalNum = orderLineDtoList.stream().map(DgPerformOrderLineDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal goodsTotalAmount = Optional.ofNullable(orderLineDtoList.stream().map(saleOrderItemReqDto -> {
                if (saleOrderItemReqDto.getSalePrice() != null) {
                    return saleOrderItemReqDto.getSalePrice().multiply(saleOrderItemReqDto.getItemNum());
                }
                return BigDecimal.ZERO;
            }).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
            BigDecimal discountAmount = Optional.ofNullable(orderLineDtoList.stream().map(DgPerformOrderLineDto::getDiscountAmount).filter(Objects::nonNull).reduce(BigDecimal.ZERO, BigDecimal::add)).orElse(BigDecimal.ZERO);
            BigDecimal freightCost = Optional.ofNullable(dto.getFreightCost()).orElse(BigDecimal.ZERO);
            BigDecimal payAmount = orderLineDtoList.stream().map(DgPerformOrderLineDto::getPayAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
            BigDecimal merchantReceivableAmount = goodsTotalAmount.add(freightCost).subtract(discountAmount);
            log.info("[\u65b0\u589e\u9500\u552e\u8ba2\u5355]\u5546\u54c1\u603b\u6570\u91cf\uff1a{}\uff0c\u5546\u54c1\u603b\u91d1\u989d\uff1a{}\uff0c\u6210\u4ea4\u91d1\u989d\uff1a{}, \u4f18\u60e0\u603b\u91d1\u989d\uff1a{}, \u5546\u5bb6\u5e94\u6536\uff1a{}", new Object[]{goodsTotalNum, goodsTotalAmount, payAmount, discountAmount, merchantReceivableAmount});
            DgPerformOrderReqDto updateReqDto = new DgPerformOrderReqDto();
            updateReqDto.setId(dto.getId());
            updateReqDto.setGoodsTotalNum(goodsTotalNum);
            updateReqDto.setGoodsTotalAmount(goodsTotalAmount);
            updateReqDto.setPayAmount(payAmount);
            updateReqDto.setRealPayAmount(payAmount);
            updateReqDto.setDiscountAmount(discountAmount);
            updateReqDto.setMerchantReceivableAmount(merchantReceivableAmount);
            this.performOrderInfoDomain.modifySaleOrder((DgPerformOrderInfoDto)updateReqDto);
            DgPerformOrderAmountEo amountEo = new DgPerformOrderAmountEo();
            amountEo.setId(dto.getPerformOrderAmountDto().getId());
            amountEo.setGoodsTotalNum(goodsTotalNum);
            amountEo.setGoodsTotalAmount(goodsTotalAmount);
            amountEo.setPayAmount(payAmount);
            amountEo.setRealPayAmount(payAmount);
            amountEo.setDiscountAmount(discountAmount);
            amountEo.setMerchantReceivableAmount(merchantReceivableAmount);
            this.dgPerformOrderAmountDomain.updateSelective((BaseEo)amountEo);
        });
    }

    @Override
    public void calculatorOrderItemAmountForDifference(DgPerformOrderItemReqDto orderItemReqDto, DgPerformOrderLineDto oriOrderItemRespDto, int index, int lastIndex) {
        BigDecimal price = orderItemReqDto.getPayAmount().divide(orderItemReqDto.getItemNum(), 6, 4);
        orderItemReqDto.setPrice(price);
        BigDecimal salePrice = orderItemReqDto.getPayAmount().add(orderItemReqDto.getDiscountAmount()).divide(orderItemReqDto.getItemNum(), 6, 4);
        orderItemReqDto.setSalePrice(salePrice);
        if (index < lastIndex) {
            BigDecimal payAmount = orderItemReqDto.getPayAmount().divide(oriOrderItemRespDto.getPayAmount(), 6, 4).multiply(Optional.ofNullable(oriOrderItemRespDto.getPayAmount()).orElse(BigDecimal.ZERO)).setScale(2, 4);
            orderItemReqDto.setPayAmount(payAmount);
            orderItemReqDto.setRealPayAmount(payAmount);
            this.accumulatedRealPayAmount(payAmount);
            log.info("[\u4e00\u5143\u8865\u5dee]\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0cskucode={}", new Object[]{price, salePrice, payAmount, orderItemReqDto.getSkuCode()});
        } else {
            BigDecimal accumulatedRealPayAmount = this.getAccumulatedDigit(ACCUMULATED_REALPAYAMOUNT);
            BigDecimal lastRealPayAmount = Optional.ofNullable(orderItemReqDto.getPayAmount()).orElse(BigDecimal.ZERO).subtract(accumulatedRealPayAmount);
            orderItemReqDto.setPayAmount(lastRealPayAmount);
            orderItemReqDto.setRealPayAmount(lastRealPayAmount);
            log.info("[\u4e00\u5143\u8865\u5dee]\u6700\u540e\u4e00\u4e2a\u5546\u54c1\u6210\u4ea4\u91d1\u989d\u4e3a\uff1a{}, \u96f6\u552e\u5355\u4ef7\u4e3a\uff1a{},\u5b9e\u4ed8\u91d1\u989d\uff1a{}\uff0cskucode={}", new Object[]{price, salePrice, lastRealPayAmount, orderItemReqDto.getSkuCode()});
            CACHE_DIGIT_DIFFERENCE.remove();
        }
    }

    private void accumulatedRealPayAmount(BigDecimal realPayAmount) {
        Map<String, BigDecimal> accumulatedMap = CACHE_DIGIT_DIFFERENCE.get();
        if (MapUtils.isEmpty(accumulatedMap)) {
            accumulatedMap = new ConcurrentHashMap<String, BigDecimal>();
            CACHE_DIGIT_DIFFERENCE.set(accumulatedMap);
        }
        BigDecimal accumulatedRealPayAmount = Optional.ofNullable(accumulatedMap.get(ACCUMULATED_REALPAYAMOUNT)).orElse(BigDecimal.ZERO).add(realPayAmount);
        accumulatedMap.put(ACCUMULATED_REALPAYAMOUNT, accumulatedRealPayAmount);
        log.info("[\u4e00\u5143\u8865\u5dee]\u7d2f\u8ba1\u5b9e\u4ed8\u91d1\u989d\u4e3a\uff1a{}", (Object)accumulatedRealPayAmount);
    }

    private BigDecimal getAccumulatedDigit(String key) {
        Map<String, BigDecimal> accumulatedMap = CACHE_DIGIT_DIFFERENCE.get();
        if (accumulatedMap == null) {
            return BigDecimal.ZERO;
        }
        return Optional.ofNullable(accumulatedMap.get(key)).orElse(BigDecimal.ZERO);
    }

    @Override
    public void calculateF2BOrderBaseAmount(DgF2BOrderPreviewContext previewRespDto) {
        DgF2BPerformOrderReqDto previewReqDto = previewRespDto.getDgF2BPerformOrderReqDto();
        BigDecimal totalAmount = BigDecimal.ZERO;
        BigDecimal totalPayAmount = BigDecimal.ZERO;
        BigDecimal totalRealPayAmount = BigDecimal.ZERO;
        List allItemList = Stream.of(previewReqDto.getItemList(), previewReqDto.getMaterialList()).flatMap(Collection::stream).collect(Collectors.toList());
        for (DgPreviewPerformOrderItemReqDto orderItemReqDto : allItemList) {
            BigDecimal itemNum = orderItemReqDto.getCalcItemNum();
            BigDecimal itemTotalAmount = orderItemReqDto.getItemMarketPrice().multiply(itemNum).setScale(2, RoundingMode.HALF_UP);
            BigDecimal payAmount = itemTotalAmount.subtract(orderItemReqDto.getDiscountAmount());
            BigDecimal realPayAmount = payAmount.subtract(orderItemReqDto.getTotalUseCostAmount());
            orderItemReqDto.setSaleAmount(itemTotalAmount);
            orderItemReqDto.setPayAmount(payAmount);
            orderItemReqDto.setRealPayAmount(realPayAmount);
            orderItemReqDto.setItemOrigAmount(itemTotalAmount);
            totalAmount = totalAmount.add(itemTotalAmount);
            totalPayAmount = totalPayAmount.add(payAmount);
            totalRealPayAmount = totalRealPayAmount.add(realPayAmount);
            log.info("\u6ca1\u6709\u4fc3\u9500\u6d3b\u52a8\u8ba1\u7b97");
            log.info("\u5546\u54c1skuCode: " + orderItemReqDto.getSkuCode() + ",\u9500\u552e\u4ef7(\u653f\u7b56\u4ef7): " + orderItemReqDto.getItemMarketPrice() + ",\u9500\u552e\u91d1\u989d(\u5546\u54c1\u603b\u91d1\u989d): " + orderItemReqDto.getSaleAmount() + ",\u4f18\u60e0\u91d1\u989d: " + orderItemReqDto.getDiscountAmount() + ",\u6210\u4ea4\u91d1\u989d: " + orderItemReqDto.getPayAmount() + ",\u9700\u8981\u5b9e\u4ed8\u91d1\u989d: " + orderItemReqDto.getRealPayAmount() + ",\u9500\u552e\u5355\u4f4d: " + orderItemReqDto.getOrderItemUnit() + ",\u9500\u552e\u5355\u4f4d\u540d\u79f0: " + orderItemReqDto.getOrderItemUnitName() + ",\u8ba1\u4ef7\u5355\u4f4d: " + orderItemReqDto.getCalcUnit() + ",\u8ba1\u4ef7\u5355\u4f4d\u540d\u79f0: " + orderItemReqDto.getCalcUnitDesc());
        }
        previewReqDto.setGoodsTotalNum(allItemList.stream().map(DgPerformOrderItemDto::getCalcItemNum).reduce(BigDecimal.ZERO, BigDecimal::add));
        previewReqDto.setOrigAmount(totalAmount);
        previewReqDto.setOrderTotalAmount(totalAmount);
        previewReqDto.setTotalAmount(totalAmount);
        previewReqDto.setPayAmount(totalPayAmount);
        previewReqDto.setRealPayAmount(totalRealPayAmount);
        log.info("\u8ba2\u5355\u9500\u552e\u603b\u989d: " + totalAmount + ",\u603b\u6210\u4ea4\u91d1\u989d: " + totalPayAmount + ",\u5b9e\u4ed8\u603b\u91d1\u989d: " + totalRealPayAmount + ",");
    }
}

