/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants;

import java.util.Arrays;
import java.util.Map;
import java.util.stream.Collectors;

public enum ShippingTypeEnum {
    PREPLAN("PREPLAN", "\u9884\u914d\u7269\u6d41"),
    ACTUAL_SHIPPING("ACTUAL_SHIPPING", "\u5b9e\u53d1\u7269\u6d41"),
    UPDATE_SHIPPING("UPDATE_SHIPPING", "\u66f4\u6539\u7269\u6d41");

    private String type;
    private String desc;
    public static final Map<String, ShippingTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;

    private ShippingTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static ShippingTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    static {
        CODE_LOOKUP = Arrays.stream(ShippingTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.type, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(ShippingTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.type, thisEnum -> thisEnum.desc));
    }
}

