/*
 * Decompiled with CFR 0.152.
 */
package com.dtyunxi.yundt.cube.center.trade.api.constant;

import com.dtyunxi.cube.commons.exceptions.BizException;
import com.dtyunxi.yundt.cube.center.trade.api.exception.PcpTradeExceptionCode;
import com.google.common.collect.Lists;
import java.util.List;

public enum SaleOrderTypeEnum {
    COMMON_ORDER("common_order", "\u666e\u901a\u8ba2\u5355"),
    AGENCY_ORDER("agency_order", "\u7ecf\u9500\u8ba2\u5355"),
    SHOPPE_ORDER("shoppe_order", "\u4e13\u67dc\u8ba2\u5355"),
    INTEGRAL_ORDER("integral_order", "\u7ecf\u9500\u5546\u79ef\u5206"),
    REPLENISHMENT_ORDER("replenishment_order", "\u8425\u517b\u5bb6\u8d27\u8865"),
    ACTIVITY_ORDER("activity_order", "\u8425\u517b\u5bb6\u6d3b\u52a8"),
    CUSTOMER_REFUNDING_ORDER("customer_refunding_order", "\u6d88\u8d39\u8005\u9000\u6362\u8d27"),
    COMPENSATION_ORDER("compensation_order", "\u7d22\u8d54\u8865\u53d1"),
    QUALITY_REFUNDING_ORDER("quality_refunding_order", "\u8d28\u91cf\u9000\u6362\u8d27"),
    REPLENISH_ORDER("replenish_order", "\u5c11\u8d27\u8865\u53d1"),
    VIRTUAL_ORDER("virtual_order", "\u865a\u62df\u5546\u54c1"),
    CONSIGNMENT_ORDER("consignment_order", "\u501f\u673a\u5bc4\u552e"),
    PRE_SALE_ORDER("pre_sale_order", "\u9884\u552e\u8ba2\u5355"),
    EXCHANGE_ORDER("exchange_order", "\u6362\u8d27\u8ba2\u5355"),
    INFERIOR_QUALITY_ORDER("inferior_quality_order", "\u6b21\u54c1\u9500\u552e\u8ba2\u5355"),
    RECEIVE_ORDER("receive_order", "\u9886\u7528\u8ba2\u5355"),
    AFTER_SALE_ORDER("after_sale_order", "\u552e\u540e\u8ba2\u5355"),
    NUTRITION_INTEGRAL("nutrition_integral", "\u8425\u517b\u5bb6\u79ef\u5206"),
    OTHER_OUT_STOCK("other_out_stock", "\u5176\u4ed6\u51fa\u5e93"),
    INTERNAL_DISTRIBUTION("internal_distribution", "\u5185\u90e8\u5206\u9500"),
    SECONDARY_DISTRIBUTION("secondary_distribution", "\u4e8c\u7ea7\u5206\u9500"),
    CLAIM_REISSUE("claim_reissue", "\u4ed3\u5e93\u7d22\u8d54\u8865\u53d1"),
    CLAIM_POSTING("claim_posting", "\u4ed3\u5e93\u7d22\u8d54\u8fc7\u8d26"),
    CHILD_DIRECT_SALES("child_direct_sales", "\u5b50\u516c\u53f8\u76f4\u9500"),
    PRESALE_ORDER("presale_order", "\u9884\u552e\u8ba2\u5355"),
    COMPENSATION_NOT_ORDER("compensation_not_order", "\u7d22\u8d54\u4e0d\u8865\u53d1"),
    BAIJIAN_DIRECT_SALES("baijian_direct_sales", "\u4f70\u5065\u76f4\u9500"),
    MAIYOU_ALLOT("maiyou_allot", "\u9ea6\u4f18\u8c03\u62e8"),
    SPECIAL_CHANNEL_ORDER("special_channel_order", "\u7279\u6e20\u5355");

    private String type;
    private String desc;
    public static List<String> saleOutOrderTypeList;
    public static List<String> otherOutOrderTypeList;

    private SaleOrderTypeEnum(String type, String desc) {
        this.type = type;
        this.desc = desc;
    }

    public String getType() {
        return this.type;
    }

    public String getDesc() {
        return this.desc;
    }

    public static SaleOrderTypeEnum enumOf(String type) {
        for (SaleOrderTypeEnum typeEnum : SaleOrderTypeEnum.values()) {
            if (!typeEnum.getType().equals(type)) continue;
            return typeEnum;
        }
        throw new BizException(PcpTradeExceptionCode.TYPE_NOT_EXIT.getCode(), String.format("(%s)%s", type, PcpTradeExceptionCode.TYPE_NOT_EXIT.getMsg()));
    }

    public static SaleOrderTypeEnum enumOfDesc(String desc) {
        for (SaleOrderTypeEnum typeEnum : SaleOrderTypeEnum.values()) {
            if (!typeEnum.getDesc().equals(desc)) continue;
            return typeEnum;
        }
        return null;
    }

    public static List<String> easSaleOrderTypes() {
        return Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.AGENCY_ORDER.desc, SaleOrderTypeEnum.INTEGRAL_ORDER.desc, SaleOrderTypeEnum.PRESALE_ORDER.desc, SaleOrderTypeEnum.INTERNAL_DISTRIBUTION.desc, SaleOrderTypeEnum.COMPENSATION_ORDER.desc, SaleOrderTypeEnum.CLAIM_REISSUE.desc, SaleOrderTypeEnum.CHILD_DIRECT_SALES.desc, SaleOrderTypeEnum.SECONDARY_DISTRIBUTION.desc, SaleOrderTypeEnum.CHILD_DIRECT_SALES.desc});
    }

    public static List<String> easOtherOutOrderTypes() {
        return Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.OTHER_OUT_STOCK.desc, SaleOrderTypeEnum.CUSTOMER_REFUNDING_ORDER.desc, SaleOrderTypeEnum.QUALITY_REFUNDING_ORDER.desc, SaleOrderTypeEnum.REPLENISH_ORDER.desc});
    }

    public static List<String> nutritionOrderTypes() {
        return Lists.newArrayList((Object[])new String[]{SaleOrderTypeEnum.REPLENISHMENT_ORDER.desc, SaleOrderTypeEnum.ACTIVITY_ORDER.desc, SaleOrderTypeEnum.ACTIVITY_ORDER.desc});
    }

    static {
        saleOutOrderTypeList = Lists.newArrayList((Object[])new String[]{AGENCY_ORDER.getType(), INTERNAL_DISTRIBUTION.getType(), SECONDARY_DISTRIBUTION.getType(), CLAIM_REISSUE.getType(), CLAIM_POSTING.getType(), COMPENSATION_ORDER.getType(), INTEGRAL_ORDER.getType(), PRESALE_ORDER.getType(), CHILD_DIRECT_SALES.getType()});
        otherOutOrderTypeList = Lists.newArrayList((Object[])new String[]{OTHER_OUT_STOCK.getType(), CUSTOMER_REFUNDING_ORDER.getType(), QUALITY_REFUNDING_ORDER.getType(), REPLENISH_ORDER.getType()});
    }
}

