/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.constants.strategy;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.assertj.core.util.Lists;

public enum DgStrategyFeeTypeEnum {
    MANUAL_GIFT("MANUAL_GIFT", "\u624b\u5de5\u8d60\u54c1"),
    FULL_GIFT("FULL_GIFT", "\u6ee1\u8d60"),
    FULL_REDUCE("FULL_REDUCE", "\u6ee1\u51cf"),
    FULL_DISCOUNT("FULL_DISCOUNT", "\u6ee1\u6298"),
    COUPON("COUPON", "\u4f18\u60e0\u5238"),
    SPECIAL_OFFER("SPECIAL_OFFER", "\u7279\u4ef7\u4f18\u60e0"),
    PANIC_BUYING("PANIC_BUYING", "\u62a2\u8d2d"),
    REPLENISH("REPLENISH", "\u8865\u8d27"),
    REBATE("REBATE", "\u8fd4\u5229"),
    INTEGRAL("INTEGRAL", "\u79ef\u5206"),
    GOLD("GOLD", "\u91d1\u5e01"),
    PROMOTION_GOODS("PROMOTION_GOODS", "\u4fc3\u9500\u7269\u6599");

    private final String code;
    private final String desc;
    public static final Map<String, DgStrategyFeeTypeEnum> CODE_LOOKUP;
    public static final Map<String, String> CODE_DESC_MAP;
    public static final List<String> PROMOTION_TYPE_List;

    private DgStrategyFeeTypeEnum(String code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    public static DgStrategyFeeTypeEnum forCode(String code) {
        return CODE_LOOKUP.get(code);
    }

    public Map<String, String> getCodeAndDesc() {
        return CODE_DESC_MAP;
    }

    public String getCode() {
        return this.code;
    }

    public String getDesc() {
        return this.desc;
    }

    static {
        CODE_LOOKUP = Arrays.stream(DgStrategyFeeTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum));
        CODE_DESC_MAP = Arrays.stream(DgStrategyFeeTypeEnum.values()).collect(Collectors.toMap(thisEnum -> thisEnum.code, thisEnum -> thisEnum.desc));
        PROMOTION_TYPE_List = Lists.newArrayList((Object[])new String[]{MANUAL_GIFT.getCode(), FULL_GIFT.getCode(), FULL_REDUCE.getCode(), FULL_DISCOUNT.getCode(), COUPON.getCode(), SPECIAL_OFFER.getCode(), PANIC_BUYING.getCode()});
    }
}

