/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.dtyunxi.util.JacksonUtil;
import com.dtyunxi.yundt.cube.center.inventory.dto.request.cs.inventory.CsOrderAfterSaleMessageDto;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgAfterSaleOrderItemQueryApi;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgAfterSaleOrderQueryApi;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2BAfterSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2CAfterSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_AFTER_SALE_WMS_SEND_BACK_TAG")
@ConditionalOnProperty(name={"cis.pms.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class AfterSaleOrderConfirmProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(AfterSaleOrderConfirmProcessor.class);
    @Resource
    private IDgAfterSaleOrderQueryApi afterSaleOrderQueryApi;
    @Resource
    private IDgAfterSaleOrderItemQueryApi afterSaleOrderItemQueryApi;
    @Resource
    private IDgB2CAfterSaleStatemachineApi b2CAfterSaleStatemachineApi;
    @Resource
    private IDgB2BAfterSaleStatemachineApi b2BAfterSaleStatemachineApi;

    public MessageResponse process(MessageVo message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]: {}", (Object)JacksonUtil.toJson((Object)message.getData()));
            Object messageData = message.getData();
            if (messageData instanceof CsOrderAfterSaleMessageDto) {
                try {
                    CsOrderAfterSaleMessageDto noticeMessage = (CsOrderAfterSaleMessageDto)messageData;
                    boolean portionFlag = noticeMessage.getPortionFlag();
                    DgBizAfterSaleOrderReqDto modifyStatusReqDto = new DgBizAfterSaleOrderReqDto();
                    modifyStatusReqDto.setTypeFlag("SEND_BACK");
                    modifyStatusReqDto.setSaleRefundNo(noticeMessage.getInResultDocumentNo());
                    modifyStatusReqDto.setPortionFlag(Boolean.valueOf(portionFlag));
                    String afterSaleOrderNo = noticeMessage.getOrderNo();
                    DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.afterSaleOrderQueryApi.queryByNo(afterSaleOrderNo));
                    DgCisAfterSaleBizModelEnum bizModelEnum = DgCisAfterSaleBizModelEnum.forCode((String)afterSaleOrderRespDto.getAfterSaleOrderType());
                    switch (bizModelEnum) {
                        case SALE_RUND: {
                            RestResponseHelper.checkOrThrow((RestResponse)this.b2BAfterSaleStatemachineApi.inventoryConfirm(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), modifyStatusReqDto));
                            break;
                        }
                        default: {
                            if (portionFlag) {
                                logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]{}:\u90e8\u5206\u5165\u5e93\u6682\u4e0d\u5904\u7406", (Object)afterSaleOrderNo);
                                return MessageResponse.SUCCESS;
                            }
                            RestResponseHelper.checkOrThrow((RestResponse)this.b2CAfterSaleStatemachineApi.inventoryConfirm(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), modifyStatusReqDto));
                        }
                    }
                    logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]{}:\u5165\u5e93\u56de\u8c03\u6210\u529f", (Object)afterSaleOrderNo);
                    return MessageResponse.SUCCESS;
                }
                catch (Exception e) {
                    logger.error("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
                    return MessageResponse.SUCCESS;
                }
            }
            logger.error("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\u8f6c\u6362\u7c7b\u578b\u4e0d\u4e00\u81f4");
            return MessageResponse.SUCCESS;
        });
    }
}

