/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.enums.NextOptTypeEnum;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="DELAY_AUTO_AUDIT_TAG")
@ConditionalOnProperty(name={"perform.order.auto.audit.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class PerformOrderAutoAuditProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderAutoAuditProcessor.class);
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;
    @Resource
    private IDgB2CSaleStatemachineHandle dgB2CSaleStatemachineHandle;

    public MessageResponse process(MessageVo message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
            Object messageData = message.getData();
            if (messageData instanceof SaleTradeMessageVo) {
                try {
                    SaleTradeMessageVo tradeMessageVo = (SaleTradeMessageVo)messageData;
                    NextOptTypeEnum nextOptTypeEnum = NextOptTypeEnum.enumOf((String)tradeMessageVo.getNextOptType());
                    switch (nextOptTypeEnum) {
                        case B2B_AUTO_AUDIT: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u5ba1\u6838{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.auditPass(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                            break;
                        }
                        case B2B_AUTO_CHECK: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u786e\u8ba4{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.checkOrder(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                            break;
                        }
                        case B2B_AUTO_PICK: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u914d\u8d27{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.manualPick(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                            break;
                        }
                        case B2B_AUTO_APPOINT: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u4e0b\u53d1\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.continueDeliver(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                            break;
                        }
                        case CUSTOMER_AUTO_AUDIT: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u5ba2\u5ba1{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.autoCsAuditSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getStrategyOrderId(), tradeMessageVo.getOrderId(), null));
                            break;
                        }
                        case BUSINESS_AUTO_AUDIT: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u5546\u5ba1{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.autoBsAuditSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getStrategyOrderId(), tradeMessageVo.getOrderId(), null));
                            break;
                        }
                        case PICK_AUTO_AUDIT: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u914d\u8d27\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.manualPick(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), null));
                            break;
                        }
                        case AUTO_SEND_WAREHOUSE: {
                            LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u4e0b\u53d1\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                            RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.manualSendWarehouse(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), null));
                        }
                    }
                    return MessageResponse.SUCCESS;
                }
                catch (Exception e) {
                    LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                    return MessageResponse.SUCCESS;
                }
            }
            return MessageResponse.SUCCESS;
        });
    }
}

