/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutNoticeOrderDetailPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderDto;
import com.yunxi.dg.base.center.inventory.dto.entity.InOutResultOrderPageReqDto;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryMessageExtDto;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutNoticeOrderDetailApiProxy;
import com.yunxi.dg.base.center.inventory.proxy.baseorder.IInOutResultOrderApiProxy;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgAfterSaleOrderItemQueryApi;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgAfterSaleOrderQueryApi;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2BAfterSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgB2CAfterSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgAfterSaleOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgAfterSaleOrderItemDto;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_AFTER_SALE_WMS_SEND_BACK_TAG")
@ConditionalOnProperty(name={"cis.pms.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class AfterSaleOrderConfirmProcessor
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(AfterSaleOrderConfirmProcessor.class);
    @Resource
    private IDgAfterSaleOrderQueryApi afterSaleOrderQueryApi;
    @Resource
    private IDgAfterSaleOrderItemQueryApi afterSaleOrderItemQueryApi;
    @Resource
    private IDgB2CAfterSaleStatemachineApi b2CAfterSaleStatemachineApi;
    @Resource
    private IDgB2BAfterSaleStatemachineApi b2BAfterSaleStatemachineApi;
    @Resource
    private IInOutNoticeOrderDetailApiProxy inOutNoticeOrderDetailApi;
    @Resource
    private IInOutResultOrderApiProxy inOutResultOrderApiProxy;

    public MessageResponse process(String message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)message));
            try {
                OutDeliveryMessageExtDto noticeMessage = (OutDeliveryMessageExtDto)JSON.parseObject((String)message, OutDeliveryMessageExtDto.class);
                InOutResultOrderPageReqDto queryDto = new InOutResultOrderPageReqDto();
                queryDto.setDocumentNo(noticeMessage.getOutResultOrderNo());
                PageInfo pageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.inOutResultOrderApiProxy.page(queryDto));
                Date inWarehouseDate = null;
                if (pageInfo != null && CollectionUtils.isNotEmpty((Collection)pageInfo.getList())) {
                    inWarehouseDate = ((InOutResultOrderDto)pageInfo.getList().get(0)).getCreateTime();
                }
                InOutNoticeOrderDetailPageReqDto inOutNoticeOrderDetailPageReqDto = new InOutNoticeOrderDetailPageReqDto();
                inOutNoticeOrderDetailPageReqDto.setDocumentNo(noticeMessage.getOutNoticeOrderNo());
                List inOutNoticeOrderDetailDtos = ((PageInfo)RestResponseHelper.extractData((RestResponse)this.inOutNoticeOrderDetailApi.page(inOutNoticeOrderDetailPageReqDto))).getList();
                logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f,\u67e5\u8be2\u901a\u77e5\u5355\u660e\u7ec6]: {}", (Object)JSON.toJSONString((Object)inOutNoticeOrderDetailDtos));
                ArrayList itemModifyReqDtoList = Lists.newArrayList();
                for (InOutNoticeOrderDetailDto inOutNoticeOrderDetailDto : inOutNoticeOrderDetailDtos) {
                    DgAfterSaleOrderItemDto itemModifyReqDto = new DgAfterSaleOrderItemDto();
                    itemModifyReqDto.setId(inOutNoticeOrderDetailDto.getPreOrderItemId());
                    itemModifyReqDto.setActualReturnNum(Integer.valueOf(inOutNoticeOrderDetailDto.getDoneQuantity().intValue()));
                    itemModifyReqDtoList.add(itemModifyReqDto);
                }
                boolean portionFlag = noticeMessage.getPortionFlag();
                DgBizAfterSaleOrderReqDto modifyStatusReqDto = new DgBizAfterSaleOrderReqDto();
                modifyStatusReqDto.setTypeFlag("SEND_BACK");
                modifyStatusReqDto.setInputWarehouseResultOrderNo(noticeMessage.getOutResultOrderNo());
                modifyStatusReqDto.setPortionFlag(Boolean.valueOf(portionFlag));
                modifyStatusReqDto.setItemDtoList((List)itemModifyReqDtoList);
                String afterSaleOrderNo = noticeMessage.getOrderNo();
                modifyStatusReqDto.setAfterSaleOrderNo(afterSaleOrderNo);
                DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.afterSaleOrderQueryApi.queryByNo(afterSaleOrderNo));
                modifyStatusReqDto.setId(afterSaleOrderRespDto.getId());
                modifyStatusReqDto.setSaleOrderNo(afterSaleOrderRespDto.getSaleOrderNo());
                modifyStatusReqDto.setPlatformRefundOrderSn(afterSaleOrderRespDto.getPlatformRefundOrderSn());
                modifyStatusReqDto.setPlatformRefundOrderId(afterSaleOrderRespDto.getPlatformRefundOrderId());
                modifyStatusReqDto.setInWarehouseDate(inWarehouseDate);
                DgAfterSaleOrderBizModelEnum bizModelEnum = DgAfterSaleOrderBizModelEnum.forCode((String)afterSaleOrderRespDto.getBizModel());
                if (Objects.requireNonNull(bizModelEnum) == DgAfterSaleOrderBizModelEnum.B2B) {
                    RestResponseHelper.checkOrThrow((RestResponse)this.b2BAfterSaleStatemachineApi.inventoryConfirm(DgCisAfterSaleBizModelEnum.SALE_REFUND.getCode(), afterSaleOrderRespDto.getId(), modifyStatusReqDto));
                } else {
                    if (portionFlag) {
                        logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]{}:\u90e8\u5206\u5165\u5e93\u6682\u4e0d\u5904\u7406", (Object)afterSaleOrderNo);
                        return MessageResponse.SUCCESS;
                    }
                    RestResponseHelper.checkOrThrow((RestResponse)this.b2CAfterSaleStatemachineApi.inventoryConfirm(afterSaleOrderRespDto.getAfterSaleOrderType(), afterSaleOrderRespDto.getId(), modifyStatusReqDto));
                }
                logger.info("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]{}:\u5165\u5e93\u56de\u8c03\u6210\u529f", (Object)afterSaleOrderNo);
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                logger.error("[\u63a5\u6536WMS\u9000\u5165\u5e93\u7ed3\u679c\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
                return MessageResponse.SUCCESS;
            }
        });
    }
}

