/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.api.statemachine.IDgF2BAfterSaleStatemachineApi;
import com.yunxi.dg.base.center.trade.domain.entity.IDgAfterSaleOrderDomain;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgBizAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderOptService;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="B2B_SALE_RETURN_COMPLETE_CALL_BACK_CHANNEL")
public class ChannelAfterOrderProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger logger = LoggerFactory.getLogger(ChannelAfterOrderProcessor.class);
    @Resource
    private IDgF2BAfterSaleStatemachineApi f2BAfterSaleStatemachineApi;
    @Resource
    private IDgAfterSaleOrderOptService dgAfterSaleOrderOptService;
    @Resource
    protected IDgAfterSaleOrderDomain afterSaleOrderDomain;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        logger.info("[\u63a5\u6536\u4f9b\u5e94\u94fe\u672a\u53d1\u8d27\u9000\u8d27\u5355\u5b8c\u6210\u7ed3\u679c\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)message.getData()));
        try {
            DgBizAfterSaleOrderReqDto noticeMessage = (DgBizAfterSaleOrderReqDto)JSON.parseObject((String)JSON.toJSONString((Object)message.getData()), DgBizAfterSaleOrderReqDto.class);
            Boolean allComplete = noticeMessage.getAllComplete();
            logger.info("[\u63a5\u6536\u4f9b\u5e94\u94fe\u672a\u53d1\u8d27\u9000\u8d27\u5355\u5b8c\u6210\u7ed3\u679c\u6d88\u606f]{}:\u4f9b\u5e94\u94fe\u5355\u662f\u5426\u90fd\u5df2\u5b8c\u6210", (Object)allComplete);
            DgAfterSaleOrderRespDto orderRespDto = this.afterSaleOrderDomain.queryById(Long.valueOf(noticeMessage.getPlatformRefundOrderId()));
            AssertUtils.isFalse((boolean)ObjectUtils.isEmpty((Object)orderRespDto), (String)"\u627e\u4e0d\u5230\u9000\u8d27\u5355\u4fe1\u606f");
            if (allComplete.booleanValue()) {
                logger.info("\u7ecf\u9500");
                RestResponseHelper.checkOrThrow((RestResponse)this.f2BAfterSaleStatemachineApi.syncApplyToChannelAfterOrder(noticeMessage));
            }
            logger.info("[\u63a5\u6536\u4f9b\u5e94\u94fe\u672a\u53d1\u8d27\u9000\u8d27\u5355\u5b8c\u6210\u7ed3\u679c\u6d88\u606f]{}:\u56de\u8c03\u6210\u529f", (Object)noticeMessage.getPlatformRefundOrderSn());
        }
        catch (Exception e) {
            logger.error("[\u63a5\u6536\u4f9b\u5e94\u94fe\u672a\u53d1\u8d27\u9000\u8d27\u5355\u5b8c\u6210\u7ed3\u679c\u6d88\u606f]\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            logger.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

