/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.afterorder;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.DgAfterSaleOrderCancelMessageDto;
import com.yunxi.dg.base.center.trade.action.SCM.aftersaleorder.basic.IDgAfterSaleOrderBasicOptAction;
import com.yunxi.dg.base.center.trade.api.aftersale.IDgAfterSaleOrderQueryApi;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderReqDto;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.center.trade.service.after.IDgAfterSaleOrderService;
import com.yunxi.dg.base.center.trade.statemachine.b2b.aftersale.constant.DgB2BAfterSaleStatus;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="ORDER_SALE_REFUND_WMS_CANCEL_TAG")
@ConditionalOnProperty(name={"cis.pms.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class DgAfterSaleOrderFinshProcessor
implements IMessageProcessor<String> {
    private static final Logger logger = LoggerFactory.getLogger(DgAfterSaleOrderFinshProcessor.class);
    @Resource
    private IDgAfterSaleOrderQueryApi afterSaleOrderQueryApi;
    @Resource
    private IDgAfterSaleOrderService afterSaleOrderService;
    @Resource
    private IDgAfterSaleOrderBasicOptAction dgAfterSaleOrderBasicOptAction;

    public MessageResponse process(String message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            logger.info("[\u63a5\u6536\u5e93\u5b58\u5b8c\u7ed3\u53d6\u6d88\u6d88\u606f]: {}", (Object)JSON.toJSONString((Object)message));
            try {
                DgAfterSaleOrderCancelMessageDto cancelMessageDto = (DgAfterSaleOrderCancelMessageDto)JSON.parseObject((String)message, DgAfterSaleOrderCancelMessageDto.class);
                String type = cancelMessageDto.getType();
                String afterSaleOrderNo = cancelMessageDto.getOrderNo();
                DgAfterSaleOrderRespDto afterSaleOrderRespDto = (DgAfterSaleOrderRespDto)RestResponseHelper.extractData((RestResponse)this.afterSaleOrderQueryApi.queryByNo(afterSaleOrderNo));
                if (afterSaleOrderRespDto == null) {
                    return MessageResponse.SUCCESS;
                }
                DgAfterSaleOrderReqDto afterSaleOrderReqDto = new DgAfterSaleOrderReqDto();
                afterSaleOrderReqDto.setId(afterSaleOrderRespDto.getId());
                switch (type) {
                    case "finish_over": {
                        afterSaleOrderReqDto.setStatus(DgB2BAfterSaleStatus.FINISH.getCode());
                        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
                        break;
                    }
                    case "cancel": {
                        afterSaleOrderReqDto.setStatus(DgB2BAfterSaleStatus.CLOSE.getCode());
                        this.dgAfterSaleOrderBasicOptAction.modifyAfterSaleOrderInfo(afterSaleOrderReqDto);
                    }
                }
                logger.info("[\u63a5\u6536\u5e93\u5b58\u5b8c\u7ed3\u53d6\u6d88\u6d88\u606f]{}:\u53d8\u66f4\u72b6\u6001\u6210\u529f", (Object)afterSaleOrderNo);
                return MessageResponse.SUCCESS;
            }
            catch (Exception e) {
                logger.error("[\u63a5\u6536\u5e93\u5b58\u5b8c\u7ed3\u53d6\u6d88\u6d88\u606f]\u5f02\u5e38", (Throwable)e);
                return MessageResponse.SUCCESS;
            }
        });
    }
}

