/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.keep;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.ExtQueryChainWrapper;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.eo.BaseEo;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.yunxi.dg.base.center.trade.dao.das.IDgAfterSaleOrderDas;
import com.yunxi.dg.base.center.trade.dao.das.IDgPerformOrderInfoDas;
import com.yunxi.dg.base.center.trade.dto.finance.PushKeepStatusToTradeDto;
import com.yunxi.dg.base.center.trade.enums.VoucherTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgAfterSaleOrderEo;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component
@MQDesc(topic="SINGLE_TOPIC", tag="CIS_SALE_AFTER_ORDER_KEEP_STATUS_CHANGE_TAG")
public class KeepStatusChangeProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(KeepStatusChangeProcessor.class);
    @Resource
    private IDgPerformOrderInfoDas performOrderInfoDas;
    @Resource
    private IDgAfterSaleOrderDas afterSaleOrderDas;
    public static final String BUSINESS_ORDER_TYPE = "saleOrder";

    public MessageResponse process(String message) {
        log.info("\u63a5\u6536\u5230\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u53d8\u66f4\u6d88\u606f\uff1a{}", (Object)message);
        if (StringUtils.isEmpty((CharSequence)message)) {
            log.info("\u63a5\u6536\u5230\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u4f53\u4e3a\u7a7a,\u6d88\u606f\u5ffd\u7565\u5904\u7406");
            return MessageResponse.SUCCESS;
        }
        try {
            PushKeepStatusToTradeDto pushKeepStatusToTradeDto = (PushKeepStatusToTradeDto)JSONObject.parseObject((String)message, PushKeepStatusToTradeDto.class);
            log.info("\u63a5\u6536\u5230\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u4f53\u96c6\u5408\uff1a{}", (Object)JSONObject.toJSONString((Object)pushKeepStatusToTradeDto));
            if (Objects.isNull(pushKeepStatusToTradeDto)) {
                log.info("\u63a5\u6536\u5230\u66f4\u65b0\u8bb0\u8d26\u72b6\u6001\u53d8\u66f4\u6d88\u606f\u4f53\u4e3a\u7a7a,\u6d88\u606f\u5ffd\u7565\u5904\u7406");
                return MessageResponse.SUCCESS;
            }
            if (BUSINESS_ORDER_TYPE.equals(pushKeepStatusToTradeDto.getBusinessOrderType())) {
                this.batchUpdateSaleOrderKeepStatus(pushKeepStatusToTradeDto.getOrderNoList(), pushKeepStatusToTradeDto.getVoucherType());
            } else {
                this.batchUpdateAfterSaleOrderKeepStatus(pushKeepStatusToTradeDto.getOrderNoList(), pushKeepStatusToTradeDto.getVoucherType());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            log.error("\u66f4\u65b0\u5f00\u7968\u8bb0\u8d26\u72b6\u6001\u53d8\u66f4\u5f02\u5e38,{}", (Object)e.getMessage(), (Object)e);
        }
        return MessageResponse.SUCCESS;
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateSaleOrderKeepStatus(List<String> orderNosList, String voucherType) {
        List performOrderInfoEos;
        int length;
        log.info("batchUpdateSaleOrderKeepStatus:{},{}", (Object)JSONObject.toJSONString(orderNosList), (Object)voucherType);
        if (CollectionUtils.isEmpty(orderNosList)) {
            return;
        }
        int i = 0;
        for (length = orderNosList.size(); length > 500; length -= 500) {
            performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDas.filter().in((Object)"sale_order_no", orderNosList.subList(i, i + 500))).list();
            this.updateSaleKeepStatus(voucherType, performOrderInfoEos);
            i += 500;
        }
        if (length > 0) {
            performOrderInfoEos = ((ExtQueryChainWrapper)this.performOrderInfoDas.filter().in((Object)"sale_order_no", orderNosList.subList(i, i + length))).list();
            this.updateSaleKeepStatus(voucherType, performOrderInfoEos);
        }
    }

    private void updateSaleKeepStatus(String voucherType, List<DgPerformOrderInfoEo> performOrderInfoEos) {
        if (CollectionUtils.isNotEmpty(performOrderInfoEos)) {
            performOrderInfoEos.forEach(v -> {
                DgPerformOrderInfoEo update = new DgPerformOrderInfoEo();
                update.setId(v.getId());
                if (VoucherTypeEnum.DELIVERY.getCode().equals(voucherType)) {
                    update.setDeliveryKeepStatus("ACCOUNTED");
                } else if (VoucherTypeEnum.INVOICE.getCode().equals(voucherType)) {
                    update.setDeliveryKeepStatus("ACCOUNTED");
                    update.setBillingKeepStatus("ACCOUNTED");
                }
                this.performOrderInfoDas.updateSelective((BaseEo)update);
            });
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void batchUpdateAfterSaleOrderKeepStatus(List<String> orderNosList, String voucherType) {
        List afterSaleOrderEos;
        int length;
        log.info("batchUpdateAfterSaleOrderKeepStatus:{},{}", (Object)JSONObject.toJSONString(orderNosList), (Object)voucherType);
        int i = 0;
        for (length = orderNosList.size(); length > 500; length -= 500) {
            afterSaleOrderEos = ((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().in((Object)"after_sale_order_no", orderNosList.subList(i, i + 500))).list();
            this.updateAfterKeepStatus(voucherType, afterSaleOrderEos);
            i += 500;
        }
        if (length > 0) {
            afterSaleOrderEos = ((ExtQueryChainWrapper)this.afterSaleOrderDas.filter().in((Object)"after_sale_order_no", orderNosList.subList(i, i + length))).list();
            this.updateAfterKeepStatus(voucherType, afterSaleOrderEos);
        }
    }

    private void updateAfterKeepStatus(String voucherType, List<DgAfterSaleOrderEo> afterSaleOrderEos) {
        if (CollectionUtils.isNotEmpty(afterSaleOrderEos)) {
            afterSaleOrderEos.forEach(v -> {
                DgAfterSaleOrderEo update = new DgAfterSaleOrderEo();
                update.setId(v.getId());
                if (VoucherTypeEnum.DELIVERY.getCode().equals(voucherType)) {
                    update.setAfterDeliveryAccounting("ACCOUNTED");
                } else if (VoucherTypeEnum.INVOICE.getCode().equals(voucherType)) {
                    update.setAfterDeliveryAccounting("ACCOUNTED");
                    update.setAfterBillingAccounting("ACCOUNTED");
                }
                this.afterSaleOrderDas.updateSelective((BaseEo)update);
            });
        }
    }
}

