/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.aftersale.DgCisAfterSaleBizModelEnum;
import com.yunxi.dg.base.center.trade.dto.aftersale.DgAfterSaleOrderRespDto;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BAfterSaleStatemachineHandle;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(topic="TRADE_DELAY_TOPIC", tag="AFTER_SALES_ORDER_TO_AUTO_CONFIRM")
public class AfterSaleOrderAutoConfirmProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(AfterSaleOrderAutoConfirmProcessor.class);
    @Resource
    private IDgB2BAfterSaleStatemachineHandle dgB2BAfterSaleStatemachineHandle;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        try {
            LOGGER.info("\u53d1\u9001\u552e\u540e\u5355\u81ea\u52a8\u786e\u8ba4\u76d1\u542c\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
            DgAfterSaleOrderRespDto orderDto = (DgAfterSaleOrderRespDto)JSON.parseObject((String)message.getData().toString(), DgAfterSaleOrderRespDto.class);
            RestResponseHelper.extractData((RestResponse)this.dgB2BAfterSaleStatemachineHandle.confirm(DgCisAfterSaleBizModelEnum.SALE_REFUND.getCode(), orderDto.getId()));
        }
        catch (Exception e) {
            LOGGER.error("\u53d1\u9001\u552e\u540e\u5355\u81ea\u52a8\u786e\u8ba4\u76d1\u542c\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

