/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.action.oms.B2B.IB2BOrderPickAction;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.vo.BatchLogisticsSourceResultVo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.assertj.core.util.Lists;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="batchLogisticsSourceResult", msgType="publish")
public class B2BOrderLogisticsSourceProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2BOrderLogisticsSourceProcessor.class);
    @Resource
    private IB2BOrderPickAction b2BOrderPickAction;
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;

    public MessageResponse process(MessageVo message) {
        MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
        LOGGER.info("\u63a5\u6536\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c={}", JSON.toJSON((Object)message));
        if (Objects.isNull(message.getData())) {
            return MessageResponse.SUCCESS;
        }
        List successOrderIdList = Lists.newArrayList();
        try {
            List batchLogisticsSourceResultVos = JSON.parseArray((String)message.getData().toString(), BatchLogisticsSourceResultVo.class);
            successOrderIdList = (List)RestResponseHelper.extractData((RestResponse)this.b2BOrderPickAction.batchLogisticsSourceResult(batchLogisticsSourceResultVos));
        }
        catch (Exception e) {
            LOGGER.error("\u63a5\u6536\u7269\u6d41\u5bfb\u6e90\u5904\u7406\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        if (CollectionUtils.isEmpty((Collection)successOrderIdList)) {
            LOGGER.info("\u63a5\u6536\u7269\u6d41\u5bfb\u6e90\u7ed3\u679c\u672a\u6709\u5904\u7406\u6210\u529f\u7684\u8ba2\u5355");
            return MessageResponse.SUCCESS;
        }
        for (Long orderId : successOrderIdList) {
            try {
                RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.continueDeliver(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), orderId, null));
            }
            catch (Exception e) {
                LOGGER.error("\u63a5\u6536\u7269\u6d41\u5bfb\u6e90\u8ba2\u5355\u540c\u6b65\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
        }
        return MessageResponse.SUCCESS;
    }
}

