/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformOrderAddrApplyLineDto;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformOrderAddrApplyService;
import com.yunxi.dg.base.commons.rpc.third.audit.PushThirdAuditBo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@MQDesc(tag="OA_AUDIT_RESULT_MAPPING", msgType="publish")
@Component
public class OrderAddressAuditResultProcessor
implements IMessageProcessor<String> {
    private static final Logger log = LoggerFactory.getLogger(OrderAddressAuditResultProcessor.class);
    @Resource
    private IDgPerformOrderAddrApplyService dgPerformOrderAddrApplyService;

    public MessageResponse process(String message) {
        log.info("\u6536\u5230OA\u5ba1\u6279\u7ed3\u679c\u5e7f\u64ad");
        try {
            PushThirdAuditBo auditBo = (PushThirdAuditBo)JSON.parseObject((String)message, PushThirdAuditBo.class);
            if (Objects.nonNull(auditBo) && (Objects.equals(auditBo.getOrderType(), "order_addr_modify") || Objects.equals(auditBo.getOrderType(), "customer_addr_modify") || Objects.equals(auditBo.getOrderType(), "customer_addr"))) {
                log.info("\u5e7f\u64ad\u5185\u5bb9\u4e3a\u8ba2\u5355\u5730\u5740\u4fee\u6539\u5ba1\u6279\u7ed3\u679c\uff1a{}", (Object)message);
                DgPerformOrderAddrApplyDto applyDto = new DgPerformOrderAddrApplyDto();
                applyDto.setId(Long.valueOf(Long.parseLong(auditBo.getExtendedFieldMap().get("id").toString())));
                List rows = (List)auditBo.getExtendedFieldMap().get("items");
                ArrayList lineDtos = Lists.newArrayList();
                for (JSONObject row : rows) {
                    DgPerformOrderAddrApplyLineDto lineDto = new DgPerformOrderAddrApplyLineDto();
                    lineDto.setOrderId(row.getLong("orderId"));
                    lineDtos.add(lineDto);
                }
                applyDto.setApplyLineDtos((List)lineDtos);
                applyDto.setAuditStatus(Integer.valueOf(Objects.equals(auditBo.getStatus(), "\u5ba1\u6279\u901a\u8fc7") ? 1 : 2));
                applyDto.setEmployeeNo(auditBo.getWorkCode());
                applyDto.setAuditTime(new Date());
                applyDto.setAuditRemark(auditBo.getAuditText());
                this.dgPerformOrderAddrApplyService.audit(applyDto);
            }
        }
        catch (Exception e) {
            log.error("OA\u56de\u8c03\u7ed3\u679c\u5904\u7406\u5f02\u5e38:", (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }
}

