/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.google.common.collect.Lists;
import com.yunxi.dg.base.center.inventory.dto.request.baseorder.OutDeliveryMessageExtDto;
import com.yunxi.dg.base.center.trade.action.oms.B2C.IDgMqMessageAction;
import com.yunxi.dg.base.center.trade.action.oms.channel.IChannelOrderDeliveryAction;
import com.yunxi.dg.base.center.trade.api.order.IPerformOrderQueryApi;
import com.yunxi.dg.base.center.trade.constants.DgOrderLabelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgOrderLabelRecordDomain;
import com.yunxi.dg.base.center.trade.domain.order.IDgOmsOrderInfoQueryDomain;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.orderresp.DgPerformOrderRespDto;
import com.yunxi.dg.base.center.trade.enums.ShippingOrderTypeEnum;
import com.yunxi.dg.base.center.trade.enums.SyncRecordShippingTypeEnum;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.entity.IMqFailRetryRecordService;
import com.yunxi.dg.base.center.trade.service.oms.common.IDgCommonLabelManageService;
import com.yunxi.dg.base.center.trade.statemachine.b2b.order.execute.DgB2BOrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.commons.utils.AssertUtils;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="NOTICE_ADVANCED_SHIPPING_ORDER_SALE_TAG")
@ConditionalOnProperty(name={"perform.order.delivered.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class PerformOrderAdvancedDeliveredProcessor
implements IMessageProcessor<String> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderAdvancedDeliveredProcessor.class);
    @Resource
    private IPerformOrderQueryApi performOrderQueryApi;
    @Resource
    private IChannelOrderDeliveryAction channelOrderDeliveryAction;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private DgB2BOrderStatemachineExecutor dgB2BOrderStatemachineExecutor;
    @Resource
    private IDgOmsOrderInfoQueryDomain omsOrderInfoQueryDomain;
    @Resource
    private IMqFailRetryRecordService mqFailRetryRecordService;
    @Resource
    private IDgCommonLabelManageService commonLabelManageService;
    @Resource
    private IDgPerformNoticeSyncRecordService performNoticeSyncRecordService;
    @Resource
    private IDgOrderLabelRecordDomain orderLabelRecordDomain;
    @Resource
    private IDgMqMessageAction mqMessageAction;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService performNoticeSyncRecordShippingService;

    public MessageResponse process(String message) {
        return MqConsumerAround.aroundMqProcess(o -> {
            LOGGER.info("\u5e93\u5b58\u51fa\u5e93\u56de\u8c03\uff0c\u9884\u53d1\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)message));
            try {
                OutDeliveryMessageExtDto csOutDeliveryMessageExtDto = (OutDeliveryMessageExtDto)JSON.parseObject((String)message, OutDeliveryMessageExtDto.class);
                LOGGER.info("\u62a5\u6587\u8f6c\u6362\uff1a{}", (Object)JSON.toJSONString((Object)csOutDeliveryMessageExtDto));
                DgPerformOrderRespDto orderRespDto = this.omsOrderInfoQueryDomain.queryDtoByOrderNo(csOutDeliveryMessageExtDto.getOrderNo());
                AssertUtils.isFalse((boolean)ObjectUtil.isEmpty((Object)orderRespDto), (String)("\u627e\u4e0d\u5230\u9500\u552e\u5355\uff1a" + csOutDeliveryMessageExtDto.getOrderNo()));
                List labelRecordDtoList = this.orderLabelRecordDomain.queryByOrderIdsAndLabelCodes((List)Lists.newArrayList((Object[])new Long[]{orderRespDto.getId()}), DgOrderLabelEnum.ADVANCED_DELIVER.getCode());
                if (CollectionUtils.isNotEmpty((Collection)labelRecordDtoList)) {
                    LOGGER.info("\u9884\u5148\u53d1\u8d27\u6807\u7b7e\u5df2\u5b58\u5728\uff01");
                    return MessageResponse.SUCCESS;
                }
                this.commonLabelManageService.markAdvancedDeliverOrderLabel(orderRespDto.getId());
                DgPerformNoticeSyncRecordShippingDto recordShippingDto = new DgPerformNoticeSyncRecordShippingDto();
                recordShippingDto.setDeliveryTime(csOutDeliveryMessageExtDto.getDeliveryTime());
                recordShippingDto.setOrderId(orderRespDto.getId());
                recordShippingDto.setNoticeOrderNo(csOutDeliveryMessageExtDto.getOutNoticeOrderNo());
                recordShippingDto.setShippingCompany(csOutDeliveryMessageExtDto.getShipmentEnterpriseName());
                recordShippingDto.setShippingCompanyCode(csOutDeliveryMessageExtDto.getShipmentEnterpriseCode());
                recordShippingDto.setConsignmentNo(csOutDeliveryMessageExtDto.getShippingNo());
                recordShippingDto.setShippingType(SyncRecordShippingTypeEnum.PREDICT_SHIPPING.getCode());
                recordShippingDto.setOrderType(ShippingOrderTypeEnum.SALE.getCode());
                this.performNoticeSyncRecordShippingService.saveExternalNoticeRecordShipping((List)Lists.newArrayList((Object[])new DgPerformNoticeSyncRecordShippingDto[]{recordShippingDto}));
                LOGGER.info("\u89e6\u53d1\u901a\u77e5\u5e73\u53f0\u53d1\u8d27\uff1a{}", (Object)JSON.toJSONString((Object)orderRespDto));
                this.mqMessageAction.sendMsgForAllDelivery(orderRespDto, null);
            }
            catch (Exception e) {
                LOGGER.error("\u5e93\u5b58\u51fa\u5e93\u56de\u8c03\uff0c\u9884\u53d1\u8d27\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return MessageResponse.SUCCESS;
        });
    }
}

