/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.annotation.TableName;
import com.dtyunxi.app.ServiceContext;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.yunxi.dg.base.center.trade.constants.DgOmsSaleOrderStatus;
import com.yunxi.dg.base.center.trade.constants.DgPerformOrderBizModelEnum;
import com.yunxi.dg.base.center.trade.domain.entity.IDgPerformOrderInfoDomain;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgConfirmReceiveOrderReqDto;
import com.yunxi.dg.base.center.trade.enums.NextOptTypeEnum;
import com.yunxi.dg.base.center.trade.eo.DgPerformOrderInfoEo;
import com.yunxi.dg.base.center.trade.mqc.common.MqConsumerAround;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2BSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.statemachine.handler.IDgB2CSaleStatemachineHandle;
import com.yunxi.dg.base.center.trade.vo.SaleTradeMessageVo;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Objects;
import javax.annotation.Resource;
import javax.persistence.Table;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@Table
@TableName
@MQDesc(topic="TRADE_DELAY_TOPIC", tag="DELAY_AUTO_AUDIT_TAG")
@ConditionalOnProperty(name={"perform.order.auto.audit.mq.processor.enable"}, havingValue="true", matchIfMissing=true)
public class PerformOrderAutoAuditProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderAutoAuditProcessor.class);
    @Resource
    private IDgPerformOrderInfoDomain dgPerformOrderInfoDomain;
    @Resource
    private IDgB2BSaleStatemachineHandle dgB2BSaleStatemachineHandle;
    @Resource
    private IDgB2CSaleStatemachineHandle dgB2CSaleStatemachineHandle;

    public MessageResponse process(MessageVo message) {
        LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a{}", (Object)JSON.toJSONString((Object)message.getData()));
        Object messageData = message.getData();
        if (messageData instanceof SaleTradeMessageVo) {
            try {
                SaleTradeMessageVo tradeMessageVo = (SaleTradeMessageVo)messageData;
                NextOptTypeEnum nextOptTypeEnum = NextOptTypeEnum.enumOf((String)tradeMessageVo.getNextOptType());
                Boolean success = this.checkOrderStatus(tradeMessageVo.getOrderId(), nextOptTypeEnum);
                LOGGER.info("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5224\u65ad\u8ba2\u5355\u72b6\u6001\u4e0e\u7b56\u7565\u662f\u5426\u5339\u914d:{}", (Object)success);
                if (success.booleanValue()) {
                    ServiceContext.getContext().removeAttachment("yes.req.userId");
                    ServiceContext.getContext().removeAttachment("yes.req.userCode");
                    return MqConsumerAround.aroundMessageConsumer(message, o -> "DELAY_AUTO_AUDIT_TAG", o -> String.format("\u7cfb\u7edf%s\u6267\u884c", nextOptTypeEnum.getDesc()), o -> "PERFORM_ORDER", msg -> {
                        String linkCode = "DELAY_AUTO_AUDIT_TAG";
                        LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a{}", (Object)JSON.toJSONString((Object)msg.getData()));
                        try {
                            linkCode = tradeMessageVo.getOrderId().toString();
                        }
                        catch (Exception e) {
                            LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                        }
                        return linkCode;
                    }, msg -> {
                        try {
                            switch (nextOptTypeEnum) {
                                case ORDER_REVIEW: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u5ba1\u6838{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.auditPass(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                                    break;
                                }
                                case ORDER_CONFIRM: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u786e\u8ba4{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.checkOrder(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                                    break;
                                }
                                case AUTOMATIC_ALLOCATION: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u914d\u8d27{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.manualPick(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId()));
                                    break;
                                }
                                case AUTOMATIC_DELIVERY: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u81ea\u52a8\u4e0b\u53d1\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.continueDeliver(DgPerformOrderBizModelEnum.INSIDE_SALES_ORDER.getCode(), tradeMessageVo.getOrderId(), null));
                                    break;
                                }
                                case CUSTOMER_AUTO_AUDIT: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u5ba2\u5ba1{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.autoCsAuditSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getStrategyOrderId(), tradeMessageVo.getOrderId(), null));
                                    break;
                                }
                                case BUSINESS_AUTO_AUDIT: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u5546\u5ba1{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.autoBsAuditSaleOrder(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getStrategyOrderId(), tradeMessageVo.getOrderId(), null));
                                    break;
                                }
                                case CONFIRM_RECEIPT_POLICY: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u786e\u8ba4\u6536\u8d27{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    DgConfirmReceiveOrderReqDto dgConfirmReceiveOrderReqDto = new DgConfirmReceiveOrderReqDto();
                                    dgConfirmReceiveOrderReqDto.setSaleOrderId(tradeMessageVo.getOrderId());
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.confirmReceiveGoods(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), dgConfirmReceiveOrderReqDto));
                                    break;
                                }
                                case CONFIRM_RECEIPT_STRATEGY: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2B-\u786e\u8ba4\u6536\u8d27{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    DgConfirmReceiveOrderReqDto dgConfirmReceiveOrderReqDto2b = new DgConfirmReceiveOrderReqDto();
                                    dgConfirmReceiveOrderReqDto2b.setSaleOrderId(tradeMessageVo.getOrderId());
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2BSaleStatemachineHandle.confirmReceiptGoods(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), dgConfirmReceiveOrderReqDto2b));
                                    break;
                                }
                                case PICK_AUTO_AUDIT: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u914d\u8d27\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.manualPick(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), null));
                                    break;
                                }
                                case PICKED: {
                                    LOGGER.info("[\u81ea\u52a8\u5ba1\u6838]\uff1a2C-\u81ea\u52a8\u4e0b\u53d1\u4ed3\u5e93{}", (Object)JSON.toJSONString((Object)tradeMessageVo));
                                    RestResponseHelper.checkOrThrow((RestResponse)this.dgB2CSaleStatemachineHandle.manualSendWarehouse(DgPerformOrderBizModelEnum.INVOICE_ORDER.getCode(), tradeMessageVo.getOrderId(), null));
                                }
                            }
                            return MessageResponse.SUCCESS;
                        }
                        catch (Exception e) {
                            LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                            return MessageResponse.SUCCESS;
                        }
                    });
                }
            }
            catch (Exception e) {
                LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5f02\u5e38" + e.getMessage(), (Throwable)e);
                return MessageResponse.SUCCESS;
            }
        }
        return MessageResponse.SUCCESS;
    }

    private boolean checkOrderStatus(Long orderId, NextOptTypeEnum nextOptTypeEnum) {
        DgPerformOrderInfoEo performOrderInfoEo = (DgPerformOrderInfoEo)this.dgPerformOrderInfoDomain.selectByPrimaryKey(orderId);
        LOGGER.info("orderStatus:{}", (Object)performOrderInfoEo.getOmsSaleOrderStatus());
        try {
            if (Objects.nonNull(performOrderInfoEo)) {
                DgOmsSaleOrderStatus orderStatus = DgOmsSaleOrderStatus.forCode((String)performOrderInfoEo.getOmsSaleOrderStatus());
                switch (orderStatus) {
                    case WAIT_AUDIT: {
                        return nextOptTypeEnum == NextOptTypeEnum.ORDER_REVIEW;
                    }
                    case WAIT_BUSINESS_AUDIT: {
                        return nextOptTypeEnum == NextOptTypeEnum.BUSINESS_AUTO_AUDIT;
                    }
                    case WAIT_CUSTOMER_AUDIT: {
                        return nextOptTypeEnum == NextOptTypeEnum.CUSTOMER_AUTO_AUDIT;
                    }
                    case WAIT_CHECK: {
                        return nextOptTypeEnum == NextOptTypeEnum.ORDER_CONFIRM;
                    }
                    case DELIVERY_ALL: {
                        return nextOptTypeEnum == NextOptTypeEnum.CONFIRM_RECEIPT_STRATEGY || nextOptTypeEnum == NextOptTypeEnum.CONFIRM_RECEIPT_POLICY;
                    }
                    case WAIT_PICK: {
                        return nextOptTypeEnum == NextOptTypeEnum.AUTOMATIC_ALLOCATION || nextOptTypeEnum == NextOptTypeEnum.PICK_AUTO_AUDIT;
                    }
                    case PICKED: {
                        return nextOptTypeEnum == NextOptTypeEnum.AUTOMATIC_DELIVERY || nextOptTypeEnum == NextOptTypeEnum.PICKED;
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("[\u63a5\u6536\u81ea\u52a8\u5316\u6d41\u7a0b\u6d88\u606f]\u5224\u65ad\u8ba2\u5355\u72b6\u6001\u4e0e\u7b56\u7565\u662f\u5426\u5339\u914d\u5f02\u5e38" + e.getMessage(), (Throwable)e);
        }
        return Boolean.FALSE;
    }
}

