/*
 * Decompiled with CFR 0.152.
 */
package com.yunxi.dg.base.center.trade.mqc.order;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.dtyunxi.cube.commons.beans.mq.MessageVo;
import com.dtyunxi.cube.plugin.mq.annotation.MQDesc;
import com.dtyunxi.huieryun.log.RequestId;
import com.dtyunxi.huieryun.mq.api.IMessageProcessor;
import com.dtyunxi.huieryun.mq.vo.MessageResponse;
import com.dtyunxi.rest.RestResponse;
import com.github.pagehelper.PageInfo;
import com.yunxi.dg.base.center.data.dto.DictDto;
import com.yunxi.dg.base.center.data.proxy.api.IDictQueryApiProxy;
import com.yunxi.dg.base.center.logistics.dto.LogisticsInfoDto;
import com.yunxi.dg.base.center.logistics.dto.LogisticsInfoPageReqDto;
import com.yunxi.dg.base.center.logistics.proxy.entity.ILogisticsInfoApiProxy;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.entity.DgPerformNoticeSyncRecordShippingDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgBizPerformNoticeSyncRecordDto;
import com.yunxi.dg.base.center.trade.dto.orderreq.DgPerformOrderReqDto;
import com.yunxi.dg.base.center.trade.enums.PerformOrderGeneralConfigDataEnum;
import com.yunxi.dg.base.center.trade.enums.PerformOrderParcelSignStatusEnum;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordService;
import com.yunxi.dg.base.center.trade.service.entity.IDgPerformNoticeSyncRecordShippingService;
import com.yunxi.dg.base.center.trade.service.oms.b2c.IDgOmsOrderService;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.constant.DgB2COrderMachineEvents;
import com.yunxi.dg.base.center.trade.statemachine.b2c.order.execute.DgB2COrderStatemachineExecutor;
import com.yunxi.dg.base.center.trade.utils.AssertUtils;
import com.yunxi.dg.base.commons.dto.BaseDto;
import com.yunxi.dg.base.commons.utils.RestResponseHelper;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.stereotype.Component;

@Component
@MQDesc(tag="LOGISTICS_INFO_SIGN_TAG", msgType="publish")
public class PerformOrderParcelSignProcessor
implements IMessageProcessor<MessageVo> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PerformOrderParcelSignProcessor.class);
    @Resource
    private IDgPerformNoticeSyncRecordService dgPerformNoticeSyncRecordService;
    @Resource
    private IDgPerformNoticeSyncRecordShippingService dgPerformNoticeSyncRecordShippingService;
    @Resource
    private IDgOmsOrderService omsOrderService;
    @Resource
    private ILogisticsInfoApiProxy logisticsInfoApiProxy;
    @Resource
    private DgB2COrderStatemachineExecutor dgB2COrderStatemachineExecutor;
    @Resource
    private IDictQueryApiProxy dictQueryApiProxy;

    public MessageResponse process(MessageVo message) {
        try {
            MDC.put((String)"yes.req.requestId", (String)RequestId.createReqId());
            LOGGER.info("\u76d1\u542c\u7269\u6d41\u7b7e\u6536\u6d88\u606f\uff1a{}", message.getData());
            LogisticsInfoDto logisticsInfoDto = (LogisticsInfoDto)JSON.parseObject((String)message.getData().toString(), LogisticsInfoDto.class);
            AssertUtils.isFalse((boolean)StringUtils.isBlank((CharSequence)logisticsInfoDto.getBusinessOrderNo()), (String)"\u4e1a\u52a1\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            DgPerformNoticeSyncRecordDto recordDto = new DgPerformNoticeSyncRecordDto();
            recordDto.setBusinessNo(logisticsInfoDto.getBusinessOrderNo());
            List recordDtoList = this.dgPerformNoticeSyncRecordService.queryList(recordDto);
            if (CollectionUtil.isEmpty((Collection)recordDtoList)) {
                LOGGER.error("\u627e\u4e0d\u5230\u51fa\u5165\u5e93\u8bb0\u5f55");
                return MessageResponse.SUCCESS;
            }
            List recordIds = recordDtoList.stream().map(BaseDto::getId).collect(Collectors.toList());
            List recordShippingDtoList = this.dgPerformNoticeSyncRecordShippingService.queryByRecordIds(recordIds);
            if (CollectionUtil.isEmpty((Collection)recordShippingDtoList)) {
                LOGGER.error("\u901a\u8fc7recordId\u627e\u4e0d\u5230\u7269\u6d41\u4fe1\u606f \u5c1d\u8bd5\u901a\u8fc7\u8ba2\u5355id\u83b7\u53d6");
                Long businessId = ((DgBizPerformNoticeSyncRecordDto)recordDtoList.get(0)).getBusinessId();
                if (businessId != null) {
                    recordShippingDtoList = this.dgPerformNoticeSyncRecordShippingService.queryByOrderId(businessId);
                    if (CollectionUtil.isEmpty((Collection)recordShippingDtoList)) {
                        LOGGER.error("\u5c1d\u8bd5\u901a\u8fc7\u8ba2\u5355id\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25 {} \u901a\u8fc7businessId\u83b7\u53d6\u4e0d\u5230\u7269\u6d41\u4fe1\u606f", (Object)businessId);
                        return MessageResponse.SUCCESS;
                    }
                    LOGGER.info("\u5c1d\u8bd5\u901a\u8fc7\u8ba2\u5355id\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u7ed3\u679c\u6570\u91cf {}", (Object)recordShippingDtoList.size());
                } else {
                    LOGGER.error("\u5c1d\u8bd5\u901a\u8fc7\u8ba2\u5355id\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25 {} businessId\u4e3a\u7a7a", (Object)((DgBizPerformNoticeSyncRecordDto)recordDtoList.get(0)).getId());
                    return MessageResponse.SUCCESS;
                }
            }
            DgPerformOrderReqDto orderReqDto = new DgPerformOrderReqDto();
            orderReqDto.setId(((DgBizPerformNoticeSyncRecordDto)recordDtoList.get(0)).getBusinessId());
            orderReqDto.setParcelSignStatus(PerformOrderParcelSignStatusEnum.PART.getCode());
            if (recordShippingDtoList.size() == 1 && ((DgPerformNoticeSyncRecordShippingDto)recordShippingDtoList.get(0)).getConsignmentNo().equals(logisticsInfoDto.getLogisticsOrderNo())) {
                orderReqDto.setParcelSignStatus(PerformOrderParcelSignStatusEnum.ALL.getCode());
            } else if (recordShippingDtoList.size() > 1) {
                orderReqDto.setParcelSignStatus(PerformOrderParcelSignStatusEnum.ALL.getCode());
                List orderNo = recordShippingDtoList.stream().map(DgPerformNoticeSyncRecordShippingDto::getConsignmentNo).collect(Collectors.toList());
                LogisticsInfoPageReqDto pageReqDto = new LogisticsInfoPageReqDto();
                pageReqDto.setOrderNoList(orderNo);
                PageInfo logisticsInfoDtoPageInfo = (PageInfo)RestResponseHelper.extractData((RestResponse)this.logisticsInfoApiProxy.pageList(pageReqDto));
                if (CollectionUtil.isNotEmpty((Collection)logisticsInfoDtoPageInfo.getList())) {
                    LOGGER.info("\u591a\u4e2a\u7269\u6d41\u5355\uff1a{}", (Object)JSON.toJSONString((Object)logisticsInfoDtoPageInfo.getList()));
                    Map logisticsInfoDtoMap = logisticsInfoDtoPageInfo.getList().stream().collect(Collectors.toMap(LogisticsInfoDto::getLogisticsOrderNo, Function.identity(), (k1, k2) -> k1));
                    for (String order : orderNo) {
                        LogisticsInfoDto logisticsInfo = (LogisticsInfoDto)logisticsInfoDtoMap.get(order);
                        if (!ObjectUtil.isEmpty((Object)logisticsInfo) && !StringUtils.isBlank((CharSequence)logisticsInfo.getLogisticsStatus()) && logisticsInfo.getLogisticsStatus().equals("3")) continue;
                        orderReqDto.setParcelSignStatus(PerformOrderParcelSignStatusEnum.PART.getCode());
                        break;
                    }
                }
            }
            this.omsOrderService.updateParcelSignStatus(orderReqDto);
            if (orderReqDto.getParcelSignStatus().equals(PerformOrderParcelSignStatusEnum.ALL.getCode())) {
                this.orderComplete(orderReqDto.getId());
            }
        }
        catch (Exception e) {
            LOGGER.error("\u76d1\u542c\u7269\u6d41\u7b7e\u6536\u6d88\u606f\u5f02\u5e38\uff1a{}", (Object)e.getMessage());
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
        return MessageResponse.SUCCESS;
    }

    private void orderComplete(Long orderId) {
        LOGGER.info("\u5305\u88f9\u5168\u90e8\u7b7e\u6536\uff0c\u89e6\u53d1\u9500\u552e\u5355\u5b8c\u6210\uff1a{}", (Object)orderId);
        DictDto dictDto = (DictDto)RestResponseHelper.extractData((RestResponse)this.dictQueryApiProxy.queryByGroupCodeAndCode("yunxi-dg-base-center-trade", PerformOrderGeneralConfigDataEnum.ORDER_FINISH_CONDITION.getCode()));
        int status = Optional.ofNullable(dictDto).map(DictDto::getStatus).orElse(2);
        if (status == 1) {
            this.dgB2COrderStatemachineExecutor.executeStatemachine("INVOICE_ORDER", orderId, (Object)"", (Object)DgB2COrderMachineEvents.CONFIRM_RECEIVE_GOODS).getFirstActionResultSubRestResponse(Void.class);
        }
    }
}

